/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.event.ChangeListener;
import org.netbeans.swing.tabcontrol.TabData;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public abstract class ProjectSupport {
    private static ProjectSupport theInstance = null;
    private static final RequestProcessor RP = new RequestProcessor("project support queries");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectSupport getDefault() {
        Class<ProjectSupport> clazz = ProjectSupport.class;
        synchronized (ProjectSupport.class) {
            if (null == theInstance && null == (theInstance = (ProjectSupport)Lookup.getDefault().lookup(ProjectSupport.class))) {
                theInstance = new DummyProjectSupport();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    public final ProjectProxy tryGetProjectForTab(TabData tab) {
        Map<TabData, ProjectProxy> ret = this.queryProjectsForTabs(Collections.singletonList(tab), 50);
        if (ret.isEmpty()) {
            return null;
        }
        return ret.get(tab);
    }

    public final Map<TabData, ProjectProxy> tryGetProjectsForTabs(List<TabData> tabs) {
        return this.queryProjectsForTabs(tabs, 200);
    }

    private Map<TabData, ProjectProxy> queryProjectsForTabs(List<TabData> tabs, int timeout) {
        try {
            return (Map)RP.submit(() -> {
                HashMap<TabData, ProjectProxy> map = new HashMap<TabData, ProjectProxy>();
                for (TabData tab : tabs) {
                    ProjectProxy proj = this.getProjectForTab(tab);
                    if (proj == null) continue;
                    map.put(tab, proj);
                }
                return map;
            }).get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            return Collections.emptyMap();
        }
    }

    public abstract boolean isEnabled();

    public abstract void addChangeListener(ChangeListener var1);

    public abstract void removeChangeListener(ChangeListener var1);

    public abstract ProjectProxy[] getOpenProjects();

    public abstract ProjectProxy getProjectForTab(TabData var1);

    private static class DummyProjectSupport
    extends ProjectSupport {
        private DummyProjectSupport() {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public ProjectProxy[] getOpenProjects() {
            return new ProjectProxy[0];
        }

        @Override
        public ProjectProxy getProjectForTab(TabData tab) {
            return null;
        }
    }

    public static final class ProjectProxy {
        private final Object token;
        private final String displayName;
        private final String path;

        public ProjectProxy(Object token, String displayName, String path) {
            Parameters.notNull((CharSequence)"token", (Object)token);
            this.token = token;
            this.displayName = displayName;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + (this.token != null ? this.token.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectProxy other = (ProjectProxy)obj;
            return this.token == other.token || this.token != null && this.token.equals(other.token);
        }

        final Object getToken() {
            return this.token;
        }
    }
}

