/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.oracle.bmc.auth.internal.AbstractTemplateRptPathProvider;
import java.util.Map;

public class EnvironmentRptPathProvider
extends AbstractTemplateRptPathProvider {
    static final String OCI_RESOURCE_PRINCIPAL_RPT_PATH = "OCI_RESOURCE_PRINCIPAL_RPT_PATH";
    static final String OCI_RESOURCE_PRINCIPAL_RPT_ID = "OCI_RESOURCE_PRINCIPAL_RPT_ID";
    private final Map<String, String> replacements = EnvironmentRptPathProvider.buildReplacements();

    public EnvironmentRptPathProvider() {
        super(EnvironmentRptPathProvider.getPathTemplate());
        Preconditions.checkNotNull(this.replacements, (Object)"Environment variable 'OCI_RESOURCE_PRINCIPAL_RPT_ID' was not set");
    }

    @Override
    protected Map<String, String> getReplacements() {
        return this.replacements;
    }

    protected static String getPathTemplate() {
        return System.getenv(OCI_RESOURCE_PRINCIPAL_RPT_PATH);
    }

    protected static Map<String, String> buildReplacements() {
        String rpt_id = System.getenv(OCI_RESOURCE_PRINCIPAL_RPT_ID);
        if (rpt_id != null) {
            return ImmutableMap.of((Object)"id", (Object)rpt_id);
        }
        return null;
    }
}

