/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.TaskSchedulingManager;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;

public class ScheduleCategory
extends Category {
    private IssueScheduleInfo scheduleInfo;
    private final TaskSchedulingManager schedulingManager;
    private final DashboardViewer dashboardViewer;
    private final int sortIndexAddition;

    public ScheduleCategory(String name, IssueScheduleInfo scheduleInfo, int sortIndexAddition) {
        super(name, new ArrayList<IssueImpl>(0), true);
        this.scheduleInfo = scheduleInfo;
        this.schedulingManager = TaskSchedulingManager.getInstance();
        this.dashboardViewer = DashboardViewer.getInstance();
        this.sortIndexAddition = sortIndexAddition;
    }

    @Override
    public boolean persist() {
        return false;
    }

    @Override
    public void reload() {
    }

    @Override
    public List<IssueImpl> getTasks() {
        IssueImpl[] scheduledTasks = this.schedulingManager.getScheduledTasks(this.scheduleInfo, this.dashboardViewer.getRepositories(true).toArray(new RepositoryImpl[0]));
        return Arrays.asList(scheduledTasks);
    }

    public IssueScheduleInfo getScheduleInfo() {
        return this.scheduleInfo;
    }

    public void setScheduleInfo(IssueScheduleInfo scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
    }

    @Override
    public int sortIndex() {
        return 200 + this.sortIndexAddition;
    }
}

