/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.palette;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.web.core.api.JspContextInfo;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class JspPaletteUtilities {
    public static final String CARET = "&CARET&";
    private static final String JSTL_PREFIX = "c";
    private static final String JSTL_URI = "http://java.sun.com/jsp/jstl/core";
    private static final String SQL_PREFIX = "sql";
    private static final String SQL_URI = "http://java.sun.com/jsp/jstl/sql";

    public static void insert(String s, JTextComponent target) throws BadLocationException {
        JspPaletteUtilities.insert(s, target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String s, JTextComponent target, boolean reformat) throws BadLocationException {
        Document _doc = target.getDocument();
        if (!(_doc instanceof BaseDocument)) {
            return;
        }
        if (s == null) {
            s = "";
        }
        BaseDocument doc = (BaseDocument)_doc;
        Indent indent = Indent.get((Document)doc);
        indent.lock();
        try {
            doc.atomicLock();
            try {
                int cursor_offset = s.indexOf(CARET);
                if (cursor_offset != -1) {
                    s = s.replace(CARET, "");
                }
                int start = JspPaletteUtilities.insert(s, target, _doc);
                if (cursor_offset != -1) {
                    target.setCaretPosition(start + cursor_offset);
                }
                if (reformat && start >= 0 && _doc instanceof BaseDocument) {
                    int end = start + s.length();
                    indent.reindent(start, end);
                }
            }
            finally {
                doc.atomicUnlock();
            }
        }
        finally {
            indent.unlock();
        }
    }

    private static FileObject getFileObject(JTextComponent target) {
        BaseDocument doc = (BaseDocument)target.getDocument();
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        FileObject fobj = dobj != null ? NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile() : null;
        return fobj;
    }

    private static int insert(String s, JTextComponent target, Document doc) throws BadLocationException {
        int start = -1;
        try {
            Caret caret = target.getCaret();
            int p0 = Math.min(caret.getDot(), caret.getMark());
            int p1 = Math.max(caret.getDot(), caret.getMark());
            doc.remove(p0, p1 - p0);
            start = caret.getDot();
            doc.insertString(start, s, null);
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
        }
        return start;
    }

    public static PageInfo.BeanData[] getAllBeans(JTextComponent target) {
        JspParserAPI.ParseResult result;
        FileObject fobj = JspPaletteUtilities.getFileObject(target);
        if (fobj != null && (result = JspContextInfo.getContextInfo(fobj).getCachedParseResult(fobj, false, true)) != null && result.getPageInfo() != null) {
            return result.getPageInfo().getBeans();
        }
        return null;
    }

    public static boolean idExists(String id, PageInfo.BeanData[] beanData) {
        boolean res = false;
        if (id != null && beanData != null) {
            for (int i = 0; i < beanData.length; ++i) {
                PageInfo.BeanData beanData1 = beanData[i];
                if (!beanData1.getId().equals(id)) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    public static boolean typeExists(JTextComponent target, final String fqcn) {
        final boolean[] result = new boolean[]{false};
        if (fqcn != null) {
            JspPaletteUtilities.runUserActionTask(target, new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    result[0] = parameter.getElements().getTypeElement(fqcn) != null;
                }
            });
        }
        return result[0];
    }

    private static void runUserActionTask(JTextComponent target, Task<CompilationController> aTask) {
        FileObject fobj = JspPaletteUtilities.getFileObject(target);
        if (fobj == null) {
            return;
        }
        try {
            JavaSource src = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)fobj), (FileObject[])new FileObject[0]);
            if (src != null) {
                src.runUserActionTask(aTask, false);
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public static List<String> getTypeProperties(JTextComponent target, final String fqcn, final String[] prefix) {
        final ArrayList<String> result = new ArrayList<String>();
        if (prefix != null) {
            JspPaletteUtilities.runUserActionTask(target, new Task<CompilationController>(){

                public void run(CompilationController parameter) throws Exception {
                    TypeElement te = parameter.getElements().getTypeElement(fqcn);
                    if (te != null) {
                        List<ExecutableElement> list = ElementFilter.methodsIn(te.getEnclosedElements());
                        for (ExecutableElement executableElement : list) {
                            String propName;
                            String methodName = executableElement.getSimpleName().toString();
                            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !this.match(methodName, prefix) || (propName = this.extractPropName(methodName, prefix)) == null) continue;
                            result.add(propName);
                        }
                    }
                }

                private String extractPropName(String methodName, String[] prefix2) {
                    for (int i = 0; i < prefix2.length; ++i) {
                        String res;
                        String string = prefix2[i];
                        if (!methodName.startsWith(string) || (res = methodName.substring(string.length())).length() <= 0) continue;
                        return Character.toLowerCase(res.charAt(0)) + res.substring(1);
                    }
                    return null;
                }

                private boolean match(String methodName, String[] prefix2) {
                    boolean res = false;
                    for (int i = 0; i < prefix2.length; ++i) {
                        String string = prefix2[i];
                        if (!methodName.startsWith(string)) continue;
                        res = true;
                        break;
                    }
                    return res;
                }
            });
        }
        return result;
    }

    public static String getTagLibPrefix(JTextComponent target, String tagLibUri) {
        JspParserAPI.ParseResult result;
        FileObject fobj = JspPaletteUtilities.getFileObject(target);
        if (fobj != null && (result = JspContextInfo.getContextInfo(fobj).getCachedParseResult(fobj, false, true)) != null && result.getPageInfo() != null) {
            for (TagLibraryInfo tli : result.getPageInfo().getTaglibs()) {
                if (!tagLibUri.equals(tli.getURI())) continue;
                return tli.getPrefixString();
            }
        }
        return null;
    }

    public static String findJstlPrefix(JTextComponent target) {
        String res = JspPaletteUtilities.getTagLibPrefix(target, JSTL_URI);
        if (res == null) {
            JspPaletteUtilities.insertTagLibRef(target, JSTL_PREFIX, JSTL_URI);
        }
        return res != null ? res : JSTL_PREFIX;
    }

    public static String findSqlPrefix(JTextComponent target) {
        String res = JspPaletteUtilities.getTagLibPrefix(target, SQL_URI);
        if (res == null) {
            JspPaletteUtilities.insertTagLibRef(target, SQL_PREFIX, SQL_URI);
        }
        return res != null ? res : SQL_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertTagLibRef(JTextComponent target, String prefix, String uri) {
        Document doc = target.getDocument();
        if (doc instanceof BaseDocument) {
            BaseDocument baseDoc = (BaseDocument)doc;
            baseDoc.atomicLock();
            try {
                String jspRootBegin;
                int baseDocLength;
                String text;
                int jspRootIndex;
                int pos = 0;
                String definition = "<%@taglib prefix=\"" + prefix + "\" uri=\"" + uri + "\"%>\n";
                FileObject fobj = JspPaletteUtilities.getFileObject(target);
                if (fobj != null && "jspx".equals(fobj.getExt()) && (jspRootIndex = (text = baseDoc.getText(0, baseDocLength = baseDoc.getLength())).indexOf(jspRootBegin = "<jsp:root ")) != -1) {
                    pos = jspRootIndex + jspRootBegin.length();
                    definition = "xmlns:" + prefix + "=\"" + uri + "\" ";
                }
                doc.insertString(pos, definition, null);
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            finally {
                baseDoc.atomicUnlock();
            }
        }
    }
}

