/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.html.editor.indexing.Entry;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation {
    private final PositionBounds bounds;
    private final String displayText;
    private final FileObject parentFile;
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";

    public WhereUsedElement(PositionBounds bounds, String displayText, FileObject parentFile, String name, OffsetRange range, Icon icon) {
        this.bounds = bounds;
        this.displayText = displayText;
        this.parentFile = parentFile;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        FileObject composite = null;
        if (composite == null) {
            composite = this.parentFile;
        }
        return Lookups.singleton(composite);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    public static WhereUsedElement create(FileObject fileObject, Entry entry, ElementKind kind) {
        return WhereUsedElement.create(fileObject, entry, kind, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WhereUsedElement create(FileObject fileObject, Entry entry, ElementKind kind, boolean related) {
        ImageIcon icon = UiUtils.getElementIcon((ElementKind)kind, Collections.emptyList());
        String name = entry.getName();
        OffsetRange range = entry.getDocumentRange();
        int start = range.getStart();
        int end = range.getEnd();
        int sta = start;
        int en = start;
        String content = null;
        BaseDocument bdoc = GsfUtilities.getDocument((FileObject)fileObject, (boolean)true);
        try {
            bdoc.readLock();
            content = bdoc.getText(0, bdoc.getLength());
            sta = Utilities.getRowFirstNonWhite((BaseDocument)bdoc, (int)start);
            if (sta == -1) {
                sta = Utilities.getRowStart((BaseDocument)bdoc, (int)start);
            }
            en = (en = Utilities.getRowLastNonWhite((BaseDocument)bdoc, (int)start)) == -1 ? Utilities.getRowEnd((BaseDocument)bdoc, (int)start) : ++en;
            if (end > en && (end = start + name.length()) > bdoc.getLength()) {
                end = bdoc.getLength();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            bdoc.readUnlock();
        }
        StringBuilder sb = new StringBuilder();
        if (end < sta) {
            sta = end;
        }
        if (start < sta) {
            start = sta;
        }
        if (en < end) {
            en = end;
        }
        sb.append(WhereUsedElement.encodeCharRefs(content.subSequence(sta, start).toString()));
        sb.append("<b>");
        sb.append(content.subSequence(start, end));
        sb.append("</b>");
        sb.append(WhereUsedElement.encodeCharRefs(content.subSequence(end, en).toString()));
        if (!related) {
            sb.append(NbBundle.getMessage(WhereUsedElement.class, (String)"MSG_Unrelated_Where_Used_Occurance"));
        }
        CloneableEditorSupport ces = GsfUtilities.findCloneableEditorSupport((FileObject)fileObject);
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        return new WhereUsedElement(bounds, sb.toString().trim(), fileObject, name, new OffsetRange(start, end), icon);
    }

    private static String encodeCharRefs(String htmlCode) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < htmlCode.length(); ++i) {
            String repl;
            char c = htmlCode.charAt(i);
            switch (c) {
                case '<': {
                    repl = LT;
                    break;
                }
                case '>': {
                    repl = GT;
                    break;
                }
                default: {
                    repl = null;
                }
            }
            buf.append(repl == null ? Character.valueOf(c) : repl);
        }
        return buf.toString();
    }

    public static WhereUsedElement create(CloneableEditorSupport ces, FileObject fo, String name, String html, OffsetRange range, Icon icon) {
        int start = range.getStart();
        int end = range.getEnd();
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        return new WhereUsedElement(bounds, html, fo, name, new OffsetRange(start, end), icon);
    }
}

