/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.openide.ErrorManager;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;

public class SyntaxErrorHighlighter
implements ParserManagerListener {
    private NbEditorDocument doc;
    private ParserManagerImpl parserManager;
    private List<LanguagesAnnotation> annotations = new ArrayList<LanguagesAnnotation>();

    public SyntaxErrorHighlighter(Document doc) {
        this.doc = (NbEditorDocument)doc;
        this.parserManager = ParserManagerImpl.getImpl(doc);
        this.parserManager.addListener(this);
    }

    @Override
    public void parsed(ParserManager.State state, ASTNode root) {
        final ArrayList<SyntaxError> newErrors = new ArrayList<SyntaxError>(this.parserManager.getSyntaxErrors());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<LanguagesAnnotation> newAnnotations = new ArrayList<LanguagesAnnotation>();
                    Iterator oldIterator = SyntaxErrorHighlighter.this.annotations.iterator();
                    LanguagesAnnotation oldAnnotation = oldIterator.hasNext() ? (LanguagesAnnotation)((Object)oldIterator.next()) : null;
                    Iterator newIterator = newErrors.iterator();
                    int lastLineNumber = -1;
                    int count = 0;
                    while (newIterator.hasNext() && count < 100) {
                        int ln;
                        SyntaxError syntaxError = (SyntaxError)newIterator.next();
                        ASTItem item = syntaxError.getItem();
                        String message = syntaxError.getMessage();
                        while (oldAnnotation != null && oldAnnotation.getPosition().getOffset() < item.getOffset()) {
                            SyntaxErrorHighlighter.this.doc.removeAnnotation((Annotation)oldAnnotation);
                            oldAnnotation = oldIterator.hasNext() ? (LanguagesAnnotation)((Object)oldIterator.next()) : null;
                        }
                        ++count;
                        if (oldAnnotation != null && oldAnnotation.getPosition().getOffset() == item.getOffset() && oldAnnotation.getShortDescription().equals(message)) {
                            ln = NbDocument.findLineNumber((StyledDocument)SyntaxErrorHighlighter.this.doc, (int)oldAnnotation.getPosition().getOffset());
                            if (ln > lastLineNumber) {
                                newAnnotations.add(oldAnnotation);
                            } else {
                                SyntaxErrorHighlighter.this.doc.removeAnnotation((Annotation)oldAnnotation);
                            }
                            lastLineNumber = ln;
                            oldAnnotation = oldIterator.hasNext() ? (LanguagesAnnotation)((Object)oldIterator.next()) : null;
                            continue;
                        }
                        ln = NbDocument.findLineNumber((StyledDocument)SyntaxErrorHighlighter.this.doc, (int)item.getOffset());
                        if (ln == lastLineNumber) continue;
                        LanguagesAnnotation la = new LanguagesAnnotation("SyntaxError", message);
                        Position position = SyntaxErrorHighlighter.this.doc.createPosition(item.getOffset());
                        la.setPosition(position);
                        SyntaxErrorHighlighter.this.doc.addAnnotation(position, item.getLength(), (Annotation)la);
                        newAnnotations.add(la);
                        lastLineNumber = ln;
                    }
                    if (oldAnnotation != null) {
                        SyntaxErrorHighlighter.this.doc.removeAnnotation((Annotation)oldAnnotation);
                    }
                    while (oldIterator.hasNext()) {
                        SyntaxErrorHighlighter.this.doc.removeAnnotation((Annotation)oldIterator.next());
                    }
                    SyntaxErrorHighlighter.this.annotations = newAnnotations;
                }
                catch (BadLocationException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        });
    }

    static class LanguagesAnnotation
    extends Annotation {
        private String type;
        private String description;
        private Position position;

        LanguagesAnnotation(String type, String description) {
            this.type = type;
            this.description = description;
        }

        public String getAnnotationType() {
            return this.type;
        }

        public String getShortDescription() {
            return this.description;
        }

        void setPosition(Position position) {
            this.position = position;
        }

        Position getPosition() {
            return this.position;
        }
    }
}

