/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StringReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class ShortenedStrings {
    private static final Map<String, StringInfo> infoStrings = new WeakHashMap<String, StringInfo>();
    private static final Map<StringReference, StringValueInfo> stringsCache = new WeakHashMap<StringReference, StringValueInfo>();
    private static final Set<StringReference> retrievingStrings = new HashSet<StringReference>();
    private static final Map<VirtualMachine, Boolean> isLittleEndianCache = new WeakHashMap<VirtualMachine, Boolean>();

    private ShortenedStrings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringInfo getShortenedInfo(String s) {
        Map<String, StringInfo> map = infoStrings;
        synchronized (map) {
            return infoStrings.get(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLittleEndian(VirtualMachine virtualMachine) throws InvalidTypeException, IncompatibleThreadStateException, ClassNotLoadedException, InvocationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        Map<VirtualMachine, Boolean> map = isLittleEndianCache;
        synchronized (map) {
            Boolean cached = isLittleEndianCache.get(virtualMachine);
            if (cached != null) {
                return cached;
            }
            List<ReferenceType> possibleClasses = virtualMachine.classesByName("java.lang.StringUTF16");
            boolean defaultValue = true;
            if (possibleClasses.isEmpty()) {
                ClassType ct = (ClassType)virtualMachine.classesByName("java.lang.Class").iterator().next();
                Method m = ct.concreteMethodByName("forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                StringReference referenceString = virtualMachine.mirrorOf("java.lang.StringUTF16");
                ThreadReference threadReference = virtualMachine.allThreads().get(0);
                ct.invokeMethod(threadReference, m, Collections.singletonList(referenceString), 0);
                possibleClasses = virtualMachine.classesByName("java.lang.StringUTF16");
            }
            if (possibleClasses.size() != 1) {
                isLittleEndianCache.put(virtualMachine, true);
                return true;
            }
            ReferenceType utf16 = possibleClasses.get(0);
            Field hiByteShiftField = ReferenceTypeWrapper.fieldByName(utf16, "HI_BYTE_SHIFT");
            if (hiByteShiftField == null) {
                isLittleEndianCache.put(virtualMachine, true);
                return true;
            }
            Value hiByteShiftValue = utf16.getValue(hiByteShiftField);
            if (!(hiByteShiftValue instanceof PrimitiveValue)) {
                isLittleEndianCache.put(virtualMachine, true);
                return true;
            }
            boolean result = ((PrimitiveValue)hiByteShiftValue).intValue() == 0;
            isLittleEndianCache.put(virtualMachine, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(String shortedString, StringReference sr, int length, ArrayReference chars) {
        StringInfo si = new StringInfo(sr, shortedString.length() - 3, length, chars);
        Map<String, StringInfo> map = infoStrings;
        synchronized (map) {
            infoStrings.put(shortedString, si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getStringWithLengthControl(StringReference sr) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, ClassNotLoadedException, ClassNotPreparedExceptionWrapper, IncompatibleThreadStateException, InvalidTypeException, InvocationException {
        block60: {
            block63: {
                block64: {
                    block68: {
                        block61: {
                            block67: {
                                block58: {
                                    block65: {
                                        block66: {
                                            retrieved = false;
                                            var2_2 = ShortenedStrings.stringsCache;
                                            synchronized (var2_2) {
                                                svi = ShortenedStrings.stringsCache.get(sr);
                                                if (svi != null) {
                                                    if (svi.isShort) {
                                                        return StringReferenceWrapper.value(sr);
                                                    }
                                                    str = svi.shortValueRef.get();
                                                    if (str != null) {
                                                        return str;
                                                    }
                                                }
                                                if (ShortenedStrings.retrievingStrings.contains(sr)) {
                                                    try {
                                                        ShortenedStrings.stringsCache.wait();
                                                    }
                                                    catch (InterruptedException str) {
                                                        // empty catch block
                                                    }
                                                    retrieved = true;
                                                } else {
                                                    ShortenedStrings.retrievingStrings.add(sr);
                                                }
                                                ** if (!retrieved) goto lbl23
                                            }
lbl22:
                                            // 1 sources

                                            return ShortenedStrings.getStringWithLengthControl(sr);
lbl23:
                                            // 1 sources

                                            string = null;
                                            isShort = true;
                                            st = ObjectReferenceWrapper.referenceType(sr);
                                            sa = null;
                                            isUTF16 = false;
                                            isCompactImpl = false;
                                            saLength = 0;
                                            ERROR_RESULT = "<Unreadable>";
                                            try {
                                                valuesField = ReferenceTypeWrapper.fieldByName((ReferenceType)st, "value");
                                                if (valuesField == null) {
                                                    allFields = ReferenceTypeWrapper.allFields((ReferenceType)st);
                                                    var12_20 = allFields.iterator();
                                                    break block58;
                                                }
                                                if (valuesField.type() instanceof ArrayType && "byte".equals(((ArrayType)valuesField.type()).componentTypeName())) {
                                                    isCompactImpl = true;
                                                }
lbl40:
                                                // 6 sources

                                                while (true) {
                                                    if (valuesField == null) {
                                                        isShort = true;
                                                    } else {
                                                        if (isCompactImpl) {
                                                            LATIN1 = false;
                                                            coderField = ReferenceTypeWrapper.fieldByName((ReferenceType)st, "coder");
                                                            if (coderField != null && (coderValue = ObjectReferenceWrapper.getValue(sr, coderField)) instanceof PrimitiveValue && ((PrimitiveValue)coderValue).intValue() != 0) {
                                                                isUTF16 = true;
                                                            }
                                                        }
                                                        limit = 100000;
                                                        if (isUTF16) {
                                                            limit *= 2;
                                                        }
                                                        isShort = (values = ObjectReferenceWrapper.getValue(sr, valuesField)) instanceof ArrayReference ? (saLength = ArrayReferenceWrapper.length(sa = (ArrayReference)values)) <= limit : true;
                                                    }
                                                    break;
                                                }
                                            }
                                            catch (ClassNotPreparedExceptionWrapper cnpex) {
                                                isShort = true;
                                            }
                                            catch (ClassNotLoadedException cnlex) {
                                                isShort = true;
                                            }
                                            if (isShort) {
                                                string = StringReferenceWrapper.value(sr);
                                                break block60;
                                            }
                                            if (!ShortenedStrings.$assertionsDisabled && sa == null) {
                                                throw new AssertionError();
                                            }
                                            l = 100000;
                                            values = ArrayReferenceWrapper.getValues(sa, 0, isUTF16 != false ? l * 2 : l);
                                            characters = new char[l + 3];
                                            if (!isCompactImpl) break block65;
                                            if (isUTF16) break block66;
                                            break block67;
                                        }
                                        if (ShortenedStrings.isLittleEndian(sr.virtualMachine())) {
                                            hiByteShift = 0;
                                            lowByteShift = 8;
                                            break block61;
                                        } else {
                                            hiByteShift = 8;
                                            lowByteShift = 0;
                                        }
                                        break block61;
                                    }
                                    i = 0;
                                    break block68;
                                }
                                while (true) {
                                    block69: {
                                        if (!var12_20.hasNext()) ** GOTO lbl40
                                        f = var12_20.next();
                                        if (f.isStatic() || !((type = f.type()) instanceof ArrayType)) continue;
                                        componentType = ((ArrayType)type).componentTypeName();
                                        if (!"byte".equals(componentType)) break block69;
                                        isCompactImpl = true;
                                        valuesField = f;
                                        ** GOTO lbl40
                                    }
                                    if ("char".equals(componentType)) break;
                                }
                                valuesField = f;
                                ** continue;
                            }
                            for (i = 0; i < l; ++i) {
                                v = values.get(i);
                                if (!(v instanceof ByteValue)) {
                                    componentType = "<Unreadable>";
                                    var16_30 = ShortenedStrings.stringsCache;
                                    synchronized (var16_30) {
                                        if (string != null) {
                                            svi = isShort != false ? new StringValueInfo(isShort) : new StringValueInfo(string);
                                            ShortenedStrings.stringsCache.put(sr, svi);
                                        }
                                        ShortenedStrings.retrievingStrings.remove(sr);
                                        ShortenedStrings.stringsCache.notifyAll();
                                        return componentType;
                                    }
                                }
                                c = (char)((ByteValue)v).byteValue();
                                characters[i] = c = (char)(c & 255);
                            }
                            ** GOTO lbl175
                        }
                        for (i = 0; i < l; c1 = (char)(255 & c1), c2 = (char)(255 & c2), ++i) {
                            block62: {
                                index = i * 2;
                                v = values.get(index);
                                if (!(v instanceof ByteValue)) {
                                    var18_36 = "<Unreadable>";
                                    var19_38 = ShortenedStrings.stringsCache;
                                    synchronized (var19_38) {
                                        if (string != null) {
                                            svi = isShort != false ? new StringValueInfo(isShort) : new StringValueInfo(string);
                                            ShortenedStrings.stringsCache.put(sr, svi);
                                        }
                                        ShortenedStrings.retrievingStrings.remove(sr);
                                        ShortenedStrings.stringsCache.notifyAll();
                                        return var18_36;
                                    }
                                }
                                v2 = values.get(index + 1);
                                if (v instanceof ByteValue) break block62;
                                var19_39 = "<Unreadable>";
                                svi = ShortenedStrings.stringsCache;
                                synchronized (svi) {
                                    if (string != null) {
                                        svi = isShort != false ? new StringValueInfo(isShort) : new StringValueInfo(string);
                                        ShortenedStrings.stringsCache.put(sr, svi);
                                    }
                                    ShortenedStrings.retrievingStrings.remove(sr);
                                    ShortenedStrings.stringsCache.notifyAll();
                                    return var19_39;
                                }
                            }
                            c1 = (char)((ByteValue)v).byteValue();
                            c2 = (char)((ByteValue)v2).byteValue();
                            characters[i] = c = (char)(c1 << hiByteShift | c2 << lowByteShift);
                        }
                        ** GOTO lbl175
                    }
lbl153:
                    // 2 sources

                    while (i < l) {
                        v = values.get(i);
                        if (v instanceof CharValue) break block63;
                        var15_27 = "<Unreadable>";
                        var16_32 = ShortenedStrings.stringsCache;
                        break block64;
                    }
                    ** GOTO lbl175
                }
                synchronized (var16_32) {
                    if (string != null) {
                        svi = isShort != false ? new StringValueInfo(isShort) : new StringValueInfo(string);
                        ShortenedStrings.stringsCache.put(sr, svi);
                    }
                    ShortenedStrings.retrievingStrings.remove(sr);
                    ShortenedStrings.stringsCache.notifyAll();
                    return var15_27;
                }
            }
            try {
                characters[i] = ((CharValue)v).charValue();
                ++i;
                ** GOTO lbl153
lbl175:
                // 4 sources

                for (i = l; i < l + 3; ++i) {
                    characters[i] = 46;
                }
                shortedString = new String(characters);
                stringLength = isUTF16 != false ? saLength / 2 : saLength;
                ShortenedStrings.register(shortedString, sr, stringLength, sa);
                string = shortedString;
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException | ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper e) {
                try {
                    Logger.getLogger(ShortenedStrings.class.getSimpleName()).log(Level.INFO, "Error in getStringWithLengthControl", e);
                    throw e;
                }
                catch (Throwable var25_45) {
                    var26_46 = ShortenedStrings.stringsCache;
                    synchronized (var26_46) {
                        if (string != null) {
                            svi = isShort != false ? new StringValueInfo(isShort) : new StringValueInfo(string);
                            ShortenedStrings.stringsCache.put(sr, svi);
                        }
                        ShortenedStrings.retrievingStrings.remove(sr);
                        ShortenedStrings.stringsCache.notifyAll();
                        throw var25_45;
                    }
                }
            }
        }
        st = ShortenedStrings.stringsCache;
        synchronized (st) {
            if (string != null) {
                svi = isShort != false ? new StringValueInfo(isShort) : new StringValueInfo(string);
                ShortenedStrings.stringsCache.put(sr, svi);
            }
            ShortenedStrings.retrievingStrings.remove(sr);
            ShortenedStrings.stringsCache.notifyAll();
            return string;
        }
    }

    static {
        DebuggerManager.getDebuggerManager().addDebuggerListener("sessions", (DebuggerManagerListener)new DebuggerManagerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionRemoved(Session session) {
                int n = DebuggerManager.getDebuggerManager().getSessions().length;
                if (n == 0) {
                    Map map = infoStrings;
                    synchronized (map) {
                        infoStrings.clear();
                    }
                    map = stringsCache;
                    synchronized (map) {
                        stringsCache.clear();
                        retrievingStrings.clear();
                    }
                    map = isLittleEndianCache;
                    synchronized (map) {
                        isLittleEndianCache.clear();
                    }
                }
            }
        });
    }

    private static class StringValueInfo {
        boolean isShort;
        Reference<String> shortValueRef;

        StringValueInfo(boolean isShort) {
            this.isShort = isShort;
        }

        StringValueInfo(String shortenedValue) {
            this.isShort = false;
            this.shortValueRef = new WeakReference<String>(shortenedValue);
        }
    }

    public static class StringInfo {
        private final StringReference sr;
        private final int shortLength;
        private final int length;
        private final ArrayReference chars;

        private StringInfo(StringReference sr, int shortLength, int length, ArrayReference chars) {
            this.sr = sr;
            this.shortLength = shortLength;
            this.length = length;
            this.chars = chars;
        }

        public int getShortLength() {
            return this.shortLength;
        }

        public int getLength() {
            return this.length;
        }

        public String getFullString() {
            try {
                return StringReferenceWrapper.value(this.sr);
            }
            catch (InternalExceptionWrapper ex) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return null;
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                return null;
            }
        }

        public Reader getContent() {
            return new Reader(){
                int pos = 0;

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    List<Value> values;
                    if (this.pos + len > length) {
                        len = length - this.pos;
                    }
                    try {
                        values = ArrayReferenceWrapper.getValues(chars, this.pos, len);
                    }
                    catch (InternalExceptionWrapper ex) {
                        throw new IOException(ex);
                    }
                    catch (VMDisconnectedExceptionWrapper ex) {
                        throw new IOException(ex);
                    }
                    catch (ObjectCollectedExceptionWrapper ex) {
                        throw new IOException(ex);
                    }
                    for (int i = 0; i < len; ++i) {
                        Value v = values.get(i);
                        if (!(v instanceof CharValue)) {
                            int p = this.pos + i;
                            throw new IOException("Char at " + p + " is not a character: " + v);
                        }
                        cbuf[off + i] = ((CharValue)v).charValue();
                    }
                    this.pos += len;
                    return len;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }
}

