/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.terraform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.languages.hcl.HCLParserResult;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.SourceRef;
import org.netbeans.modules.languages.hcl.terraform.Bundle;
import org.netbeans.modules.parsing.api.Snapshot;

public class TerraformParserResult
extends HCLParserResult {
    public TerraformParserResult(Snapshot snapshot) {
        super(snapshot);
    }

    @Override
    protected void processDocument(HCLDocument doc) {
        HashSet<String> defined = new HashSet<String>();
        for (HCLBlock hCLBlock : doc.getBlocks()) {
            DefaultError error;
            List<HCLIdentifier> decl = hCLBlock.getDeclaration();
            HCLIdentifier type = decl.get(0);
            BlockType bt = BlockType.get(type.id());
            SourceRef src = type.getSourceRef().get();
            if (bt != null) {
                if (decl.size() != bt.definitionLength) {
                    error = new DefaultError(null, Bundle.INVALID_BLOCK_DECLARATION(bt.type, bt.definitionLength - 1), null, this.getFileObject(), src.startOffset, src.endOffset, Severity.ERROR);
                    this.errors.add(error);
                    continue;
                }
                if (bt.definitionLength <= 1 || defined.add(hCLBlock.id())) continue;
                this.errors.add(new DefaultError(null, Bundle.DUPLICATE_BLOCK(hCLBlock.id()), null, this.getFileObject(), src.startOffset, src.endOffset, Severity.ERROR));
                continue;
            }
            error = new DefaultError(null, Bundle.UNKNOWN_BLOCK(type.id()), null, this.getFileObject(), src.startOffset, src.endOffset, Severity.ERROR);
            this.errors.add(error);
        }
    }

    static enum BlockType {
        DATA("data", 3),
        LOCALS("locals", 1),
        MODULE("module", 2),
        OUTPUT("output", 2),
        PROVIDER("provider", 2),
        RESOURCE("resource", 3),
        TERRAFORM("terraform", 1),
        VARIABLE("variable", 2);

        final String type;
        final int definitionLength;
        private static final Map<String, BlockType> TYPES;

        private BlockType(String type, int definitionLenght) {
            this.type = type;
            this.definitionLength = definitionLenght;
        }

        public static BlockType get(String name) {
            return TYPES.get(name);
        }

        static {
            TYPES = new HashMap<String, BlockType>();
            for (BlockType bt : BlockType.values()) {
                TYPES.put(bt.type, bt);
            }
        }
    }
}

