/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.xml;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ext.ContextResolver;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

class MoxyContextResolver
implements ContextResolver<JAXBContext> {
    private static final Logger LOGGER = Logger.getLogger(MoxyContextResolver.class.getName());
    private static final String MOXY_OXM_MAPPING_FILE_NAME = "eclipselink-oxm.xml";
    private final boolean oxmMappingLookup;
    private final Map<String, Object> properties;
    private final ClassLoader classLoader;
    private final Class[] classes;

    public MoxyContextResolver() {
        this(Collections.emptyMap(), Thread.currentThread().getContextClassLoader(), false, new Class[0]);
    }

    public MoxyContextResolver(Map<String, Object> properties, ClassLoader classLoader, boolean oxmMappingLookup, Class ... classes) {
        this.properties = properties == null ? Collections.emptyMap() : properties;
        this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.oxmMappingLookup = oxmMappingLookup;
        this.classes = classes;
    }

    public JAXBContext getContext(Class<?> type) {
        Class[] typeArray;
        InputStream eclipseLinkOxm;
        HashMap<String, Object> propertiesCopy = new HashMap<String, Object>(this.properties);
        if (this.oxmMappingLookup && (eclipseLinkOxm = type.getResourceAsStream(MOXY_OXM_MAPPING_FILE_NAME)) != null && !propertiesCopy.containsKey("eclipselink.oxm.metadata-source")) {
            propertiesCopy.put("eclipselink.oxm.metadata-source", eclipseLinkOxm);
        }
        if (this.classes != null && this.classes.length > 0) {
            typeArray = new Class[1 + this.classes.length];
            System.arraycopy(this.classes, 0, typeArray, 0, this.classes.length);
            typeArray[typeArray.length - 1] = type;
        } else {
            typeArray = new Class[]{type};
        }
        try {
            JAXBContext context = JAXBContextFactory.createContext((Class[])typeArray, propertiesCopy, (ClassLoader)this.classLoader);
            LOGGER.log(Level.FINE, "Using JAXB context " + context);
            return context;
        }
        catch (JAXBException e) {
            LOGGER.fine("Unable to create JAXB context.");
            return null;
        }
    }
}

