/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops;

import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.devops.DevopsAsync;
import com.oracle.bmc.devops.internal.http.ApproveDeploymentConverter;
import com.oracle.bmc.devops.internal.http.CancelBuildRunConverter;
import com.oracle.bmc.devops.internal.http.CancelDeploymentConverter;
import com.oracle.bmc.devops.internal.http.ChangeProjectCompartmentConverter;
import com.oracle.bmc.devops.internal.http.CreateBuildPipelineConverter;
import com.oracle.bmc.devops.internal.http.CreateBuildPipelineStageConverter;
import com.oracle.bmc.devops.internal.http.CreateBuildRunConverter;
import com.oracle.bmc.devops.internal.http.CreateConnectionConverter;
import com.oracle.bmc.devops.internal.http.CreateDeployArtifactConverter;
import com.oracle.bmc.devops.internal.http.CreateDeployEnvironmentConverter;
import com.oracle.bmc.devops.internal.http.CreateDeployPipelineConverter;
import com.oracle.bmc.devops.internal.http.CreateDeployStageConverter;
import com.oracle.bmc.devops.internal.http.CreateDeploymentConverter;
import com.oracle.bmc.devops.internal.http.CreateProjectConverter;
import com.oracle.bmc.devops.internal.http.CreateRepositoryConverter;
import com.oracle.bmc.devops.internal.http.CreateTriggerConverter;
import com.oracle.bmc.devops.internal.http.DeleteBuildPipelineConverter;
import com.oracle.bmc.devops.internal.http.DeleteBuildPipelineStageConverter;
import com.oracle.bmc.devops.internal.http.DeleteConnectionConverter;
import com.oracle.bmc.devops.internal.http.DeleteDeployArtifactConverter;
import com.oracle.bmc.devops.internal.http.DeleteDeployEnvironmentConverter;
import com.oracle.bmc.devops.internal.http.DeleteDeployPipelineConverter;
import com.oracle.bmc.devops.internal.http.DeleteDeployStageConverter;
import com.oracle.bmc.devops.internal.http.DeleteProjectConverter;
import com.oracle.bmc.devops.internal.http.DeleteRefConverter;
import com.oracle.bmc.devops.internal.http.DeleteRepositoryConverter;
import com.oracle.bmc.devops.internal.http.DeleteTriggerConverter;
import com.oracle.bmc.devops.internal.http.GetBuildPipelineConverter;
import com.oracle.bmc.devops.internal.http.GetBuildPipelineStageConverter;
import com.oracle.bmc.devops.internal.http.GetBuildRunConverter;
import com.oracle.bmc.devops.internal.http.GetCommitConverter;
import com.oracle.bmc.devops.internal.http.GetCommitDiffConverter;
import com.oracle.bmc.devops.internal.http.GetConnectionConverter;
import com.oracle.bmc.devops.internal.http.GetDeployArtifactConverter;
import com.oracle.bmc.devops.internal.http.GetDeployEnvironmentConverter;
import com.oracle.bmc.devops.internal.http.GetDeployPipelineConverter;
import com.oracle.bmc.devops.internal.http.GetDeployStageConverter;
import com.oracle.bmc.devops.internal.http.GetDeploymentConverter;
import com.oracle.bmc.devops.internal.http.GetFileDiffConverter;
import com.oracle.bmc.devops.internal.http.GetMirrorRecordConverter;
import com.oracle.bmc.devops.internal.http.GetObjectContentConverter;
import com.oracle.bmc.devops.internal.http.GetObjectConverter;
import com.oracle.bmc.devops.internal.http.GetProjectConverter;
import com.oracle.bmc.devops.internal.http.GetRefConverter;
import com.oracle.bmc.devops.internal.http.GetRepoFileDiffConverter;
import com.oracle.bmc.devops.internal.http.GetRepoFileLinesConverter;
import com.oracle.bmc.devops.internal.http.GetRepositoryArchiveContentConverter;
import com.oracle.bmc.devops.internal.http.GetRepositoryConverter;
import com.oracle.bmc.devops.internal.http.GetRepositoryFileLinesConverter;
import com.oracle.bmc.devops.internal.http.GetTriggerConverter;
import com.oracle.bmc.devops.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.devops.internal.http.ListAuthorsConverter;
import com.oracle.bmc.devops.internal.http.ListBuildPipelineStagesConverter;
import com.oracle.bmc.devops.internal.http.ListBuildPipelinesConverter;
import com.oracle.bmc.devops.internal.http.ListBuildRunsConverter;
import com.oracle.bmc.devops.internal.http.ListCommitDiffsConverter;
import com.oracle.bmc.devops.internal.http.ListCommitsConverter;
import com.oracle.bmc.devops.internal.http.ListConnectionsConverter;
import com.oracle.bmc.devops.internal.http.ListDeployArtifactsConverter;
import com.oracle.bmc.devops.internal.http.ListDeployEnvironmentsConverter;
import com.oracle.bmc.devops.internal.http.ListDeployPipelinesConverter;
import com.oracle.bmc.devops.internal.http.ListDeployStagesConverter;
import com.oracle.bmc.devops.internal.http.ListDeploymentsConverter;
import com.oracle.bmc.devops.internal.http.ListMirrorRecordsConverter;
import com.oracle.bmc.devops.internal.http.ListPathsConverter;
import com.oracle.bmc.devops.internal.http.ListProjectsConverter;
import com.oracle.bmc.devops.internal.http.ListRefsConverter;
import com.oracle.bmc.devops.internal.http.ListRepositoriesConverter;
import com.oracle.bmc.devops.internal.http.ListTriggersConverter;
import com.oracle.bmc.devops.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.devops.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.devops.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.devops.internal.http.MirrorRepositoryConverter;
import com.oracle.bmc.devops.internal.http.PutRepositoryRefConverter;
import com.oracle.bmc.devops.internal.http.UpdateBuildPipelineConverter;
import com.oracle.bmc.devops.internal.http.UpdateBuildPipelineStageConverter;
import com.oracle.bmc.devops.internal.http.UpdateBuildRunConverter;
import com.oracle.bmc.devops.internal.http.UpdateConnectionConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeployArtifactConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeployEnvironmentConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeployPipelineConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeployStageConverter;
import com.oracle.bmc.devops.internal.http.UpdateDeploymentConverter;
import com.oracle.bmc.devops.internal.http.UpdateProjectConverter;
import com.oracle.bmc.devops.internal.http.UpdateRepositoryConverter;
import com.oracle.bmc.devops.internal.http.UpdateTriggerConverter;
import com.oracle.bmc.devops.requests.ApproveDeploymentRequest;
import com.oracle.bmc.devops.requests.CancelBuildRunRequest;
import com.oracle.bmc.devops.requests.CancelDeploymentRequest;
import com.oracle.bmc.devops.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.devops.requests.CreateBuildPipelineRequest;
import com.oracle.bmc.devops.requests.CreateBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.CreateBuildRunRequest;
import com.oracle.bmc.devops.requests.CreateConnectionRequest;
import com.oracle.bmc.devops.requests.CreateDeployArtifactRequest;
import com.oracle.bmc.devops.requests.CreateDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.CreateDeployPipelineRequest;
import com.oracle.bmc.devops.requests.CreateDeployStageRequest;
import com.oracle.bmc.devops.requests.CreateDeploymentRequest;
import com.oracle.bmc.devops.requests.CreateProjectRequest;
import com.oracle.bmc.devops.requests.CreateRepositoryRequest;
import com.oracle.bmc.devops.requests.CreateTriggerRequest;
import com.oracle.bmc.devops.requests.DeleteBuildPipelineRequest;
import com.oracle.bmc.devops.requests.DeleteBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.DeleteConnectionRequest;
import com.oracle.bmc.devops.requests.DeleteDeployArtifactRequest;
import com.oracle.bmc.devops.requests.DeleteDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.DeleteDeployPipelineRequest;
import com.oracle.bmc.devops.requests.DeleteDeployStageRequest;
import com.oracle.bmc.devops.requests.DeleteProjectRequest;
import com.oracle.bmc.devops.requests.DeleteRefRequest;
import com.oracle.bmc.devops.requests.DeleteRepositoryRequest;
import com.oracle.bmc.devops.requests.DeleteTriggerRequest;
import com.oracle.bmc.devops.requests.GetBuildPipelineRequest;
import com.oracle.bmc.devops.requests.GetBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.GetBuildRunRequest;
import com.oracle.bmc.devops.requests.GetCommitDiffRequest;
import com.oracle.bmc.devops.requests.GetCommitRequest;
import com.oracle.bmc.devops.requests.GetConnectionRequest;
import com.oracle.bmc.devops.requests.GetDeployArtifactRequest;
import com.oracle.bmc.devops.requests.GetDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.GetDeployPipelineRequest;
import com.oracle.bmc.devops.requests.GetDeployStageRequest;
import com.oracle.bmc.devops.requests.GetDeploymentRequest;
import com.oracle.bmc.devops.requests.GetFileDiffRequest;
import com.oracle.bmc.devops.requests.GetMirrorRecordRequest;
import com.oracle.bmc.devops.requests.GetObjectContentRequest;
import com.oracle.bmc.devops.requests.GetObjectRequest;
import com.oracle.bmc.devops.requests.GetProjectRequest;
import com.oracle.bmc.devops.requests.GetRefRequest;
import com.oracle.bmc.devops.requests.GetRepoFileDiffRequest;
import com.oracle.bmc.devops.requests.GetRepoFileLinesRequest;
import com.oracle.bmc.devops.requests.GetRepositoryArchiveContentRequest;
import com.oracle.bmc.devops.requests.GetRepositoryFileLinesRequest;
import com.oracle.bmc.devops.requests.GetRepositoryRequest;
import com.oracle.bmc.devops.requests.GetTriggerRequest;
import com.oracle.bmc.devops.requests.GetWorkRequestRequest;
import com.oracle.bmc.devops.requests.ListAuthorsRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelineStagesRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelinesRequest;
import com.oracle.bmc.devops.requests.ListBuildRunsRequest;
import com.oracle.bmc.devops.requests.ListCommitDiffsRequest;
import com.oracle.bmc.devops.requests.ListCommitsRequest;
import com.oracle.bmc.devops.requests.ListConnectionsRequest;
import com.oracle.bmc.devops.requests.ListDeployArtifactsRequest;
import com.oracle.bmc.devops.requests.ListDeployEnvironmentsRequest;
import com.oracle.bmc.devops.requests.ListDeployPipelinesRequest;
import com.oracle.bmc.devops.requests.ListDeployStagesRequest;
import com.oracle.bmc.devops.requests.ListDeploymentsRequest;
import com.oracle.bmc.devops.requests.ListMirrorRecordsRequest;
import com.oracle.bmc.devops.requests.ListPathsRequest;
import com.oracle.bmc.devops.requests.ListProjectsRequest;
import com.oracle.bmc.devops.requests.ListRefsRequest;
import com.oracle.bmc.devops.requests.ListRepositoriesRequest;
import com.oracle.bmc.devops.requests.ListTriggersRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestsRequest;
import com.oracle.bmc.devops.requests.MirrorRepositoryRequest;
import com.oracle.bmc.devops.requests.PutRepositoryRefRequest;
import com.oracle.bmc.devops.requests.UpdateBuildPipelineRequest;
import com.oracle.bmc.devops.requests.UpdateBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.UpdateBuildRunRequest;
import com.oracle.bmc.devops.requests.UpdateConnectionRequest;
import com.oracle.bmc.devops.requests.UpdateDeployArtifactRequest;
import com.oracle.bmc.devops.requests.UpdateDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.UpdateDeployPipelineRequest;
import com.oracle.bmc.devops.requests.UpdateDeployStageRequest;
import com.oracle.bmc.devops.requests.UpdateDeploymentRequest;
import com.oracle.bmc.devops.requests.UpdateProjectRequest;
import com.oracle.bmc.devops.requests.UpdateRepositoryRequest;
import com.oracle.bmc.devops.requests.UpdateTriggerRequest;
import com.oracle.bmc.devops.responses.ApproveDeploymentResponse;
import com.oracle.bmc.devops.responses.CancelBuildRunResponse;
import com.oracle.bmc.devops.responses.CancelDeploymentResponse;
import com.oracle.bmc.devops.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.devops.responses.CreateBuildPipelineResponse;
import com.oracle.bmc.devops.responses.CreateBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.CreateBuildRunResponse;
import com.oracle.bmc.devops.responses.CreateConnectionResponse;
import com.oracle.bmc.devops.responses.CreateDeployArtifactResponse;
import com.oracle.bmc.devops.responses.CreateDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.CreateDeployPipelineResponse;
import com.oracle.bmc.devops.responses.CreateDeployStageResponse;
import com.oracle.bmc.devops.responses.CreateDeploymentResponse;
import com.oracle.bmc.devops.responses.CreateProjectResponse;
import com.oracle.bmc.devops.responses.CreateRepositoryResponse;
import com.oracle.bmc.devops.responses.CreateTriggerResponse;
import com.oracle.bmc.devops.responses.DeleteBuildPipelineResponse;
import com.oracle.bmc.devops.responses.DeleteBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.DeleteConnectionResponse;
import com.oracle.bmc.devops.responses.DeleteDeployArtifactResponse;
import com.oracle.bmc.devops.responses.DeleteDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.DeleteDeployPipelineResponse;
import com.oracle.bmc.devops.responses.DeleteDeployStageResponse;
import com.oracle.bmc.devops.responses.DeleteProjectResponse;
import com.oracle.bmc.devops.responses.DeleteRefResponse;
import com.oracle.bmc.devops.responses.DeleteRepositoryResponse;
import com.oracle.bmc.devops.responses.DeleteTriggerResponse;
import com.oracle.bmc.devops.responses.GetBuildPipelineResponse;
import com.oracle.bmc.devops.responses.GetBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.GetBuildRunResponse;
import com.oracle.bmc.devops.responses.GetCommitDiffResponse;
import com.oracle.bmc.devops.responses.GetCommitResponse;
import com.oracle.bmc.devops.responses.GetConnectionResponse;
import com.oracle.bmc.devops.responses.GetDeployArtifactResponse;
import com.oracle.bmc.devops.responses.GetDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.GetDeployPipelineResponse;
import com.oracle.bmc.devops.responses.GetDeployStageResponse;
import com.oracle.bmc.devops.responses.GetDeploymentResponse;
import com.oracle.bmc.devops.responses.GetFileDiffResponse;
import com.oracle.bmc.devops.responses.GetMirrorRecordResponse;
import com.oracle.bmc.devops.responses.GetObjectContentResponse;
import com.oracle.bmc.devops.responses.GetObjectResponse;
import com.oracle.bmc.devops.responses.GetProjectResponse;
import com.oracle.bmc.devops.responses.GetRefResponse;
import com.oracle.bmc.devops.responses.GetRepoFileDiffResponse;
import com.oracle.bmc.devops.responses.GetRepoFileLinesResponse;
import com.oracle.bmc.devops.responses.GetRepositoryArchiveContentResponse;
import com.oracle.bmc.devops.responses.GetRepositoryFileLinesResponse;
import com.oracle.bmc.devops.responses.GetRepositoryResponse;
import com.oracle.bmc.devops.responses.GetTriggerResponse;
import com.oracle.bmc.devops.responses.GetWorkRequestResponse;
import com.oracle.bmc.devops.responses.ListAuthorsResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelineStagesResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelinesResponse;
import com.oracle.bmc.devops.responses.ListBuildRunsResponse;
import com.oracle.bmc.devops.responses.ListCommitDiffsResponse;
import com.oracle.bmc.devops.responses.ListCommitsResponse;
import com.oracle.bmc.devops.responses.ListConnectionsResponse;
import com.oracle.bmc.devops.responses.ListDeployArtifactsResponse;
import com.oracle.bmc.devops.responses.ListDeployEnvironmentsResponse;
import com.oracle.bmc.devops.responses.ListDeployPipelinesResponse;
import com.oracle.bmc.devops.responses.ListDeployStagesResponse;
import com.oracle.bmc.devops.responses.ListDeploymentsResponse;
import com.oracle.bmc.devops.responses.ListMirrorRecordsResponse;
import com.oracle.bmc.devops.responses.ListPathsResponse;
import com.oracle.bmc.devops.responses.ListProjectsResponse;
import com.oracle.bmc.devops.responses.ListRefsResponse;
import com.oracle.bmc.devops.responses.ListRepositoriesResponse;
import com.oracle.bmc.devops.responses.ListTriggersResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestsResponse;
import com.oracle.bmc.devops.responses.MirrorRepositoryResponse;
import com.oracle.bmc.devops.responses.PutRepositoryRefResponse;
import com.oracle.bmc.devops.responses.UpdateBuildPipelineResponse;
import com.oracle.bmc.devops.responses.UpdateBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.UpdateBuildRunResponse;
import com.oracle.bmc.devops.responses.UpdateConnectionResponse;
import com.oracle.bmc.devops.responses.UpdateDeployArtifactResponse;
import com.oracle.bmc.devops.responses.UpdateDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.UpdateDeployPipelineResponse;
import com.oracle.bmc.devops.responses.UpdateDeployStageResponse;
import com.oracle.bmc.devops.responses.UpdateDeploymentResponse;
import com.oracle.bmc.devops.responses.UpdateProjectResponse;
import com.oracle.bmc.devops.responses.UpdateRepositoryResponse;
import com.oracle.bmc.devops.responses.UpdateTriggerResponse;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevopsAsyncClient
implements DevopsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DevopsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DEVOPS").serviceEndpointPrefix("").serviceEndpointTemplate("https://devops.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;

    public DevopsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DevopsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DevopsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DevopsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DevopsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DevopsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DevopsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DevopsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        boolean isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)restClientFactory.getClientConfigurator());
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration, isNonBufferingApacheClient);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ApproveDeploymentResponse> approveDeployment(ApproveDeploymentRequest request, AsyncHandler<ApproveDeploymentRequest, ApproveDeploymentResponse> handler) {
        LOG.trace("Called async approveDeployment");
        ApproveDeploymentRequest interceptedRequest = ApproveDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ApproveDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ApproveDeploymentResponse> transformer = ApproveDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ApproveDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/ApproveDeployment");
        AsyncHandler<ApproveDeploymentRequest, ApproveDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getApproveDeploymentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ApproveDeploymentRequest, ApproveDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelBuildRunResponse> cancelBuildRun(CancelBuildRunRequest request, AsyncHandler<CancelBuildRunRequest, CancelBuildRunResponse> handler) {
        LOG.trace("Called async cancelBuildRun");
        CancelBuildRunRequest interceptedRequest = CancelBuildRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelBuildRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CancelBuildRunResponse> transformer = CancelBuildRunConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CancelBuildRun", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/CancelBuildRun");
        AsyncHandler<CancelBuildRunRequest, CancelBuildRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCancelBuildRunDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelBuildRunRequest, CancelBuildRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelDeploymentResponse> cancelDeployment(CancelDeploymentRequest request, AsyncHandler<CancelDeploymentRequest, CancelDeploymentResponse> handler) {
        LOG.trace("Called async cancelDeployment");
        CancelDeploymentRequest interceptedRequest = CancelDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CancelDeploymentResponse> transformer = CancelDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CancelDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/CancelDeployment");
        AsyncHandler<CancelDeploymentRequest, CancelDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCancelDeploymentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelDeploymentRequest, CancelDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeProjectCompartmentResponse> changeProjectCompartment(ChangeProjectCompartmentRequest request, AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handler) {
        LOG.trace("Called async changeProjectCompartment");
        ChangeProjectCompartmentRequest interceptedRequest = ChangeProjectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeProjectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ChangeProjectCompartmentResponse> transformer = ChangeProjectCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ChangeProjectCompartment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/ChangeProjectCompartment");
        AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeProjectCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBuildPipelineResponse> createBuildPipeline(CreateBuildPipelineRequest request, AsyncHandler<CreateBuildPipelineRequest, CreateBuildPipelineResponse> handler) {
        LOG.trace("Called async createBuildPipeline");
        CreateBuildPipelineRequest interceptedRequest = CreateBuildPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBuildPipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateBuildPipelineResponse> transformer = CreateBuildPipelineConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateBuildPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/CreateBuildPipeline");
        AsyncHandler<CreateBuildPipelineRequest, CreateBuildPipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateBuildPipelineDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBuildPipelineRequest, CreateBuildPipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBuildPipelineStageResponse> createBuildPipelineStage(CreateBuildPipelineStageRequest request, AsyncHandler<CreateBuildPipelineStageRequest, CreateBuildPipelineStageResponse> handler) {
        LOG.trace("Called async createBuildPipelineStage");
        CreateBuildPipelineStageRequest interceptedRequest = CreateBuildPipelineStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBuildPipelineStageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateBuildPipelineStageResponse> transformer = CreateBuildPipelineStageConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateBuildPipelineStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/CreateBuildPipelineStage");
        AsyncHandler<CreateBuildPipelineStageRequest, CreateBuildPipelineStageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateBuildPipelineStageDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBuildPipelineStageRequest, CreateBuildPipelineStageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBuildRunResponse> createBuildRun(CreateBuildRunRequest request, AsyncHandler<CreateBuildRunRequest, CreateBuildRunResponse> handler) {
        LOG.trace("Called async createBuildRun");
        CreateBuildRunRequest interceptedRequest = CreateBuildRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBuildRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateBuildRunResponse> transformer = CreateBuildRunConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateBuildRun", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/CreateBuildRun");
        AsyncHandler<CreateBuildRunRequest, CreateBuildRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateBuildRunDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBuildRunRequest, CreateBuildRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateConnectionResponse> createConnection(CreateConnectionRequest request, AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handler) {
        LOG.trace("Called async createConnection");
        CreateConnectionRequest interceptedRequest = CreateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateConnectionResponse> transformer = CreateConnectionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateConnection", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/CreateConnection");
        AsyncHandler<CreateConnectionRequest, CreateConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateConnectionDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateConnectionRequest, CreateConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDeployArtifactResponse> createDeployArtifact(CreateDeployArtifactRequest request, AsyncHandler<CreateDeployArtifactRequest, CreateDeployArtifactResponse> handler) {
        LOG.trace("Called async createDeployArtifact");
        CreateDeployArtifactRequest interceptedRequest = CreateDeployArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeployArtifactConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDeployArtifactResponse> transformer = CreateDeployArtifactConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployArtifact", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/CreateDeployArtifact");
        AsyncHandler<CreateDeployArtifactRequest, CreateDeployArtifactResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateDeployArtifactDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDeployArtifactRequest, CreateDeployArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDeployEnvironmentResponse> createDeployEnvironment(CreateDeployEnvironmentRequest request, AsyncHandler<CreateDeployEnvironmentRequest, CreateDeployEnvironmentResponse> handler) {
        LOG.trace("Called async createDeployEnvironment");
        CreateDeployEnvironmentRequest interceptedRequest = CreateDeployEnvironmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeployEnvironmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDeployEnvironmentResponse> transformer = CreateDeployEnvironmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployEnvironment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/CreateDeployEnvironment");
        AsyncHandler<CreateDeployEnvironmentRequest, CreateDeployEnvironmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateDeployEnvironmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDeployEnvironmentRequest, CreateDeployEnvironmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDeployPipelineResponse> createDeployPipeline(CreateDeployPipelineRequest request, AsyncHandler<CreateDeployPipelineRequest, CreateDeployPipelineResponse> handler) {
        LOG.trace("Called async createDeployPipeline");
        CreateDeployPipelineRequest interceptedRequest = CreateDeployPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeployPipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDeployPipelineResponse> transformer = CreateDeployPipelineConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/CreateDeployPipeline");
        AsyncHandler<CreateDeployPipelineRequest, CreateDeployPipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateDeployPipelineDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDeployPipelineRequest, CreateDeployPipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDeployStageResponse> createDeployStage(CreateDeployStageRequest request, AsyncHandler<CreateDeployStageRequest, CreateDeployStageResponse> handler) {
        LOG.trace("Called async createDeployStage");
        CreateDeployStageRequest interceptedRequest = CreateDeployStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeployStageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDeployStageResponse> transformer = CreateDeployStageConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/CreateDeployStage");
        AsyncHandler<CreateDeployStageRequest, CreateDeployStageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateDeployStageDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDeployStageRequest, CreateDeployStageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest request, AsyncHandler<CreateDeploymentRequest, CreateDeploymentResponse> handler) {
        LOG.trace("Called async createDeployment");
        CreateDeploymentRequest interceptedRequest = CreateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateDeploymentResponse> transformer = CreateDeploymentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/CreateDeployment");
        AsyncHandler<CreateDeploymentRequest, CreateDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateDeploymentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDeploymentRequest, CreateDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        LOG.trace("Called async createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateProject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/CreateProject");
        AsyncHandler<CreateProjectRequest, CreateProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateProjectDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateProjectRequest, CreateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateRepositoryResponse> createRepository(CreateRepositoryRequest request, AsyncHandler<CreateRepositoryRequest, CreateRepositoryResponse> handler) {
        LOG.trace("Called async createRepository");
        CreateRepositoryRequest interceptedRequest = CreateRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRepositoryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateRepositoryResponse> transformer = CreateRepositoryConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/CreateRepository");
        AsyncHandler<CreateRepositoryRequest, CreateRepositoryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateRepositoryDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateRepositoryRequest, CreateRepositoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateTriggerResponse> createTrigger(CreateTriggerRequest request, AsyncHandler<CreateTriggerRequest, CreateTriggerResponse> handler) {
        LOG.trace("Called async createTrigger");
        CreateTriggerRequest interceptedRequest = CreateTriggerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTriggerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, CreateTriggerResponse> transformer = CreateTriggerConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"CreateTrigger", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/CreateTrigger");
        AsyncHandler<CreateTriggerRequest, CreateTriggerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateTriggerDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateTriggerRequest, CreateTriggerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBuildPipelineResponse> deleteBuildPipeline(DeleteBuildPipelineRequest request, AsyncHandler<DeleteBuildPipelineRequest, DeleteBuildPipelineResponse> handler) {
        LOG.trace("Called async deleteBuildPipeline");
        DeleteBuildPipelineRequest interceptedRequest = DeleteBuildPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBuildPipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteBuildPipelineResponse> transformer = DeleteBuildPipelineConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteBuildPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/DeleteBuildPipeline");
        AsyncHandler<DeleteBuildPipelineRequest, DeleteBuildPipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBuildPipelineRequest, DeleteBuildPipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBuildPipelineStageResponse> deleteBuildPipelineStage(DeleteBuildPipelineStageRequest request, AsyncHandler<DeleteBuildPipelineStageRequest, DeleteBuildPipelineStageResponse> handler) {
        LOG.trace("Called async deleteBuildPipelineStage");
        DeleteBuildPipelineStageRequest interceptedRequest = DeleteBuildPipelineStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBuildPipelineStageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteBuildPipelineStageResponse> transformer = DeleteBuildPipelineStageConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteBuildPipelineStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/DeleteBuildPipelineStage");
        AsyncHandler<DeleteBuildPipelineStageRequest, DeleteBuildPipelineStageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBuildPipelineStageRequest, DeleteBuildPipelineStageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest request, AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handler) {
        LOG.trace("Called async deleteConnection");
        DeleteConnectionRequest interceptedRequest = DeleteConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteConnectionResponse> transformer = DeleteConnectionConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteConnection", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/DeleteConnection");
        AsyncHandler<DeleteConnectionRequest, DeleteConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteConnectionRequest, DeleteConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDeployArtifactResponse> deleteDeployArtifact(DeleteDeployArtifactRequest request, AsyncHandler<DeleteDeployArtifactRequest, DeleteDeployArtifactResponse> handler) {
        LOG.trace("Called async deleteDeployArtifact");
        DeleteDeployArtifactRequest interceptedRequest = DeleteDeployArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeployArtifactConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDeployArtifactResponse> transformer = DeleteDeployArtifactConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteDeployArtifact", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/DeleteDeployArtifact");
        AsyncHandler<DeleteDeployArtifactRequest, DeleteDeployArtifactResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDeployArtifactRequest, DeleteDeployArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDeployEnvironmentResponse> deleteDeployEnvironment(DeleteDeployEnvironmentRequest request, AsyncHandler<DeleteDeployEnvironmentRequest, DeleteDeployEnvironmentResponse> handler) {
        LOG.trace("Called async deleteDeployEnvironment");
        DeleteDeployEnvironmentRequest interceptedRequest = DeleteDeployEnvironmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeployEnvironmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDeployEnvironmentResponse> transformer = DeleteDeployEnvironmentConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteDeployEnvironment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/DeleteDeployEnvironment");
        AsyncHandler<DeleteDeployEnvironmentRequest, DeleteDeployEnvironmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDeployEnvironmentRequest, DeleteDeployEnvironmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDeployPipelineResponse> deleteDeployPipeline(DeleteDeployPipelineRequest request, AsyncHandler<DeleteDeployPipelineRequest, DeleteDeployPipelineResponse> handler) {
        LOG.trace("Called async deleteDeployPipeline");
        DeleteDeployPipelineRequest interceptedRequest = DeleteDeployPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeployPipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDeployPipelineResponse> transformer = DeleteDeployPipelineConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteDeployPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/DeleteDeployPipeline");
        AsyncHandler<DeleteDeployPipelineRequest, DeleteDeployPipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDeployPipelineRequest, DeleteDeployPipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDeployStageResponse> deleteDeployStage(DeleteDeployStageRequest request, AsyncHandler<DeleteDeployStageRequest, DeleteDeployStageResponse> handler) {
        LOG.trace("Called async deleteDeployStage");
        DeleteDeployStageRequest interceptedRequest = DeleteDeployStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDeployStageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteDeployStageResponse> transformer = DeleteDeployStageConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteDeployStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/DeleteDeployStage");
        AsyncHandler<DeleteDeployStageRequest, DeleteDeployStageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDeployStageRequest, DeleteDeployStageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        LOG.trace("Called async deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteProject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/DeleteProject");
        AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteProjectRequest, DeleteProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRefResponse> deleteRef(DeleteRefRequest request, AsyncHandler<DeleteRefRequest, DeleteRefResponse> handler) {
        LOG.trace("Called async deleteRef");
        DeleteRefRequest interceptedRequest = DeleteRefConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRefConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteRefResponse> transformer = DeleteRefConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteRef", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/DeleteRef");
        AsyncHandler<DeleteRefRequest, DeleteRefResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRefRequest, DeleteRefResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest request, AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResponse> handler) {
        LOG.trace("Called async deleteRepository");
        DeleteRepositoryRequest interceptedRequest = DeleteRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRepositoryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteRepositoryResponse> transformer = DeleteRepositoryConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/DeleteRepository");
        AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRepositoryRequest, DeleteRepositoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteTriggerResponse> deleteTrigger(DeleteTriggerRequest request, AsyncHandler<DeleteTriggerRequest, DeleteTriggerResponse> handler) {
        LOG.trace("Called async deleteTrigger");
        DeleteTriggerRequest interceptedRequest = DeleteTriggerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTriggerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, DeleteTriggerResponse> transformer = DeleteTriggerConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"DeleteTrigger", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/DeleteTrigger");
        AsyncHandler<DeleteTriggerRequest, DeleteTriggerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteTriggerRequest, DeleteTriggerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBuildPipelineResponse> getBuildPipeline(GetBuildPipelineRequest request, AsyncHandler<GetBuildPipelineRequest, GetBuildPipelineResponse> handler) {
        LOG.trace("Called async getBuildPipeline");
        GetBuildPipelineRequest interceptedRequest = GetBuildPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBuildPipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetBuildPipelineResponse> transformer = GetBuildPipelineConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetBuildPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/GetBuildPipeline");
        AsyncHandler<GetBuildPipelineRequest, GetBuildPipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBuildPipelineRequest, GetBuildPipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBuildPipelineStageResponse> getBuildPipelineStage(GetBuildPipelineStageRequest request, AsyncHandler<GetBuildPipelineStageRequest, GetBuildPipelineStageResponse> handler) {
        LOG.trace("Called async getBuildPipelineStage");
        GetBuildPipelineStageRequest interceptedRequest = GetBuildPipelineStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBuildPipelineStageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetBuildPipelineStageResponse> transformer = GetBuildPipelineStageConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetBuildPipelineStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/GetBuildPipelineStage");
        AsyncHandler<GetBuildPipelineStageRequest, GetBuildPipelineStageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBuildPipelineStageRequest, GetBuildPipelineStageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBuildRunResponse> getBuildRun(GetBuildRunRequest request, AsyncHandler<GetBuildRunRequest, GetBuildRunResponse> handler) {
        LOG.trace("Called async getBuildRun");
        GetBuildRunRequest interceptedRequest = GetBuildRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBuildRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetBuildRunResponse> transformer = GetBuildRunConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetBuildRun", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/GetBuildRun");
        AsyncHandler<GetBuildRunRequest, GetBuildRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBuildRunRequest, GetBuildRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCommitResponse> getCommit(GetCommitRequest request, AsyncHandler<GetCommitRequest, GetCommitResponse> handler) {
        LOG.trace("Called async getCommit");
        GetCommitRequest interceptedRequest = GetCommitConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCommitConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetCommitResponse> transformer = GetCommitConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetCommit", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetCommit");
        AsyncHandler<GetCommitRequest, GetCommitResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCommitRequest, GetCommitResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetCommitDiffResponse> getCommitDiff(GetCommitDiffRequest request, AsyncHandler<GetCommitDiffRequest, GetCommitDiffResponse> handler) {
        LOG.trace("Called async getCommitDiff");
        GetCommitDiffRequest interceptedRequest = GetCommitDiffConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetCommitDiffConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetCommitDiffResponse> transformer = GetCommitDiffConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetCommitDiff", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetCommitDiff");
        AsyncHandler<GetCommitDiffRequest, GetCommitDiffResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetCommitDiffRequest, GetCommitDiffResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetConnectionResponse> getConnection(GetConnectionRequest request, AsyncHandler<GetConnectionRequest, GetConnectionResponse> handler) {
        LOG.trace("Called async getConnection");
        GetConnectionRequest interceptedRequest = GetConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetConnectionResponse> transformer = GetConnectionConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetConnection", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/GetConnection");
        AsyncHandler<GetConnectionRequest, GetConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetConnectionRequest, GetConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDeployArtifactResponse> getDeployArtifact(GetDeployArtifactRequest request, AsyncHandler<GetDeployArtifactRequest, GetDeployArtifactResponse> handler) {
        LOG.trace("Called async getDeployArtifact");
        GetDeployArtifactRequest interceptedRequest = GetDeployArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeployArtifactConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDeployArtifactResponse> transformer = GetDeployArtifactConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployArtifact", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/GetDeployArtifact");
        AsyncHandler<GetDeployArtifactRequest, GetDeployArtifactResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDeployArtifactRequest, GetDeployArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDeployEnvironmentResponse> getDeployEnvironment(GetDeployEnvironmentRequest request, AsyncHandler<GetDeployEnvironmentRequest, GetDeployEnvironmentResponse> handler) {
        LOG.trace("Called async getDeployEnvironment");
        GetDeployEnvironmentRequest interceptedRequest = GetDeployEnvironmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeployEnvironmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDeployEnvironmentResponse> transformer = GetDeployEnvironmentConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployEnvironment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/GetDeployEnvironment");
        AsyncHandler<GetDeployEnvironmentRequest, GetDeployEnvironmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDeployEnvironmentRequest, GetDeployEnvironmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDeployPipelineResponse> getDeployPipeline(GetDeployPipelineRequest request, AsyncHandler<GetDeployPipelineRequest, GetDeployPipelineResponse> handler) {
        LOG.trace("Called async getDeployPipeline");
        GetDeployPipelineRequest interceptedRequest = GetDeployPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeployPipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDeployPipelineResponse> transformer = GetDeployPipelineConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/GetDeployPipeline");
        AsyncHandler<GetDeployPipelineRequest, GetDeployPipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDeployPipelineRequest, GetDeployPipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDeployStageResponse> getDeployStage(GetDeployStageRequest request, AsyncHandler<GetDeployStageRequest, GetDeployStageResponse> handler) {
        LOG.trace("Called async getDeployStage");
        GetDeployStageRequest interceptedRequest = GetDeployStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeployStageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDeployStageResponse> transformer = GetDeployStageConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/GetDeployStage");
        AsyncHandler<GetDeployStageRequest, GetDeployStageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDeployStageRequest, GetDeployStageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDeploymentResponse> getDeployment(GetDeploymentRequest request, AsyncHandler<GetDeploymentRequest, GetDeploymentResponse> handler) {
        LOG.trace("Called async getDeployment");
        GetDeploymentRequest interceptedRequest = GetDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetDeploymentResponse> transformer = GetDeploymentConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/GetDeployment");
        AsyncHandler<GetDeploymentRequest, GetDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDeploymentRequest, GetDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetFileDiffResponse> getFileDiff(GetFileDiffRequest request, AsyncHandler<GetFileDiffRequest, GetFileDiffResponse> handler) {
        LOG.trace("Called async getFileDiff");
        GetFileDiffRequest interceptedRequest = GetFileDiffConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetFileDiffConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetFileDiffResponse> transformer = GetFileDiffConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetFileDiff", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetFileDiff");
        AsyncHandler<GetFileDiffRequest, GetFileDiffResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetFileDiffRequest, GetFileDiffResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetMirrorRecordResponse> getMirrorRecord(GetMirrorRecordRequest request, AsyncHandler<GetMirrorRecordRequest, GetMirrorRecordResponse> handler) {
        LOG.trace("Called async getMirrorRecord");
        GetMirrorRecordRequest interceptedRequest = GetMirrorRecordConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMirrorRecordConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetMirrorRecordResponse> transformer = GetMirrorRecordConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetMirrorRecord", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetMirrorRecord");
        AsyncHandler<GetMirrorRecordRequest, GetMirrorRecordResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetMirrorRecordRequest, GetMirrorRecordResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetObjectResponse> getObject(GetObjectRequest request, AsyncHandler<GetObjectRequest, GetObjectResponse> handler) {
        LOG.trace("Called async getObject");
        GetObjectRequest interceptedRequest = GetObjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetObjectResponse> transformer = GetObjectConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetObject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryObject/GetObject");
        AsyncHandler<GetObjectRequest, GetObjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetObjectRequest, GetObjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetObjectContentResponse> getObjectContent(GetObjectContentRequest request, AsyncHandler<GetObjectContentRequest, GetObjectContentResponse> handler) {
        LOG.trace("Called async getObjectContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getObjectContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetObjectContentRequest interceptedRequest = GetObjectContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetObjectContentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetObjectContentResponse> transformer = GetObjectContentConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetObjectContent", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetObjectContent");
        AsyncHandler<GetObjectContentRequest, GetObjectContentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetObjectContentRequest, GetObjectContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        LOG.trace("Called async getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetProject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/GetProject");
        AsyncHandler<GetProjectRequest, GetProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetProjectRequest, GetProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRefResponse> getRef(GetRefRequest request, AsyncHandler<GetRefRequest, GetRefResponse> handler) {
        LOG.trace("Called async getRef");
        GetRefRequest interceptedRequest = GetRefConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRefConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetRefResponse> transformer = GetRefConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRef", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRef");
        AsyncHandler<GetRefRequest, GetRefResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRefRequest, GetRefResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRepoFileDiffResponse> getRepoFileDiff(GetRepoFileDiffRequest request, AsyncHandler<GetRepoFileDiffRequest, GetRepoFileDiffResponse> handler) {
        LOG.trace("Called async getRepoFileDiff");
        GetRepoFileDiffRequest interceptedRequest = GetRepoFileDiffConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepoFileDiffConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetRepoFileDiffResponse> transformer = GetRepoFileDiffConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepoFileDiff", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepoFileDiff");
        AsyncHandler<GetRepoFileDiffRequest, GetRepoFileDiffResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRepoFileDiffRequest, GetRepoFileDiffResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRepoFileLinesResponse> getRepoFileLines(GetRepoFileLinesRequest request, AsyncHandler<GetRepoFileLinesRequest, GetRepoFileLinesResponse> handler) {
        LOG.trace("Called async getRepoFileLines");
        GetRepoFileLinesRequest interceptedRequest = GetRepoFileLinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepoFileLinesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetRepoFileLinesResponse> transformer = GetRepoFileLinesConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepoFileLines", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepoFileLines");
        AsyncHandler<GetRepoFileLinesRequest, GetRepoFileLinesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRepoFileLinesRequest, GetRepoFileLinesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRepositoryResponse> getRepository(GetRepositoryRequest request, AsyncHandler<GetRepositoryRequest, GetRepositoryResponse> handler) {
        LOG.trace("Called async getRepository");
        GetRepositoryRequest interceptedRequest = GetRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepositoryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetRepositoryResponse> transformer = GetRepositoryConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepository");
        AsyncHandler<GetRepositoryRequest, GetRepositoryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRepositoryRequest, GetRepositoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRepositoryArchiveContentResponse> getRepositoryArchiveContent(GetRepositoryArchiveContentRequest request, AsyncHandler<GetRepositoryArchiveContentRequest, GetRepositoryArchiveContentResponse> handler) {
        LOG.trace("Called async getRepositoryArchiveContent");
        if (ApacheUtils.isExtraStreamLogsEnabled()) {
            LOG.warn("getRepositoryArchiveContent returns a stream, please make sure to close the stream to avoid any indefinite hangs");
            if (this.apacheConnectionClosingStrategy != null) {
                LOG.warn("ApacheConnectionClosingStrategy set to {}. For large streams with partial reads of stream, please use ImmediateClosingStrategy. For small streams with partial reads of stream, please use GracefulClosingStrategy. More info in ApacheConnectorProperties", (Object)this.apacheConnectionClosingStrategy);
            }
        }
        GetRepositoryArchiveContentRequest interceptedRequest = GetRepositoryArchiveContentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepositoryArchiveContentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetRepositoryArchiveContentResponse> transformer = GetRepositoryArchiveContentConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepositoryArchiveContent", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepositoryArchiveContent");
        AsyncHandler<GetRepositoryArchiveContentRequest, GetRepositoryArchiveContentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRepositoryArchiveContentRequest, GetRepositoryArchiveContentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRepositoryFileLinesResponse> getRepositoryFileLines(GetRepositoryFileLinesRequest request, AsyncHandler<GetRepositoryFileLinesRequest, GetRepositoryFileLinesResponse> handler) {
        LOG.trace("Called async getRepositoryFileLines");
        GetRepositoryFileLinesRequest interceptedRequest = GetRepositoryFileLinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRepositoryFileLinesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetRepositoryFileLinesResponse> transformer = GetRepositoryFileLinesConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetRepositoryFileLines", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepositoryFileLines");
        AsyncHandler<GetRepositoryFileLinesRequest, GetRepositoryFileLinesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRepositoryFileLinesRequest, GetRepositoryFileLinesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetTriggerResponse> getTrigger(GetTriggerRequest request, AsyncHandler<GetTriggerRequest, GetTriggerResponse> handler) {
        LOG.trace("Called async getTrigger");
        GetTriggerRequest interceptedRequest = GetTriggerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTriggerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetTriggerResponse> transformer = GetTriggerConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetTrigger", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/GetTrigger");
        AsyncHandler<GetTriggerRequest, GetTriggerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetTriggerRequest, GetTriggerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"GetWorkRequest", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequest/GetWorkRequest");
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAuthorsResponse> listAuthors(ListAuthorsRequest request, AsyncHandler<ListAuthorsRequest, ListAuthorsResponse> handler) {
        LOG.trace("Called async listAuthors");
        ListAuthorsRequest interceptedRequest = ListAuthorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAuthorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListAuthorsResponse> transformer = ListAuthorsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListAuthors", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListAuthors");
        AsyncHandler<ListAuthorsRequest, ListAuthorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAuthorsRequest, ListAuthorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBuildPipelineStagesResponse> listBuildPipelineStages(ListBuildPipelineStagesRequest request, AsyncHandler<ListBuildPipelineStagesRequest, ListBuildPipelineStagesResponse> handler) {
        LOG.trace("Called async listBuildPipelineStages");
        ListBuildPipelineStagesRequest interceptedRequest = ListBuildPipelineStagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBuildPipelineStagesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListBuildPipelineStagesResponse> transformer = ListBuildPipelineStagesConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListBuildPipelineStages", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStageSummary/ListBuildPipelineStages");
        AsyncHandler<ListBuildPipelineStagesRequest, ListBuildPipelineStagesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBuildPipelineStagesRequest, ListBuildPipelineStagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBuildPipelinesResponse> listBuildPipelines(ListBuildPipelinesRequest request, AsyncHandler<ListBuildPipelinesRequest, ListBuildPipelinesResponse> handler) {
        LOG.trace("Called async listBuildPipelines");
        ListBuildPipelinesRequest interceptedRequest = ListBuildPipelinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBuildPipelinesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListBuildPipelinesResponse> transformer = ListBuildPipelinesConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListBuildPipelines", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineCollection/ListBuildPipelines");
        AsyncHandler<ListBuildPipelinesRequest, ListBuildPipelinesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBuildPipelinesRequest, ListBuildPipelinesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBuildRunsResponse> listBuildRuns(ListBuildRunsRequest request, AsyncHandler<ListBuildRunsRequest, ListBuildRunsResponse> handler) {
        LOG.trace("Called async listBuildRuns");
        ListBuildRunsRequest interceptedRequest = ListBuildRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBuildRunsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListBuildRunsResponse> transformer = ListBuildRunsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListBuildRuns", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRunSummary/ListBuildRuns");
        AsyncHandler<ListBuildRunsRequest, ListBuildRunsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBuildRunsRequest, ListBuildRunsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCommitDiffsResponse> listCommitDiffs(ListCommitDiffsRequest request, AsyncHandler<ListCommitDiffsRequest, ListCommitDiffsResponse> handler) {
        LOG.trace("Called async listCommitDiffs");
        ListCommitDiffsRequest interceptedRequest = ListCommitDiffsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCommitDiffsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCommitDiffsResponse> transformer = ListCommitDiffsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListCommitDiffs", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListCommitDiffs");
        AsyncHandler<ListCommitDiffsRequest, ListCommitDiffsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCommitDiffsRequest, ListCommitDiffsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListCommitsResponse> listCommits(ListCommitsRequest request, AsyncHandler<ListCommitsRequest, ListCommitsResponse> handler) {
        LOG.trace("Called async listCommits");
        ListCommitsRequest interceptedRequest = ListCommitsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListCommitsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListCommitsResponse> transformer = ListCommitsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListCommits", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryCommit/ListCommits");
        AsyncHandler<ListCommitsRequest, ListCommitsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListCommitsRequest, ListCommitsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListConnectionsResponse> listConnections(ListConnectionsRequest request, AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handler) {
        LOG.trace("Called async listConnections");
        ListConnectionsRequest interceptedRequest = ListConnectionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListConnectionsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListConnectionsResponse> transformer = ListConnectionsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListConnections", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/ConnectionCollection/ListConnections");
        AsyncHandler<ListConnectionsRequest, ListConnectionsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListConnectionsRequest, ListConnectionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDeployArtifactsResponse> listDeployArtifacts(ListDeployArtifactsRequest request, AsyncHandler<ListDeployArtifactsRequest, ListDeployArtifactsResponse> handler) {
        LOG.trace("Called async listDeployArtifacts");
        ListDeployArtifactsRequest interceptedRequest = ListDeployArtifactsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeployArtifactsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDeployArtifactsResponse> transformer = ListDeployArtifactsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployArtifacts", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifactSummary/ListDeployArtifacts");
        AsyncHandler<ListDeployArtifactsRequest, ListDeployArtifactsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDeployArtifactsRequest, ListDeployArtifactsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDeployEnvironmentsResponse> listDeployEnvironments(ListDeployEnvironmentsRequest request, AsyncHandler<ListDeployEnvironmentsRequest, ListDeployEnvironmentsResponse> handler) {
        LOG.trace("Called async listDeployEnvironments");
        ListDeployEnvironmentsRequest interceptedRequest = ListDeployEnvironmentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeployEnvironmentsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDeployEnvironmentsResponse> transformer = ListDeployEnvironmentsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployEnvironments", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironmentSummary/ListDeployEnvironments");
        AsyncHandler<ListDeployEnvironmentsRequest, ListDeployEnvironmentsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDeployEnvironmentsRequest, ListDeployEnvironmentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDeployPipelinesResponse> listDeployPipelines(ListDeployPipelinesRequest request, AsyncHandler<ListDeployPipelinesRequest, ListDeployPipelinesResponse> handler) {
        LOG.trace("Called async listDeployPipelines");
        ListDeployPipelinesRequest interceptedRequest = ListDeployPipelinesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeployPipelinesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDeployPipelinesResponse> transformer = ListDeployPipelinesConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployPipelines", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipelineSummary/ListDeployPipelines");
        AsyncHandler<ListDeployPipelinesRequest, ListDeployPipelinesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDeployPipelinesRequest, ListDeployPipelinesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDeployStagesResponse> listDeployStages(ListDeployStagesRequest request, AsyncHandler<ListDeployStagesRequest, ListDeployStagesResponse> handler) {
        LOG.trace("Called async listDeployStages");
        ListDeployStagesRequest interceptedRequest = ListDeployStagesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeployStagesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDeployStagesResponse> transformer = ListDeployStagesConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployStages", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStageSummary/ListDeployStages");
        AsyncHandler<ListDeployStagesRequest, ListDeployStagesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDeployStagesRequest, ListDeployStagesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest request, AsyncHandler<ListDeploymentsRequest, ListDeploymentsResponse> handler) {
        LOG.trace("Called async listDeployments");
        ListDeploymentsRequest interceptedRequest = ListDeploymentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDeploymentsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListDeploymentsResponse> transformer = ListDeploymentsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListDeployments", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeploymentSummary/ListDeployments");
        AsyncHandler<ListDeploymentsRequest, ListDeploymentsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDeploymentsRequest, ListDeploymentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListMirrorRecordsResponse> listMirrorRecords(ListMirrorRecordsRequest request, AsyncHandler<ListMirrorRecordsRequest, ListMirrorRecordsResponse> handler) {
        LOG.trace("Called async listMirrorRecords");
        ListMirrorRecordsRequest interceptedRequest = ListMirrorRecordsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMirrorRecordsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListMirrorRecordsResponse> transformer = ListMirrorRecordsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListMirrorRecords", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListMirrorRecords");
        AsyncHandler<ListMirrorRecordsRequest, ListMirrorRecordsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListMirrorRecordsRequest, ListMirrorRecordsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPathsResponse> listPaths(ListPathsRequest request, AsyncHandler<ListPathsRequest, ListPathsResponse> handler) {
        LOG.trace("Called async listPaths");
        ListPathsRequest interceptedRequest = ListPathsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPathsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListPathsResponse> transformer = ListPathsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListPaths", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryPathSummary/ListPaths");
        AsyncHandler<ListPathsRequest, ListPathsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPathsRequest, ListPathsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        LOG.trace("Called async listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListProjects", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProjectSummary/ListProjects");
        AsyncHandler<ListProjectsRequest, ListProjectsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProjectsRequest, ListProjectsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRefsResponse> listRefs(ListRefsRequest request, AsyncHandler<ListRefsRequest, ListRefsResponse> handler) {
        LOG.trace("Called async listRefs");
        ListRefsRequest interceptedRequest = ListRefsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRefsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRefsResponse> transformer = ListRefsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListRefs", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryRef/ListRefs");
        AsyncHandler<ListRefsRequest, ListRefsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRefsRequest, ListRefsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRepositoriesResponse> listRepositories(ListRepositoriesRequest request, AsyncHandler<ListRepositoriesRequest, ListRepositoriesResponse> handler) {
        LOG.trace("Called async listRepositories");
        ListRepositoriesRequest interceptedRequest = ListRepositoriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRepositoriesConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListRepositoriesResponse> transformer = ListRepositoriesConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListRepositories", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListRepositories");
        AsyncHandler<ListRepositoriesRequest, ListRepositoriesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRepositoriesRequest, ListRepositoriesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListTriggersResponse> listTriggers(ListTriggersRequest request, AsyncHandler<ListTriggersRequest, ListTriggersResponse> handler) {
        LOG.trace("Called async listTriggers");
        ListTriggersRequest interceptedRequest = ListTriggersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTriggersConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListTriggersResponse> transformer = ListTriggersConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListTriggers", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/TriggerCollection/ListTriggers");
        AsyncHandler<ListTriggersRequest, ListTriggersResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListTriggersRequest, ListTriggersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListWorkRequestErrors", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequestError/ListWorkRequestErrors");
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListWorkRequestLogs", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequestLogEntry/ListWorkRequestLogs");
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"ListWorkRequests", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequest/ListWorkRequests");
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<MirrorRepositoryResponse> mirrorRepository(MirrorRepositoryRequest request, AsyncHandler<MirrorRepositoryRequest, MirrorRepositoryResponse> handler) {
        LOG.trace("Called async mirrorRepository");
        MirrorRepositoryRequest interceptedRequest = MirrorRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = MirrorRepositoryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, MirrorRepositoryResponse> transformer = MirrorRepositoryConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"MirrorRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/MirrorRepository");
        AsyncHandler<MirrorRepositoryRequest, MirrorRepositoryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<MirrorRepositoryRequest, MirrorRepositoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<PutRepositoryRefResponse> putRepositoryRef(PutRepositoryRefRequest request, AsyncHandler<PutRepositoryRefRequest, PutRepositoryRefResponse> handler) {
        LOG.trace("Called async putRepositoryRef");
        PutRepositoryRefRequest interceptedRequest = PutRepositoryRefConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = PutRepositoryRefConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, PutRepositoryRefResponse> transformer = PutRepositoryRefConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails.setServiceDetails((String)"Devops", (String)"PutRepositoryRef", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/PutRepositoryRef");
        AsyncHandler<PutRepositoryRefRequest, PutRepositoryRefResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getPutRepositoryRefDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<PutRepositoryRefRequest, PutRepositoryRefResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBuildPipelineResponse> updateBuildPipeline(UpdateBuildPipelineRequest request, AsyncHandler<UpdateBuildPipelineRequest, UpdateBuildPipelineResponse> handler) {
        LOG.trace("Called async updateBuildPipeline");
        UpdateBuildPipelineRequest interceptedRequest = UpdateBuildPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBuildPipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateBuildPipelineResponse> transformer = UpdateBuildPipelineConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateBuildPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/UpdateBuildPipeline");
        AsyncHandler<UpdateBuildPipelineRequest, UpdateBuildPipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateBuildPipelineDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBuildPipelineRequest, UpdateBuildPipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBuildPipelineStageResponse> updateBuildPipelineStage(UpdateBuildPipelineStageRequest request, AsyncHandler<UpdateBuildPipelineStageRequest, UpdateBuildPipelineStageResponse> handler) {
        LOG.trace("Called async updateBuildPipelineStage");
        UpdateBuildPipelineStageRequest interceptedRequest = UpdateBuildPipelineStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBuildPipelineStageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateBuildPipelineStageResponse> transformer = UpdateBuildPipelineStageConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateBuildPipelineStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/UpdateBuildPipelineStage");
        AsyncHandler<UpdateBuildPipelineStageRequest, UpdateBuildPipelineStageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateBuildPipelineStageDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBuildPipelineStageRequest, UpdateBuildPipelineStageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBuildRunResponse> updateBuildRun(UpdateBuildRunRequest request, AsyncHandler<UpdateBuildRunRequest, UpdateBuildRunResponse> handler) {
        LOG.trace("Called async updateBuildRun");
        UpdateBuildRunRequest interceptedRequest = UpdateBuildRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBuildRunConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateBuildRunResponse> transformer = UpdateBuildRunConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateBuildRun", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/UpdateBuildRun");
        AsyncHandler<UpdateBuildRunRequest, UpdateBuildRunResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateBuildRunDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBuildRunRequest, UpdateBuildRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateConnectionResponse> updateConnection(UpdateConnectionRequest request, AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handler) {
        LOG.trace("Called async updateConnection");
        UpdateConnectionRequest interceptedRequest = UpdateConnectionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateConnectionConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateConnectionResponse> transformer = UpdateConnectionConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateConnection", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/UpdateConnection");
        AsyncHandler<UpdateConnectionRequest, UpdateConnectionResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateConnectionDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateConnectionRequest, UpdateConnectionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDeployArtifactResponse> updateDeployArtifact(UpdateDeployArtifactRequest request, AsyncHandler<UpdateDeployArtifactRequest, UpdateDeployArtifactResponse> handler) {
        LOG.trace("Called async updateDeployArtifact");
        UpdateDeployArtifactRequest interceptedRequest = UpdateDeployArtifactConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeployArtifactConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDeployArtifactResponse> transformer = UpdateDeployArtifactConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployArtifact", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/UpdateDeployArtifact");
        AsyncHandler<UpdateDeployArtifactRequest, UpdateDeployArtifactResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateDeployArtifactDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDeployArtifactRequest, UpdateDeployArtifactResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDeployEnvironmentResponse> updateDeployEnvironment(UpdateDeployEnvironmentRequest request, AsyncHandler<UpdateDeployEnvironmentRequest, UpdateDeployEnvironmentResponse> handler) {
        LOG.trace("Called async updateDeployEnvironment");
        UpdateDeployEnvironmentRequest interceptedRequest = UpdateDeployEnvironmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeployEnvironmentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDeployEnvironmentResponse> transformer = UpdateDeployEnvironmentConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployEnvironment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/UpdateDeployEnvironment");
        AsyncHandler<UpdateDeployEnvironmentRequest, UpdateDeployEnvironmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateDeployEnvironmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDeployEnvironmentRequest, UpdateDeployEnvironmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDeployPipelineResponse> updateDeployPipeline(UpdateDeployPipelineRequest request, AsyncHandler<UpdateDeployPipelineRequest, UpdateDeployPipelineResponse> handler) {
        LOG.trace("Called async updateDeployPipeline");
        UpdateDeployPipelineRequest interceptedRequest = UpdateDeployPipelineConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeployPipelineConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDeployPipelineResponse> transformer = UpdateDeployPipelineConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployPipeline", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/UpdateDeployPipeline");
        AsyncHandler<UpdateDeployPipelineRequest, UpdateDeployPipelineResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateDeployPipelineDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDeployPipelineRequest, UpdateDeployPipelineResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDeployStageResponse> updateDeployStage(UpdateDeployStageRequest request, AsyncHandler<UpdateDeployStageRequest, UpdateDeployStageResponse> handler) {
        LOG.trace("Called async updateDeployStage");
        UpdateDeployStageRequest interceptedRequest = UpdateDeployStageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeployStageConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDeployStageResponse> transformer = UpdateDeployStageConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployStage", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/UpdateDeployStage");
        AsyncHandler<UpdateDeployStageRequest, UpdateDeployStageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateDeployStageDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDeployStageRequest, UpdateDeployStageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDeploymentResponse> updateDeployment(UpdateDeploymentRequest request, AsyncHandler<UpdateDeploymentRequest, UpdateDeploymentResponse> handler) {
        LOG.trace("Called async updateDeployment");
        UpdateDeploymentRequest interceptedRequest = UpdateDeploymentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDeploymentConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateDeploymentResponse> transformer = UpdateDeploymentConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateDeployment", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/UpdateDeployment");
        AsyncHandler<UpdateDeploymentRequest, UpdateDeploymentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateDeploymentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDeploymentRequest, UpdateDeploymentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        LOG.trace("Called async updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateProject", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/UpdateProject");
        AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateProjectDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateProjectRequest, UpdateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRepositoryResponse> updateRepository(UpdateRepositoryRequest request, AsyncHandler<UpdateRepositoryRequest, UpdateRepositoryResponse> handler) {
        LOG.trace("Called async updateRepository");
        UpdateRepositoryRequest interceptedRequest = UpdateRepositoryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRepositoryConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateRepositoryResponse> transformer = UpdateRepositoryConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateRepository", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/UpdateRepository");
        AsyncHandler<UpdateRepositoryRequest, UpdateRepositoryResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateRepositoryDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRepositoryRequest, UpdateRepositoryResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateTriggerResponse> updateTrigger(UpdateTriggerRequest request, AsyncHandler<UpdateTriggerRequest, UpdateTriggerResponse> handler) {
        LOG.trace("Called async updateTrigger");
        UpdateTriggerRequest interceptedRequest = UpdateTriggerConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTriggerConverter.fromRequest(this.client, interceptedRequest);
        com.google.common.base.Function<Response, UpdateTriggerResponse> transformer = UpdateTriggerConverter.fromResponse();
        ServiceDetails.setServiceDetails((String)"Devops", (String)"UpdateTrigger", (String)ib.getRequestUri().toString(), (String)"https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/UpdateTrigger");
        AsyncHandler<UpdateTriggerRequest, UpdateTriggerResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateTriggerDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateTriggerRequest, UpdateTriggerResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DevopsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DevopsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DevopsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

