/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.stream.read.listener;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.blobstore.stream.read.ReadContext;
import org.opensearch.common.blobstore.stream.read.listener.FileCompletionListener;
import org.opensearch.common.blobstore.stream.read.listener.FilePartWriter;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;

@InternalApi
public class ReadContextListener
implements ActionListener<ReadContext> {
    private final String fileName;
    private final Path fileLocation;
    private final ThreadPool threadPool;
    private final ActionListener<String> completionListener;
    private static final Logger logger = LogManager.getLogger(ReadContextListener.class);

    public ReadContextListener(String fileName, Path fileLocation, ThreadPool threadPool, ActionListener<String> completionListener) {
        this.fileName = fileName;
        this.fileLocation = fileLocation;
        this.threadPool = threadPool;
        this.completionListener = completionListener;
    }

    public void onResponse(ReadContext readContext) {
        logger.trace("Streams received for blob {}", (Object)this.fileName);
        int numParts = readContext.getNumberOfParts();
        AtomicBoolean anyPartStreamFailed = new AtomicBoolean();
        FileCompletionListener fileCompletionListener = new FileCompletionListener(numParts, this.fileName, this.completionListener);
        for (int partNumber = 0; partNumber < numParts; ++partNumber) {
            FilePartWriter filePartWriter = new FilePartWriter(partNumber, readContext.getPartStreams().get(partNumber), this.fileLocation, anyPartStreamFailed, fileCompletionListener);
            this.threadPool.executor("generic").submit(filePartWriter);
        }
    }

    public void onFailure(Exception e) {
        this.completionListener.onFailure(e);
    }
}

