/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.opensearch.common.document.DocumentField;
import org.opensearch.search.SearchHit;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;
import org.opensearch.search.fetch.subphase.FetchFieldsContext;
import org.opensearch.search.fetch.subphase.FieldFetcher;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.lookup.SourceLookup;

public final class FetchFieldsPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext fetchContext) {
        FetchFieldsContext fetchFieldsContext = fetchContext.fetchFieldsContext();
        if (fetchFieldsContext == null) {
            return null;
        }
        SearchLookup searchLookup = fetchContext.searchLookup();
        if (!fetchContext.mapperService().documentMapper().sourceMapper().enabled()) {
            throw new IllegalArgumentException("Unable to retrieve the requested [fields] since _source is disabled in the mappings for index [" + fetchContext.getIndexName() + "]");
        }
        final FieldFetcher fieldFetcher = FieldFetcher.create(fetchContext.getQueryShardContext(), searchLookup, fetchFieldsContext.fields());
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
                fieldFetcher.setNextReader(readerContext);
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                SearchHit hit = hitContext.hit();
                SourceLookup sourceLookup = hitContext.sourceLookup();
                Set<String> ignoredFields = FetchFieldsPhase.this.getIgnoredFields(hit);
                Map<String, DocumentField> documentFields = fieldFetcher.fetch(sourceLookup, ignoredFields);
                for (Map.Entry<String, DocumentField> entry : documentFields.entrySet()) {
                    hit.setDocumentField(entry.getKey(), entry.getValue());
                }
            }
        };
    }

    private Set<String> getIgnoredFields(SearchHit hit) {
        DocumentField field = hit.field("_ignored");
        if (field == null) {
            return Set.of();
        }
        HashSet<String> ignoredFields = new HashSet<String>();
        for (Object value : field.getValues()) {
            ignoredFields.add((String)value);
        }
        return ignoredFields;
    }
}

