/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.ActionGroupsV7;
import org.opensearch.threadpool.ThreadPool;

public class ActionGroupsApiAction
extends AbstractApiAction {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/actiongroup/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/actiongroup/"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/actiongroup/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/actiongroup/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/actiongroups/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/actiongroups/"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/actiongroups/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/actiongroups/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/actiongroups/"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/actiongroups/{name}")));

    @Inject
    public ActionGroupsApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.ACTIONGROUPS, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::actionGroupsApiRequestHandlers);
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType getConfigType() {
        return CType.ACTIONGROUPS;
    }

    private void actionGroupsApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processPatchRequest)).override(RestRequest.Method.POST, RequestHandler.methodNotImplementedHandler);
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return ActionGroupsApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return ActionGroupsApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigChange(SecurityConfiguration securityConfiguration) throws IOException {
                return EndpointValidator.super.onConfigChange(securityConfiguration).map(this::actionGroupNameIsNotSameAsRoleName).map(this::hasSelfReference);
            }

            @Override
            public ValidationResult<SecurityConfiguration> isAllowedToChangeImmutableEntity(SecurityConfiguration securityConfiguration) throws IOException {
                return EndpointValidator.super.isAllowedToChangeImmutableEntity(securityConfiguration).map(this::isAllowedToChangeEntityWithRestAdminPermissions);
            }

            private ValidationResult<SecurityConfiguration> actionGroupNameIsNotSameAsRoleName(SecurityConfiguration securityConfiguration) throws IOException {
                return ActionGroupsApiAction.this.loadConfiguration(CType.ROLES, false, false).map(rolesConfiguration -> this.actionGroupNameIsNotSameAsRoleName(securityConfiguration, (SecurityDynamicConfiguration<?>)rolesConfiguration));
            }

            private ValidationResult<SecurityConfiguration> actionGroupNameIsNotSameAsRoleName(SecurityConfiguration securityConfiguration, SecurityDynamicConfiguration<?> rolesConfiguration) {
                if (rolesConfiguration.getCEntries().containsKey(securityConfiguration.entityName())) {
                    return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage(securityConfiguration.entityName() + " is an existing role. A action group cannot be named with an existing role name."));
                }
                return ValidationResult.success(securityConfiguration);
            }

            private ValidationResult<SecurityConfiguration> hasSelfReference(SecurityConfiguration securityConfiguration) throws IOException {
                ActionGroupsV7 actionGroups = (ActionGroupsV7)Utils.toConfigObject(securityConfiguration.requestContent(), securityConfiguration.configuration().getImplementingClass());
                if (this.hasSelfReference(securityConfiguration.entityName(), actionGroups)) {
                    return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage(securityConfiguration.entityName() + " cannot be an allowed_action of itself"));
                }
                return ValidationResult.success(securityConfiguration);
            }

            private boolean hasSelfReference(String name, ActionGroupsV7 actionGroups) {
                List<String> allowedActions = actionGroups.getAllowed_actions();
                return allowedActions.contains(name);
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return ActionGroupsApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        ImmutableMap.Builder allowedKeys = ImmutableMap.builder();
                        if (this.isCurrentUserAdmin()) {
                            allowedKeys.put((Object)"reserved", (Object)RequestContentValidator.DataType.BOOLEAN);
                        }
                        allowedKeys.put((Object)"allowed_actions", (Object)RequestContentValidator.DataType.ARRAY);
                        allowedKeys.put((Object)"description", (Object)RequestContentValidator.DataType.STRING);
                        allowedKeys.put((Object)"type", (Object)RequestContentValidator.DataType.STRING);
                        return allowedKeys.build();
                    }

                    @Override
                    public Set<String> mandatoryKeys() {
                        return ImmutableSet.of((Object)"allowed_actions");
                    }
                });
            }
        };
    }
}

