# Installation
> `npm install --save @types/mapbox__vector-tile`

# Summary
This package contains type definitions for @mapbox/vector-tile (https://github.com/mapbox/vector-tile-js).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/mapbox__vector-tile.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/mapbox__vector-tile/index.d.ts)
````ts
// Type definitions for @mapbox/vector-tile 1.3
// Project: https://github.com/mapbox/vector-tile-js
// Definitions by: Mathieu Maes <https://github.com/webberig>
//                 Harel Mazor <https://github.com/HarelM>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

import Pbf =  require('pbf');
import { Feature } from 'geojson';
import Point = require('@mapbox/point-geometry');

export class VectorTile {
    constructor(pbf: Pbf);
    layers: {[_: string]: VectorTileLayer};
}

export class VectorTileFeature {
    static types: ['Unknown', 'Point', 'LineString', 'Polygon'];
    extent: number;
    type: 1 | 2 | 3;
    id: number;
    properties: {[_: string]: string | number | boolean};
    loadGeometry(): Point[][];
    toGeoJSON(x: number, y: number, z: number): Feature;
    bbox?(): [number, number, number, number];
}

export class VectorTileLayer {
    constructor(pbf: Pbf);
    version?: number;
    name: string;
    extent: number;
    length: number;
    feature(featureIndex: number): VectorTileFeature;
}

````

### Additional Details
 * Last updated: Fri, 21 Jan 2022 06:31:24 GMT
 * Dependencies: [@types/pbf](https://npmjs.com/package/@types/pbf), [@types/geojson](https://npmjs.com/package/@types/geojson), [@types/mapbox__point-geometry](https://npmjs.com/package/@types/mapbox__point-geometry)
 * Global values: none

# Credits
These definitions were written by [Mathieu Maes](https://github.com/webberig), and [Harel Mazor](https://github.com/HarelM).
