/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) / 6u) => uvec4(11u, 12u, 14u, 12u)
 * (uvec4(66u, 72u, 87u, 75u) / 12u) => uvec4(5u, 6u, 7u, 6u)
 * (uvec4(66u, 72u, 87u, 75u) / 32u) => uvec4(2u, 2u, 2u, 2u)
 * (uvec4(66u, 72u, 87u, 75u) / 74u) => uvec4(0u, 0u, 1u, 1u)
 * (uvec4(24u, 40u, 23u, 74u) / 6u) => uvec4(4u, 6u, 3u, 12u)
 * (uvec4(24u, 40u, 23u, 74u) / 12u) => uvec4(2u, 3u, 1u, 6u)
 * (uvec4(24u, 40u, 23u, 74u) / 32u) => uvec4(0u, 1u, 0u, 2u)
 * (uvec4(24u, 40u, 23u, 74u) / 74u) => uvec4(0u, 0u, 0u, 1u)
 */
#version 150

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) / 6u), uvec4(11u, 12u, 14u, 12u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) / 12u), uvec4(5u, 6u, 7u, 6u))) ? 1 : -1] array1;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) / 32u), uvec4(2u, 2u, 2u, 2u))) ? 1 : -1] array2;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) / 74u), uvec4(0u, 0u, 1u, 1u))) ? 1 : -1] array3;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) / 6u), uvec4(4u, 6u, 3u, 12u))) ? 1 : -1] array4;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) / 12u), uvec4(2u, 3u, 1u, 6u))) ? 1 : -1] array5;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) / 32u), uvec4(0u, 1u, 0u, 2u))) ? 1 : -1] array6;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) / 74u), uvec4(0u, 0u, 0u, 1u))) ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
