/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(-0.0lf, 0.0lf, 0.0lf, 0.0lf)
 * (-1.3333333333333333lf / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(0.8080808080808081lf, -1.0025062656641603lf, -0.690846286701209lf, -1.7543859649122806lf)
 * (0.85lf / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)) => dvec4(-0.5151515151515151lf, 0.6390977443609022lf, 0.44041450777202074lf, 1.118421052631579lf)
 */
#version 400

void main()
{
  double[distance((0.0lf / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(-0.0lf, 0.0lf, 0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((-1.3333333333333333lf / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(0.8080808080808081lf, -1.0025062656641603lf, -0.690846286701209lf, -1.7543859649122806lf)) <= 2.2832328201071556e-05lf ? 1 : -1] array1;
  double[distance((0.85lf / dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf)), dvec4(-0.5151515151515151lf, 0.6390977443609022lf, 0.44041450777202074lf, 1.118421052631579lf)) <= 1.4555609228183118e-05lf ? 1 : -1] array2;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length());
}
