/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import com.nimbusds.oauth2.sdk.ParseException;
import jakarta.annotation.Nullable;
import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Date;
import org.traccar.api.BaseResource;
import org.traccar.api.security.LoginService;
import org.traccar.api.signature.TokenManager;
import org.traccar.database.OpenIdProvider;
import org.traccar.helper.DataConverter;
import org.traccar.helper.LogAction;
import org.traccar.helper.WebHelper;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="session")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class SessionResource
extends BaseResource {
    public static final String USER_ID_KEY = "userId";
    public static final String USER_COOKIE_KEY = "user";
    public static final String PASS_COOKIE_KEY = "password";
    @Inject
    private LoginService loginService;
    @Inject
    @Nullable
    private OpenIdProvider openIdProvider;
    @Inject
    private TokenManager tokenManager;
    @Context
    private HttpServletRequest request;

    @PermitAll
    @GET
    public User get(@QueryParam(value="token") String token) throws StorageException, IOException, GeneralSecurityException {
        User user;
        if (token != null && (user = this.loginService.login(token)) != null) {
            this.request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
            LogAction.login(user.getId(), WebHelper.retrieveRemoteAddress(this.request));
            return user;
        }
        Long userId = (Long)this.request.getSession().getAttribute(USER_ID_KEY);
        if (userId == null) {
            User user2;
            Cookie[] cookies = this.request.getCookies();
            String email = null;
            String password = null;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (cookie.getName().equals(USER_COOKIE_KEY)) {
                        byte[] emailBytes = DataConverter.parseBase64(URLDecoder.decode(cookie.getValue(), StandardCharsets.US_ASCII));
                        email = new String(emailBytes, StandardCharsets.UTF_8);
                        continue;
                    }
                    if (!cookie.getName().equals(PASS_COOKIE_KEY)) continue;
                    byte[] passwordBytes = DataConverter.parseBase64(URLDecoder.decode(cookie.getValue(), StandardCharsets.US_ASCII));
                    password = new String(passwordBytes, StandardCharsets.UTF_8);
                }
            }
            if (email != null && password != null && (user2 = this.loginService.login(email, password)) != null) {
                this.request.getSession().setAttribute(USER_ID_KEY, (Object)user2.getId());
                LogAction.login(user2.getId(), WebHelper.retrieveRemoteAddress(this.request));
                return user2;
            }
        } else {
            User user3 = this.permissionsService.getUser(userId);
            if (user3 != null) {
                return user3;
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @Path(value="{id}")
    @GET
    public User get(@PathParam(value="id") long userId) throws StorageException {
        this.permissionsService.checkUser(this.getUserId(), userId);
        User user = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", userId)));
        this.request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
        LogAction.login(user.getId(), WebHelper.retrieveRemoteAddress(this.request));
        return user;
    }

    @PermitAll
    @POST
    public User add(@FormParam(value="email") String email, @FormParam(value="password") String password) throws StorageException {
        User user = this.loginService.login(email, password);
        if (user != null) {
            this.request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
            LogAction.login(user.getId(), WebHelper.retrieveRemoteAddress(this.request));
            return user;
        }
        LogAction.failedLogin(WebHelper.retrieveRemoteAddress(this.request));
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
    }

    @DELETE
    public Response remove() {
        LogAction.logout(this.getUserId(), WebHelper.retrieveRemoteAddress(this.request));
        this.request.getSession().removeAttribute(USER_ID_KEY);
        return Response.noContent().build();
    }

    @Path(value="token")
    @POST
    public String requestToken(@FormParam(value="expiration") Date expiration) throws StorageException, GeneralSecurityException, IOException {
        return this.tokenManager.generateToken(this.getUserId(), expiration);
    }

    @PermitAll
    @Path(value="openid/auth")
    @GET
    public Response openIdAuth() throws IOException {
        return Response.seeOther((URI)this.openIdProvider.createAuthUri()).build();
    }

    @PermitAll
    @Path(value="openid/callback")
    @GET
    public Response requestToken() throws IOException, StorageException, ParseException, GeneralSecurityException {
        StringBuilder requestUrl = new StringBuilder(this.request.getRequestURL().toString());
        String queryString = this.request.getQueryString();
        String requestUri = requestUrl.append('?').append(queryString).toString();
        return Response.seeOther((URI)this.openIdProvider.handleCallback(URI.create(requestUri), this.request)).build();
    }
}

