/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Event;
import org.traccar.model.Notification;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Singleton
public class NotificatorTraccar
implements Notificator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificatorTraccar.class);
    private final NotificationFormatter notificationFormatter;
    private final Client client;
    private final Storage storage;
    private final CacheManager cacheManager;
    private final String url;
    private final String key;

    @Inject
    public NotificatorTraccar(Config config, NotificationFormatter notificationFormatter, Client client, Storage storage, CacheManager cacheManager) {
        this.notificationFormatter = notificationFormatter;
        this.client = client;
        this.storage = storage;
        this.cacheManager = cacheManager;
        this.url = "https://www.traccar.org/push/";
        this.key = config.getString(Keys.NOTIFICATOR_TRACCAR_KEY);
    }

    @Override
    public void send(Notification notification, User user, Event event, Position position) {
        if (user.hasAttribute("notificationTokens")) {
            NotificationMessage shortMessage = this.notificationFormatter.formatMessage(user, event, position, "short");
            NotificationObject item = new NotificationObject();
            item.title = shortMessage.getSubject();
            item.body = shortMessage.getBody();
            item.sound = "default";
            String[] tokenArray = user.getString("notificationTokens").split("[, ]");
            ArrayList<String> registrationTokens = new ArrayList<String>(Arrays.asList(tokenArray));
            Message message = new Message();
            message.tokens = user.getString("notificationTokens").split("[, ]");
            message.notification = item;
            Invocation.Builder request = this.client.target(this.url).request().header("Authorization", (Object)("key=" + this.key));
            try (Response result = request.post(Entity.json((Object)message));){
                JsonObject json = (JsonObject)result.readEntity(JsonObject.class);
                LinkedList<String> failedTokens = new LinkedList<String>();
                JsonArray responses = json.getJsonArray("responses");
                for (int i = 0; i < responses.size(); ++i) {
                    JsonObject response = responses.getJsonObject(i);
                    if (response.getBoolean("success")) continue;
                    JsonObject error = response.getJsonObject("error");
                    String errorCode = error.getString("code");
                    if (errorCode.equals("messaging/invalid-argument") || errorCode.equals("messaging/registration-token-not-registered")) {
                        failedTokens.add((String)registrationTokens.get(i));
                    }
                    LOGGER.warn("Push user {} error - {}", (Object)user.getId(), (Object)error.getString("message"));
                }
                if (!failedTokens.isEmpty()) {
                    registrationTokens.removeAll(failedTokens);
                    if (registrationTokens.isEmpty()) {
                        user.getAttributes().remove("notificationTokens");
                    } else {
                        user.set("notificationTokens", String.join((CharSequence)",", registrationTokens));
                    }
                    this.storage.updateObject(user, new Request((Columns)new Columns.Include("attributes"), new Condition.Equals("id", user.getId())));
                    this.cacheManager.updateOrInvalidate(true, user);
                }
            }
            catch (StorageException e) {
                LOGGER.warn("Push error", (Throwable)e);
            }
        }
    }

    public static class NotificationObject {
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="body")
        private String body;
        @JsonProperty(value="sound")
        private String sound;
    }

    public static class Message {
        @JsonProperty(value="registration_ids")
        private String[] tokens;
        @JsonProperty(value="notification")
        private NotificationObject notification;
    }
}

