/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class FlextrackProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_LOGON = new PatternBuilder().number("(-?d+),").text("LOGON,").number("(d+),").number("(d+)").compile();
    private static final Pattern PATTERN = new PatternBuilder().number("(-?d+),").text("UNITSTAT,").number("(dddd)(dd)(dd),").number("(dd)(dd)(dd),").number("d+,").number("([NS])(d+).(d+.d+),").number("([EW])(d+).(d+.d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(x+),").number("(ddd)").number("(dd),").number("(-?d+),").number("(d+),").number("(x+),").number("d+,").number("(x+),").number("(d+)").compile();

    public FlextrackProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendAcknowledgement(Channel channel, SocketAddress remoteAddress, String index) {
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(index + ",ACK\r", remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.contains("LOGON")) {
            Parser parser = new Parser(PATTERN_LOGON, sentence);
            if (!parser.matches()) {
                return null;
            }
            this.sendAcknowledgement(channel, remoteAddress, parser.next());
            String id = parser.next();
            String iccid = parser.next();
            this.getDeviceSession(channel, remoteAddress, iccid, id);
        } else if (sentence.contains("UNITSTAT")) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Parser parser = new Parser(PATTERN, sentence);
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.sendAcknowledgement(channel, remoteAddress, parser.next());
            position.setTime(parser.nextDateTime());
            position.setValid(true);
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt(0)));
            position.setCourse(parser.nextInt(0));
            position.set("sat", parser.nextInt(0));
            position.set("battery", parser.nextInt(0));
            int rssi = parser.nextInt(0);
            position.set("status", parser.nextHexInt(0));
            int mcc = parser.nextInt(0);
            int mnc = parser.nextInt(0);
            position.setAltitude(parser.nextInt(0));
            position.set("hdop", (double)parser.nextInt(0) * 0.1);
            position.setNetwork(new Network(CellTower.from(mcc, mnc, parser.nextHexInt(0), parser.nextHexInt(0), rssi)));
            position.set("odometer", parser.nextInt(0));
            return position;
        }
        return null;
    }
}

