/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.formula;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jxls.area.Area;
import org.jxls.common.CellData;
import org.jxls.common.CellRef;
import org.jxls.formula.FormulaProcessor;
import org.jxls.transform.Transformer;
import org.jxls.util.Util;

public abstract class AbstractFormulaProcessor
implements FormulaProcessor {
    protected Map<CellRef, List<CellRef>> buildTargetCellRefMap(Transformer transformer, Area area, CellData formulaCellData) {
        LinkedHashMap<CellRef, List<CellRef>> targetCellRefMap = new LinkedHashMap<CellRef, List<CellRef>>();
        List<String> formulaCellRefs = Util.getFormulaCellRefs(formulaCellData.getFormula());
        for (String cellRef : formulaCellRefs) {
            List<CellRef> targetCellDataList;
            CellRef pos = new CellRef(cellRef);
            if (!pos.isValid()) continue;
            if (pos.getSheetName() == null) {
                pos.setSheetName(formulaCellData.getSheetName());
                pos.setIgnoreSheetNameInFormat(true);
            }
            if ((targetCellDataList = transformer.getTargetCellRef(pos)).isEmpty() && area != null && !area.getAreaRef().contains(pos)) {
                targetCellDataList.add(pos);
            }
            targetCellRefMap.put(pos, targetCellDataList);
        }
        return targetCellRefMap;
    }

    protected Map<String, List<CellRef>> buildJointedCellRefMap(Transformer transformer, CellData formulaCellData) {
        LinkedHashMap<String, List<CellRef>> jointedCellRefMap = new LinkedHashMap<String, List<CellRef>>();
        List<String> jointedCellRefs = Util.getJointedCellRefs(formulaCellData.getFormula());
        for (String jointedCellRef : jointedCellRefs) {
            List<String> nestedCellRefs = Util.getCellRefsFromJointedCellRef(jointedCellRef);
            ArrayList<CellRef> jointedCellRefList = new ArrayList<CellRef>();
            for (String cellRef : nestedCellRefs) {
                CellRef pos = new CellRef(cellRef);
                if (pos.getSheetName() == null) {
                    pos.setSheetName(formulaCellData.getSheetName());
                    pos.setIgnoreSheetNameInFormat(true);
                }
                List<CellRef> targetCellDataList = transformer.getTargetCellRef(pos);
                jointedCellRefList.addAll(targetCellDataList);
            }
            jointedCellRefMap.put(jointedCellRef, jointedCellRefList);
        }
        return jointedCellRefMap;
    }

    @Override
    @Deprecated
    public void processAreaFormulas(Transformer transformer) {
        this.processAreaFormulas(transformer, null);
    }
}

