/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.ObjectReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.Debugger;
import jde.debugger.JDE;
import jde.debugger.Protocol;

public class ObjectStore
implements Protocol {
    private Debugger m_debugger;
    private Map m_objectMap;
    private long m_maximumLimit = 100L;
    private boolean m_requestPending = false;

    public ObjectStore(Debugger debugger) {
        this.m_debugger = debugger;
        this.m_objectMap = new HashMap();
    }

    public synchronized void put(ObjectReference ref) {
        this.m_objectMap.put(new Long(ref.uniqueID()), ref);
        long size = this.m_objectMap.size();
        if (size > this.m_maximumLimit && !this.m_requestPending) {
            JDE.signal(this.m_debugger.getProcID(), "report-ids-in-use", null);
            this.m_requestPending = true;
        }
    }

    public synchronized void trim(List objectIDs) {
        HashMap newMap = new HashMap();
        Iterator it = objectIDs.iterator();
        while (it.hasNext()) {
            Long id = (Long)it.next();
            if (!this.m_objectMap.containsKey(id)) continue;
            newMap.put(id, this.m_objectMap.get(id));
        }
        this.m_maximumLimit = 2 * newMap.size();
        this.m_objectMap = newMap;
        this.m_requestPending = false;
    }

    public synchronized ObjectReference get(Object id) {
        return (ObjectReference)this.m_objectMap.get(id);
    }
}

