/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.AbstractNameValueComment;
import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarHeader
extends AbstractNameValueComment {
    private HarCustomFields customFields = new HarCustomFields();

    public HarHeader(String name, String value, String comment) {
        super(name, value, comment);
    }

    public HarHeader(HarDatabaseConfig config, long headerId, String name, String value, String comment) throws SQLException {
        super(name, value, comment);
        this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARHEADER, headerId);
    }

    public HarHeader(String name, String value) {
        super(name, value);
    }

    public HarHeader(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        super(jp);
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"headers\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("name".equals(name)) {
                this.setName(jp.getText());
                continue;
            }
            if ("value".equals(name)) {
                this.setValue(jp.getText());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in headers element", jp.getCurrentLocation());
        }
        if (this.getName() == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing name field in header element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing name field in header element", jp.getCurrentLocation());
            }
        }
        if (this.getValue() == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing value field in header element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing value field in header element", jp.getCurrentLocation());
            }
        }
    }

    @Override
    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeStartObject();
        g.writeStringField("name", this.getName());
        g.writeStringField("value", this.getValue());
        if (this.getComment() != null) {
            g.writeStringField("comment", this.getComment());
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    public void writeJDBC(HarDatabaseConfig config, long id, PreparedStatement ps, boolean isRequest, long logId) throws SQLException {
        ps.setString(1, this.getName());
        ps.setString(2, this.getValue());
        if (this.getComment() == null) {
            ps.setNull(3, -1);
        } else {
            ps.setString(3, this.getComment());
        }
        ps.setInt(4, isRequest ? 1 : 0);
        ps.setLong(5, id);
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException("The database did not generate a key for an HarPage entry");
        }
        long hearderId = rs.getLong(1);
        this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARHEADER, hearderId, logId);
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    @Override
    public String toString() {
        return "{ \"name\": \"" + this.getName() + "\", \"value\": \"" + this.getValue() + "\", \"comment\": \"" + this.getComment() + "\", " + this.customFields + " }";
    }
}

