/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.WhitePointColorSpace;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001a\u001b\u001cJ*\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u000fH\u0016J\u001a\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0012\u001a\u00020\u0015H\u0016J+\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0017H\u00a6\u0002J+\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00152\b\b\u0002\u0010\u0012\u001a\u00020\u0015H\u0096\u0002J\u0011\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0096\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/github/ajalt/colormath/model/RGBColorSpace;", "Lcom/github/ajalt/colormath/WhitePointColorSpace;", "Lcom/github/ajalt/colormath/model/RGB;", "matrixFromXyz", "", "getMatrixFromXyz", "()[F", "matrixToXyz", "getMatrixToXyz", "transferFunctions", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "getTransferFunctions", "()Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "from255", "r", "", "g", "b", "alpha", "grey", "amount", "", "invoke", "", "hex", "", "GammaTransferFunctions", "LinearTransferFunctions", "TransferFunctions", "colormath"})
public interface RGBColorSpace
extends WhitePointColorSpace<RGB> {
    @NotNull
    public RGB invoke(float var1, float var2, float var3, float var4);

    @NotNull
    public RGB invoke(@NotNull Number var1, @NotNull Number var2, @NotNull Number var3, @NotNull Number var4);

    @NotNull
    public RGB from255(int var1, int var2, int var3, int var4);

    @NotNull
    public RGB invoke(@NotNull String var1);

    @NotNull
    public RGB grey(@NotNull Number var1, @NotNull Number var2);

    @NotNull
    public TransferFunctions getTransferFunctions();

    @NotNull
    public float[] getMatrixToXyz();

    @NotNull
    public float[] getMatrixFromXyz();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0006"}, d2={"Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "", "eotf", "", "x", "oetf", "colormath"})
    public static interface TransferFunctions {
        public float eotf(float var1);

        public float oetf(float var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/ajalt/colormath/model/RGBColorSpace$GammaTransferFunctions;", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "gamma", "", "(D)V", "component1", "copy", "eotf", "", "x", "equals", "", "other", "", "hashCode", "", "oetf", "toString", "", "colormath"})
    public static final class GammaTransferFunctions
    implements TransferFunctions {
        private final double gamma;

        public GammaTransferFunctions(double gamma) {
            this.gamma = gamma;
        }

        @Override
        public float eotf(float x) {
            return (float)InternalMathKt.spow(x, this.gamma);
        }

        @Override
        public float oetf(float x) {
            return (float)InternalMathKt.spow(x, 1.0 / this.gamma);
        }

        private final double component1() {
            return this.gamma;
        }

        @NotNull
        public final GammaTransferFunctions copy(double gamma) {
            return new GammaTransferFunctions(gamma);
        }

        public static /* synthetic */ GammaTransferFunctions copy$default(GammaTransferFunctions gammaTransferFunctions, double d, int n, Object object) {
            if ((n & 1) != 0) {
                d = gammaTransferFunctions.gamma;
            }
            return gammaTransferFunctions.copy(d);
        }

        @NotNull
        public String toString() {
            return "GammaTransferFunctions(gamma=" + this.gamma + ')';
        }

        public int hashCode() {
            return Double.hashCode(this.gamma);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GammaTransferFunctions)) {
                return false;
            }
            GammaTransferFunctions gammaTransferFunctions = (GammaTransferFunctions)other;
            return Intrinsics.areEqual((Object)this.gamma, (Object)gammaTransferFunctions.gamma);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/github/ajalt/colormath/model/RGBColorSpace$LinearTransferFunctions;", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "()V", "eotf", "", "x", "oetf", "colormath"})
    public static final class LinearTransferFunctions
    implements TransferFunctions {
        @NotNull
        public static final LinearTransferFunctions INSTANCE = new LinearTransferFunctions();

        private LinearTransferFunctions() {
        }

        @Override
        public float eotf(float x) {
            return x;
        }

        @Override
        public float oetf(float x) {
            return x;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ RGB invoke$default(RGBColorSpace rGBColorSpace, float f, float f2, float f3, float f4, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invoke");
            }
            if ((n & 8) != 0) {
                f4 = 1.0f;
            }
            return rGBColorSpace.invoke(f, f2, f3, f4);
        }

        @NotNull
        public static RGB invoke(@NotNull RGBColorSpace this_, @NotNull Number r, @NotNull Number g, @NotNull Number b, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(r, "r");
            Intrinsics.checkNotNullParameter(g, "g");
            Intrinsics.checkNotNullParameter(b, "b");
            Intrinsics.checkNotNullParameter(alpha, "alpha");
            return this_.invoke(r.floatValue(), g.floatValue(), b.floatValue(), alpha.floatValue());
        }

        public static /* synthetic */ RGB invoke$default(RGBColorSpace rGBColorSpace, Number number, Number number2, Number number3, Number number4, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invoke");
            }
            if ((n & 8) != 0) {
                number4 = Float.valueOf(1.0f);
            }
            return rGBColorSpace.invoke(number, number2, number3, number4);
        }

        @NotNull
        public static RGB from255(@NotNull RGBColorSpace this_, int r, int g, int b, int alpha) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return this_.invoke((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)alpha / 255.0f);
        }

        public static /* synthetic */ RGB from255$default(RGBColorSpace rGBColorSpace, int n, int n2, int n3, int n4, int n5, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: from255");
            }
            if ((n5 & 8) != 0) {
                n4 = 255;
            }
            return rGBColorSpace.from255(n, n2, n3, n4);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static RGB invoke(@NotNull RGBColorSpace this_, @NotNull String hex) {
            void it;
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(hex, "hex");
            int n = RGBKt.access$getHexLength(hex);
            boolean bl = false;
            boolean bl2 = false;
            int n2 = n;
            int n3 = RGBKt.access$parseHex(hex, 2);
            int n4 = RGBKt.access$parseHex(hex, 1);
            int n5 = RGBKt.access$parseHex(RGBKt.access$validateHex(hex), 0);
            RGBColorSpace rGBColorSpace = this_;
            boolean bl3 = false;
            boolean bl4 = it == 4 || it == 8;
            return rGBColorSpace.from255(n5, n4, n3, bl4 ? RGBKt.access$parseHex(hex, 3) : 255);
        }

        @NotNull
        public static RGB grey(@NotNull RGBColorSpace this_, @NotNull Number amount, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter(this_, "this");
            Intrinsics.checkNotNullParameter(amount, "amount");
            Intrinsics.checkNotNullParameter(alpha, "alpha");
            return this_.invoke(amount, amount, amount, alpha);
        }

        public static /* synthetic */ RGB grey$default(RGBColorSpace rGBColorSpace, Number number, Number number2, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: grey");
            }
            if ((n & 2) != 0) {
                number2 = Float.valueOf(1.0f);
            }
            return rGBColorSpace.grey(number, number2);
        }
    }
}

