/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0002\u001a \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\b*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\bH\u0000\u001a,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0002\u00a8\u0006\u001a"}, d2={"downsample", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "style", "level", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "hyperlinks", "", "makeHyperlinkTag", "", "hyperlink", "hyperlinkId", "makeTag", "old", "new", "renderLinesAnsi", "lines", "Lcom/github/ajalt/mordant/rendering/Lines;", "invokeStyle", "text", "toAnsi", "", "", "Lcom/github/ajalt/colormath/Color;", "select", "reset", "offset", "mordant"})
public final class AnsiRenderKt {
    @NotNull
    public static final String renderLinesAnsi(@NotNull Lines lines, @NotNull AnsiLevel level, boolean hyperlinks) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter((Object)level, "level");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$renderLinesAnsi_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        Iterator<Line> iterator2 = lines.getLines().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Line line = iterator2.next();
            if (i > 0) {
                $this$renderLinesAnsi_u24lambda_u2d0.append("\n");
            }
            TextStyle activeStyle = ConstantsKt.getDEFAULT_STYLE();
            for (Span span : line) {
                TextStyle newStyle = AnsiRenderKt.downsample(span.getStyle(), level, hyperlinks);
                $this$renderLinesAnsi_u24lambda_u2d0.append(AnsiRenderKt.makeTag(activeStyle, newStyle));
                activeStyle = newStyle;
                $this$renderLinesAnsi_u24lambda_u2d0.append(span.getText());
            }
            $this$renderLinesAnsi_u24lambda_u2d0.append(AnsiRenderKt.makeTag(activeStyle, ConstantsKt.getDEFAULT_STYLE()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String invokeStyle(@NotNull TextStyle $this$invokeStyle, @NotNull String text) {
        Intrinsics.checkNotNullParameter($this$invokeStyle, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        CharSequence charSequence = text;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        Ref.ObjectRef<TextStyle> openStyle = new Ref.ObjectRef<TextStyle>();
        openStyle.element = $this$invokeStyle;
        Ref.ObjectRef<TextStyle> style = new Ref.ObjectRef<TextStyle>();
        style.element = $this$invokeStyle;
        String inner2 = ConstantsKt.getANSI_RE().replace((CharSequence)text, (Function1<? super MatchResult, ? extends CharSequence>)new Function1<MatchResult, CharSequence>(text, style, $this$invokeStyle, openStyle){
            final /* synthetic */ String $text;
            final /* synthetic */ Ref.ObjectRef<TextStyle> $style;
            final /* synthetic */ TextStyle $this_invokeStyle;
            final /* synthetic */ Ref.ObjectRef<TextStyle> $openStyle;
            {
                this.$text = $text;
                this.$style = $style;
                this.$this_invokeStyle = $receiver;
                this.$openStyle = $openStyle;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MatchResult match) {
                Intrinsics.checkNotNullParameter(match, "match");
                if (match.getRange().getLast() == StringsKt.getLastIndex(this.$text)) {
                    return "";
                }
                TextStyle textStyle = ParsingKt.updateStyle((TextStyle)this.$style.element, this.$this_invokeStyle, match.getValue());
                if (match.getRange().getFirst() == 0) {
                    this.$openStyle.element = textStyle;
                    this.$style.element = textStyle;
                    return "";
                }
                String tag = AnsiRenderKt.access$makeTag((TextStyle)this.$style.element, textStyle);
                this.$style.element = textStyle;
                return tag;
            }
        });
        return AnsiRenderKt.makeTag(ConstantsKt.getDEFAULT_STYLE(), (TextStyle)openStyle.element) + inner2 + AnsiRenderKt.makeTag((TextStyle)style.element, ConstantsKt.getDEFAULT_STYLE());
    }

    @NotNull
    public static final TextStyle downsample(@NotNull TextStyle style, @NotNull AnsiLevel level, boolean hyperlinks) {
        TextStyle textStyle;
        Intrinsics.checkNotNullParameter(style, "style");
        Intrinsics.checkNotNullParameter((Object)level, "level");
        if (style == ConstantsKt.getDEFAULT_STYLE()) {
            textStyle = style;
        } else {
            AnsiLevel ansiLevel = level;
            int n = WhenMappings.$EnumSwitchMapping$0[ansiLevel.ordinal()];
            switch (n) {
                case 1: {
                    textStyle = ConstantsKt.getDEFAULT_STYLE();
                    break;
                }
                case 2: {
                    Object object = style.getColor();
                    Color color = object == null ? null : object.toAnsi16();
                    object = style.getBgColor();
                    Ansi16 ansi16 = object == null ? null : object.toAnsi16();
                    object = style.getHyperlink();
                    boolean bl = false;
                    boolean bl2 = false;
                    Object object2 = object;
                    Color color2 = ansi16;
                    Color color3 = color;
                    TextStyle textStyle2 = style;
                    boolean bl3 = false;
                    boolean bl4 = hyperlinks;
                    Object object3 = bl4 ? object : null;
                    object = style.getHyperlinkId();
                    bl = false;
                    bl2 = false;
                    Object it = object;
                    Object object4 = object3;
                    boolean bl5 = false;
                    boolean bl6 = hyperlinks;
                    textStyle = TextStyleKt.copy(textStyle2, color3, color2, (String)object4, (String)(bl6 ? object : null));
                    break;
                }
                case 3: {
                    Color color;
                    Color color4;
                    Color color5;
                    Color it;
                    TextStyle textStyle3;
                    boolean it22;
                    boolean bl;
                    Color color6;
                    Color color7;
                    TextStyle textStyle4 = style;
                    Object object = style.getColor();
                    if (object == null) {
                        color7 = null;
                    } else {
                        color6 = object;
                        bl = false;
                        it22 = false;
                        Color bl5 = color6;
                        textStyle3 = textStyle4;
                        boolean bl7 = false;
                        color5 = it instanceof Ansi16 ? it : (Color)it.toAnsi256();
                        textStyle4 = textStyle3;
                        color7 = color5;
                    }
                    object = style.getBgColor();
                    if (object == null) {
                        color4 = null;
                    } else {
                        color6 = object;
                        bl = false;
                        it22 = false;
                        it = color6;
                        color5 = color7;
                        textStyle3 = textStyle4;
                        boolean bl8 = false;
                        color = it instanceof Ansi16 ? it : (Color)it.toAnsi256();
                        textStyle4 = textStyle3;
                        color7 = color5;
                        color4 = color;
                    }
                    object = style.getHyperlink();
                    boolean bl9 = false;
                    bl = false;
                    Object it22 = object;
                    color = color4;
                    color5 = color7;
                    textStyle3 = textStyle4;
                    boolean bl10 = false;
                    boolean bl11 = hyperlinks;
                    Object object5 = bl11 ? object : null;
                    object = style.getHyperlinkId();
                    bl9 = false;
                    bl = false;
                    it22 = object;
                    Object object6 = object5;
                    boolean bl12 = false;
                    boolean bl13 = hyperlinks;
                    textStyle = TextStyleKt.copy(textStyle3, color5, color, (String)object6, (String)(bl13 ? object : null));
                    break;
                }
                case 4: {
                    if (hyperlinks || style.getHyperlink() == null) {
                        textStyle = style;
                        break;
                    }
                    textStyle = TextStyleKt.copy(style, style.getColor(), style.getBgColor(), null, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return textStyle;
    }

    private static final String makeTag(TextStyle old, TextStyle textStyle) {
        boolean bl;
        Iterable iterable;
        if (Intrinsics.areEqual(old, textStyle)) {
            return "";
        }
        boolean bl2 = false;
        List codes = new ArrayList();
        if (!Intrinsics.areEqual(old.getColor(), textStyle.getColor())) {
            Collection collection = codes;
            iterable = AnsiRenderKt.toAnsi(textStyle.getColor(), 38, 39, 0);
            bl = false;
            CollectionsKt.addAll(collection, iterable);
        }
        if (!Intrinsics.areEqual(old.getBgColor(), textStyle.getBgColor())) {
            Collection collection = codes;
            iterable = AnsiRenderKt.toAnsi(textStyle.getBgColor(), 48, 49, 10);
            bl = false;
            CollectionsKt.addAll(collection, iterable);
        }
        AnsiRenderKt.makeTag$style(codes, old.getBold(), textStyle.getBold(), 1, 22);
        AnsiRenderKt.makeTag$style(codes, old.getItalic(), textStyle.getItalic(), 3, 23);
        AnsiRenderKt.makeTag$style(codes, old.getUnderline(), textStyle.getUnderline(), 4, 24);
        AnsiRenderKt.makeTag$style(codes, old.getDim(), textStyle.getDim(), 2, 22);
        AnsiRenderKt.makeTag$style(codes, old.getInverse(), textStyle.getInverse(), 7, 27);
        AnsiRenderKt.makeTag$style(codes, old.getStrikethrough(), textStyle.getStrikethrough(), 9, 29);
        String csi = codes.isEmpty() ? "" : CollectionsKt.joinToString$default(codes, ";", "\u001b[", "m", 0, null, null, 56, null);
        return !Intrinsics.areEqual(old.getHyperlink(), textStyle.getHyperlink()) ? Intrinsics.stringPlus(csi, AnsiRenderKt.makeHyperlinkTag(textStyle.getHyperlink(), textStyle.getHyperlinkId())) : csi;
    }

    private static final String makeHyperlinkTag(String hyperlink, String hyperlinkId) {
        String string;
        if (hyperlink == null) {
            return "\u001b]8;;\u001b\\";
        }
        String string2 = hyperlinkId;
        if (string2 == null) {
            string = "";
        } else {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            String string4 = Intrinsics.stringPlus("id=", it);
            string = string4 == null ? "" : string4;
        }
        String id = string;
        return "\u001b]8;" + id + ';' + hyperlink + "\u001b\\";
    }

    private static final List<Integer> toAnsi(Color $this$toAnsi, int select, int reset, int offset) {
        List<Integer> list;
        Color color;
        Color it;
        Object object;
        Object object2 = object = $this$toAnsi instanceof TextStyle ? (Integer[])$this$toAnsi : null;
        Color color2 = object == null ? $this$toAnsi : (it = (color = object.getColor()) == null ? $this$toAnsi : color);
        if (it == null) {
            list = CollectionsKt.listOf(reset);
        } else if (it instanceof Ansi16) {
            list = CollectionsKt.listOf(((Ansi16)it).getCode() + offset);
        } else if (it instanceof Ansi256) {
            object = new Integer[]{select, 5, ((Ansi256)it).getCode()};
            list = CollectionsKt.listOf(object);
        } else {
            object = it.toSRGB();
            boolean bl = false;
            boolean bl2 = false;
            Object $this$toAnsi_u24lambda_u2d8 = object;
            boolean bl3 = false;
            Integer[] integerArray = new Integer[]{select, 2, ((RGB)$this$toAnsi_u24lambda_u2d8).getRedInt(), ((RGB)$this$toAnsi_u24lambda_u2d8).getGreenInt(), ((RGB)$this$toAnsi_u24lambda_u2d8).getBlueInt()};
            list = CollectionsKt.listOf(integerArray);
        }
        return list;
    }

    private static final void makeTag$style(List<Integer> codes, boolean old, boolean bl, int open, int close) {
        if (old != bl) {
            Collection collection = codes;
            Integer n = bl ? open : close;
            boolean bl2 = false;
            collection.add(n);
        }
    }

    public static final /* synthetic */ String access$makeTag(TextStyle old, TextStyle textStyle) {
        return AnsiRenderKt.makeTag(old, textStyle);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnsiLevel.values().length];
            nArray[AnsiLevel.NONE.ordinal()] = 1;
            nArray[AnsiLevel.ANSI16.ordinal()] = 2;
            nArray[AnsiLevel.ANSI256.ordinal()] = 3;
            nArray[AnsiLevel.TRUECOLOR.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

