"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFloorPlotTime = exports.formatAnomalyNumber = exports.SHOW_DECIMAL_NUMBER_THRESHOLD = exports.NO_PERMISSIONS_KEY_WORD = exports.DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = exports.CANT_FIND_KEY_WORD = void 0;
exports.mapKeysDeep = mapKeysDeep;
exports.toSnake = exports.toFixedNumberForAnomaly = exports.toFixedNumber = exports.toCamel = exports.prettifyErrorMessage = void 0;

var _lodash = require("lodash");

var _constants = require("./constants");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
const SHOW_DECIMAL_NUMBER_THRESHOLD = 0.01;
exports.SHOW_DECIMAL_NUMBER_THRESHOLD = SHOW_DECIMAL_NUMBER_THRESHOLD;

function mapKeysDeep(obj, fn) {
  if (Array.isArray(obj)) {
    return (0, _lodash.map)(obj, innerObj => mapKeysDeep(innerObj, fn));
  } else {
    //@ts-ignore
    return (0, _lodash.isPlainObject)(obj) ? (0, _lodash.mapValues)((0, _lodash.mapKeys)(obj, fn), value => mapKeysDeep(value, fn)) : obj;
  }
}

const toSnake = (value, key) => (0, _lodash.snakeCase)(key);

exports.toSnake = toSnake;

const toCamel = (value, key) => (0, _lodash.camelCase)(key);

exports.toCamel = toCamel;

const getFloorPlotTime = plotTime => {
  return Math.floor(plotTime / _constants.MIN_IN_MILLI_SECS) * _constants.MIN_IN_MILLI_SECS;
};

exports.getFloorPlotTime = getFloorPlotTime;

const toFixedNumber = (num, digits, base) => {
  var pow = Math.pow(base || 10, digits || 2);
  return Math.round(num * pow) / pow;
}; // 1.If num>0.01, will keep two digits;
// 2.If num<0.01, will use scientific notation, for example 0.001234 will become 1.23e-3


exports.toFixedNumber = toFixedNumber;

const toFixedNumberForAnomaly = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? toFixedNumber(num, 2) : Number(num.toExponential(2));
};

exports.toFixedNumberForAnomaly = toFixedNumberForAnomaly;

const formatAnomalyNumber = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? num.toFixed(2) : num.toExponential(2);
};

exports.formatAnomalyNumber = formatAnomalyNumber;
const PERMISSIONS_ERROR_PATTERN = /no permissions for \[(.+)\] and User \[name=(.+), backend_roles/;
const NO_PERMISSIONS_KEY_WORD = 'no permissions';
exports.NO_PERMISSIONS_KEY_WORD = NO_PERMISSIONS_KEY_WORD;
const DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = 'does not have permissions';
exports.DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = DOES_NOT_HAVE_PERMISSIONS_KEY_WORD;
const CANT_FIND_KEY_WORD = "Can't find";
exports.CANT_FIND_KEY_WORD = CANT_FIND_KEY_WORD;

const prettifyErrorMessage = rawErrorMessage => {
  if ((0, _lodash.isEmpty)(rawErrorMessage) || rawErrorMessage === 'undefined') {
    return 'Unknown error is returned.';
  }

  const match = rawErrorMessage.match(PERMISSIONS_ERROR_PATTERN);

  if ((0, _lodash.isEmpty)(match)) {
    return rawErrorMessage;
  } else {
    return `User ${match[2]} has no permissions to [${match[1]}].`;
  }
};

exports.prettifyErrorMessage = prettifyErrorMessage;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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