/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.aesh.utils.Config;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningOption;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.Table;
import org.jboss.galleon.cli.cmd.maingrp.LayersConfigBuilder;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.PackageInfo;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.cli.resolver.ResolvedPlugins;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;

public class StateInfoUtil {
    public static final String DEFAULT_UNIVERSE = "default";
    public static final String NO_CONFIGURATIONS = "No configurations.";
    public static final String NO_DEPENDENCIES = "No dependencies.";
    public static final String NO_LAYERS = "No layers.";
    public static final String NO_OPTIONAL_PACKAGES = "No optional packages.";
    public static final String NO_OPTIONS = "No options.";
    public static final String NO_PATCHES = "No patches.";
    public static final String NO_UNIVERSES = "No custom universes.";

    public static void printContentPath(PmCommandInvocation session, FeatureContainer fp, String path) throws ProvisioningException, PathParserException, PathConsumerException, IOException {
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(fp, false);
        PathParser.parse(path, consumer);
        Group grp = consumer.getCurrentNode(path);
        if (grp != null) {
            if (grp.getFeature() != null) {
                StateInfoUtil.displayFeature(session, grp);
            } else if (grp.getSpec() != null) {
                StateInfoUtil.displayFeatureSpec(session, grp);
            } else if (grp.getPackage() != null) {
                StateInfoUtil.displayPackage(session, grp);
            } else if (!grp.getGroups().isEmpty()) {
                StateInfoUtil.displayContainmentGroup(session, grp);
            }
        }
    }

    private static void displayContainmentGroup(PmCommandInvocation session, Group grp) {
        for (Group fg : grp.getGroups()) {
            session.println(fg.getIdentity().getName());
        }
    }

    private static void displayFeature(PmCommandInvocation session, Group grp) throws ProvisioningException {
        FeatureInfo f = grp.getFeature();
        session.println("");
        session.println("Type       : " + f.getType());
        session.println("Path       : " + f.getPath());
        session.println("Origin     : " + f.getSpecId().getProducer());
        session.println("Description: " + f.getDescription());
        session.println("");
        session.println("Parameters id");
        if (f.getFeatureId() == null) {
            session.println("NONE");
        } else {
            for (Map.Entry<String, String> entry : f.getFeatureId().getParams().entrySet()) {
                session.println(entry.getKey() + "=" + entry.getValue());
            }
        }
        session.println(Config.getLineSeparator() + "Feature XML extract");
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<feature spec=\"" + f.getType() + "\">").append(Config.getLineSeparator());
        String tab = "  ";
        for (Map.Entry<String, Object> entry : f.getResolvedParams().entrySet()) {
            if ("GLN_UNDEFINED".equals(entry.getValue())) continue;
            xmlBuilder.append(tab + "<param name=\"" + entry.getKey() + "\" value=\"" + entry.getValue() + "\"/>").append(Config.getLineSeparator());
        }
        xmlBuilder.append("</feature>").append(Config.getLineSeparator());
        session.println(xmlBuilder.toString());
        session.println("Unset parameters");
        if (f.getUndefinedParams().isEmpty()) {
            session.println("NONE");
        }
        for (String string : f.getUndefinedParams()) {
            session.println(tab + "<param name=\"" + string + "\" value=\"???\"/>");
        }
    }

    private static void displayFeatureSpec(PmCommandInvocation session, Group grp) throws IOException {
        FeatureSpecInfo f = grp.getSpec();
        session.println("");
        session.println("Feature type       : " + f.getSpecId().getName());
        session.println("Feature origin     : " + f.getSpecId().getProducer());
        session.println("Feature description: " + f.getDescription());
        if (!f.isEnabled()) {
            session.println("WARNING! The feature is not enabled.");
            session.println("Missing packages");
            for (Identity m : f.getMissingPackages()) {
                session.println(m.toString());
            }
        }
        List<FeatureParameterSpec> idparams = f.getSpec().getIdParams();
        String tab = "  ";
        session.println(Config.getLineSeparator() + "Feature Id parameters");
        if (idparams.isEmpty()) {
            session.println("NONE");
        } else {
            for (FeatureParameterSpec param : idparams) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(tab + param.getName()).append(Config.getLineSeparator());
                stringBuilder.append(tab + tab + "description  : no description available").append(Config.getLineSeparator());
                stringBuilder.append(tab + tab + "type         : " + param.getType()).append(Config.getLineSeparator());
                stringBuilder.append(tab + tab + "default-value: " + param.getDefaultValue()).append(Config.getLineSeparator());
                stringBuilder.append(tab + tab + "nillable     : " + param.isNillable()).append(Config.getLineSeparator());
                session.print(stringBuilder.toString());
            }
        }
        session.println(Config.getLineSeparator() + "Feature parameters");
        Map<String, FeatureParameterSpec> params = f.getSpec().getParams();
        if (params.isEmpty()) {
            session.println("NONE");
        } else {
            for (Map.Entry<String, FeatureParameterSpec> entry : params.entrySet()) {
                FeatureParameterSpec param = entry.getValue();
                if (param.isFeatureId()) continue;
                StringBuilder builder = new StringBuilder();
                builder.append(tab + param.getName()).append(Config.getLineSeparator());
                builder.append(tab + tab + "description  : no description available").append(Config.getLineSeparator());
                builder.append(tab + tab + "type         : " + param.getType()).append(Config.getLineSeparator());
                builder.append(tab + tab + "default-value: " + param.getDefaultValue()).append(Config.getLineSeparator());
                builder.append(tab + tab + "nillable     : " + param.isNillable()).append(Config.getLineSeparator());
                session.println(builder.toString());
            }
        }
        session.println(Config.getLineSeparator() + "Packages");
        if (f.getPackages().isEmpty()) {
            session.println(tab + "NONE");
        } else {
            for (PackageInfo packageInfo : f.getPackages()) {
                session.println(packageInfo.getIdentity().toString());
            }
        }
        session.println(Config.getLineSeparator() + "Provided capabilities");
        if (f.getSpec().getProvidedCapabilities().isEmpty()) {
            session.println(tab + "NONE");
        } else {
            for (CapabilitySpec capabilitySpec : f.getSpec().getProvidedCapabilities()) {
                session.println(tab + capabilitySpec.toString());
            }
        }
        session.println(Config.getLineSeparator() + "Consumed capabilities");
        if (f.getSpec().getRequiredCapabilities().isEmpty()) {
            session.println(tab + "NONE");
        } else {
            for (CapabilitySpec capabilitySpec : f.getSpec().getRequiredCapabilities()) {
                session.println(tab + capabilitySpec.toString());
            }
        }
        session.println(Config.getLineSeparator() + "Features dependencies");
        if (f.getSpec().getFeatureDeps().isEmpty()) {
            session.println(tab + "NONE");
        } else {
            for (FeatureDependencySpec featureDependencySpec : f.getSpec().getFeatureDeps()) {
                session.println(tab + featureDependencySpec.getFeatureId().toString());
            }
        }
        session.println(Config.getLineSeparator() + "Features references");
        if (f.getSpec().getFeatureRefs().isEmpty()) {
            session.println(tab + "NONE");
        } else {
            for (FeatureReferenceSpec featureReferenceSpec : f.getSpec().getFeatureRefs()) {
                session.println(tab + featureReferenceSpec.getFeature());
            }
        }
        session.println(Config.getLineSeparator() + "Features Annotations");
        if (f.getSpec().getAnnotations().isEmpty()) {
            session.println(tab + "NONE");
        } else {
            for (FeatureAnnotation featureAnnotation : f.getSpec().getAnnotations()) {
                session.println(tab + featureAnnotation.toString());
            }
        }
    }

    private static void displayPackage(PmCommandInvocation session, Group grp) throws IOException {
        PackageInfo pkg = grp.getPackage();
        session.println("");
        session.println("Package name : " + pkg.getIdentity().getName());
        session.println("Package origin : " + pkg.getIdentity().getOrigin());
        session.println(Config.getLineSeparator() + "Package providers (features that depend on this package)");
        if (pkg.getProviders().isEmpty()) {
            session.println("default provider");
        } else {
            for (Identity id : pkg.getProviders()) {
                session.println(id.toString());
            }
        }
        session.println(Config.getLineSeparator() + "Package dependencies");
        if (grp.getGroups().isEmpty()) {
            session.println("NONE");
        } else {
            for (Group dep : grp.getGroups()) {
                session.println(dep.getIdentity().toString());
            }
        }
        session.println(Config.getLineSeparator() + "Package content");
        String customContent = pkg.getCustomContent();
        if (customContent != null) {
            session.println(customContent);
        } else if (pkg.getContent().isEmpty()) {
            session.println("NONE");
        } else {
            StringBuilder contentBuilder = new StringBuilder();
            for (String name : pkg.getContent()) {
                contentBuilder.append("  " + name + Config.getLineSeparator());
            }
            session.println(contentBuilder.toString());
        }
    }

    public static String buildConfigs(Map<String, List<ConfigInfo>> configs, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        if (!configs.isEmpty()) {
            boolean hasLayers = false;
            ArrayList<Table.Node> nodes = new ArrayList<Table.Node>();
            Map<String, Map<String, Set<String>>> layers = LayersConfigBuilder.getAllLayers(pLayout);
            for (Map.Entry<String, List<ConfigInfo>> entry : configs.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                Table.Node model = new Table.Node(entry.getKey());
                nodes.add(model);
                for (ConfigInfo name : entry.getValue()) {
                    Table.Node nameNode = new Table.Node(name.getName());
                    model.addNext(nameNode);
                    for (ConfigId id : name.getlayers()) {
                        Map<String, Set<String>> map = layers.get(entry.getKey());
                        boolean foundAsDependency = false;
                        if (map != null) {
                            for (ConfigId l : name.getlayers()) {
                                Set<String> deps;
                                if (l.getName().equals(id.getName()) || (deps = map.get(l.getName())) == null || !deps.contains(id.getName())) continue;
                                foundAsDependency = true;
                                break;
                            }
                        }
                        if (foundAsDependency) continue;
                        hasLayers = true;
                        nameNode.addNext(new Table.Node(id.getName()));
                    }
                    ConfigModel m = pLayout.getConfig().getDefinedConfig(name.getId());
                    if (m == null || !m.hasExcludedLayers()) continue;
                    for (String ex : m.getExcludedLayers()) {
                        hasLayers = true;
                        nameNode.addNext(new Table.Node(ex + "(excluded)"));
                    }
                }
            }
            Table.Tree table = hasLayers ? new Table.Tree("Configuration", "Name", "Layers") : new Table.Tree("Configuration", "Name");
            table.addAll(nodes);
            return "Configurations" + Config.getLineSeparator() + table.build();
        }
        return null;
    }

    public static String buildOptionalPackages(PmSession session, FeatureContainer container, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        String optionValue = container.getProvisioningConfig().getOption(ProvisioningOption.OPTIONAL_PACKAGES.getName());
        if (optionValue == null) {
            optionValue = "all";
        }
        Table.Tree t = null;
        boolean passivePresent = !container.getPassivePackages().isEmpty() || !container.getOrphanPassivePackages().isEmpty();
        Set<String> optionalProducers = container.getOptionalPackagesProducers();
        if (!optionalProducers.isEmpty()) {
            t = passivePresent ? new Table.Tree("Product", "Feature", "Package", "Passive") : new Table.Tree("Product", "Feature", "Package");
            Iterator<String> iterator = optionalProducers.iterator();
            while (iterator.hasNext()) {
                Object passives;
                Object pkg;
                Table.Node feat;
                String producer;
                String displayProducer = producer = iterator.next();
                try {
                    FeaturePackLocation.ProducerSpec pSpec = FeaturePackLocation.fromString(producer).getProducer();
                    if (session.getUniverse().getBuiltinUniverseSpec().equals(pSpec.getUniverse())) {
                        displayProducer = pSpec.getName();
                    }
                }
                catch (Exception pSpec) {
                    // empty catch block
                }
                Table.Node producerNode = new Table.Node(displayProducer);
                t.add(producerNode);
                Map<String, Set<String>> optionalPkgs = container.getOptionalPackages().get(producer);
                if (optionalPkgs != null && !optionalPkgs.isEmpty()) {
                    for (Map.Entry<String, Set<String>> entry : optionalPkgs.entrySet()) {
                        feat = new Table.Node(entry.getKey());
                        producerNode.addNext(feat);
                        for (String p : entry.getValue()) {
                            pkg = new Table.Node(p);
                            feat.addNext((Table.Node)pkg);
                            if (!passivePresent) continue;
                            ((Table.Node)pkg).addNext(new Table.Node(""));
                        }
                        Map<String, Set<String>> passivePkgs = container.getPassivePackages().get(producer);
                        if (passivePkgs == null || (passives = passivePkgs.get(entry.getKey())) == null) continue;
                        pkg = passives.iterator();
                        while (pkg.hasNext()) {
                            String p = (String)pkg.next();
                            Table.Node pkg2 = new Table.Node(p);
                            feat.addNext(pkg2);
                            pkg2.addNext(new Table.Node("true"));
                        }
                    }
                } else {
                    Map<String, Set<String>> passivePkgs = container.getPassivePackages().get(producer);
                    if (passivePkgs != null && !passivePkgs.isEmpty()) {
                        for (Map.Entry<String, Set<String>> entry2 : passivePkgs.entrySet()) {
                            Table.Node feat2 = new Table.Node(entry2.getKey());
                            producerNode.addNext(feat2);
                            passives = entry2.getValue().iterator();
                            while (passives.hasNext()) {
                                String p = passives.next();
                                Table.Node pkg3 = new Table.Node(p);
                                feat2.addNext(pkg3);
                                pkg3.addNext(new Table.Node("true"));
                            }
                        }
                    }
                }
                Set<String> orphanOptionals = container.getOrphanOptionalPackages().get(producer);
                Set<String> set = container.getOrphanPassivePackages().get(producer);
                if (orphanOptionals == null && set == null) continue;
                feat = new Table.Node("{no-feature}");
                producerNode.addNext(feat);
                if (orphanOptionals != null) {
                    for (String p : orphanOptionals) {
                        pkg = new Table.Node(p);
                        feat.addNext((Table.Node)pkg);
                        if (!passivePresent) continue;
                        ((Table.Node)pkg).addNext(new Table.Node(""));
                    }
                }
                if (set == null) continue;
                for (String p : set) {
                    pkg = new Table.Node(p);
                    feat.addNext((Table.Node)pkg);
                    ((Table.Node)pkg).addNext(new Table.Node("true"));
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Optional packages (Provisioning option: " + optionValue + ")" + Config.getLineSeparator());
        if (t == null) {
            builder.append(NO_OPTIONAL_PACKAGES);
        } else {
            builder.append(t.build());
        }
        return builder.toString();
    }

    public static String buildLayers(ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        Map<String, Map<String, Set<String>>> layersMap = LayersConfigBuilder.getAllLayers(pLayout);
        if (!layersMap.isEmpty()) {
            Table.Tree t = new Table.Tree("Configuration", "Layers", "Dependencies");
            for (Map.Entry<String, Map<String, Set<String>>> entry : layersMap.entrySet()) {
                Table.Node model = new Table.Node(entry.getKey());
                t.add(model);
                for (Map.Entry<String, Set<String>> layerEntry : entry.getValue().entrySet()) {
                    Table.Node name = new Table.Node(layerEntry.getKey());
                    model.addNext(name);
                    for (String dep : layerEntry.getValue()) {
                        Table.Node dependency = new Table.Node(dep);
                        name.addNext(dependency);
                    }
                }
            }
            return "Layers" + Config.getLineSeparator() + t.build();
        }
        return null;
    }

    private static boolean displayLayers(PmCommandInvocation invoc, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        String str = StateInfoUtil.buildLayers(pLayout);
        if (str != null) {
            invoc.print(str);
        }
        return str != null;
    }

    public static String buildDependencies(List<FeaturePackLocation> dependencies, Map<FeaturePackLocation.FPID, FeaturePackConfig> configs) {
        if (!dependencies.isEmpty()) {
            boolean showPatches = configs == null ? false : StateInfoUtil.showPatches(configs.values());
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("Dependency");
            headers.add("Build");
            if (showPatches) {
                headers.add("Patches");
            }
            headers.add("Update Channel");
            Table table = new Table(headers);
            for (FeaturePackLocation d : dependencies) {
                FeaturePackConfig config;
                ArrayList<Table.Cell> line = new ArrayList<Table.Cell>();
                line.add(new Table.Cell(d.getProducerName()));
                line.add(new Table.Cell(d.getBuild()));
                if (showPatches && (config = configs.get(d.getFPID())) != null && config.hasPatches()) {
                    Table.Cell patches = new Table.Cell(new String[0]);
                    for (FeaturePackLocation.FPID p : config.getPatches()) {
                        patches.addLine(p.getBuild());
                    }
                    line.add(patches);
                }
                line.add(new Table.Cell(StateInfoUtil.formatChannel(d)));
                table.addCellsLine(line);
            }
            table.sort(Table.SortType.ASCENDANT);
            return table.build();
        }
        return null;
    }

    public static String buildPatches(PmCommandInvocation invoc, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        if (!layout.hasPatches()) {
            return null;
        }
        Table table = new Table("Patch", "Patch For", "Update Channel");
        for (FeaturePackLayout fpLayout : layout.getOrderedFeaturePacks()) {
            List<FeaturePackLayout> patches = layout.getPatches(fpLayout.getFPID());
            for (FeaturePackLayout patch : patches) {
                FeaturePackLocation loc = invoc.getPmSession().getExposedLocation(null, patch.getFPID().getLocation());
                FeaturePackLocation.FPID patchFor = patch.getSpec().getPatchFor();
                table.addLine(patch.getFPID().getBuild(), patchFor.getProducer().getName() + "#" + patchFor.getBuild(), StateInfoUtil.formatChannel(loc));
            }
        }
        if (!table.isEmpty()) {
            table.sort(Table.SortType.ASCENDANT);
            return table.build();
        }
        return null;
    }

    public static void printFeaturePack(PmCommandInvocation commandInvocation, FeaturePackLocation loc) {
        loc = commandInvocation.getPmSession().getExposedLocation(null, loc);
        Table t = new Table("Product", "Build", "Update Channel");
        t.addLine(loc.getProducer().getName(), loc.getBuild(), StateInfoUtil.formatChannel(loc));
        commandInvocation.print(t.build());
    }

    private static String buildFeaturePacks(PmCommandInvocation commandInvocation, Path installation, Collection<FeaturePackConfig> fps) {
        boolean showPatches = StateInfoUtil.showPatches(fps);
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Product");
        headers.add("Build");
        if (showPatches) {
            headers.add("Patches");
        }
        headers.add("Update Channel");
        Table t = new Table(headers);
        for (FeaturePackConfig c : fps) {
            FeaturePackLocation loc = commandInvocation.getPmSession().getExposedLocation(installation, c.getLocation());
            ArrayList<Table.Cell> line = new ArrayList<Table.Cell>();
            line.add(new Table.Cell(loc.getProducer().getName()));
            line.add(new Table.Cell(loc.getBuild()));
            if (showPatches && c.hasPatches()) {
                Table.Cell patches = new Table.Cell(new String[0]);
                for (FeaturePackLocation.FPID p : c.getPatches()) {
                    patches.addLine(p.getBuild());
                }
                line.add(patches);
            }
            line.add(new Table.Cell(StateInfoUtil.formatChannel(loc)));
            t.addCellsLine(line);
        }
        if (!t.isEmpty()) {
            t.sort(Table.SortType.ASCENDANT);
            return t.build();
        }
        return null;
    }

    private static boolean showPatches(Collection<FeaturePackConfig> configs) {
        if (configs != null) {
            for (FeaturePackConfig c : configs) {
                if (c == null || !c.hasPatches()) continue;
                return true;
            }
        }
        return false;
    }

    public static String buildOptions(ResolvedPlugins plugins) {
        StringBuilder builder = new StringBuilder();
        boolean found = false;
        if (!plugins.getInstall().isEmpty()) {
            found = true;
            builder.append("Install and provision commands options").append(Config.getLineSeparator());
            builder.append(StateInfoUtil.buildOptionsTable(plugins.getInstall())).append(Config.getLineSeparator());
        }
        if (!plugins.getInstall().isEmpty()) {
            found = true;
            builder.append("Update command options").append(Config.getLineSeparator());
            builder.append(StateInfoUtil.buildOptionsTable(plugins.getDiff()));
        }
        if (found) {
            return builder.toString();
        }
        return null;
    }

    public static String formatChannel(FeaturePackLocation loc) {
        String channel = loc.getFrequency() == null ? loc.getChannel().getName() : loc.getChannel().getName() + "/" + loc.getFrequency();
        return (String)(loc.getUniverse() == null ? "" : loc.getUniverse() + "@") + (channel == null ? "" : channel);
    }

    private static String buildOptionsTable(Set<ProvisioningOption> options) {
        Table t = new Table("Option", "Required", "Default Value");
        for (ProvisioningOption opt : options) {
            t.addLine("--" + opt.getName() + "=", opt.isRequired() ? "Y" : "N", opt.getDefaultValue() == null ? "" : opt.getDefaultValue());
        }
        t.sort(Table.SortType.ASCENDANT);
        return t.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void displayInfo(PmCommandInvocation invoc, Path installation, ProvisioningConfig config, String type, Function<ProvisioningLayout<FeaturePackLayout>, FeatureContainer> supplier) throws CommandExecutionException {
        try {
            if (!config.hasFeaturePackDeps()) {
                return;
            }
            invoc.println("");
            StateInfoUtil.displayFeaturePacks(invoc, installation, config);
            if (type == null) return;
            invoc.println("");
            try (ProvisioningLayout<FeaturePackLayout> layout = invoc.getPmSession().getLayoutFactory().newConfigLayout(config);){
                switch (type) {
                    case "all": {
                        FeatureContainer container = supplier.apply(layout);
                        if (StateInfoUtil.displayDependencies(invoc, layout)) {
                            invoc.println("");
                        }
                        if (StateInfoUtil.displayPatches(invoc, layout)) {
                            invoc.println("");
                        }
                        if (StateInfoUtil.displayConfigs(invoc, container, layout)) {
                            invoc.println("");
                        }
                        if (StateInfoUtil.displayLayers(invoc, layout)) {
                            invoc.println("");
                        }
                        if (StateInfoUtil.displayOptionalPackages(invoc, container, layout)) {
                            invoc.println("");
                        }
                        if (StateInfoUtil.displayOptions(invoc, layout)) {
                            invoc.println("");
                        }
                        StateInfoUtil.displayUniverses(invoc, config);
                        return;
                    }
                    case "configs": {
                        FeatureContainer container = supplier.apply(layout);
                        String configs = StateInfoUtil.buildConfigs(invoc, container, layout);
                        if (configs != null) {
                            invoc.print(configs);
                            return;
                        } else {
                            invoc.println(NO_CONFIGURATIONS);
                            return;
                        }
                    }
                    case "dependencies": {
                        String deps = StateInfoUtil.buildDependencies(invoc, layout);
                        if (deps != null) {
                            invoc.print(deps);
                            return;
                        } else {
                            invoc.println(NO_DEPENDENCIES);
                            return;
                        }
                    }
                    case "layers": {
                        String layers = StateInfoUtil.buildLayers(layout);
                        if (layers != null) {
                            invoc.print(layers);
                            return;
                        } else {
                            invoc.println(NO_LAYERS);
                            return;
                        }
                    }
                    case "options": {
                        String options = StateInfoUtil.buildOptions(layout);
                        if (options != null) {
                            invoc.print(options);
                            return;
                        } else {
                            invoc.println(NO_OPTIONS);
                            return;
                        }
                    }
                    case "patches": {
                        String patches = StateInfoUtil.buildPatches(invoc, layout);
                        if (patches != null) {
                            invoc.print(patches);
                            return;
                        } else {
                            invoc.println(NO_PATCHES);
                            return;
                        }
                    }
                    case "universes": {
                        String universes = StateInfoUtil.buildUniverses(config);
                        if (universes != null) {
                            invoc.print(universes);
                            return;
                        } else {
                            invoc.println(NO_UNIVERSES);
                            return;
                        }
                    }
                    case "optional-packages": {
                        FeatureContainer container = supplier.apply(layout);
                        String packages = StateInfoUtil.buildOptionalPackages(invoc.getPmSession(), container, layout);
                        invoc.print(packages);
                        return;
                    }
                    default: {
                        throw new CommandExecutionException(CliErrors.invalidInfoType());
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.infoFailed(), ex);
        }
    }

    private static boolean displayConfigs(PmCommandInvocation invoc, FeatureContainer container, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        String str = StateInfoUtil.buildConfigs(invoc, container, pLayout);
        if (str != null) {
            invoc.print(str);
        }
        return str != null;
    }

    private static String buildConfigs(PmCommandInvocation invoc, FeatureContainer container, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        return StateInfoUtil.buildConfigs(container.getFinalConfigs(), pLayout);
    }

    private static boolean displayOptionalPackages(PmCommandInvocation invoc, FeatureContainer container, ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        String str = StateInfoUtil.buildOptionalPackages(invoc.getPmSession(), container, pLayout);
        invoc.print(str);
        return true;
    }

    private static void displayFeaturePacks(PmCommandInvocation invoc, Path installation, ProvisioningConfig config) {
        String str = StateInfoUtil.buildFeaturePacks(invoc, installation, config.getFeaturePackDeps());
        if (str != null) {
            invoc.print(str);
        }
    }

    private static boolean displayDependencies(PmCommandInvocation invoc, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        String str = StateInfoUtil.buildDependencies(invoc, layout);
        if (str != null) {
            invoc.print(str);
        }
        return str != null;
    }

    private static String buildDependencies(PmCommandInvocation invoc, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        HashMap<FeaturePackLocation.FPID, FeaturePackConfig> configs = new HashMap<FeaturePackLocation.FPID, FeaturePackConfig>();
        ArrayList<FeaturePackLocation> dependencies = new ArrayList<FeaturePackLocation>();
        for (FeaturePackLayout fpLayout : layout.getOrderedFeaturePacks()) {
            boolean isProduct = true;
            for (FeaturePackLayout fpLayout2 : layout.getOrderedFeaturePacks()) {
                if (!fpLayout2.getSpec().hasTransitiveDep(fpLayout.getFPID().getProducer()) && fpLayout2.getSpec().getFeaturePackDep(fpLayout.getFPID().getProducer()) == null) continue;
                isProduct = false;
                break;
            }
            if (isProduct) continue;
            FeaturePackLocation loc = invoc.getPmSession().getExposedLocation(null, fpLayout.getFPID().getLocation());
            dependencies.add(loc);
            FeaturePackConfig transitiveConfig = layout.getConfig().getTransitiveDep(fpLayout.getFPID().getProducer());
            configs.put(loc.getFPID(), transitiveConfig);
        }
        return StateInfoUtil.buildDependencies(dependencies, configs);
    }

    private static boolean displayPatches(PmCommandInvocation invoc, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        String str = StateInfoUtil.buildPatches(invoc, layout);
        if (str != null) {
            invoc.print(str);
        }
        return str != null;
    }

    private static String buildOptions(ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        return StateInfoUtil.buildOptions(PluginResolver.resolvePlugins(layout));
    }

    private static boolean displayOptions(PmCommandInvocation commandInvocation, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        String str = StateInfoUtil.buildOptions(layout);
        if (str != null) {
            commandInvocation.print(str);
        }
        return str != null;
    }

    private static String buildUniverses(ProvisioningConfig config) throws ProvisioningException {
        UniverseSpec defaultUniverse = config.getDefaultUniverse();
        StringBuilder builder = new StringBuilder();
        if (defaultUniverse != null || !config.getUniverseNamedSpecs().isEmpty()) {
            builder.append("Universes").append(Config.getLineSeparator());
            Table t = new Table("Name", "Factory", "Location");
            if (defaultUniverse != null) {
                t.addLine("<default>", defaultUniverse.getFactory(), defaultUniverse.getLocation());
            }
            for (Map.Entry<String, UniverseSpec> entry : config.getUniverseNamedSpecs().entrySet()) {
                t.addLine(entry.getKey(), entry.getValue().getFactory(), entry.getValue().getLocation());
            }
            t.sort(Table.SortType.ASCENDANT);
            builder.append(t.build());
        }
        return builder.length() == 0 ? null : builder.toString();
    }

    private static boolean displayUniverses(PmCommandInvocation commandInvocation, ProvisioningConfig config) throws ProvisioningException {
        String str = StateInfoUtil.buildUniverses(config);
        if (str != null) {
            commandInvocation.print(str);
        }
        return str != null;
    }
}

