/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class RelationChecker
extends Test {
    public static final int ROLE_UNKNOWN = 1701;
    public static final int ROLE_EMPTY = 1702;
    public static final int WRONG_TYPE = 1703;
    public static final int HIGH_COUNT = 1704;
    public static final int LOW_COUNT = 1705;
    public static final int ROLE_MISSING = 1706;
    public static final int RELATION_UNKNOWN = 1707;
    public static final int RELATION_EMPTY = 1708;
    public static final String ROLE_VERIF_PROBLEM_MSG = I18n.tr("Role verification problem", new Object[0]);
    private boolean ignoreMultiPolygons;
    private static final Collection<TaggingPreset> relationpresets = new LinkedList<TaggingPreset>();

    public RelationChecker() {
        super(I18n.tr("Relation checker", new Object[0]), I18n.tr("Checks for errors in relations.", new Object[0]));
    }

    @Override
    public void initialize() {
        RelationChecker.initializePresets();
    }

    public static synchronized void initializePresets() {
        if (!relationpresets.isEmpty()) {
            return;
        }
        block0: for (TaggingPreset p : TaggingPresets.getTaggingPresets()) {
            for (TaggingPresetItem i : p.data) {
                if (!(i instanceof Roles)) continue;
                relationpresets.add(p);
                continue block0;
            }
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        for (Test t : OsmValidator.getEnabledTests(false)) {
            if (!(t instanceof MultipolygonTest)) continue;
            this.ignoreMultiPolygons = true;
            break;
        }
    }

    @Override
    public void visit(Relation n) {
        Map<String, RoleInfo> map = RelationChecker.buildRoleInfoMap(n);
        if (map.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 1708).message(I18n.tr("Relation is empty", new Object[0])).primitives(n).build());
        }
        if (this.ignoreMultiPolygons && n.isMultipolygon()) {
            return;
        }
        Map<Roles.Role, String> allroles = RelationChecker.buildAllRoles(n);
        if (allroles.isEmpty() && n.hasTag("type", "route") && n.hasTag("route", "train", "subway", "monorail", "tram", "bus", "trolleybus", "aerialway", "ferry")) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1707).message(I18n.tr("Route scheme is unspecified. Add {0} ({1}=public_transport; {2}=legacy)", "public_transport:version", "2", "1")).primitives(n).build());
        } else if (allroles.isEmpty()) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 1707).message(I18n.tr("Relation type is unknown", new Object[0])).primitives(n).build());
        }
        if (!map.isEmpty() && !allroles.isEmpty()) {
            this.checkRoles(n, allroles, map);
        }
    }

    private static Map<String, RoleInfo> buildRoleInfoMap(Relation n) {
        HashMap<String, RoleInfo> map = new HashMap<String, RoleInfo>();
        for (RelationMember m : n.getMembers()) {
            map.computeIfAbsent(m.getRole(), k -> new RoleInfo()).total++;
        }
        return map;
    }

    private static Map<Roles.Role, String> buildAllRoles(Relation n) {
        LinkedHashMap<Roles.Role, String> allroles = new LinkedHashMap<Roles.Role, String>();
        for (TaggingPreset p : relationpresets) {
            boolean matches = TaggingPresetItem.matches(Utils.filteredCollection(p.data, KeyedItem.class), n.getKeys());
            Roles r = Utils.find(p.data, Roles.class);
            if (!matches || r == null) continue;
            for (Roles.Role role : r.roles) {
                allroles.put(role, p.name);
            }
        }
        return allroles;
    }

    private static boolean checkMemberType(Roles.Role r, RelationMember member) {
        if (r.types != null) {
            switch (member.getDisplayType()) {
                case NODE: {
                    return r.types.contains((Object)TaggingPresetType.NODE);
                }
                case CLOSEDWAY: {
                    return r.types.contains((Object)TaggingPresetType.CLOSEDWAY);
                }
                case WAY: {
                    return r.types.contains((Object)TaggingPresetType.WAY);
                }
                case MULTIPOLYGON: {
                    return r.types.contains((Object)TaggingPresetType.MULTIPOLYGON);
                }
                case RELATION: {
                    return r.types.contains((Object)TaggingPresetType.RELATION);
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkMemberExpressionAndType(Map<Roles.Role, String> allroles, RelationMember member, Relation n) {
        String role = member.getRole();
        String name = null;
        EnumSet<TaggingPresetType> types = EnumSet.noneOf(TaggingPresetType.class);
        TestError possibleMatchError = null;
        for (Map.Entry<Roles.Role, String> e : allroles.entrySet()) {
            Roles.Role r = e.getKey();
            if (!r.isRole(role)) continue;
            name = e.getValue();
            types.addAll(r.types);
            if (RelationChecker.checkMemberType(r, member)) {
                if (r.memberExpression == null) {
                    return true;
                }
                OsmPrimitive primitive = member.getMember();
                if (!primitive.isUsable()) {
                    return true;
                }
                if (r.memberExpression.match(primitive)) {
                    return true;
                }
                possibleMatchError = TestError.builder(this, Severity.WARNING, 1703).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role of relation member does not match expression ''{0}'' in template {1}"), r.memberExpression, name).primitives(member.getMember().isUsable() ? member.getMember() : n).build();
                continue;
            }
            if (OsmPrimitiveType.RELATION != member.getType() || member.getMember().isUsable() || !r.types.contains((Object)TaggingPresetType.MULTIPOLYGON)) continue;
            return true;
        }
        if (name == null) {
            return true;
        }
        if (possibleMatchError != null) {
            this.errors.add(possibleMatchError);
        } else {
            boolean ignored;
            boolean bl = ignored = member.getMember().isIncomplete() && OsmPrimitiveType.WAY == member.getType() && !types.contains((Object)TaggingPresetType.WAY) && types.contains((Object)TaggingPresetType.CLOSEDWAY);
            if (!ignored) {
                String typesStr = types.stream().map(x -> I18n.tr(x.getName(), new Object[0])).collect(Collectors.joining("/"));
                this.errors.add(TestError.builder(this, Severity.WARNING, 1703).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Type ''{0}'' of relation member with role ''{1}'' does not match accepted types ''{2}'' in template {3}"), new Object[]{member.getType(), member.getRole(), typesStr, name}).primitives(member.getMember().isUsable() ? member.getMember() : n).build());
            }
        }
        return false;
    }

    private void checkRoles(Relation n, Map<Roles.Role, String> allroles, Map<String, RoleInfo> map) {
        for (RelationMember member : n.getMembers()) {
            this.checkMemberExpressionAndType(allroles, member, n);
        }
        for (Roles.Role r2 : allroles.keySet()) {
            String keyname = r2.key;
            if (keyname.isEmpty()) {
                keyname = I18n.tr("<empty>", new Object[0]);
            }
            this.checkRoleCounts(n, r2, keyname, map.get(r2.key));
        }
        if ("network".equals(n.get("type")) && !"bicycle".equals(n.get("route"))) {
            return;
        }
        for (String key : map.keySet()) {
            boolean found = false;
            for (Roles.Role r3 : allroles.keySet()) {
                if (!r3.isRole(key)) continue;
                found = true;
                break;
            }
            if (found) continue;
            String templates = allroles.keySet().stream().map(r -> r.key).collect(Collectors.joining("/"));
            if (!key.isEmpty()) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1701).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role ''{0}'' unknown in templates ''{1}''"), key, templates).primitives(n).build());
                continue;
            }
            this.errors.add(TestError.builder(this, Severity.WARNING, 1702).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Empty role type found when expecting one of ''{0}''"), templates).primitives(n).build());
        }
    }

    private void checkRoleCounts(Relation n, Roles.Role r, String keyname, RoleInfo ri) {
        long vc;
        long count = ri == null ? 0L : (long)ri.total;
        if (count != (vc = r.getValidCount(count))) {
            if (count == 0L) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1706).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Role ''{0}'' missing"), keyname).primitives(n).build());
            } else if (vc > count) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1705).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Number of ''{0}'' roles too low ({1})"), keyname, count).primitives(n).build());
            } else {
                this.errors.add(TestError.builder(this, Severity.WARNING, 1704).message(ROLE_VERIF_PROBLEM_MSG, I18n.marktr("Number of ''{0}'' roles too high ({1})"), keyname, count).primitives(n).build());
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        Collection<? extends OsmPrimitive> primitives = testError.getPrimitives();
        if (this.isFixable(testError) && !primitives.iterator().next().isDeleted()) {
            return new DeleteCommand(primitives);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        Collection<? extends OsmPrimitive> primitives = testError.getPrimitives();
        return testError.getCode() == 1708 && !primitives.isEmpty() && primitives.iterator().next().isNew();
    }

    private static class RoleInfo {
        private int total;

        private RoleInfo() {
        }
    }
}

