/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.Value;

public class VariableReference
extends Expression
implements BindingReference {
    protected Binding binding = null;
    protected SequenceType staticType = null;
    protected Value constantValue = null;
    transient String displayName = null;
    private boolean flattened = false;
    private boolean inLoop = true;
    private boolean filtered = false;

    public VariableReference() {
    }

    public VariableReference(Binding binding) {
        this.displayName = binding.getVariableQName().getDisplayName();
        this.fixup(binding);
    }

    public Expression copy() {
        if (this.binding == null) {
            throw new UnsupportedOperationException("Cannot copy a variable reference whose binding is unknown");
        }
        VariableReference ref = new VariableReference();
        ref.binding = this.binding;
        ref.staticType = this.staticType;
        ref.constantValue = this.constantValue;
        ref.displayName = this.displayName;
        ExpressionTool.copyLocationInfo(this, ref);
        return ref;
    }

    public void setStaticType(SequenceType type, Value value, int properties) {
        this.staticType = type;
        this.constantValue = value;
        int dependencies = this.getDependencies();
        this.staticProperties = properties & 0xFFFEFFFF | type.getCardinality() | dependencies;
    }

    public void setFlattened(boolean flattened) {
        super.setFlattened(flattened);
        this.flattened = flattened;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isInLoop() {
        return this.inLoop;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.constantValue != null) {
            this.binding = null;
            return Literal.makeLiteral(this.constantValue);
        }
        if (this.binding instanceof Expression) {
            this.inLoop = visitor.isLoopingSubexpression((Expression)((Object)this.binding));
        } else if (this.binding instanceof UserFunctionParameter) {
            this.inLoop = visitor.isLoopingSubexpression(null);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.constantValue != null) {
            this.binding = null;
            return Literal.makeLiteral(this.constantValue);
        }
        return this;
    }

    public void fixup(Binding binding) {
        this.binding = binding;
        this.resetLocalStaticProperties();
    }

    public void refineVariableType(ItemType type, int cardinality, Value constantValue, int properties, ExpressionVisitor visitor) {
        int newcard;
        ItemType oldItemType;
        Executable exec = visitor.getExecutable();
        if (exec == null) {
            return;
        }
        TypeHierarchy th = exec.getConfiguration().getTypeHierarchy();
        ItemType newItemType = oldItemType = this.getItemType(th);
        if (th.isSubType(type, oldItemType)) {
            newItemType = type;
        }
        if ((newcard = cardinality & this.getCardinality()) == 0) {
            newcard = this.getCardinality();
        }
        SequenceType seqType = SequenceType.makeSequenceType(newItemType, newcard);
        this.setStaticType(seqType, constantValue, properties);
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.staticType == null || this.staticType.getPrimaryType() == AnyItemType.getInstance()) {
            if (this.binding != null) {
                return this.binding.getRequiredType().getPrimaryType();
            }
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    public int computeCardinality() {
        if (this.staticType == null) {
            if (this.binding == null) {
                return 57344;
            }
            if (this.binding instanceof LetExpression) {
                return this.binding.getRequiredType().getCardinality();
            }
            if (this.binding instanceof Assignation) {
                return 16384;
            }
            return this.binding.getRequiredType().getCardinality();
        }
        return this.staticType.getCardinality();
    }

    public int computeSpecialProperties() {
        Expression exp;
        int p = super.computeSpecialProperties();
        if (this.binding == null || !this.binding.isAssignable()) {
            p |= 0x400000;
        }
        if (this.binding instanceof Assignation && (exp = ((Assignation)this.binding).getSequence()) != null) {
            p |= exp.getSpecialProperties() & 0x2000000;
        }
        if (this.staticType != null && !Cardinality.allowsMany(this.staticType.getCardinality()) && this.staticType.getPrimaryType() instanceof NodeTest) {
            p |= 0x800000;
        }
        return p;
    }

    public boolean equals(Object other) {
        return other instanceof VariableReference && this.binding == ((VariableReference)other).binding && this.binding != null;
    }

    public int hashCode() {
        return this.binding == null ? 73619830 : this.binding.hashCode();
    }

    public int getIntrinsicDependencies() {
        int d = 0;
        if (this.binding == null) {
            d |= 0x680;
        } else if (this.binding.isGlobal()) {
            if (this.binding.isAssignable()) {
                d |= 0x200;
            }
            if (this.binding instanceof GlobalParam) {
                d |= 0x400;
            }
        } else {
            d |= 0x80;
        }
        return d;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp;
        if (offer.action == 12 && (exp = offer.accept(this)) != null) {
            offer.accepted = true;
            return exp;
        }
        return this;
    }

    public int getImplementationMethod() {
        return (Cardinality.allowsMany(this.getCardinality()) ? 0 : 1) | 2 | 4;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMap.getPathForVariable(this.getBinding());
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        try {
            ValueRepresentation actual = this.evaluateVariable(c);
            return Value.getIterator(actual);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
        catch (AssertionError err) {
            String msg = ((Throwable)((Object)err)).getMessage() + " Variable " + this.getDisplayName() + " at " + this.getLineNumber() + " of " + this.getSystemId();
            throw new AssertionError((Object)msg);
        }
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        try {
            ValueRepresentation actual = this.evaluateVariable(c);
            if (actual instanceof Item) {
                return (Item)actual;
            }
            return Value.asItem(actual);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public void process(XPathContext c) throws XPathException {
        try {
            ValueRepresentation actual = this.evaluateVariable(c);
            if (actual instanceof NodeInfo) {
                actual = new SingletonNode((NodeInfo)actual);
            }
            ((Value)actual).process(c);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public ValueRepresentation evaluateVariable(XPathContext c) throws XPathException {
        try {
            return this.binding.evaluateVariable(c);
        }
        catch (NullPointerException err) {
            if (this.binding == null) {
                throw new IllegalStateException("Variable $" + this.displayName + " has not been fixed up");
            }
            throw err;
        }
    }

    public Binding getBinding() {
        return this.binding;
    }

    public String getDisplayName() {
        if (this.binding != null) {
            return this.binding.getVariableQName().getDisplayName();
        }
        return this.displayName;
    }

    public String toString() {
        String d = this.getDisplayName();
        return "$" + (d == null ? "$" : d);
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("variableReference");
        String d = this.getDisplayName();
        destination.emitAttribute("name", d == null ? "null" : this.getDisplayName());
        destination.endElement();
    }
}

