/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

public final class Utilities {
    public static final boolean isPlatformUnix;
    public static final boolean isPlatformWindows;

    public static boolean isFilenameAbsolute(String filename) {
        int length = filename.length();
        if (length > 0) {
            char c0 = filename.charAt(0);
            if (c0 == '\\' || c0 == '/') {
                return true;
            }
            if (length > 2) {
                if (isPlatformWindows) {
                    char c1 = filename.charAt(1);
                    if (c1 == ':') {
                        if (c0 >= 'a' && c0 <= 'z') {
                            return true;
                        }
                        if (c0 >= 'A' && c0 <= 'Z') {
                            return true;
                        }
                    }
                } else if (filename.equals("~") || filename.startsWith("~/")) {
                    return true;
                }
            }
        }
        return false;
    }

    static String escapeFormat(String s) {
        return s.replace("~", "~~");
    }

    static {
        String osName = System.getProperty("os.name");
        isPlatformUnix = osName.startsWith("Linux") || osName.startsWith("Mac OS X") || osName.startsWith("Darwin") || osName.startsWith("Solaris") || osName.startsWith("SunOS") || osName.startsWith("AIX") || osName.startsWith("FreeBSD") || osName.startsWith("OpenBSD") || osName.startsWith("NetBSD");
        isPlatformWindows = osName.startsWith("Windows");
    }
}

