/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap;

import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MondrianModel {

    public static class Parameter
    extends OLAPObject {
        private String name;
        private String description;
        private String type;
        private Boolean modifiable;
        private String defaultValue;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public Parameter() {
            this.setName("New Parameter");
        }

        @Constructor
        public Parameter(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="description") String description, @ConstructorParameter(propertyName="type") String type, @ConstructorParameter(propertyName="modifiable") Boolean modifiable, @ConstructorParameter(propertyName="defaultValue") String defaultValue) {
            this();
            this.setName(name);
            this.setDescription(description);
            this.setType(type);
            this.setModifiable(modifiable);
            this.setDefaultValue(defaultValue);
        }

        public Parameter(Parameter original) {
            super(original);
            this.name = original.getName();
            this.description = original.getDescription();
            this.type = original.getType();
            this.modifiable = original.getModifiable();
            this.defaultValue = original.getDefaultValue();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Parameter:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" description = ");
            retStr.append(this.description);
            retStr.append(",");
            retStr.append(" type = ");
            retStr.append(this.type);
            retStr.append(",");
            retStr.append(" modifiable = ");
            retStr.append(this.modifiable);
            retStr.append(",");
            retStr.append(" defaultValue = ");
            retStr.append(this.defaultValue);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getDescription() {
            return this.description;
        }

        @Mutator
        public void setDescription(String newval) {
            String oldval = this.description;
            this.description = newval;
            this.firePropertyChange("description", oldval, newval);
        }

        @Accessor
        public String getType() {
            return this.type;
        }

        @Mutator
        public void setType(String newval) {
            String oldval = this.type;
            this.type = newval;
            this.firePropertyChange("type", oldval, newval);
        }

        @Accessor
        public Boolean getModifiable() {
            return this.modifiable;
        }

        @Mutator
        public void setModifiable(Boolean newval) {
            Boolean oldval = this.modifiable;
            this.modifiable = newval;
            this.firePropertyChange("modifiable", oldval, newval);
        }

        @Accessor
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Mutator
        public void setDefaultValue(String newval) {
            String oldval = this.defaultValue;
            this.defaultValue = newval;
            this.firePropertyChange("defaultValue", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class UserDefinedFunction
    extends OLAPObject {
        private String name;
        private String className;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public UserDefinedFunction() {
            this.setName("New UserDefinedFunction");
        }

        @Constructor
        public UserDefinedFunction(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="className") String className) {
            this();
            this.setName(name);
            this.setClassName(className);
        }

        public UserDefinedFunction(UserDefinedFunction original) {
            super(original);
            this.name = original.getName();
            this.className = original.getClassName();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("UserDefinedFunction:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" className = ");
            retStr.append(this.className);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getClassName() {
            return this.className;
        }

        @Mutator
        public void setClassName(String newval) {
            String oldval = this.className;
            this.className = newval;
            this.firePropertyChange("className", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class RoleUsage
    extends OLAPObject {
        private String roleName;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public RoleUsage() {
            this.setName("New RoleUsage");
        }

        @Constructor
        public RoleUsage(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="roleName") String roleName) {
            this();
            this.setName(name);
            this.setRoleName(roleName);
        }

        public RoleUsage(RoleUsage original) {
            super(original);
            this.roleName = original.getRoleName();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("RoleUsage:");
            retStr.append(" roleName = ");
            retStr.append(this.roleName);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getRoleName() {
            return this.roleName;
        }

        @Mutator
        public void setRoleName(String newval) {
            String oldval = this.roleName;
            this.roleName = newval;
            this.firePropertyChange("roleName", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class Union
    extends OLAPObject {
        private final List<RoleUsage> roleUsages = new ArrayList<RoleUsage>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Union() {
            this.setName("New Union");
        }

        @Constructor
        public Union(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public Union(Union original) {
            super(original);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Union:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        public void addRoleUsage(int pos, RoleUsage newChild) {
            this.roleUsages.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(RoleUsage.class) + pos;
            this.fireChildAdded(RoleUsage.class, (SPObject)newChild, overallPosition);
        }

        public void addRoleUsage(RoleUsage newChild) {
            this.addRoleUsage(this.roleUsages.size(), newChild);
        }

        public boolean removeRoleUsage(RoleUsage removeChild) {
            int pos = this.roleUsages.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeRoleUsage(pos);
                return true;
            }
            return false;
        }

        public RoleUsage removeRoleUsage(int pos) {
            RoleUsage removedItem = this.roleUsages.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(RoleUsage.class) + pos;
                this.fireChildRemoved(RoleUsage.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<RoleUsage> getRoleUsages() {
            return Collections.unmodifiableList(this.roleUsages);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<RoleUsage> children = new ArrayList<RoleUsage>();
            children.addAll(this.roleUsages);
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (RoleUsage.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.roleUsages.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof RoleUsage) {
                int offset = this.childPositionOffset(RoleUsage.class);
                if (index < 0 || index > this.roleUsages.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.roleUsages.size());
                }
                this.addRoleUsage(index, (RoleUsage)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof RoleUsage) {
                return this.removeRoleUsage((RoleUsage)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(RoleUsage.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class MemberGrant
    extends OLAPObject {
        private String member;
        private String access;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public MemberGrant() {
            this.setName("New MemberGrant");
        }

        @Constructor
        public MemberGrant(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="member") String member, @ConstructorParameter(propertyName="access") String access) {
            this();
            this.setName(name);
            this.setMember(member);
            this.setAccess(access);
        }

        public MemberGrant(MemberGrant original) {
            super(original);
            this.member = original.getMember();
            this.access = original.getAccess();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("MemberGrant:");
            retStr.append(" member = ");
            retStr.append(this.member);
            retStr.append(",");
            retStr.append(" access = ");
            retStr.append(this.access);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getMember() {
            return this.member;
        }

        @Mutator
        public void setMember(String newval) {
            String oldval = this.member;
            this.member = newval;
            this.firePropertyChange("member", oldval, newval);
        }

        @Accessor
        public String getAccess() {
            return this.access;
        }

        @Mutator
        public void setAccess(String newval) {
            String oldval = this.access;
            this.access = newval;
            this.firePropertyChange("access", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class HierarchyGrant
    extends Grant {
        private String hierarchy;
        private String topLevel;
        private String bottomLevel;
        private String rollupPolicy;
        private final List<MemberGrant> memberGrants = new ArrayList<MemberGrant>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public HierarchyGrant() {
            this.setName("New HierarchyGrant");
        }

        @Constructor
        public HierarchyGrant(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="hierarchy") String hierarchy, @ConstructorParameter(propertyName="topLevel") String topLevel, @ConstructorParameter(propertyName="bottomLevel") String bottomLevel, @ConstructorParameter(propertyName="rollupPolicy") String rollupPolicy, @ConstructorParameter(propertyName="access") String access) {
            this();
            this.setName(name);
            this.setHierarchy(hierarchy);
            this.setTopLevel(topLevel);
            this.setBottomLevel(bottomLevel);
            this.setRollupPolicy(rollupPolicy);
            this.setAccess(access);
        }

        public HierarchyGrant(HierarchyGrant original) {
            super(original);
            this.hierarchy = original.getHierarchy();
            this.topLevel = original.getTopLevel();
            this.bottomLevel = original.getBottomLevel();
            this.rollupPolicy = original.getRollupPolicy();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("HierarchyGrant:");
            retStr.append(" hierarchy = ");
            retStr.append(this.hierarchy);
            retStr.append(",");
            retStr.append(" topLevel = ");
            retStr.append(this.topLevel);
            retStr.append(",");
            retStr.append(" bottomLevel = ");
            retStr.append(this.bottomLevel);
            retStr.append(",");
            retStr.append(" rollupPolicy = ");
            retStr.append(this.rollupPolicy);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getHierarchy() {
            return this.hierarchy;
        }

        @Mutator
        public void setHierarchy(String newval) {
            String oldval = this.hierarchy;
            this.hierarchy = newval;
            this.firePropertyChange("hierarchy", oldval, newval);
        }

        @Accessor
        public String getTopLevel() {
            return this.topLevel;
        }

        @Mutator
        public void setTopLevel(String newval) {
            String oldval = this.topLevel;
            this.topLevel = newval;
            this.firePropertyChange("topLevel", oldval, newval);
        }

        @Accessor
        public String getBottomLevel() {
            return this.bottomLevel;
        }

        @Mutator
        public void setBottomLevel(String newval) {
            String oldval = this.bottomLevel;
            this.bottomLevel = newval;
            this.firePropertyChange("bottomLevel", oldval, newval);
        }

        @Accessor
        public String getRollupPolicy() {
            return this.rollupPolicy;
        }

        @Mutator
        public void setRollupPolicy(String newval) {
            String oldval = this.rollupPolicy;
            this.rollupPolicy = newval;
            this.firePropertyChange("rollupPolicy", oldval, newval);
        }

        public void addMemberGrant(int pos, MemberGrant newChild) {
            this.memberGrants.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(MemberGrant.class) + pos;
            this.fireChildAdded(MemberGrant.class, (SPObject)newChild, overallPosition);
        }

        public void addMemberGrant(MemberGrant newChild) {
            this.addMemberGrant(this.memberGrants.size(), newChild);
        }

        public boolean removeMemberGrant(MemberGrant removeChild) {
            int pos = this.memberGrants.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeMemberGrant(pos);
                return true;
            }
            return false;
        }

        public MemberGrant removeMemberGrant(int pos) {
            MemberGrant removedItem = this.memberGrants.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(MemberGrant.class) + pos;
                this.fireChildRemoved(MemberGrant.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<MemberGrant> getMemberGrants() {
            return Collections.unmodifiableList(this.memberGrants);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<MemberGrant> children = new ArrayList<MemberGrant>();
            children.addAll(this.memberGrants);
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (MemberGrant.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.memberGrants.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof MemberGrant) {
                int offset = this.childPositionOffset(MemberGrant.class);
                if (index < 0 || index > this.memberGrants.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.memberGrants.size());
                }
                this.addMemberGrant(index, (MemberGrant)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof MemberGrant) {
                return this.removeMemberGrant((MemberGrant)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(MemberGrant.class));
            childTypes.addAll(Grant.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class DimensionGrant
    extends Grant {
        private String dimension;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Grant.allowedChildTypes;

        public DimensionGrant() {
            this.setName("New DimensionGrant");
        }

        @Constructor
        public DimensionGrant(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="dimension") String dimension, @ConstructorParameter(propertyName="access") String access) {
            this();
            this.setName(name);
            this.setDimension(dimension);
            this.setAccess(access);
        }

        public DimensionGrant(DimensionGrant original) {
            super(original);
            this.dimension = original.getDimension();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("DimensionGrant:");
            retStr.append(" dimension = ");
            retStr.append(this.dimension);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getDimension() {
            return this.dimension;
        }

        @Mutator
        public void setDimension(String newval) {
            String oldval = this.dimension;
            this.dimension = newval;
            this.firePropertyChange("dimension", oldval, newval);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class CubeGrant
    extends Grant {
        private String cube;
        private final List<DimensionGrant> dimensionGrants = new ArrayList<DimensionGrant>();
        private final List<HierarchyGrant> hierarchyGrants = new ArrayList<HierarchyGrant>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public CubeGrant() {
            this.setName("New CubeGrant");
        }

        @Constructor
        public CubeGrant(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="cube") String cube, @ConstructorParameter(propertyName="access") String access) {
            this();
            this.setName(name);
            this.setCube(cube);
            this.setAccess(access);
        }

        public CubeGrant(CubeGrant original) {
            super(original);
            this.cube = original.getCube();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("CubeGrant:");
            retStr.append(" cube = ");
            retStr.append(this.cube);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getCube() {
            return this.cube;
        }

        @Mutator
        public void setCube(String newval) {
            String oldval = this.cube;
            this.cube = newval;
            this.firePropertyChange("cube", oldval, newval);
        }

        public void addDimensionGrant(int pos, DimensionGrant newChild) {
            this.dimensionGrants.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(DimensionGrant.class) + pos;
            this.fireChildAdded(DimensionGrant.class, (SPObject)newChild, overallPosition);
        }

        public void addDimensionGrant(DimensionGrant newChild) {
            this.addDimensionGrant(this.dimensionGrants.size(), newChild);
        }

        public boolean removeDimensionGrant(DimensionGrant removeChild) {
            int pos = this.dimensionGrants.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeDimensionGrant(pos);
                return true;
            }
            return false;
        }

        public DimensionGrant removeDimensionGrant(int pos) {
            DimensionGrant removedItem = this.dimensionGrants.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(DimensionGrant.class) + pos;
                this.fireChildRemoved(DimensionGrant.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<DimensionGrant> getDimensionGrants() {
            return Collections.unmodifiableList(this.dimensionGrants);
        }

        public void addHierarchyGrant(int pos, HierarchyGrant newChild) {
            this.hierarchyGrants.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(HierarchyGrant.class) + pos;
            this.fireChildAdded(HierarchyGrant.class, (SPObject)newChild, overallPosition);
        }

        public void addHierarchyGrant(HierarchyGrant newChild) {
            this.addHierarchyGrant(this.hierarchyGrants.size(), newChild);
        }

        public boolean removeHierarchyGrant(HierarchyGrant removeChild) {
            int pos = this.hierarchyGrants.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeHierarchyGrant(pos);
                return true;
            }
            return false;
        }

        public HierarchyGrant removeHierarchyGrant(int pos) {
            HierarchyGrant removedItem = this.hierarchyGrants.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(HierarchyGrant.class) + pos;
                this.fireChildRemoved(HierarchyGrant.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<HierarchyGrant> getHierarchyGrants() {
            return Collections.unmodifiableList(this.hierarchyGrants);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<Grant> children = new ArrayList<Grant>();
            children.addAll(this.dimensionGrants);
            children.addAll(this.hierarchyGrants);
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (DimensionGrant.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.dimensionGrants.size();
            if (HierarchyGrant.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.hierarchyGrants.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof DimensionGrant) {
                int offset = this.childPositionOffset(DimensionGrant.class);
                if (index < 0 || index > this.dimensionGrants.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.dimensionGrants.size());
                }
                this.addDimensionGrant(index, (DimensionGrant)child);
            } else if (child instanceof HierarchyGrant) {
                int offset = this.childPositionOffset(HierarchyGrant.class);
                if (index < 0 || index > this.hierarchyGrants.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.hierarchyGrants.size());
                }
                this.addHierarchyGrant(index, (HierarchyGrant)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof DimensionGrant) {
                return this.removeDimensionGrant((DimensionGrant)child);
            }
            if (child instanceof HierarchyGrant) {
                return this.removeHierarchyGrant((HierarchyGrant)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(DimensionGrant.class, HierarchyGrant.class));
            childTypes.addAll(Grant.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class SchemaGrant
    extends Grant {
        private final List<CubeGrant> cubeGrants = new ArrayList<CubeGrant>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public SchemaGrant() {
            this.setName("New SchemaGrant");
        }

        @Constructor
        public SchemaGrant(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="access") String access) {
            this();
            this.setName(name);
            this.setAccess(access);
        }

        public SchemaGrant(SchemaGrant original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("SchemaGrant:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        public void addCubeGrant(int pos, CubeGrant newChild) {
            this.cubeGrants.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(CubeGrant.class) + pos;
            this.fireChildAdded(CubeGrant.class, (SPObject)newChild, overallPosition);
        }

        public void addCubeGrant(CubeGrant newChild) {
            this.addCubeGrant(this.cubeGrants.size(), newChild);
        }

        public boolean removeCubeGrant(CubeGrant removeChild) {
            int pos = this.cubeGrants.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeCubeGrant(pos);
                return true;
            }
            return false;
        }

        public CubeGrant removeCubeGrant(int pos) {
            CubeGrant removedItem = this.cubeGrants.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(CubeGrant.class) + pos;
                this.fireChildRemoved(CubeGrant.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<CubeGrant> getCubeGrants() {
            return Collections.unmodifiableList(this.cubeGrants);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<CubeGrant> children = new ArrayList<CubeGrant>();
            children.addAll(this.cubeGrants);
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (CubeGrant.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.cubeGrants.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof CubeGrant) {
                int offset = this.childPositionOffset(CubeGrant.class);
                if (index < 0 || index > this.cubeGrants.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.cubeGrants.size());
                }
                this.addCubeGrant(index, (CubeGrant)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof CubeGrant) {
                return this.removeCubeGrant((CubeGrant)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(CubeGrant.class));
            childTypes.addAll(Grant.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static abstract class Grant
    extends OLAPObject {
        private String access;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public Grant() {
            this.setName("New Grant");
        }

        @Constructor
        public Grant(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="access") String access) {
            this();
            this.setName(name);
            this.setAccess(access);
        }

        public Grant(Grant original) {
            super(original);
            this.access = original.getAccess();
        }

        @Accessor
        public String getAccess() {
            return this.access;
        }

        @Mutator
        public void setAccess(String newval) {
            String oldval = this.access;
            this.access = newval;
            this.firePropertyChange("access", oldval, newval);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Grant:");
            retStr.append(" access = ");
            retStr.append(this.access);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class Role
    extends OLAPObject {
        private String name;
        private final List<SchemaGrant> schemaGrants = new ArrayList<SchemaGrant>();
        private Union union;
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Role() {
            this.setName("New Role");
        }

        @Constructor
        public Role(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public Role(Role original) {
            super(original);
            this.name = original.getName();
            this.union = original.getUnion();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Role:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" union = ");
            retStr.append((Object)this.union);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        public void addSchemaGrant(int pos, SchemaGrant newChild) {
            this.schemaGrants.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(SchemaGrant.class) + pos;
            this.fireChildAdded(SchemaGrant.class, (SPObject)newChild, overallPosition);
        }

        public void addSchemaGrant(SchemaGrant newChild) {
            this.addSchemaGrant(this.schemaGrants.size(), newChild);
        }

        public boolean removeSchemaGrant(SchemaGrant removeChild) {
            int pos = this.schemaGrants.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeSchemaGrant(pos);
                return true;
            }
            return false;
        }

        public SchemaGrant removeSchemaGrant(int pos) {
            SchemaGrant removedItem = this.schemaGrants.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(SchemaGrant.class) + pos;
                this.fireChildRemoved(SchemaGrant.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<SchemaGrant> getSchemaGrants() {
            return Collections.unmodifiableList(this.schemaGrants);
        }

        @NonProperty
        public Union getUnion() {
            return this.union;
        }

        @NonProperty
        public void setUnion(Union newval) {
            Union oldval = this.union;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(Union.class);
            if (this.union != null) {
                this.fireChildRemoved(Union.class, (SPObject)oldval, overallPosition);
            }
            this.union = newval;
            if (this.union != null) {
                this.union.setParent((SPObject)this);
                this.fireChildAdded(Union.class, (SPObject)this.union, overallPosition);
            }
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.schemaGrants);
            if (this.union != null) {
                children.add(this.union);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (SchemaGrant.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.schemaGrants.size();
            if (Union.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof SchemaGrant) {
                int offset = this.childPositionOffset(SchemaGrant.class);
                if (index < 0 || index > this.schemaGrants.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.schemaGrants.size());
                }
                this.addSchemaGrant(index, (SchemaGrant)child);
            } else if (child instanceof Union) {
                this.setUnion((Union)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof SchemaGrant) {
                return this.removeSchemaGrant((SchemaGrant)child);
            }
            if (child instanceof Union) {
                this.setUnion(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(SchemaGrant.class, Union.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class MeasureExpression
    extends ExpressionView {
        public static final List<Class<? extends SPObject>> allowedChildTypes = ExpressionView.allowedChildTypes;

        public MeasureExpression() {
            this.setName("New MeasureExpression");
        }

        @Constructor
        public MeasureExpression(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public MeasureExpression(MeasureExpression original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("MeasureExpression:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class CaptionExpression
    extends ExpressionView {
        public static final List<Class<? extends SPObject>> allowedChildTypes = ExpressionView.allowedChildTypes;

        public CaptionExpression() {
            this.setName("New CaptionExpression");
        }

        @Constructor
        public CaptionExpression(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public CaptionExpression(CaptionExpression original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("CaptionExpression:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class NameExpression
    extends ExpressionView {
        public static final List<Class<? extends SPObject>> allowedChildTypes = ExpressionView.allowedChildTypes;

        public NameExpression() {
            this.setName("New NameExpression");
        }

        @Constructor
        public NameExpression(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public NameExpression(NameExpression original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("NameExpression:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class OrdinalExpression
    extends ExpressionView {
        public static final List<Class<? extends SPObject>> allowedChildTypes = ExpressionView.allowedChildTypes;

        public OrdinalExpression() {
            this.setName("New OrdinalExpression");
        }

        @Constructor
        public OrdinalExpression(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public OrdinalExpression(OrdinalExpression original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("OrdinalExpression:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class ParentExpression
    extends ExpressionView {
        public static final List<Class<? extends SPObject>> allowedChildTypes = ExpressionView.allowedChildTypes;

        public ParentExpression() {
            this.setName("New ParentExpression");
        }

        @Constructor
        public ParentExpression(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public ParentExpression(ParentExpression original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("ParentExpression:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class KeyExpression
    extends ExpressionView {
        public static final List<Class<? extends SPObject>> allowedChildTypes = ExpressionView.allowedChildTypes;

        public KeyExpression() {
            this.setName("New KeyExpression");
        }

        @Constructor
        public KeyExpression(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public KeyExpression(KeyExpression original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("KeyExpression:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static abstract class ExpressionView
    extends Expression {
        private final List<SQL> expressions = new ArrayList<SQL>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public ExpressionView() {
            this.setName("New ExpressionView");
        }

        @Constructor
        public ExpressionView(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public ExpressionView(ExpressionView original) {
            super(original);
        }

        public void addExpression(int pos, SQL newChild) {
            this.expressions.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(SQL.class) + pos;
            this.fireChildAdded(SQL.class, (SPObject)newChild, overallPosition);
        }

        public void addExpression(SQL newChild) {
            this.addExpression(this.expressions.size(), newChild);
        }

        public boolean removeExpression(SQL removeChild) {
            int pos = this.expressions.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeExpression(pos);
                return true;
            }
            return false;
        }

        public SQL removeExpression(int pos) {
            SQL removedItem = this.expressions.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(SQL.class) + pos;
                this.fireChildRemoved(SQL.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<SQL> getExpressions() {
            return Collections.unmodifiableList(this.expressions);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("ExpressionView:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<SQL> children = new ArrayList<SQL>();
            children.addAll(this.expressions);
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (SQL.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.expressions.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof SQL) {
                int offset = this.childPositionOffset(SQL.class);
                if (index < 0 || index > this.expressions.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.expressions.size());
                }
                this.addExpression(index, (SQL)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof SQL) {
                return this.removeExpression((SQL)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(SQL.class));
            childTypes.addAll(Expression.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Column
    extends Expression {
        private String table;
        private String name;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Expression.allowedChildTypes;

        public Column() {
            this.setName("New Column");
        }

        @Constructor
        public Column(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="table") String table) {
            this();
            this.setName(name);
            this.setTable(table);
        }

        public Column(Column original) {
            super(original);
            this.table = original.getTable();
            this.name = original.getName();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Column:");
            retStr.append(" table = ");
            retStr.append(this.table);
            retStr.append(",");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getTable() {
            return this.table;
        }

        @Mutator
        public void setTable(String newval) {
            String oldval = this.table;
            this.table = newval;
            this.firePropertyChange("table", oldval, newval);
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static abstract class Expression
    extends OLAPObject {
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public Expression() {
            this.setName("New Expression");
        }

        @Constructor
        public Expression(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public Expression(Expression original) {
            super(original);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Expression:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class AggMeasure
    extends OLAPObject {
        private String column;
        private String name;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public AggMeasure() {
            this.setName("New AggMeasure");
        }

        @Constructor
        public AggMeasure(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="column") String column) {
            this();
            this.setName(name);
            this.setColumn(column);
        }

        public AggMeasure(AggMeasure original) {
            super(original);
            this.column = original.getColumn();
            this.name = original.getName();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggMeasure:");
            retStr.append(" column = ");
            retStr.append(this.column);
            retStr.append(",");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getColumn() {
            return this.column;
        }

        @Mutator
        public void setColumn(String newval) {
            String oldval = this.column;
            this.column = newval;
            this.firePropertyChange("column", oldval, newval);
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class AggLevel
    extends OLAPObject {
        private String column;
        private String name;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public AggLevel() {
            this.setName("New AggLevel");
        }

        @Constructor
        public AggLevel(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="column") String column) {
            this();
            this.setName(name);
            this.setColumn(column);
        }

        public AggLevel(AggLevel original) {
            super(original);
            this.column = original.getColumn();
            this.name = original.getName();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggLevel:");
            retStr.append(" column = ");
            retStr.append(this.column);
            retStr.append(",");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getColumn() {
            return this.column;
        }

        @Mutator
        public void setColumn(String newval) {
            String oldval = this.column;
            this.column = newval;
            this.firePropertyChange("column", oldval, newval);
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class AggForeignKey
    extends OLAPObject {
        private String factColumn;
        private String aggColumn;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public AggForeignKey() {
            this.setName("New AggForeignKey");
        }

        @Constructor
        public AggForeignKey(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="factColumn") String factColumn, @ConstructorParameter(propertyName="aggColumn") String aggColumn) {
            this();
            this.setName(name);
            this.setFactColumn(factColumn);
            this.setAggColumn(aggColumn);
        }

        public AggForeignKey(AggForeignKey original) {
            super(original);
            this.factColumn = original.getFactColumn();
            this.aggColumn = original.getAggColumn();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggForeignKey:");
            retStr.append(" factColumn = ");
            retStr.append(this.factColumn);
            retStr.append(",");
            retStr.append(" aggColumn = ");
            retStr.append(this.aggColumn);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getFactColumn() {
            return this.factColumn;
        }

        @Mutator
        public void setFactColumn(String newval) {
            String oldval = this.factColumn;
            this.factColumn = newval;
            this.firePropertyChange("factColumn", oldval, newval);
        }

        @Accessor
        public String getAggColumn() {
            return this.aggColumn;
        }

        @Mutator
        public void setAggColumn(String newval) {
            String oldval = this.aggColumn;
            this.aggColumn = newval;
            this.firePropertyChange("aggColumn", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class AggIgnoreColumn
    extends AggColumnName {
        public static final List<Class<? extends SPObject>> allowedChildTypes = AggColumnName.allowedChildTypes;

        public AggIgnoreColumn() {
            this.setName("New AggIgnoreColumn");
        }

        @Constructor
        public AggIgnoreColumn(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="column") String column) {
            this();
            this.setName(name);
            this.setColumn(column);
        }

        public AggIgnoreColumn(AggIgnoreColumn original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggIgnoreColumn:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class AggFactCount
    extends AggColumnName {
        public static final List<Class<? extends SPObject>> allowedChildTypes = AggColumnName.allowedChildTypes;

        public AggFactCount() {
            this.setName("New AggFactCount");
        }

        @Constructor
        public AggFactCount(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="column") String column) {
            this();
            this.setName(name);
            this.setColumn(column);
        }

        public AggFactCount(AggFactCount original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggFactCount:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static abstract class AggColumnName
    extends OLAPObject {
        private String column;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public AggColumnName() {
            this.setName("New AggColumnName");
        }

        @Constructor
        public AggColumnName(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="column") String column) {
            this();
            this.setName(name);
            this.setColumn(column);
        }

        public AggColumnName(AggColumnName original) {
            super(original);
            this.column = original.getColumn();
        }

        @Accessor
        public String getColumn() {
            return this.column;
        }

        @Mutator
        public void setColumn(String newval) {
            String oldval = this.column;
            this.column = newval;
            this.firePropertyChange("column", oldval, newval);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggColumnName:");
            retStr.append(" column = ");
            retStr.append(this.column);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class AggExclude
    extends OLAPObject {
        private String pattern;
        private String name;
        private Boolean ignorecase;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public AggExclude() {
            this.setName("New AggExclude");
        }

        @Constructor
        public AggExclude(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="pattern") String pattern, @ConstructorParameter(propertyName="ignorecase") Boolean ignorecase) {
            this();
            this.setName(name);
            this.setPattern(pattern);
            this.setIgnorecase(ignorecase);
        }

        public AggExclude(AggExclude original) {
            super(original);
            this.pattern = original.getPattern();
            this.name = original.getName();
            this.ignorecase = original.getIgnorecase();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggExclude:");
            retStr.append(" pattern = ");
            retStr.append(this.pattern);
            retStr.append(",");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" ignorecase = ");
            retStr.append(this.ignorecase);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getPattern() {
            return this.pattern;
        }

        @Mutator
        public void setPattern(String newval) {
            String oldval = this.pattern;
            this.pattern = newval;
            this.firePropertyChange("pattern", oldval, newval);
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public Boolean getIgnorecase() {
            return this.ignorecase;
        }

        @Mutator
        public void setIgnorecase(Boolean newval) {
            Boolean oldval = this.ignorecase;
            this.ignorecase = newval;
            this.firePropertyChange("ignorecase", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class AggPattern
    extends AggTable {
        private String pattern;
        private final List<AggExclude> excludes = new ArrayList<AggExclude>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public AggPattern() {
            this.setName("New AggPattern");
        }

        @Constructor
        public AggPattern(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="pattern") String pattern, @ConstructorParameter(propertyName="ignorecase") Boolean ignorecase) {
            this();
            this.setName(name);
            this.setPattern(pattern);
            this.setIgnorecase(ignorecase);
        }

        public AggPattern(AggPattern original) {
            super(original);
            this.pattern = original.getPattern();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggPattern:");
            retStr.append(" pattern = ");
            retStr.append(this.pattern);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getPattern() {
            return this.pattern;
        }

        @Mutator
        public void setPattern(String newval) {
            String oldval = this.pattern;
            this.pattern = newval;
            this.firePropertyChange("pattern", oldval, newval);
        }

        public void addExclude(int pos, AggExclude newChild) {
            this.excludes.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(AggExclude.class) + pos;
            this.fireChildAdded(AggExclude.class, (SPObject)newChild, overallPosition);
        }

        public void addExclude(AggExclude newChild) {
            this.addExclude(this.excludes.size(), newChild);
        }

        public boolean removeExclude(AggExclude removeChild) {
            int pos = this.excludes.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeExclude(pos);
                return true;
            }
            return false;
        }

        public AggExclude removeExclude(int pos) {
            AggExclude removedItem = this.excludes.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(AggExclude.class) + pos;
                this.fireChildRemoved(AggExclude.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<AggExclude> getExcludes() {
            return Collections.unmodifiableList(this.excludes);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<AggExclude> children = new ArrayList<AggExclude>();
            children.addAll(this.excludes);
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (AggExclude.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.excludes.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof AggExclude) {
                int offset = this.childPositionOffset(AggExclude.class);
                if (index < 0 || index > this.excludes.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.excludes.size());
                }
                this.addExclude(index, (AggExclude)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof AggExclude) {
                return this.removeExclude((AggExclude)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(AggExclude.class));
            childTypes.addAll(AggTable.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class AggName
    extends AggTable {
        private String name;
        public static final List<Class<? extends SPObject>> allowedChildTypes = AggTable.allowedChildTypes;

        public AggName() {
            this.setName("New AggName");
        }

        @Constructor
        public AggName(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="ignorecase") Boolean ignorecase) {
            this();
            this.setName(name);
            this.setIgnorecase(ignorecase);
        }

        public AggName(AggName original) {
            super(original);
            this.name = original.getName();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggName:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static abstract class AggTable
    extends OLAPObject {
        private Boolean ignorecase;
        private AggFactCount factcount;
        private final List<AggIgnoreColumn> ignoreColumns = new ArrayList<AggIgnoreColumn>();
        private final List<AggForeignKey> foreignKeys = new ArrayList<AggForeignKey>();
        private final List<AggMeasure> measures = new ArrayList<AggMeasure>();
        private final List<AggLevel> levels = new ArrayList<AggLevel>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public AggTable() {
            this.setName("New AggTable");
        }

        @Constructor
        public AggTable(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="ignorecase") Boolean ignorecase) {
            this();
            this.setName(name);
            this.setIgnorecase(ignorecase);
        }

        public AggTable(AggTable original) {
            super(original);
            this.ignorecase = original.getIgnorecase();
            this.factcount = original.getFactcount();
        }

        @Accessor
        public Boolean getIgnorecase() {
            return this.ignorecase;
        }

        @Mutator
        public void setIgnorecase(Boolean newval) {
            Boolean oldval = this.ignorecase;
            this.ignorecase = newval;
            this.firePropertyChange("ignorecase", oldval, newval);
        }

        @NonProperty
        public AggFactCount getFactcount() {
            return this.factcount;
        }

        @NonProperty
        public void setFactcount(AggFactCount newval) {
            AggFactCount oldval = this.factcount;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(AggFactCount.class);
            if (this.factcount != null) {
                this.fireChildRemoved(AggFactCount.class, (SPObject)oldval, overallPosition);
            }
            this.factcount = newval;
            if (this.factcount != null) {
                this.factcount.setParent((SPObject)this);
                this.fireChildAdded(AggFactCount.class, (SPObject)this.factcount, overallPosition);
            }
        }

        public void addIgnoreColumn(int pos, AggIgnoreColumn newChild) {
            this.ignoreColumns.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(AggIgnoreColumn.class) + pos;
            this.fireChildAdded(AggIgnoreColumn.class, (SPObject)newChild, overallPosition);
        }

        public void addIgnoreColumn(AggIgnoreColumn newChild) {
            this.addIgnoreColumn(this.ignoreColumns.size(), newChild);
        }

        public boolean removeIgnoreColumn(AggIgnoreColumn removeChild) {
            int pos = this.ignoreColumns.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeIgnoreColumn(pos);
                return true;
            }
            return false;
        }

        public AggIgnoreColumn removeIgnoreColumn(int pos) {
            AggIgnoreColumn removedItem = this.ignoreColumns.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(AggIgnoreColumn.class) + pos;
                this.fireChildRemoved(AggIgnoreColumn.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<AggIgnoreColumn> getIgnoreColumns() {
            return Collections.unmodifiableList(this.ignoreColumns);
        }

        public void addForeignKey(int pos, AggForeignKey newChild) {
            this.foreignKeys.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(AggForeignKey.class) + pos;
            this.fireChildAdded(AggForeignKey.class, (SPObject)newChild, overallPosition);
        }

        public void addForeignKey(AggForeignKey newChild) {
            this.addForeignKey(this.foreignKeys.size(), newChild);
        }

        public boolean removeForeignKey(AggForeignKey removeChild) {
            int pos = this.foreignKeys.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeForeignKey(pos);
                return true;
            }
            return false;
        }

        public AggForeignKey removeForeignKey(int pos) {
            AggForeignKey removedItem = this.foreignKeys.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(AggForeignKey.class) + pos;
                this.fireChildRemoved(AggForeignKey.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<AggForeignKey> getForeignKeys() {
            return Collections.unmodifiableList(this.foreignKeys);
        }

        public void addMeasure(int pos, AggMeasure newChild) {
            this.measures.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(AggMeasure.class) + pos;
            this.fireChildAdded(AggMeasure.class, (SPObject)newChild, overallPosition);
        }

        public void addMeasure(AggMeasure newChild) {
            this.addMeasure(this.measures.size(), newChild);
        }

        public boolean removeMeasure(AggMeasure removeChild) {
            int pos = this.measures.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeMeasure(pos);
                return true;
            }
            return false;
        }

        public AggMeasure removeMeasure(int pos) {
            AggMeasure removedItem = this.measures.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(AggMeasure.class) + pos;
                this.fireChildRemoved(AggMeasure.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<AggMeasure> getMeasures() {
            return Collections.unmodifiableList(this.measures);
        }

        public void addLevel(int pos, AggLevel newChild) {
            this.levels.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(AggLevel.class) + pos;
            this.fireChildAdded(AggLevel.class, (SPObject)newChild, overallPosition);
        }

        public void addLevel(AggLevel newChild) {
            this.addLevel(this.levels.size(), newChild);
        }

        public boolean removeLevel(AggLevel removeChild) {
            int pos = this.levels.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeLevel(pos);
                return true;
            }
            return false;
        }

        public AggLevel removeLevel(int pos) {
            AggLevel removedItem = this.levels.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(AggLevel.class) + pos;
                this.fireChildRemoved(AggLevel.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<AggLevel> getLevels() {
            return Collections.unmodifiableList(this.levels);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("AggTable:");
            retStr.append(" ignorecase = ");
            retStr.append(this.ignorecase);
            retStr.append(",");
            retStr.append(" factcount = ");
            retStr.append((Object)this.factcount);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.ignoreColumns);
            children.addAll(this.foreignKeys);
            children.addAll(this.measures);
            children.addAll(this.levels);
            if (this.factcount != null) {
                children.add(this.factcount);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (AggIgnoreColumn.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.ignoreColumns.size();
            if (AggForeignKey.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.foreignKeys.size();
            if (AggMeasure.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.measures.size();
            if (AggLevel.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.levels.size();
            if (AggFactCount.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof AggIgnoreColumn) {
                int offset = this.childPositionOffset(AggIgnoreColumn.class);
                if (index < 0 || index > this.ignoreColumns.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.ignoreColumns.size());
                }
                this.addIgnoreColumn(index, (AggIgnoreColumn)child);
            } else if (child instanceof AggForeignKey) {
                int offset = this.childPositionOffset(AggForeignKey.class);
                if (index < 0 || index > this.foreignKeys.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.foreignKeys.size());
                }
                this.addForeignKey(index, (AggForeignKey)child);
            } else if (child instanceof AggMeasure) {
                int offset = this.childPositionOffset(AggMeasure.class);
                if (index < 0 || index > this.measures.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.measures.size());
                }
                this.addMeasure(index, (AggMeasure)child);
            } else if (child instanceof AggLevel) {
                int offset = this.childPositionOffset(AggLevel.class);
                if (index < 0 || index > this.levels.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.levels.size());
                }
                this.addLevel(index, (AggLevel)child);
            } else if (child instanceof AggFactCount) {
                this.setFactcount((AggFactCount)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof AggIgnoreColumn) {
                return this.removeIgnoreColumn((AggIgnoreColumn)child);
            }
            if (child instanceof AggForeignKey) {
                return this.removeForeignKey((AggForeignKey)child);
            }
            if (child instanceof AggMeasure) {
                return this.removeMeasure((AggMeasure)child);
            }
            if (child instanceof AggLevel) {
                return this.removeLevel((AggLevel)child);
            }
            if (child instanceof AggFactCount) {
                this.setFactcount(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(AggIgnoreColumn.class, AggForeignKey.class, AggMeasure.class, AggLevel.class, AggFactCount.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Value
    extends OLAPObject {
        private String column;
        private String text;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public Value() {
            this.setName("New Value");
        }

        @Constructor
        public Value(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="column") String column) {
            this();
            this.setName(name);
            this.setColumn(column);
        }

        public Value(Value original) {
            super(original);
            this.column = original.getColumn();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Value:");
            retStr.append(" column = ");
            retStr.append(this.column);
            retStr.append(",");
            retStr.append("text = ");
            retStr.append(this.text);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getColumn() {
            return this.column;
        }

        @Mutator
        public void setColumn(String newval) {
            String oldval = this.column;
            this.column = newval;
            this.firePropertyChange("column", oldval, newval);
        }

        @Accessor
        public String getText() {
            return this.text;
        }

        @Mutator
        public void setText(String newval) {
            String oldval = this.text;
            this.text = newval;
            this.firePropertyChange("text", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class Row
    extends OLAPObject {
        private final List<Value> values = new ArrayList<Value>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Row() {
            this.setName("New Row");
        }

        @Constructor
        public Row(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public Row(Row original) {
            super(original);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Row:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        public void addValue(int pos, Value newChild) {
            this.values.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Value.class) + pos;
            this.fireChildAdded(Value.class, (SPObject)newChild, overallPosition);
        }

        public void addValue(Value newChild) {
            this.addValue(this.values.size(), newChild);
        }

        public boolean removeValue(Value removeChild) {
            int pos = this.values.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeValue(pos);
                return true;
            }
            return false;
        }

        public Value removeValue(int pos) {
            Value removedItem = this.values.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Value.class) + pos;
                this.fireChildRemoved(Value.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Value> getValues() {
            return Collections.unmodifiableList(this.values);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<Value> children = new ArrayList<Value>();
            children.addAll(this.values);
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (Value.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.values.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof Value) {
                int offset = this.childPositionOffset(Value.class);
                if (index < 0 || index > this.values.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.values.size());
                }
                this.addValue(index, (Value)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof Value) {
                return this.removeValue((Value)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(Value.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Rows
    extends OLAPObject {
        private final List<Row> array = new ArrayList<Row>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Rows() {
            this.setName("New Rows");
        }

        @Constructor
        public Rows(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public Rows(Rows original) {
            super(original);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Rows:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        public void addArray(int pos, Row newChild) {
            this.array.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Row.class) + pos;
            this.fireChildAdded(Row.class, (SPObject)newChild, overallPosition);
        }

        public void addArray(Row newChild) {
            this.addArray(this.array.size(), newChild);
        }

        public boolean removeArray(Row removeChild) {
            int pos = this.array.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeArray(pos);
                return true;
            }
            return false;
        }

        public Row removeArray(int pos) {
            Row removedItem = this.array.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Row.class) + pos;
                this.fireChildRemoved(Row.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Row> getArray() {
            return Collections.unmodifiableList(this.array);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<Row> children = new ArrayList<Row>();
            children.addAll(this.array);
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (Row.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.array.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof Row) {
                int offset = this.childPositionOffset(Row.class);
                if (index < 0 || index > this.array.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.array.size());
                }
                this.addArray(index, (Row)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof Row) {
                return this.removeArray((Row)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(Row.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class ColumnDef
    extends OLAPObject {
        private String name;
        private String type;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public ColumnDef() {
            this.setName("New ColumnDef");
        }

        @Constructor
        public ColumnDef(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="type") String type) {
            this();
            this.setName(name);
            this.setType(type);
        }

        public ColumnDef(ColumnDef original) {
            super(original);
            this.name = original.getName();
            this.type = original.getType();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("ColumnDef:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" type = ");
            retStr.append(this.type);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getType() {
            return this.type;
        }

        @Mutator
        public void setType(String newval) {
            String oldval = this.type;
            this.type = newval;
            this.firePropertyChange("type", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class ColumnDefs
    extends OLAPObject {
        private final List<ColumnDef> array = new ArrayList<ColumnDef>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public ColumnDefs() {
            this.setName("New ColumnDefs");
        }

        @Constructor
        public ColumnDefs(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public ColumnDefs(ColumnDefs original) {
            super(original);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("ColumnDefs:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        public void addArray(int pos, ColumnDef newChild) {
            this.array.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(ColumnDef.class) + pos;
            this.fireChildAdded(ColumnDef.class, (SPObject)newChild, overallPosition);
        }

        public void addArray(ColumnDef newChild) {
            this.addArray(this.array.size(), newChild);
        }

        public boolean removeArray(ColumnDef removeChild) {
            int pos = this.array.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeArray(pos);
                return true;
            }
            return false;
        }

        public ColumnDef removeArray(int pos) {
            ColumnDef removedItem = this.array.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(ColumnDef.class) + pos;
                this.fireChildRemoved(ColumnDef.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<ColumnDef> getArray() {
            return Collections.unmodifiableList(this.array);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<ColumnDef> children = new ArrayList<ColumnDef>();
            children.addAll(this.array);
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (ColumnDef.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.array.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof ColumnDef) {
                int offset = this.childPositionOffset(ColumnDef.class);
                if (index < 0 || index > this.array.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.array.size());
                }
                this.addArray(index, (ColumnDef)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof ColumnDef) {
                return this.removeArray((ColumnDef)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(ColumnDef.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class InlineTable
    extends Relation {
        private String alias;
        private ColumnDefs columnDefs;
        private Rows rows;
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public InlineTable() {
            this.setName("New InlineTable");
        }

        @Constructor
        public InlineTable(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="alias") String alias) {
            this();
            this.setName(name);
            this.setAlias(alias);
        }

        public InlineTable(InlineTable original) {
            super(original);
            this.alias = original.getAlias();
            this.columnDefs = original.getColumnDefs();
            this.rows = original.getRows();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("InlineTable:");
            retStr.append(" alias = ");
            retStr.append(this.alias);
            retStr.append(",");
            retStr.append(" columnDefs = ");
            retStr.append((Object)this.columnDefs);
            retStr.append(",");
            retStr.append(" rows = ");
            retStr.append((Object)this.rows);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getAlias() {
            return this.alias;
        }

        @Mutator
        public void setAlias(String newval) {
            String oldval = this.alias;
            this.alias = newval;
            this.firePropertyChange("alias", oldval, newval);
        }

        @NonProperty
        public ColumnDefs getColumnDefs() {
            return this.columnDefs;
        }

        @NonProperty
        public void setColumnDefs(ColumnDefs newval) {
            ColumnDefs oldval = this.columnDefs;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(ColumnDefs.class);
            if (this.columnDefs != null) {
                this.fireChildRemoved(ColumnDefs.class, (SPObject)oldval, overallPosition);
            }
            this.columnDefs = newval;
            if (this.columnDefs != null) {
                this.columnDefs.setParent((SPObject)this);
                this.fireChildAdded(ColumnDefs.class, (SPObject)this.columnDefs, overallPosition);
            }
        }

        @NonProperty
        public Rows getRows() {
            return this.rows;
        }

        @NonProperty
        public void setRows(Rows newval) {
            Rows oldval = this.rows;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(Rows.class);
            if (this.rows != null) {
                this.fireChildRemoved(Rows.class, (SPObject)oldval, overallPosition);
            }
            this.rows = newval;
            if (this.rows != null) {
                this.rows.setParent((SPObject)this);
                this.fireChildAdded(Rows.class, (SPObject)this.rows, overallPosition);
            }
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            if (this.columnDefs != null) {
                children.add(this.columnDefs);
            }
            if (this.rows != null) {
                children.add(this.rows);
            }
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (ColumnDefs.class.isAssignableFrom(childClass)) {
                return offset;
            }
            ++offset;
            if (Rows.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof ColumnDefs) {
                this.setColumnDefs((ColumnDefs)child);
            } else if (child instanceof Rows) {
                this.setRows((Rows)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof ColumnDefs) {
                this.setColumnDefs(null);
                return true;
            }
            if (child instanceof Rows) {
                this.setRows(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(ColumnDefs.class, Rows.class));
            childTypes.addAll(Relation.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Table
    extends Relation {
        private String name;
        private String schema;
        private String alias;
        private SQL filter;
        private final List<AggExclude> aggExcludes = new ArrayList<AggExclude>();
        private final List<AggTable> aggTables = new ArrayList<AggTable>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Table() {
            this.setName("New Table");
        }

        @Constructor
        public Table(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="schema") String schema, @ConstructorParameter(propertyName="alias") String alias) {
            this();
            this.setName(name);
            this.setSchema(schema);
            this.setAlias(alias);
        }

        public Table(Table original) {
            super(original);
            this.name = original.getName();
            this.schema = original.getSchema();
            this.alias = original.getAlias();
            this.filter = original.getFilter();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Table:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" schema = ");
            retStr.append(this.schema);
            retStr.append(",");
            retStr.append(" alias = ");
            retStr.append(this.alias);
            retStr.append(",");
            retStr.append(" filter = ");
            retStr.append((Object)this.filter);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getSchema() {
            return this.schema;
        }

        @Mutator
        public void setSchema(String newval) {
            String oldval = this.schema;
            this.schema = newval;
            this.firePropertyChange("schema", oldval, newval);
        }

        @Accessor
        public String getAlias() {
            return this.alias;
        }

        @Mutator
        public void setAlias(String newval) {
            String oldval = this.alias;
            this.alias = newval;
            this.firePropertyChange("alias", oldval, newval);
        }

        @NonProperty
        public SQL getFilter() {
            return this.filter;
        }

        @NonProperty
        public void setFilter(SQL newval) {
            SQL oldval = this.filter;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(SQL.class);
            if (this.filter != null) {
                this.fireChildRemoved(SQL.class, (SPObject)oldval, overallPosition);
            }
            this.filter = newval;
            if (this.filter != null) {
                this.filter.setParent((SPObject)this);
                this.fireChildAdded(SQL.class, (SPObject)this.filter, overallPosition);
            }
        }

        public void addAggExclude(int pos, AggExclude newChild) {
            this.aggExcludes.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(AggExclude.class) + pos;
            this.fireChildAdded(AggExclude.class, (SPObject)newChild, overallPosition);
        }

        public void addAggExclude(AggExclude newChild) {
            this.addAggExclude(this.aggExcludes.size(), newChild);
        }

        public boolean removeAggExclude(AggExclude removeChild) {
            int pos = this.aggExcludes.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeAggExclude(pos);
                return true;
            }
            return false;
        }

        public AggExclude removeAggExclude(int pos) {
            AggExclude removedItem = this.aggExcludes.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(AggExclude.class) + pos;
                this.fireChildRemoved(AggExclude.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<AggExclude> getAggExcludes() {
            return Collections.unmodifiableList(this.aggExcludes);
        }

        public void addAggTable(int pos, AggTable newChild) {
            this.aggTables.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(AggTable.class) + pos;
            this.fireChildAdded(AggTable.class, (SPObject)newChild, overallPosition);
        }

        public void addAggTable(AggTable newChild) {
            this.addAggTable(this.aggTables.size(), newChild);
        }

        public boolean removeAggTable(AggTable removeChild) {
            int pos = this.aggTables.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeAggTable(pos);
                return true;
            }
            return false;
        }

        public AggTable removeAggTable(int pos) {
            AggTable removedItem = this.aggTables.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(AggTable.class) + pos;
                this.fireChildRemoved(AggTable.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<AggTable> getAggTables() {
            return Collections.unmodifiableList(this.aggTables);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.aggExcludes);
            children.addAll(this.aggTables);
            if (this.filter != null) {
                children.add(this.filter);
            }
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (AggExclude.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.aggExcludes.size();
            if (AggTable.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.aggTables.size();
            if (SQL.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof AggExclude) {
                int offset = this.childPositionOffset(AggExclude.class);
                if (index < 0 || index > this.aggExcludes.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.aggExcludes.size());
                }
                this.addAggExclude(index, (AggExclude)child);
            } else if (child instanceof AggTable) {
                int offset = this.childPositionOffset(AggTable.class);
                if (index < 0 || index > this.aggTables.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.aggTables.size());
                }
                this.addAggTable(index, (AggTable)child);
            } else if (child instanceof SQL) {
                this.setFilter((SQL)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof AggExclude) {
                return this.removeAggExclude((AggExclude)child);
            }
            if (child instanceof AggTable) {
                return this.removeAggTable((AggTable)child);
            }
            if (child instanceof SQL) {
                this.setFilter(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(AggExclude.class, AggTable.class, SQL.class));
            childTypes.addAll(Relation.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Join
    extends RelationOrJoin {
        private String leftAlias;
        private String leftKey;
        private String rightAlias;
        private String rightKey;
        private RelationOrJoin left;
        private RelationOrJoin right;
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Join() {
            this.setName("New Join");
        }

        @Constructor
        public Join(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="leftAlias") String leftAlias, @ConstructorParameter(propertyName="leftKey") String leftKey, @ConstructorParameter(propertyName="rightAlias") String rightAlias, @ConstructorParameter(propertyName="rightKey") String rightKey) {
            this();
            this.setName(name);
            this.setLeftAlias(leftAlias);
            this.setLeftKey(leftKey);
            this.setRightAlias(rightAlias);
            this.setRightKey(rightKey);
        }

        public Join(Join original) {
            super(original);
            this.leftAlias = original.getLeftAlias();
            this.leftKey = original.getLeftKey();
            this.rightAlias = original.getRightAlias();
            this.rightKey = original.getRightKey();
            this.left = original.getLeft();
            this.right = original.getRight();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Join:");
            retStr.append(" leftAlias = ");
            retStr.append(this.leftAlias);
            retStr.append(",");
            retStr.append(" leftKey = ");
            retStr.append(this.leftKey);
            retStr.append(",");
            retStr.append(" rightAlias = ");
            retStr.append(this.rightAlias);
            retStr.append(",");
            retStr.append(" rightKey = ");
            retStr.append(this.rightKey);
            retStr.append(",");
            retStr.append(" left = ");
            retStr.append((Object)this.left);
            retStr.append(",");
            retStr.append(" right = ");
            retStr.append((Object)this.right);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getLeftAlias() {
            return this.leftAlias;
        }

        @Mutator
        public void setLeftAlias(String newval) {
            String oldval = this.leftAlias;
            this.leftAlias = newval;
            this.firePropertyChange("leftAlias", oldval, newval);
        }

        @Accessor
        public String getLeftKey() {
            return this.leftKey;
        }

        @Mutator
        public void setLeftKey(String newval) {
            String oldval = this.leftKey;
            this.leftKey = newval;
            this.firePropertyChange("leftKey", oldval, newval);
        }

        @Accessor
        public String getRightAlias() {
            return this.rightAlias;
        }

        @Mutator
        public void setRightAlias(String newval) {
            String oldval = this.rightAlias;
            this.rightAlias = newval;
            this.firePropertyChange("rightAlias", oldval, newval);
        }

        @Accessor
        public String getRightKey() {
            return this.rightKey;
        }

        @Mutator
        public void setRightKey(String newval) {
            String oldval = this.rightKey;
            this.rightKey = newval;
            this.firePropertyChange("rightKey", oldval, newval);
        }

        @NonProperty
        public RelationOrJoin getLeft() {
            return this.left;
        }

        @NonProperty
        public void setLeft(RelationOrJoin newval) {
            RelationOrJoin oldval = this.left;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(RelationOrJoin.class);
            if (this.left != null) {
                this.fireChildRemoved(RelationOrJoin.class, (SPObject)oldval, overallPosition);
            }
            this.left = newval;
            if (this.left != null) {
                this.left.setParent((SPObject)this);
                this.fireChildAdded(RelationOrJoin.class, (SPObject)this.left, overallPosition);
            }
        }

        @NonProperty
        public RelationOrJoin getRight() {
            return this.right;
        }

        @NonProperty
        public void setRight(RelationOrJoin newval) {
            RelationOrJoin oldval = this.right;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(RelationOrJoin.class);
            if (this.right != null) {
                this.fireChildRemoved(RelationOrJoin.class, (SPObject)oldval, overallPosition);
            }
            this.right = newval;
            if (this.right != null) {
                this.right.setParent((SPObject)this);
                this.fireChildAdded(RelationOrJoin.class, (SPObject)this.right, overallPosition);
            }
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<RelationOrJoin> children = new ArrayList<RelationOrJoin>();
            if (this.left != null) {
                children.add(this.left);
            }
            if (this.right != null) {
                children.add(this.right);
            }
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (RelationOrJoin.class.isAssignableFrom(childClass)) {
                return offset;
            }
            ++offset;
            if (RelationOrJoin.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof RelationOrJoin) {
                if (this.getLeft() == null) {
                    this.setLeft((RelationOrJoin)child);
                } else if (this.getRight() == null) {
                    this.setRight((RelationOrJoin)child);
                }
            } else {
                super.addChild(child);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof RelationOrJoin) {
                if (this.getLeft() == child) {
                    this.setLeft(null);
                    return true;
                }
                if (this.getRight() == child) {
                    this.setRight(null);
                    return true;
                }
                return false;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(RelationOrJoin.class, RelationOrJoin.class));
            childTypes.addAll(RelationOrJoin.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class SQL
    extends OLAPObject {
        private String dialect;
        private String text;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public SQL() {
            this.setName("New SQL");
        }

        @Constructor
        public SQL(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="dialect") String dialect) {
            this();
            this.setName(name);
            this.setDialect(dialect);
        }

        public SQL(SQL original) {
            super(original);
            this.dialect = original.getDialect();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("SQL:");
            retStr.append(" dialect = ");
            retStr.append(this.dialect);
            retStr.append(",");
            retStr.append("text = ");
            retStr.append(this.text);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getDialect() {
            return this.dialect;
        }

        @Mutator
        public void setDialect(String newval) {
            String oldval = this.dialect;
            this.dialect = newval;
            this.firePropertyChange("dialect", oldval, newval);
        }

        @Accessor
        public String getText() {
            return this.text;
        }

        @Mutator
        public void setText(String newval) {
            String oldval = this.text;
            this.text = newval;
            this.firePropertyChange("text", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class View
    extends Relation {
        private String alias;
        private final List<SQL> selects = new ArrayList<SQL>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public View() {
            this.setName("New View");
        }

        @Constructor
        public View(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="alias") String alias) {
            this();
            this.setName(name);
            this.setAlias(alias);
        }

        public View(View original) {
            super(original);
            this.alias = original.getAlias();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("View:");
            retStr.append(" alias = ");
            retStr.append(this.alias);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getAlias() {
            return this.alias;
        }

        @Mutator
        public void setAlias(String newval) {
            String oldval = this.alias;
            this.alias = newval;
            this.firePropertyChange("alias", oldval, newval);
        }

        public void addSelect(int pos, SQL newChild) {
            this.selects.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(SQL.class) + pos;
            this.fireChildAdded(SQL.class, (SPObject)newChild, overallPosition);
        }

        public void addSelect(SQL newChild) {
            this.addSelect(this.selects.size(), newChild);
        }

        public boolean removeSelect(SQL removeChild) {
            int pos = this.selects.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeSelect(pos);
                return true;
            }
            return false;
        }

        public SQL removeSelect(int pos) {
            SQL removedItem = this.selects.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(SQL.class) + pos;
                this.fireChildRemoved(SQL.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<SQL> getSelects() {
            return Collections.unmodifiableList(this.selects);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<SQL> children = new ArrayList<SQL>();
            children.addAll(this.selects);
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (SQL.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.selects.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof SQL) {
                int offset = this.childPositionOffset(SQL.class);
                if (index < 0 || index > this.selects.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.selects.size());
                }
                this.addSelect(index, (SQL)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof SQL) {
                return this.removeSelect((SQL)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(SQL.class));
            childTypes.addAll(Relation.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static abstract class Relation
    extends RelationOrJoin {
        public static final List<Class<? extends SPObject>> allowedChildTypes = RelationOrJoin.allowedChildTypes;

        public Relation() {
            this.setName("New Relation");
        }

        @Constructor
        public Relation(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public Relation(Relation original) {
            super(original);
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Relation:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static abstract class RelationOrJoin
    extends OLAPObject {
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public RelationOrJoin() {
            this.setName("New RelationOrJoin");
        }

        @Constructor
        public RelationOrJoin(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public RelationOrJoin(RelationOrJoin original) {
            super(original);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("RelationOrJoin:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class MemberReaderParameter
    extends OLAPObject {
        private String name;
        private String value;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public MemberReaderParameter() {
            this.setName("New MemberReaderParameter");
        }

        @Constructor
        public MemberReaderParameter(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="value") String value) {
            this();
            this.setName(name);
            this.setValue(value);
        }

        public MemberReaderParameter(MemberReaderParameter original) {
            super(original);
            this.name = original.getName();
            this.value = original.getValue();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("MemberReaderParameter:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" value = ");
            retStr.append(this.value);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getValue() {
            return this.value;
        }

        @Mutator
        public void setValue(String newval) {
            String oldval = this.value;
            this.value = newval;
            this.firePropertyChange("value", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class Formula
    extends OLAPObject {
        private String text;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public Formula() {
            this.setName("New Formula");
        }

        @Constructor
        public Formula(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public Formula(Formula original) {
            super(original);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Formula:");
            retStr.append("text = ");
            retStr.append(this.text);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getText() {
            return this.text;
        }

        @Mutator
        public void setText(String newval) {
            String oldval = this.text;
            this.text = newval;
            this.firePropertyChange("text", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class NamedSet
    extends OLAPObject {
        private String name;
        private String formula;
        private Formula formulaElement;
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public NamedSet() {
            this.setName("New NamedSet");
        }

        @Constructor
        public NamedSet(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="formula") String formula) {
            this();
            this.setName(name);
            this.setFormula(formula);
        }

        public NamedSet(NamedSet original) {
            super(original);
            this.name = original.getName();
            this.formula = original.getFormula();
            this.formulaElement = original.getFormulaElement();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("NamedSet:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" formula = ");
            retStr.append(this.formula);
            retStr.append(",");
            retStr.append(" formulaElement = ");
            retStr.append((Object)this.formulaElement);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getFormula() {
            return this.formula;
        }

        @Mutator
        public void setFormula(String newval) {
            String oldval = this.formula;
            this.formula = newval;
            this.firePropertyChange("formula", oldval, newval);
        }

        @NonProperty
        public Formula getFormulaElement() {
            return this.formulaElement;
        }

        @NonProperty
        public void setFormulaElement(Formula newval) {
            Formula oldval = this.formulaElement;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(Formula.class);
            if (this.formulaElement != null) {
                this.fireChildRemoved(Formula.class, (SPObject)oldval, overallPosition);
            }
            this.formulaElement = newval;
            if (this.formulaElement != null) {
                this.formulaElement.setParent((SPObject)this);
                this.fireChildAdded(Formula.class, (SPObject)this.formulaElement, overallPosition);
            }
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<Formula> children = new ArrayList<Formula>();
            if (this.formulaElement != null) {
                children.add(this.formulaElement);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (Formula.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof Formula) {
                this.setFormulaElement((Formula)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof Formula) {
                this.setFormulaElement(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(Formula.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class CalculatedMemberProperty
    extends OLAPObject {
        private String name;
        private String caption;
        private String expression;
        private String value;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public CalculatedMemberProperty() {
            this.setName("New CalculatedMemberProperty");
        }

        @Constructor
        public CalculatedMemberProperty(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="caption") String caption, @ConstructorParameter(propertyName="expression") String expression, @ConstructorParameter(propertyName="value") String value) {
            this();
            this.setName(name);
            this.setCaption(caption);
            this.setExpression(expression);
            this.setValue(value);
        }

        public CalculatedMemberProperty(CalculatedMemberProperty original) {
            super(original);
            this.name = original.getName();
            this.caption = original.getCaption();
            this.expression = original.getExpression();
            this.value = original.getValue();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("CalculatedMemberProperty:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr.append(" expression = ");
            retStr.append(this.expression);
            retStr.append(",");
            retStr.append(" value = ");
            retStr.append(this.value);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @Accessor
        public String getExpression() {
            return this.expression;
        }

        @Mutator
        public void setExpression(String newval) {
            String oldval = this.expression;
            this.expression = newval;
            this.firePropertyChange("expression", oldval, newval);
        }

        @Accessor
        public String getValue() {
            return this.value;
        }

        @Mutator
        public void setValue(String newval) {
            String oldval = this.value;
            this.value = newval;
            this.firePropertyChange("value", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class CalculatedMember
    extends OLAPObject {
        private String name;
        private String formatString;
        private String caption;
        private String formula;
        private String dimension;
        private Boolean visible;
        private Formula formulaElement;
        private final List<CalculatedMemberProperty> memberProperties = new ArrayList<CalculatedMemberProperty>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public CalculatedMember() {
            this.setName("New CalculatedMember");
        }

        @Constructor
        public CalculatedMember(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="formatString") String formatString, @ConstructorParameter(propertyName="caption") String caption, @ConstructorParameter(propertyName="formula") String formula, @ConstructorParameter(propertyName="dimension") String dimension, @ConstructorParameter(propertyName="visible") Boolean visible) {
            this();
            this.setName(name);
            this.setFormatString(formatString);
            this.setCaption(caption);
            this.setFormula(formula);
            this.setDimension(dimension);
            this.setVisible(visible);
        }

        public CalculatedMember(CalculatedMember original) {
            super(original);
            this.name = original.getName();
            this.formatString = original.getFormatString();
            this.caption = original.getCaption();
            this.formula = original.getFormula();
            this.dimension = original.getDimension();
            this.visible = original.getVisible();
            this.formulaElement = original.getFormulaElement();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("CalculatedMember:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" formatString = ");
            retStr.append(this.formatString);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr.append(" formula = ");
            retStr.append(this.formula);
            retStr.append(",");
            retStr.append(" dimension = ");
            retStr.append(this.dimension);
            retStr.append(",");
            retStr.append(" visible = ");
            retStr.append(this.visible);
            retStr.append(",");
            retStr.append(" formulaElement = ");
            retStr.append((Object)this.formulaElement);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getFormatString() {
            return this.formatString;
        }

        @Mutator
        public void setFormatString(String newval) {
            String oldval = this.formatString;
            this.formatString = newval;
            this.firePropertyChange("formatString", oldval, newval);
        }

        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @Accessor
        public String getFormula() {
            return this.formula;
        }

        @Mutator
        public void setFormula(String newval) {
            String oldval = this.formula;
            this.formula = newval;
            this.firePropertyChange("formula", oldval, newval);
        }

        @Accessor
        public String getDimension() {
            return this.dimension;
        }

        @Mutator
        public void setDimension(String newval) {
            String oldval = this.dimension;
            this.dimension = newval;
            this.firePropertyChange("dimension", oldval, newval);
        }

        @Accessor
        public Boolean getVisible() {
            return this.visible;
        }

        @Mutator
        public void setVisible(Boolean newval) {
            Boolean oldval = this.visible;
            this.visible = newval;
            this.firePropertyChange("visible", oldval, newval);
        }

        @NonProperty
        public Formula getFormulaElement() {
            return this.formulaElement;
        }

        @NonProperty
        public void setFormulaElement(Formula newval) {
            Formula oldval = this.formulaElement;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(Formula.class);
            if (this.formulaElement != null) {
                this.fireChildRemoved(Formula.class, (SPObject)oldval, overallPosition);
            }
            this.formulaElement = newval;
            if (this.formulaElement != null) {
                this.formulaElement.setParent((SPObject)this);
                this.fireChildAdded(Formula.class, (SPObject)this.formulaElement, overallPosition);
            }
        }

        public void addMemberPropertie(int pos, CalculatedMemberProperty newChild) {
            this.memberProperties.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(CalculatedMemberProperty.class) + pos;
            this.fireChildAdded(CalculatedMemberProperty.class, (SPObject)newChild, overallPosition);
        }

        public void addMemberPropertie(CalculatedMemberProperty newChild) {
            this.addMemberPropertie(this.memberProperties.size(), newChild);
        }

        public boolean removeMemberPropertie(CalculatedMemberProperty removeChild) {
            int pos = this.memberProperties.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeMemberPropertie(pos);
                return true;
            }
            return false;
        }

        public CalculatedMemberProperty removeMemberPropertie(int pos) {
            CalculatedMemberProperty removedItem = this.memberProperties.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(CalculatedMemberProperty.class) + pos;
                this.fireChildRemoved(CalculatedMemberProperty.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<CalculatedMemberProperty> getMemberProperties() {
            return Collections.unmodifiableList(this.memberProperties);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.memberProperties);
            if (this.formulaElement != null) {
                children.add(this.formulaElement);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (CalculatedMemberProperty.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.memberProperties.size();
            if (Formula.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof CalculatedMemberProperty) {
                int offset = this.childPositionOffset(CalculatedMemberProperty.class);
                if (index < 0 || index > this.memberProperties.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.memberProperties.size());
                }
                this.addMemberPropertie(index, (CalculatedMemberProperty)child);
            } else if (child instanceof Formula) {
                this.setFormulaElement((Formula)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof CalculatedMemberProperty) {
                return this.removeMemberPropertie((CalculatedMemberProperty)child);
            }
            if (child instanceof Formula) {
                this.setFormulaElement(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(CalculatedMemberProperty.class, Formula.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Measure
    extends OLAPObject {
        private String name;
        private String column;
        private String datatype;
        private String formatString;
        private String aggregator;
        private String formatter;
        private String caption;
        private Boolean visible;
        private MeasureExpression measureExp;
        private final List<CalculatedMemberProperty> memberProperties = new ArrayList<CalculatedMemberProperty>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Measure() {
            this.setName("New Measure");
        }

        @Constructor
        public Measure(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="column") String column, @ConstructorParameter(propertyName="datatype") String datatype, @ConstructorParameter(propertyName="formatString") String formatString, @ConstructorParameter(propertyName="aggregator") String aggregator, @ConstructorParameter(propertyName="formatter") String formatter, @ConstructorParameter(propertyName="caption") String caption, @ConstructorParameter(propertyName="visible") Boolean visible) {
            this();
            this.setName(name);
            this.setColumn(column);
            this.setDatatype(datatype);
            this.setFormatString(formatString);
            this.setAggregator(aggregator);
            this.setFormatter(formatter);
            this.setCaption(caption);
            this.setVisible(visible);
        }

        public Measure(Measure original) {
            super(original);
            this.name = original.getName();
            this.column = original.getColumn();
            this.datatype = original.getDatatype();
            this.formatString = original.getFormatString();
            this.aggregator = original.getAggregator();
            this.formatter = original.getFormatter();
            this.caption = original.getCaption();
            this.visible = original.getVisible();
            this.measureExp = original.getMeasureExp();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Measure:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" column = ");
            retStr.append(this.column);
            retStr.append(",");
            retStr.append(" datatype = ");
            retStr.append(this.datatype);
            retStr.append(",");
            retStr.append(" formatString = ");
            retStr.append(this.formatString);
            retStr.append(",");
            retStr.append(" aggregator = ");
            retStr.append(this.aggregator);
            retStr.append(",");
            retStr.append(" formatter = ");
            retStr.append(this.formatter);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr.append(" visible = ");
            retStr.append(this.visible);
            retStr.append(",");
            retStr.append(" measureExp = ");
            retStr.append((Object)this.measureExp);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getColumn() {
            return this.column;
        }

        @Mutator
        public void setColumn(String newval) {
            String oldval = this.column;
            this.column = newval;
            this.firePropertyChange("column", oldval, newval);
        }

        @Accessor
        public String getDatatype() {
            return this.datatype;
        }

        @Mutator
        public void setDatatype(String newval) {
            String oldval = this.datatype;
            this.datatype = newval;
            this.firePropertyChange("datatype", oldval, newval);
        }

        @Accessor
        public String getFormatString() {
            return this.formatString;
        }

        @Mutator
        public void setFormatString(String newval) {
            String oldval = this.formatString;
            this.formatString = newval;
            this.firePropertyChange("formatString", oldval, newval);
        }

        @Accessor
        public String getAggregator() {
            return this.aggregator;
        }

        @Mutator
        public void setAggregator(String newval) {
            String oldval = this.aggregator;
            this.aggregator = newval;
            this.firePropertyChange("aggregator", oldval, newval);
        }

        @Accessor
        public String getFormatter() {
            return this.formatter;
        }

        @Mutator
        public void setFormatter(String newval) {
            String oldval = this.formatter;
            this.formatter = newval;
            this.firePropertyChange("formatter", oldval, newval);
        }

        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @Accessor
        public Boolean getVisible() {
            return this.visible;
        }

        @Mutator
        public void setVisible(Boolean newval) {
            Boolean oldval = this.visible;
            this.visible = newval;
            this.firePropertyChange("visible", oldval, newval);
        }

        @NonProperty
        public MeasureExpression getMeasureExp() {
            return this.measureExp;
        }

        @NonProperty
        public void setMeasureExp(MeasureExpression newval) {
            MeasureExpression oldval = this.measureExp;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(MeasureExpression.class);
            if (this.measureExp != null) {
                this.fireChildRemoved(MeasureExpression.class, (SPObject)oldval, overallPosition);
            }
            this.measureExp = newval;
            if (this.measureExp != null) {
                this.measureExp.setParent((SPObject)this);
                this.fireChildAdded(MeasureExpression.class, (SPObject)this.measureExp, overallPosition);
            }
        }

        public void addMemberPropertie(int pos, CalculatedMemberProperty newChild) {
            this.memberProperties.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(CalculatedMemberProperty.class) + pos;
            this.fireChildAdded(CalculatedMemberProperty.class, (SPObject)newChild, overallPosition);
        }

        public void addMemberPropertie(CalculatedMemberProperty newChild) {
            this.addMemberPropertie(this.memberProperties.size(), newChild);
        }

        public boolean removeMemberPropertie(CalculatedMemberProperty removeChild) {
            int pos = this.memberProperties.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeMemberPropertie(pos);
                return true;
            }
            return false;
        }

        public CalculatedMemberProperty removeMemberPropertie(int pos) {
            CalculatedMemberProperty removedItem = this.memberProperties.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(CalculatedMemberProperty.class) + pos;
                this.fireChildRemoved(CalculatedMemberProperty.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<CalculatedMemberProperty> getMemberProperties() {
            return Collections.unmodifiableList(this.memberProperties);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.memberProperties);
            if (this.measureExp != null) {
                children.add(this.measureExp);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (CalculatedMemberProperty.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.memberProperties.size();
            if (MeasureExpression.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof CalculatedMemberProperty) {
                int offset = this.childPositionOffset(CalculatedMemberProperty.class);
                if (index < 0 || index > this.memberProperties.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.memberProperties.size());
                }
                this.addMemberPropertie(index, (CalculatedMemberProperty)child);
            } else if (child instanceof MeasureExpression) {
                this.setMeasureExp((MeasureExpression)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof CalculatedMemberProperty) {
                return this.removeMemberPropertie((CalculatedMemberProperty)child);
            }
            if (child instanceof MeasureExpression) {
                this.setMeasureExp(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(CalculatedMemberProperty.class, MeasureExpression.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Property
    extends OLAPObject {
        private String name;
        private String column;
        private String type;
        private String formatter;
        private String caption;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public Property() {
            this.setName("New Property");
        }

        @Constructor
        public Property(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="column") String column, @ConstructorParameter(propertyName="type") String type, @ConstructorParameter(propertyName="formatter") String formatter, @ConstructorParameter(propertyName="caption") String caption) {
            this();
            this.setName(name);
            this.setColumn(column);
            this.setType(type);
            this.setFormatter(formatter);
            this.setCaption(caption);
        }

        public Property(Property original) {
            super(original);
            this.name = original.getName();
            this.column = original.getColumn();
            this.type = original.getType();
            this.formatter = original.getFormatter();
            this.caption = original.getCaption();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Property:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" column = ");
            retStr.append(this.column);
            retStr.append(",");
            retStr.append(" type = ");
            retStr.append(this.type);
            retStr.append(",");
            retStr.append(" formatter = ");
            retStr.append(this.formatter);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getColumn() {
            return this.column;
        }

        @Mutator
        public void setColumn(String newval) {
            String oldval = this.column;
            this.column = newval;
            this.firePropertyChange("column", oldval, newval);
        }

        @Accessor
        public String getType() {
            return this.type;
        }

        @Mutator
        public void setType(String newval) {
            String oldval = this.type;
            this.type = newval;
            this.firePropertyChange("type", oldval, newval);
        }

        @Accessor
        public String getFormatter() {
            return this.formatter;
        }

        @Mutator
        public void setFormatter(String newval) {
            String oldval = this.formatter;
            this.formatter = newval;
            this.firePropertyChange("formatter", oldval, newval);
        }

        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class Closure
    extends OLAPObject {
        private String parentColumn;
        private String childColumn;
        private Table table;
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Closure() {
            this.setName("New Closure");
        }

        @Constructor
        public Closure(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="parentColumn") String parentColumn, @ConstructorParameter(propertyName="childColumn") String childColumn) {
            this();
            this.setName(name);
            this.setParentColumn(parentColumn);
            this.setChildColumn(childColumn);
        }

        public Closure(Closure original) {
            super(original);
            this.parentColumn = original.getParentColumn();
            this.childColumn = original.getChildColumn();
            this.table = original.getTable();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Closure:");
            retStr.append(" parentColumn = ");
            retStr.append(this.parentColumn);
            retStr.append(",");
            retStr.append(" childColumn = ");
            retStr.append(this.childColumn);
            retStr.append(",");
            retStr.append(" table = ");
            retStr.append((Object)this.table);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getParentColumn() {
            return this.parentColumn;
        }

        @Mutator
        public void setParentColumn(String newval) {
            String oldval = this.parentColumn;
            this.parentColumn = newval;
            this.firePropertyChange("parentColumn", oldval, newval);
        }

        @Accessor
        public String getChildColumn() {
            return this.childColumn;
        }

        @Mutator
        public void setChildColumn(String newval) {
            String oldval = this.childColumn;
            this.childColumn = newval;
            this.firePropertyChange("childColumn", oldval, newval);
        }

        @NonProperty
        public Table getTable() {
            return this.table;
        }

        @NonProperty
        public void setTable(Table newval) {
            Table oldval = this.table;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(Table.class);
            if (this.table != null) {
                this.fireChildRemoved(Table.class, (SPObject)oldval, overallPosition);
            }
            this.table = newval;
            if (this.table != null) {
                this.table.setParent((SPObject)this);
                this.fireChildAdded(Table.class, (SPObject)this.table, overallPosition);
            }
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<Table> children = new ArrayList<Table>();
            if (this.table != null) {
                children.add(this.table);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (Table.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof Table) {
                this.setTable((Table)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof Table) {
                this.setTable(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(Table.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Level
    extends OLAPObject {
        private String approxRowCount;
        private String name;
        private String table;
        private String column;
        private String nameColumn;
        private String ordinalColumn;
        private String parentColumn;
        private String nullParentValue;
        private String type;
        private Boolean uniqueMembers;
        private String levelType;
        private String hideMemberIf;
        private String formatter;
        private String caption;
        private String captionColumn;
        private KeyExpression keyExp;
        private NameExpression nameExp;
        private OrdinalExpression ordinalExp;
        private ParentExpression parentExp;
        private Closure closure;
        private final List<Property> properties = new ArrayList<Property>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Level() {
            this.setName("New Level");
        }

        @Constructor
        public Level(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="approxRowCount") String approxRowCount, @ConstructorParameter(propertyName="table") String table, @ConstructorParameter(propertyName="column") String column, @ConstructorParameter(propertyName="nameColumn") String nameColumn, @ConstructorParameter(propertyName="ordinalColumn") String ordinalColumn, @ConstructorParameter(propertyName="parentColumn") String parentColumn, @ConstructorParameter(propertyName="nullParentValue") String nullParentValue, @ConstructorParameter(propertyName="type") String type, @ConstructorParameter(propertyName="uniqueMembers") Boolean uniqueMembers, @ConstructorParameter(propertyName="levelType") String levelType, @ConstructorParameter(propertyName="hideMemberIf") String hideMemberIf, @ConstructorParameter(propertyName="formatter") String formatter, @ConstructorParameter(propertyName="caption") String caption, @ConstructorParameter(propertyName="captionColumn") String captionColumn) {
            this();
            this.setName(name);
            this.setApproxRowCount(approxRowCount);
            this.setTable(table);
            this.setColumn(column);
            this.setNameColumn(nameColumn);
            this.setOrdinalColumn(ordinalColumn);
            this.setParentColumn(parentColumn);
            this.setNullParentValue(nullParentValue);
            this.setType(type);
            this.setUniqueMembers(uniqueMembers);
            this.setLevelType(levelType);
            this.setHideMemberIf(hideMemberIf);
            this.setFormatter(formatter);
            this.setCaption(caption);
            this.setCaptionColumn(captionColumn);
        }

        public Level(Level original) {
            super(original);
            this.approxRowCount = original.getApproxRowCount();
            this.name = original.getName();
            this.table = original.getTable();
            this.column = original.getColumn();
            this.nameColumn = original.getNameColumn();
            this.ordinalColumn = original.getOrdinalColumn();
            this.parentColumn = original.getParentColumn();
            this.nullParentValue = original.getNullParentValue();
            this.type = original.getType();
            this.uniqueMembers = original.getUniqueMembers();
            this.levelType = original.getLevelType();
            this.hideMemberIf = original.getHideMemberIf();
            this.formatter = original.getFormatter();
            this.caption = original.getCaption();
            this.captionColumn = original.getCaptionColumn();
            this.keyExp = original.getKeyExp();
            this.nameExp = original.getNameExp();
            this.ordinalExp = original.getOrdinalExp();
            this.parentExp = original.getParentExp();
            this.closure = original.getClosure();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Level:");
            retStr.append(" approxRowCount = ");
            retStr.append(this.approxRowCount);
            retStr.append(",");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" table = ");
            retStr.append(this.table);
            retStr.append(",");
            retStr.append(" column = ");
            retStr.append(this.column);
            retStr.append(",");
            retStr.append(" nameColumn = ");
            retStr.append(this.nameColumn);
            retStr.append(",");
            retStr.append(" ordinalColumn = ");
            retStr.append(this.ordinalColumn);
            retStr.append(",");
            retStr.append(" parentColumn = ");
            retStr.append(this.parentColumn);
            retStr.append(",");
            retStr.append(" nullParentValue = ");
            retStr.append(this.nullParentValue);
            retStr.append(",");
            retStr.append(" type = ");
            retStr.append(this.type);
            retStr.append(",");
            retStr.append(" uniqueMembers = ");
            retStr.append(this.uniqueMembers);
            retStr.append(",");
            retStr.append(" levelType = ");
            retStr.append(this.levelType);
            retStr.append(",");
            retStr.append(" hideMemberIf = ");
            retStr.append(this.hideMemberIf);
            retStr.append(",");
            retStr.append(" formatter = ");
            retStr.append(this.formatter);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr.append(" captionColumn = ");
            retStr.append(this.captionColumn);
            retStr.append(",");
            retStr.append(" keyExp = ");
            retStr.append((Object)this.keyExp);
            retStr.append(",");
            retStr.append(" nameExp = ");
            retStr.append((Object)this.nameExp);
            retStr.append(",");
            retStr.append(" ordinalExp = ");
            retStr.append((Object)this.ordinalExp);
            retStr.append(",");
            retStr.append(" parentExp = ");
            retStr.append((Object)this.parentExp);
            retStr.append(",");
            retStr.append(" closure = ");
            retStr.append((Object)this.closure);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getApproxRowCount() {
            return this.approxRowCount;
        }

        @Mutator
        public void setApproxRowCount(String newval) {
            String oldval = this.approxRowCount;
            this.approxRowCount = newval;
            this.firePropertyChange("approxRowCount", oldval, newval);
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getTable() {
            return this.table;
        }

        @Mutator
        public void setTable(String newval) {
            String oldval = this.table;
            this.table = newval;
            this.firePropertyChange("table", oldval, newval);
        }

        @Accessor
        public String getColumn() {
            return this.column;
        }

        @Mutator
        public void setColumn(String newval) {
            String oldval = this.column;
            this.column = newval;
            this.firePropertyChange("column", oldval, newval);
        }

        @Accessor
        public String getNameColumn() {
            return this.nameColumn;
        }

        @Mutator
        public void setNameColumn(String newval) {
            String oldval = this.nameColumn;
            this.nameColumn = newval;
            this.firePropertyChange("nameColumn", oldval, newval);
        }

        @Accessor
        public String getOrdinalColumn() {
            return this.ordinalColumn;
        }

        @Mutator
        public void setOrdinalColumn(String newval) {
            String oldval = this.ordinalColumn;
            this.ordinalColumn = newval;
            this.firePropertyChange("ordinalColumn", oldval, newval);
        }

        @Accessor
        public String getParentColumn() {
            return this.parentColumn;
        }

        @Mutator
        public void setParentColumn(String newval) {
            String oldval = this.parentColumn;
            this.parentColumn = newval;
            this.firePropertyChange("parentColumn", oldval, newval);
        }

        @Accessor
        public String getNullParentValue() {
            return this.nullParentValue;
        }

        @Mutator
        public void setNullParentValue(String newval) {
            String oldval = this.nullParentValue;
            this.nullParentValue = newval;
            this.firePropertyChange("nullParentValue", oldval, newval);
        }

        @Accessor
        public String getType() {
            return this.type;
        }

        @Mutator
        public void setType(String newval) {
            String oldval = this.type;
            this.type = newval;
            this.firePropertyChange("type", oldval, newval);
        }

        @Accessor
        public Boolean getUniqueMembers() {
            return this.uniqueMembers;
        }

        @Mutator
        public void setUniqueMembers(Boolean newval) {
            Boolean oldval = this.uniqueMembers;
            this.uniqueMembers = newval;
            this.firePropertyChange("uniqueMembers", oldval, newval);
        }

        @Accessor
        public String getLevelType() {
            return this.levelType;
        }

        @Mutator
        public void setLevelType(String newval) {
            String oldval = this.levelType;
            this.levelType = newval;
            this.firePropertyChange("levelType", oldval, newval);
        }

        @Accessor
        public String getHideMemberIf() {
            return this.hideMemberIf;
        }

        @Mutator
        public void setHideMemberIf(String newval) {
            String oldval = this.hideMemberIf;
            this.hideMemberIf = newval;
            this.firePropertyChange("hideMemberIf", oldval, newval);
        }

        @Accessor
        public String getFormatter() {
            return this.formatter;
        }

        @Mutator
        public void setFormatter(String newval) {
            String oldval = this.formatter;
            this.formatter = newval;
            this.firePropertyChange("formatter", oldval, newval);
        }

        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @Accessor
        public String getCaptionColumn() {
            return this.captionColumn;
        }

        @Mutator
        public void setCaptionColumn(String newval) {
            String oldval = this.captionColumn;
            this.captionColumn = newval;
            this.firePropertyChange("captionColumn", oldval, newval);
        }

        @NonProperty
        public KeyExpression getKeyExp() {
            return this.keyExp;
        }

        @NonProperty
        public void setKeyExp(KeyExpression newval) {
            KeyExpression oldval = this.keyExp;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(KeyExpression.class);
            if (this.keyExp != null) {
                this.fireChildRemoved(KeyExpression.class, (SPObject)oldval, overallPosition);
            }
            this.keyExp = newval;
            if (this.keyExp != null) {
                this.keyExp.setParent((SPObject)this);
                this.fireChildAdded(KeyExpression.class, (SPObject)this.keyExp, overallPosition);
            }
        }

        @NonProperty
        public NameExpression getNameExp() {
            return this.nameExp;
        }

        @NonProperty
        public void setNameExp(NameExpression newval) {
            NameExpression oldval = this.nameExp;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(NameExpression.class);
            if (this.nameExp != null) {
                this.fireChildRemoved(NameExpression.class, (SPObject)oldval, overallPosition);
            }
            this.nameExp = newval;
            if (this.nameExp != null) {
                this.nameExp.setParent((SPObject)this);
                this.fireChildAdded(NameExpression.class, (SPObject)this.nameExp, overallPosition);
            }
        }

        @NonProperty
        public OrdinalExpression getOrdinalExp() {
            return this.ordinalExp;
        }

        @NonProperty
        public void setOrdinalExp(OrdinalExpression newval) {
            OrdinalExpression oldval = this.ordinalExp;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(OrdinalExpression.class);
            if (this.ordinalExp != null) {
                this.fireChildRemoved(OrdinalExpression.class, (SPObject)oldval, overallPosition);
            }
            this.ordinalExp = newval;
            if (this.ordinalExp != null) {
                this.ordinalExp.setParent((SPObject)this);
                this.fireChildAdded(OrdinalExpression.class, (SPObject)this.ordinalExp, overallPosition);
            }
        }

        @NonProperty
        public ParentExpression getParentExp() {
            return this.parentExp;
        }

        @NonProperty
        public void setParentExp(ParentExpression newval) {
            ParentExpression oldval = this.parentExp;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(ParentExpression.class);
            if (this.parentExp != null) {
                this.fireChildRemoved(ParentExpression.class, (SPObject)oldval, overallPosition);
            }
            this.parentExp = newval;
            if (this.parentExp != null) {
                this.parentExp.setParent((SPObject)this);
                this.fireChildAdded(ParentExpression.class, (SPObject)this.parentExp, overallPosition);
            }
        }

        @NonProperty
        public Closure getClosure() {
            return this.closure;
        }

        @NonProperty
        public void setClosure(Closure newval) {
            Closure oldval = this.closure;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(Closure.class);
            if (this.closure != null) {
                this.fireChildRemoved(Closure.class, (SPObject)oldval, overallPosition);
            }
            this.closure = newval;
            if (this.closure != null) {
                this.closure.setParent((SPObject)this);
                this.fireChildAdded(Closure.class, (SPObject)this.closure, overallPosition);
            }
        }

        public void addProperty(int pos, Property newChild) {
            this.properties.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Property.class) + pos;
            this.fireChildAdded(Property.class, (SPObject)newChild, overallPosition);
        }

        public void addProperty(Property newChild) {
            this.addProperty(this.properties.size(), newChild);
        }

        public boolean removeProperty(Property removeChild) {
            int pos = this.properties.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeProperty(pos);
                return true;
            }
            return false;
        }

        public Property removeProperty(int pos) {
            Property removedItem = this.properties.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Property.class) + pos;
                this.fireChildRemoved(Property.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Property> getProperties() {
            return Collections.unmodifiableList(this.properties);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.properties);
            if (this.keyExp != null) {
                children.add(this.keyExp);
            }
            if (this.nameExp != null) {
                children.add(this.nameExp);
            }
            if (this.ordinalExp != null) {
                children.add(this.ordinalExp);
            }
            if (this.parentExp != null) {
                children.add(this.parentExp);
            }
            if (this.closure != null) {
                children.add(this.closure);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (Property.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.properties.size();
            if (KeyExpression.class.isAssignableFrom(childClass)) {
                return offset;
            }
            ++offset;
            if (NameExpression.class.isAssignableFrom(childClass)) {
                return offset;
            }
            ++offset;
            if (OrdinalExpression.class.isAssignableFrom(childClass)) {
                return offset;
            }
            ++offset;
            if (ParentExpression.class.isAssignableFrom(childClass)) {
                return offset;
            }
            ++offset;
            if (Closure.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof Property) {
                int offset = this.childPositionOffset(Property.class);
                if (index < 0 || index > this.properties.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.properties.size());
                }
                this.addProperty(index, (Property)child);
            } else if (child instanceof KeyExpression) {
                this.setKeyExp((KeyExpression)child);
            } else if (child instanceof NameExpression) {
                this.setNameExp((NameExpression)child);
            } else if (child instanceof OrdinalExpression) {
                this.setOrdinalExp((OrdinalExpression)child);
            } else if (child instanceof ParentExpression) {
                this.setParentExp((ParentExpression)child);
            } else if (child instanceof Closure) {
                this.setClosure((Closure)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof Property) {
                return this.removeProperty((Property)child);
            }
            if (child instanceof KeyExpression) {
                this.setKeyExp(null);
                return true;
            }
            if (child instanceof NameExpression) {
                this.setNameExp(null);
                return true;
            }
            if (child instanceof OrdinalExpression) {
                this.setOrdinalExp(null);
                return true;
            }
            if (child instanceof ParentExpression) {
                this.setParentExp(null);
                return true;
            }
            if (child instanceof Closure) {
                this.setClosure(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(Property.class, KeyExpression.class, NameExpression.class, OrdinalExpression.class, ParentExpression.class, Closure.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Hierarchy
    extends OLAPObject {
        private String name;
        private Boolean hasAll;
        private String allMemberName;
        private String allMemberCaption;
        private String allLevelName;
        private String primaryKey;
        private String primaryKeyTable;
        private String defaultMember;
        private String memberReaderClass;
        private String caption;
        private RelationOrJoin relation;
        private final List<Level> levels = new ArrayList<Level>();
        private final List<MemberReaderParameter> memberReaderParameters = new ArrayList<MemberReaderParameter>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Hierarchy() {
            this.setName("New Hierarchy");
        }

        @Constructor
        public Hierarchy(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="hasAll") Boolean hasAll, @ConstructorParameter(propertyName="allMemberName") String allMemberName, @ConstructorParameter(propertyName="allMemberCaption") String allMemberCaption, @ConstructorParameter(propertyName="allLevelName") String allLevelName, @ConstructorParameter(propertyName="primaryKey") String primaryKey, @ConstructorParameter(propertyName="primaryKeyTable") String primaryKeyTable, @ConstructorParameter(propertyName="defaultMember") String defaultMember, @ConstructorParameter(propertyName="memberReaderClass") String memberReaderClass, @ConstructorParameter(propertyName="caption") String caption) {
            this();
            this.setName(name);
            this.setHasAll(hasAll);
            this.setAllMemberName(allMemberName);
            this.setAllMemberCaption(allMemberCaption);
            this.setAllLevelName(allLevelName);
            this.setPrimaryKey(primaryKey);
            this.setPrimaryKeyTable(primaryKeyTable);
            this.setDefaultMember(defaultMember);
            this.setMemberReaderClass(memberReaderClass);
            this.setCaption(caption);
        }

        public Hierarchy(Hierarchy original) {
            super(original);
            this.name = original.getName();
            this.hasAll = original.getHasAll();
            this.allMemberName = original.getAllMemberName();
            this.allMemberCaption = original.getAllMemberCaption();
            this.allLevelName = original.getAllLevelName();
            this.primaryKey = original.getPrimaryKey();
            this.primaryKeyTable = original.getPrimaryKeyTable();
            this.defaultMember = original.getDefaultMember();
            this.memberReaderClass = original.getMemberReaderClass();
            this.caption = original.getCaption();
            this.relation = original.getRelation();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Hierarchy:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" hasAll = ");
            retStr.append(this.hasAll);
            retStr.append(",");
            retStr.append(" allMemberName = ");
            retStr.append(this.allMemberName);
            retStr.append(",");
            retStr.append(" allMemberCaption = ");
            retStr.append(this.allMemberCaption);
            retStr.append(",");
            retStr.append(" allLevelName = ");
            retStr.append(this.allLevelName);
            retStr.append(",");
            retStr.append(" primaryKey = ");
            retStr.append(this.primaryKey);
            retStr.append(",");
            retStr.append(" primaryKeyTable = ");
            retStr.append(this.primaryKeyTable);
            retStr.append(",");
            retStr.append(" defaultMember = ");
            retStr.append(this.defaultMember);
            retStr.append(",");
            retStr.append(" memberReaderClass = ");
            retStr.append(this.memberReaderClass);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr.append(" relation = ");
            retStr.append((Object)this.relation);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public Boolean getHasAll() {
            return this.hasAll;
        }

        @Mutator
        public void setHasAll(Boolean newval) {
            Boolean oldval = this.hasAll;
            this.hasAll = newval;
            this.firePropertyChange("hasAll", oldval, newval);
        }

        @Accessor
        public String getAllMemberName() {
            return this.allMemberName;
        }

        @Mutator
        public void setAllMemberName(String newval) {
            String oldval = this.allMemberName;
            this.allMemberName = newval;
            this.firePropertyChange("allMemberName", oldval, newval);
        }

        @Accessor
        public String getAllMemberCaption() {
            return this.allMemberCaption;
        }

        @Mutator
        public void setAllMemberCaption(String newval) {
            String oldval = this.allMemberCaption;
            this.allMemberCaption = newval;
            this.firePropertyChange("allMemberCaption", oldval, newval);
        }

        @Accessor
        public String getAllLevelName() {
            return this.allLevelName;
        }

        @Mutator
        public void setAllLevelName(String newval) {
            String oldval = this.allLevelName;
            this.allLevelName = newval;
            this.firePropertyChange("allLevelName", oldval, newval);
        }

        @Accessor
        public String getPrimaryKey() {
            return this.primaryKey;
        }

        @Mutator
        public void setPrimaryKey(String newval) {
            String oldval = this.primaryKey;
            this.primaryKey = newval;
            this.firePropertyChange("primaryKey", oldval, newval);
        }

        @Accessor
        public String getPrimaryKeyTable() {
            return this.primaryKeyTable;
        }

        @Mutator
        public void setPrimaryKeyTable(String newval) {
            String oldval = this.primaryKeyTable;
            this.primaryKeyTable = newval;
            this.firePropertyChange("primaryKeyTable", oldval, newval);
        }

        @Accessor
        public String getDefaultMember() {
            return this.defaultMember;
        }

        @Mutator
        public void setDefaultMember(String newval) {
            String oldval = this.defaultMember;
            this.defaultMember = newval;
            this.firePropertyChange("defaultMember", oldval, newval);
        }

        @Accessor
        public String getMemberReaderClass() {
            return this.memberReaderClass;
        }

        @Mutator
        public void setMemberReaderClass(String newval) {
            String oldval = this.memberReaderClass;
            this.memberReaderClass = newval;
            this.firePropertyChange("memberReaderClass", oldval, newval);
        }

        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @NonProperty
        public RelationOrJoin getRelation() {
            return this.relation;
        }

        @NonProperty
        public void setRelation(RelationOrJoin newval) {
            RelationOrJoin oldval = this.relation;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(RelationOrJoin.class);
            if (this.relation != null) {
                this.fireChildRemoved(RelationOrJoin.class, (SPObject)oldval, overallPosition);
            }
            this.relation = newval;
            if (this.relation != null) {
                this.relation.setParent((SPObject)this);
                this.fireChildAdded(RelationOrJoin.class, (SPObject)this.relation, overallPosition);
            }
        }

        public void addLevel(int pos, Level newChild) {
            this.levels.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Level.class) + pos;
            this.fireChildAdded(Level.class, (SPObject)newChild, overallPosition);
        }

        public void addLevel(Level newChild) {
            this.addLevel(this.levels.size(), newChild);
        }

        public boolean removeLevel(Level removeChild) {
            int pos = this.levels.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeLevel(pos);
                return true;
            }
            return false;
        }

        public Level removeLevel(int pos) {
            Level removedItem = this.levels.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Level.class) + pos;
                this.fireChildRemoved(Level.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Level> getLevels() {
            return Collections.unmodifiableList(this.levels);
        }

        public void addMemberReaderParameter(int pos, MemberReaderParameter newChild) {
            this.memberReaderParameters.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(MemberReaderParameter.class) + pos;
            this.fireChildAdded(MemberReaderParameter.class, (SPObject)newChild, overallPosition);
        }

        public void addMemberReaderParameter(MemberReaderParameter newChild) {
            this.addMemberReaderParameter(this.memberReaderParameters.size(), newChild);
        }

        public boolean removeMemberReaderParameter(MemberReaderParameter removeChild) {
            int pos = this.memberReaderParameters.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeMemberReaderParameter(pos);
                return true;
            }
            return false;
        }

        public MemberReaderParameter removeMemberReaderParameter(int pos) {
            MemberReaderParameter removedItem = this.memberReaderParameters.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(MemberReaderParameter.class) + pos;
                this.fireChildRemoved(MemberReaderParameter.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<MemberReaderParameter> getMemberReaderParameters() {
            return Collections.unmodifiableList(this.memberReaderParameters);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.levels);
            children.addAll(this.memberReaderParameters);
            if (this.relation != null) {
                children.add(this.relation);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (Level.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.levels.size();
            if (MemberReaderParameter.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.memberReaderParameters.size();
            if (RelationOrJoin.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof Level) {
                int offset = this.childPositionOffset(Level.class);
                if (index < 0 || index > this.levels.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.levels.size());
                }
                this.addLevel(index, (Level)child);
            } else if (child instanceof MemberReaderParameter) {
                int offset = this.childPositionOffset(MemberReaderParameter.class);
                if (index < 0 || index > this.memberReaderParameters.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.memberReaderParameters.size());
                }
                this.addMemberReaderParameter(index, (MemberReaderParameter)child);
            } else if (child instanceof RelationOrJoin) {
                this.setRelation((RelationOrJoin)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof Level) {
                return this.removeLevel((Level)child);
            }
            if (child instanceof MemberReaderParameter) {
                return this.removeMemberReaderParameter((MemberReaderParameter)child);
            }
            if (child instanceof RelationOrJoin) {
                this.setRelation(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(Level.class, MemberReaderParameter.class, RelationOrJoin.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Dimension
    extends CubeDimension {
        private String name;
        private String type;
        private String caption;
        private String usagePrefix;
        private final List<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Dimension() {
            this.setName("New Dimension");
        }

        @Constructor
        public Dimension(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="type") String type, @ConstructorParameter(propertyName="caption") String caption, @ConstructorParameter(propertyName="usagePrefix") String usagePrefix, @ConstructorParameter(propertyName="foreignKey") String foreignKey) {
            this();
            this.setName(name);
            this.setType(type);
            this.setCaption(caption);
            this.setUsagePrefix(usagePrefix);
            this.setCaption(caption);
            this.setForeignKey(foreignKey);
        }

        public Dimension(Dimension original) {
            super(original);
            this.name = original.getName();
            this.type = original.getType();
            this.caption = original.getCaption();
            this.usagePrefix = original.getUsagePrefix();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Dimension:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" type = ");
            retStr.append(this.type);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr.append(" usagePrefix = ");
            retStr.append(this.usagePrefix);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Override
        @Accessor
        public String getName() {
            return this.name;
        }

        @Override
        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getType() {
            return this.type;
        }

        @Mutator
        public void setType(String newval) {
            String oldval = this.type;
            this.type = newval;
            this.firePropertyChange("type", oldval, newval);
        }

        @Override
        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Override
        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @Accessor
        public String getUsagePrefix() {
            return this.usagePrefix;
        }

        @Mutator
        public void setUsagePrefix(String newval) {
            String oldval = this.usagePrefix;
            this.usagePrefix = newval;
            this.firePropertyChange("usagePrefix", oldval, newval);
        }

        public void addHierarchy(int pos, Hierarchy newChild) {
            this.hierarchies.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Hierarchy.class) + pos;
            this.fireChildAdded(Hierarchy.class, (SPObject)newChild, overallPosition);
        }

        public void addHierarchy(Hierarchy newChild) {
            this.addHierarchy(this.hierarchies.size(), newChild);
        }

        public boolean removeHierarchy(Hierarchy removeChild) {
            int pos = this.hierarchies.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeHierarchy(pos);
                return true;
            }
            return false;
        }

        public Hierarchy removeHierarchy(int pos) {
            Hierarchy removedItem = this.hierarchies.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Hierarchy.class) + pos;
                this.fireChildRemoved(Hierarchy.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Hierarchy> getHierarchies() {
            return Collections.unmodifiableList(this.hierarchies);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<Hierarchy> children = new ArrayList<Hierarchy>();
            children.addAll(this.hierarchies);
            return Collections.unmodifiableList(children);
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (Hierarchy.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.hierarchies.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof Hierarchy) {
                int offset = this.childPositionOffset(Hierarchy.class);
                if (index < 0 || index > this.hierarchies.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.hierarchies.size());
                }
                this.addHierarchy(index, (Hierarchy)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof Hierarchy) {
                return this.removeHierarchy((Hierarchy)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(Hierarchy.class));
            childTypes.addAll(CubeDimension.allowedChildTypes);
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class DimensionUsage
    extends CubeDimension {
        private String source;
        private String level;
        private String usagePrefix;
        public static final List<Class<? extends SPObject>> allowedChildTypes = CubeDimension.allowedChildTypes;

        public DimensionUsage() {
            this.setName("New DimensionUsage");
        }

        @Constructor
        public DimensionUsage(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="source") String source, @ConstructorParameter(propertyName="level") String level, @ConstructorParameter(propertyName="usagePrefix") String usagePrefix, @ConstructorParameter(propertyName="caption") String caption, @ConstructorParameter(propertyName="foreignKey") String foreignKey) {
            this();
            this.setName(name);
            this.setSource(source);
            this.setLevel(level);
            this.setUsagePrefix(usagePrefix);
            this.setCaption(caption);
            this.setForeignKey(foreignKey);
        }

        public DimensionUsage(DimensionUsage original) {
            super(original);
            this.source = original.getSource();
            this.level = original.getLevel();
            this.usagePrefix = original.getUsagePrefix();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("DimensionUsage:");
            retStr.append(" source = ");
            retStr.append(this.source);
            retStr.append(",");
            retStr.append(" level = ");
            retStr.append(this.level);
            retStr.append(",");
            retStr.append(" usagePrefix = ");
            retStr.append(this.usagePrefix);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getSource() {
            return this.source;
        }

        @Mutator
        public void setSource(String newval) {
            String oldval = this.source;
            this.source = newval;
            this.firePropertyChange("source", oldval, newval);
        }

        @Accessor
        public String getLevel() {
            return this.level;
        }

        @Mutator
        public void setLevel(String newval) {
            String oldval = this.level;
            this.level = newval;
            this.firePropertyChange("level", oldval, newval);
        }

        @Accessor
        public String getUsagePrefix() {
            return this.usagePrefix;
        }

        @Mutator
        public void setUsagePrefix(String newval) {
            String oldval = this.usagePrefix;
            this.usagePrefix = newval;
            this.firePropertyChange("usagePrefix", oldval, newval);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class VirtualCubeMeasure
    extends OLAPObject {
        private String cubeName;
        private String name;
        private Boolean visible;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public VirtualCubeMeasure() {
            this.setName("New VirtualCubeMeasure");
        }

        @Constructor
        public VirtualCubeMeasure(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="cubeName") String cubeName, @ConstructorParameter(propertyName="visible") Boolean visible) {
            this();
            this.setName(name);
            this.setCubeName(cubeName);
            this.setVisible(visible);
        }

        public VirtualCubeMeasure(VirtualCubeMeasure original) {
            super(original);
            this.cubeName = original.getCubeName();
            this.name = original.getName();
            this.visible = original.getVisible();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("VirtualCubeMeasure:");
            retStr.append(" cubeName = ");
            retStr.append(this.cubeName);
            retStr.append(",");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" visible = ");
            retStr.append(this.visible);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getCubeName() {
            return this.cubeName;
        }

        @Mutator
        public void setCubeName(String newval) {
            String oldval = this.cubeName;
            this.cubeName = newval;
            this.firePropertyChange("cubeName", oldval, newval);
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public Boolean getVisible() {
            return this.visible;
        }

        @Mutator
        public void setVisible(Boolean newval) {
            Boolean oldval = this.visible;
            this.visible = newval;
            this.firePropertyChange("visible", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class VirtualCubeDimension
    extends CubeDimension {
        private String cubeName;
        private String name;
        public static final List<Class<? extends SPObject>> allowedChildTypes = CubeDimension.allowedChildTypes;

        public VirtualCubeDimension() {
            this.setName("New VirtualCubeDimension");
        }

        @Constructor
        public VirtualCubeDimension(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="cubeName") String cubeName, @ConstructorParameter(propertyName="caption") String caption, @ConstructorParameter(propertyName="foreignKey") String foreignKey) {
            this();
            this.setName(name);
            this.setCubeName(cubeName);
            this.setCaption(caption);
            this.setForeignKey(foreignKey);
        }

        public VirtualCubeDimension(VirtualCubeDimension original) {
            super(original);
            this.cubeName = original.getCubeName();
            this.name = original.getName();
        }

        @Override
        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("VirtualCubeDimension:");
            retStr.append(" cubeName = ");
            retStr.append(this.cubeName);
            retStr.append(",");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            retStr.append(" [inherited ");
            retStr.append(super.toString());
            retStr.append("]");
            return retStr.toString();
        }

        @Accessor
        public String getCubeName() {
            return this.cubeName;
        }

        @Mutator
        public void setCubeName(String newval) {
            String oldval = this.cubeName;
            this.cubeName = newval;
            this.firePropertyChange("cubeName", oldval, newval);
        }

        @Override
        @Accessor
        public String getName() {
            return this.name;
        }

        @Override
        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Override
        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        @Override
        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Override
        @NonProperty
        public List<SPObject> getChildren() {
            return super.getChildren();
        }

        @Override
        public boolean allowsChildren() {
            return super.allowsChildren();
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class CubeUsage
    extends OLAPObject {
        private String cubeName;
        private Boolean ignoreUnrelatedDimensions;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public CubeUsage() {
            this.setName("New CubeUsage");
        }

        @Constructor
        public CubeUsage(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="cubeName") String cubeName, @ConstructorParameter(propertyName="ignoreUnrelatedDimensions") Boolean ignoreUnrelatedDimensions) {
            this();
            this.setName(name);
            this.setCubeName(cubeName);
            this.setIgnoreUnrelatedDimensions(ignoreUnrelatedDimensions);
        }

        public CubeUsage(CubeUsage original) {
            super(original);
            this.cubeName = original.getCubeName();
            this.ignoreUnrelatedDimensions = original.getIgnoreUnrelatedDimensions();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("CubeUsage:");
            retStr.append(" cubeName = ");
            retStr.append(this.cubeName);
            retStr.append(",");
            retStr.append(" ignoreUnrelatedDimensions = ");
            retStr.append(this.ignoreUnrelatedDimensions);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getCubeName() {
            return this.cubeName;
        }

        @Mutator
        public void setCubeName(String newval) {
            String oldval = this.cubeName;
            this.cubeName = newval;
            this.firePropertyChange("cubeName", oldval, newval);
        }

        @Accessor
        public Boolean getIgnoreUnrelatedDimensions() {
            return this.ignoreUnrelatedDimensions;
        }

        @Mutator
        public void setIgnoreUnrelatedDimensions(Boolean newval) {
            Boolean oldval = this.ignoreUnrelatedDimensions;
            this.ignoreUnrelatedDimensions = newval;
            this.firePropertyChange("ignoreUnrelatedDimensions", oldval, newval);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class CubeUsages
    extends OLAPObject {
        private final List<CubeUsage> cubeUsages = new ArrayList<CubeUsage>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public CubeUsages() {
            this.setName("New CubeUsages");
        }

        @Constructor
        public CubeUsages(@ConstructorParameter(propertyName="name") String name) {
            this();
            this.setName(name);
        }

        public CubeUsages(CubeUsages original) {
            super(original);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("CubeUsages:");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        public void addCubeUsage(int pos, CubeUsage newChild) {
            this.cubeUsages.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(CubeUsage.class) + pos;
            this.fireChildAdded(CubeUsage.class, (SPObject)newChild, overallPosition);
        }

        public void addCubeUsage(CubeUsage newChild) {
            this.addCubeUsage(this.cubeUsages.size(), newChild);
        }

        public boolean removeCubeUsage(CubeUsage removeChild) {
            int pos = this.cubeUsages.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeCubeUsage(pos);
                return true;
            }
            return false;
        }

        public CubeUsage removeCubeUsage(int pos) {
            CubeUsage removedItem = this.cubeUsages.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(CubeUsage.class) + pos;
                this.fireChildRemoved(CubeUsage.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<CubeUsage> getCubeUsages() {
            return Collections.unmodifiableList(this.cubeUsages);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<CubeUsage> children = new ArrayList<CubeUsage>();
            children.addAll(this.cubeUsages);
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (CubeUsage.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.cubeUsages.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof CubeUsage) {
                int offset = this.childPositionOffset(CubeUsage.class);
                if (index < 0 || index > this.cubeUsages.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.cubeUsages.size());
                }
                this.addCubeUsage(index, (CubeUsage)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof CubeUsage) {
                return this.removeCubeUsage((CubeUsage)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(CubeUsage.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class VirtualCube
    extends OLAPObject {
        private Boolean enabled;
        private String name;
        private String defaultMeasure;
        private String caption;
        private CubeUsages cubeUsage;
        private final List<VirtualCubeDimension> dimensions = new ArrayList<VirtualCubeDimension>();
        private final List<VirtualCubeMeasure> measures = new ArrayList<VirtualCubeMeasure>();
        private final List<CalculatedMember> calculatedMembers = new ArrayList<CalculatedMember>();
        private final List<NamedSet> namedSets = new ArrayList<NamedSet>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public VirtualCube() {
            this.setName("New VirtualCube");
        }

        @Constructor
        public VirtualCube(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="enabled") Boolean enabled, @ConstructorParameter(propertyName="defaultMeasure") String defaultMeasure, @ConstructorParameter(propertyName="caption") String caption) {
            this();
            this.setName(name);
            this.setEnabled(enabled);
            this.setDefaultMeasure(defaultMeasure);
            this.setCaption(caption);
        }

        public VirtualCube(VirtualCube original) {
            super(original);
            this.enabled = original.getEnabled();
            this.name = original.getName();
            this.defaultMeasure = original.getDefaultMeasure();
            this.caption = original.getCaption();
            this.cubeUsage = original.getCubeUsage();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("VirtualCube:");
            retStr.append(" enabled = ");
            retStr.append(this.enabled);
            retStr.append(",");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" defaultMeasure = ");
            retStr.append(this.defaultMeasure);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr.append(" cubeUsage = ");
            retStr.append((Object)this.cubeUsage);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Mutator
        public void setEnabled(Boolean newval) {
            Boolean oldval = this.enabled;
            this.enabled = newval;
            this.firePropertyChange("enabled", oldval, newval);
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getDefaultMeasure() {
            return this.defaultMeasure;
        }

        @Mutator
        public void setDefaultMeasure(String newval) {
            String oldval = this.defaultMeasure;
            this.defaultMeasure = newval;
            this.firePropertyChange("defaultMeasure", oldval, newval);
        }

        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @NonProperty
        public CubeUsages getCubeUsage() {
            return this.cubeUsage;
        }

        @NonProperty
        public void setCubeUsage(CubeUsages newval) {
            CubeUsages oldval = this.cubeUsage;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(CubeUsages.class);
            if (this.cubeUsage != null) {
                this.fireChildRemoved(CubeUsages.class, (SPObject)oldval, overallPosition);
            }
            this.cubeUsage = newval;
            if (this.cubeUsage != null) {
                this.cubeUsage.setParent((SPObject)this);
                this.fireChildAdded(CubeUsages.class, (SPObject)this.cubeUsage, overallPosition);
            }
        }

        public void addDimension(int pos, VirtualCubeDimension newChild) {
            this.dimensions.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(VirtualCubeDimension.class) + pos;
            this.fireChildAdded(VirtualCubeDimension.class, (SPObject)newChild, overallPosition);
        }

        public void addDimension(VirtualCubeDimension newChild) {
            this.addDimension(this.dimensions.size(), newChild);
        }

        public boolean removeDimension(VirtualCubeDimension removeChild) {
            int pos = this.dimensions.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeDimension(pos);
                return true;
            }
            return false;
        }

        public VirtualCubeDimension removeDimension(int pos) {
            VirtualCubeDimension removedItem = this.dimensions.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(VirtualCubeDimension.class) + pos;
                this.fireChildRemoved(VirtualCubeDimension.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<VirtualCubeDimension> getDimensions() {
            return Collections.unmodifiableList(this.dimensions);
        }

        public void addMeasure(int pos, VirtualCubeMeasure newChild) {
            this.measures.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(VirtualCubeMeasure.class) + pos;
            this.fireChildAdded(VirtualCubeMeasure.class, (SPObject)newChild, overallPosition);
        }

        public void addMeasure(VirtualCubeMeasure newChild) {
            this.addMeasure(this.measures.size(), newChild);
        }

        public boolean removeMeasure(VirtualCubeMeasure removeChild) {
            int pos = this.measures.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeMeasure(pos);
                return true;
            }
            return false;
        }

        public VirtualCubeMeasure removeMeasure(int pos) {
            VirtualCubeMeasure removedItem = this.measures.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(VirtualCubeMeasure.class) + pos;
                this.fireChildRemoved(VirtualCubeMeasure.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<VirtualCubeMeasure> getMeasures() {
            return Collections.unmodifiableList(this.measures);
        }

        public void addCalculatedMember(int pos, CalculatedMember newChild) {
            this.calculatedMembers.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(CalculatedMember.class) + pos;
            this.fireChildAdded(CalculatedMember.class, (SPObject)newChild, overallPosition);
        }

        public void addCalculatedMember(CalculatedMember newChild) {
            this.addCalculatedMember(this.calculatedMembers.size(), newChild);
        }

        public boolean removeCalculatedMember(CalculatedMember removeChild) {
            int pos = this.calculatedMembers.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeCalculatedMember(pos);
                return true;
            }
            return false;
        }

        public CalculatedMember removeCalculatedMember(int pos) {
            CalculatedMember removedItem = this.calculatedMembers.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(CalculatedMember.class) + pos;
                this.fireChildRemoved(CalculatedMember.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<CalculatedMember> getCalculatedMembers() {
            return Collections.unmodifiableList(this.calculatedMembers);
        }

        public void addNamedSet(int pos, NamedSet newChild) {
            this.namedSets.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(NamedSet.class) + pos;
            this.fireChildAdded(NamedSet.class, (SPObject)newChild, overallPosition);
        }

        public void addNamedSet(NamedSet newChild) {
            this.addNamedSet(this.namedSets.size(), newChild);
        }

        public boolean removeNamedSet(NamedSet removeChild) {
            int pos = this.namedSets.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeNamedSet(pos);
                return true;
            }
            return false;
        }

        public NamedSet removeNamedSet(int pos) {
            NamedSet removedItem = this.namedSets.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(NamedSet.class) + pos;
                this.fireChildRemoved(NamedSet.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<NamedSet> getNamedSets() {
            return Collections.unmodifiableList(this.namedSets);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.dimensions);
            children.addAll(this.measures);
            children.addAll(this.calculatedMembers);
            children.addAll(this.namedSets);
            if (this.cubeUsage != null) {
                children.add(this.cubeUsage);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (VirtualCubeDimension.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.dimensions.size();
            if (VirtualCubeMeasure.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.measures.size();
            if (CalculatedMember.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.calculatedMembers.size();
            if (NamedSet.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.namedSets.size();
            if (CubeUsages.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof VirtualCubeDimension) {
                int offset = this.childPositionOffset(VirtualCubeDimension.class);
                if (index < 0 || index > this.dimensions.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.dimensions.size());
                }
                this.addDimension(index, (VirtualCubeDimension)child);
            } else if (child instanceof VirtualCubeMeasure) {
                int offset = this.childPositionOffset(VirtualCubeMeasure.class);
                if (index < 0 || index > this.measures.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.measures.size());
                }
                this.addMeasure(index, (VirtualCubeMeasure)child);
            } else if (child instanceof CalculatedMember) {
                int offset = this.childPositionOffset(CalculatedMember.class);
                if (index < 0 || index > this.calculatedMembers.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.calculatedMembers.size());
                }
                this.addCalculatedMember(index, (CalculatedMember)child);
            } else if (child instanceof NamedSet) {
                int offset = this.childPositionOffset(NamedSet.class);
                if (index < 0 || index > this.namedSets.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.namedSets.size());
                }
                this.addNamedSet(index, (NamedSet)child);
            } else if (child instanceof CubeUsages) {
                this.setCubeUsage((CubeUsages)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof VirtualCubeDimension) {
                return this.removeDimension((VirtualCubeDimension)child);
            }
            if (child instanceof VirtualCubeMeasure) {
                return this.removeMeasure((VirtualCubeMeasure)child);
            }
            if (child instanceof CalculatedMember) {
                return this.removeCalculatedMember((CalculatedMember)child);
            }
            if (child instanceof NamedSet) {
                return this.removeNamedSet((NamedSet)child);
            }
            if (child instanceof CubeUsages) {
                this.setCubeUsage(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(VirtualCubeDimension.class, VirtualCubeMeasure.class, CalculatedMember.class, NamedSet.class, CubeUsages.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static class Cube
    extends OLAPObject {
        private String name;
        private String caption;
        private String defaultMeasure;
        private Boolean cache;
        private Boolean enabled;
        private Relation fact;
        private final List<CubeDimension> dimensions = new ArrayList<CubeDimension>();
        private final List<Measure> measures = new ArrayList<Measure>();
        private final List<CalculatedMember> calculatedMembers = new ArrayList<CalculatedMember>();
        private final List<NamedSet> namedSets = new ArrayList<NamedSet>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Cube() {
            this.setName("New Cube");
        }

        @Constructor
        public Cube(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="caption") String caption, @ConstructorParameter(propertyName="defaultMeasure") String defaultMeasure, @ConstructorParameter(propertyName="cache") Boolean cache, @ConstructorParameter(propertyName="enabled") Boolean enabled) {
            this();
            this.setName(name);
            this.setCaption(caption);
            this.setDefaultMeasure(defaultMeasure);
            this.setCache(cache);
            this.setEnabled(enabled);
        }

        public Cube(Cube original) {
            super(original);
            this.name = original.getName();
            this.caption = original.getCaption();
            this.defaultMeasure = original.getDefaultMeasure();
            this.cache = original.getCache();
            this.enabled = original.getEnabled();
            this.fact = original.getFact();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Cube:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr.append(" defaultMeasure = ");
            retStr.append(this.defaultMeasure);
            retStr.append(",");
            retStr.append(" cache = ");
            retStr.append(this.cache);
            retStr.append(",");
            retStr.append(" enabled = ");
            retStr.append(this.enabled);
            retStr.append(",");
            retStr.append(" fact = ");
            retStr.append((Object)this.fact);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @Accessor
        public String getDefaultMeasure() {
            return this.defaultMeasure;
        }

        @Mutator
        public void setDefaultMeasure(String newval) {
            String oldval = this.defaultMeasure;
            this.defaultMeasure = newval;
            this.firePropertyChange("defaultMeasure", oldval, newval);
        }

        @Accessor
        public Boolean getCache() {
            return this.cache;
        }

        @Mutator
        public void setCache(Boolean newval) {
            Boolean oldval = this.cache;
            this.cache = newval;
            this.firePropertyChange("cache", oldval, newval);
        }

        @Accessor
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Mutator
        public void setEnabled(Boolean newval) {
            Boolean oldval = this.enabled;
            this.enabled = newval;
            this.firePropertyChange("enabled", oldval, newval);
        }

        @NonProperty
        public Relation getFact() {
            return this.fact;
        }

        @NonProperty
        public void setFact(Relation newval) {
            Relation oldval = this.fact;
            if (oldval == newval) {
                return;
            }
            int overallPosition = this.childPositionOffset(Relation.class);
            if (this.fact != null) {
                this.fireChildRemoved(Relation.class, (SPObject)oldval, overallPosition);
            }
            this.fact = newval;
            if (this.fact != null) {
                this.fact.setParent((SPObject)this);
                this.fireChildAdded(Relation.class, (SPObject)this.fact, overallPosition);
            }
        }

        public void addDimension(int pos, CubeDimension newChild) {
            this.dimensions.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(CubeDimension.class) + pos;
            this.fireChildAdded(CubeDimension.class, (SPObject)newChild, overallPosition);
        }

        public void addDimension(CubeDimension newChild) {
            this.addDimension(this.dimensions.size(), newChild);
        }

        public boolean removeDimension(CubeDimension removeChild) {
            int pos = this.dimensions.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeDimension(pos);
                return true;
            }
            return false;
        }

        public CubeDimension removeDimension(int pos) {
            CubeDimension removedItem = this.dimensions.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(CubeDimension.class) + pos;
                this.fireChildRemoved(CubeDimension.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<CubeDimension> getDimensions() {
            return Collections.unmodifiableList(this.dimensions);
        }

        public void addMeasure(int pos, Measure newChild) {
            this.measures.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Measure.class) + pos;
            this.fireChildAdded(Measure.class, (SPObject)newChild, overallPosition);
        }

        public void addMeasure(Measure newChild) {
            this.addMeasure(this.measures.size(), newChild);
        }

        public boolean removeMeasure(Measure removeChild) {
            int pos = this.measures.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeMeasure(pos);
                return true;
            }
            return false;
        }

        public Measure removeMeasure(int pos) {
            Measure removedItem = this.measures.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Measure.class) + pos;
                this.fireChildRemoved(Measure.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Measure> getMeasures() {
            return Collections.unmodifiableList(this.measures);
        }

        public void addCalculatedMember(int pos, CalculatedMember newChild) {
            this.calculatedMembers.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(CalculatedMember.class) + pos;
            this.fireChildAdded(CalculatedMember.class, (SPObject)newChild, overallPosition);
        }

        public void addCalculatedMember(CalculatedMember newChild) {
            this.addCalculatedMember(this.calculatedMembers.size(), newChild);
        }

        public boolean removeCalculatedMember(CalculatedMember removeChild) {
            int pos = this.calculatedMembers.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeCalculatedMember(pos);
                return true;
            }
            return false;
        }

        public CalculatedMember removeCalculatedMember(int pos) {
            CalculatedMember removedItem = this.calculatedMembers.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(CalculatedMember.class) + pos;
                this.fireChildRemoved(CalculatedMember.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<CalculatedMember> getCalculatedMembers() {
            return Collections.unmodifiableList(this.calculatedMembers);
        }

        public void addNamedSet(int pos, NamedSet newChild) {
            this.namedSets.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(NamedSet.class) + pos;
            this.fireChildAdded(NamedSet.class, (SPObject)newChild, overallPosition);
        }

        public void addNamedSet(NamedSet newChild) {
            this.addNamedSet(this.namedSets.size(), newChild);
        }

        public boolean removeNamedSet(NamedSet removeChild) {
            int pos = this.namedSets.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeNamedSet(pos);
                return true;
            }
            return false;
        }

        public NamedSet removeNamedSet(int pos) {
            NamedSet removedItem = this.namedSets.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(NamedSet.class) + pos;
                this.fireChildRemoved(NamedSet.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<NamedSet> getNamedSets() {
            return Collections.unmodifiableList(this.namedSets);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.dimensions);
            children.addAll(this.measures);
            children.addAll(this.calculatedMembers);
            children.addAll(this.namedSets);
            if (this.fact != null) {
                children.add(this.fact);
            }
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (CubeDimension.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.dimensions.size();
            if (Measure.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.measures.size();
            if (CalculatedMember.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.calculatedMembers.size();
            if (NamedSet.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.namedSets.size();
            if (Relation.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return ++offset + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof CubeDimension) {
                int offset = this.childPositionOffset(CubeDimension.class);
                if (index < 0 || index > this.dimensions.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.dimensions.size());
                }
                this.addDimension(index, (CubeDimension)child);
            } else if (child instanceof Measure) {
                int offset = this.childPositionOffset(Measure.class);
                if (index < 0 || index > this.measures.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.measures.size());
                }
                this.addMeasure(index, (Measure)child);
            } else if (child instanceof CalculatedMember) {
                int offset = this.childPositionOffset(CalculatedMember.class);
                if (index < 0 || index > this.calculatedMembers.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.calculatedMembers.size());
                }
                this.addCalculatedMember(index, (CalculatedMember)child);
            } else if (child instanceof NamedSet) {
                int offset = this.childPositionOffset(NamedSet.class);
                if (index < 0 || index > this.namedSets.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.namedSets.size());
                }
                this.addNamedSet(index, (NamedSet)child);
            } else if (child instanceof Relation) {
                this.setFact((Relation)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof CubeDimension) {
                return this.removeDimension((CubeDimension)child);
            }
            if (child instanceof Measure) {
                return this.removeMeasure((Measure)child);
            }
            if (child instanceof CalculatedMember) {
                return this.removeCalculatedMember((CalculatedMember)child);
            }
            if (child instanceof NamedSet) {
                return this.removeNamedSet((NamedSet)child);
            }
            if (child instanceof Relation) {
                this.setFact(null);
                return true;
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(CubeDimension.class, Measure.class, CalculatedMember.class, NamedSet.class, Relation.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }

    public static abstract class CubeDimension
    extends OLAPObject {
        private String name;
        private String caption;
        private String foreignKey;
        public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();

        public CubeDimension() {
            this.setName("New CubeDimension");
        }

        @Constructor
        public CubeDimension(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="caption") String caption, @ConstructorParameter(propertyName="foreignKey") String foreignKey) {
            this();
            this.setName(name);
            this.setCaption(caption);
            this.setForeignKey(foreignKey);
        }

        public CubeDimension(CubeDimension original) {
            super(original);
            this.name = original.getName();
            this.caption = original.getCaption();
            this.foreignKey = original.getForeignKey();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getCaption() {
            return this.caption;
        }

        @Mutator
        public void setCaption(String newval) {
            String oldval = this.caption;
            this.caption = newval;
            this.firePropertyChange("caption", oldval, newval);
        }

        @Accessor
        public String getForeignKey() {
            return this.foreignKey;
        }

        @Mutator
        public void setForeignKey(String newval) {
            String oldval = this.foreignKey;
            this.foreignKey = newval;
            this.firePropertyChange("foreignKey", oldval, newval);
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("CubeDimension:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" caption = ");
            retStr.append(this.caption);
            retStr.append(",");
            retStr.append(" foreignKey = ");
            retStr.append(this.foreignKey);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            return Collections.emptyList();
        }

        public boolean allowsChildren() {
            return false;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            return super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            super.addChildImpl(child, index);
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            return super.removeChildImpl(child);
        }
    }

    public static class Schema
    extends OLAPObject {
        private String name;
        private String measuresCaption;
        private String defaultRole;
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private final List<Dimension> dimensions = new ArrayList<Dimension>();
        private final List<Cube> cubes = new ArrayList<Cube>();
        private final List<VirtualCube> virtualCubes = new ArrayList<VirtualCube>();
        private final List<NamedSet> namedSets = new ArrayList<NamedSet>();
        private final List<Role> roles = new ArrayList<Role>();
        private final List<UserDefinedFunction> userDefinedFunctions = new ArrayList<UserDefinedFunction>();
        public static final List<Class<? extends SPObject>> allowedChildTypes;

        public Schema() {
            this.setName("New Schema");
        }

        @Constructor
        public Schema(@ConstructorParameter(propertyName="name") String name, @ConstructorParameter(propertyName="measuresCaption") String measuresCaption, @ConstructorParameter(propertyName="defaultRole") String defaultRole) {
            this();
            this.setName(name);
            this.setMeasuresCaption(measuresCaption);
            this.setDefaultRole(defaultRole);
        }

        public Schema(Schema original) {
            super(original);
            this.name = original.getName();
            this.measuresCaption = original.getMeasuresCaption();
            this.defaultRole = original.getDefaultRole();
        }

        public String toString() {
            StringBuilder retStr = new StringBuilder();
            retStr.append("Schema:");
            retStr.append(" name = ");
            retStr.append(this.name);
            retStr.append(",");
            retStr.append(" measuresCaption = ");
            retStr.append(this.measuresCaption);
            retStr.append(",");
            retStr.append(" defaultRole = ");
            retStr.append(this.defaultRole);
            retStr.append(",");
            retStr = retStr.deleteCharAt(retStr.length() - 1);
            return retStr.toString();
        }

        @Accessor
        public String getName() {
            return this.name;
        }

        @Mutator
        public void setName(String newval) {
            String oldval = this.name;
            this.name = newval;
            this.firePropertyChange("name", oldval, newval);
        }

        @Accessor
        public String getMeasuresCaption() {
            return this.measuresCaption;
        }

        @Mutator
        public void setMeasuresCaption(String newval) {
            String oldval = this.measuresCaption;
            this.measuresCaption = newval;
            this.firePropertyChange("measuresCaption", oldval, newval);
        }

        @Accessor
        public String getDefaultRole() {
            return this.defaultRole;
        }

        @Mutator
        public void setDefaultRole(String newval) {
            String oldval = this.defaultRole;
            this.defaultRole = newval;
            this.firePropertyChange("defaultRole", oldval, newval);
        }

        public void addParameter(int pos, Parameter newChild) {
            this.parameters.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Parameter.class) + pos;
            this.fireChildAdded(Parameter.class, (SPObject)newChild, overallPosition);
        }

        public void addParameter(Parameter newChild) {
            this.addParameter(this.parameters.size(), newChild);
        }

        public boolean removeParameter(Parameter removeChild) {
            int pos = this.parameters.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeParameter(pos);
                return true;
            }
            return false;
        }

        public Parameter removeParameter(int pos) {
            Parameter removedItem = this.parameters.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Parameter.class) + pos;
                this.fireChildRemoved(Parameter.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Parameter> getParameters() {
            return Collections.unmodifiableList(this.parameters);
        }

        public void addDimension(int pos, Dimension newChild) {
            this.dimensions.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Dimension.class) + pos;
            this.fireChildAdded(Dimension.class, (SPObject)newChild, overallPosition);
        }

        public void addDimension(Dimension newChild) {
            this.addDimension(this.dimensions.size(), newChild);
        }

        public boolean removeDimension(Dimension removeChild) {
            int pos = this.dimensions.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeDimension(pos);
                return true;
            }
            return false;
        }

        public Dimension removeDimension(int pos) {
            Dimension removedItem = this.dimensions.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Dimension.class) + pos;
                this.fireChildRemoved(Dimension.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Dimension> getDimensions() {
            return Collections.unmodifiableList(this.dimensions);
        }

        public void addCube(int pos, Cube newChild) {
            this.cubes.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Cube.class) + pos;
            this.fireChildAdded(Cube.class, (SPObject)newChild, overallPosition);
        }

        public void addCube(Cube newChild) {
            this.addCube(this.cubes.size(), newChild);
        }

        public boolean removeCube(Cube removeChild) {
            int pos = this.cubes.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeCube(pos);
                return true;
            }
            return false;
        }

        public Cube removeCube(int pos) {
            Cube removedItem = this.cubes.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Cube.class) + pos;
                this.fireChildRemoved(Cube.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Cube> getCubes() {
            return Collections.unmodifiableList(this.cubes);
        }

        public void addVirtualCube(int pos, VirtualCube newChild) {
            this.virtualCubes.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(VirtualCube.class) + pos;
            this.fireChildAdded(VirtualCube.class, (SPObject)newChild, overallPosition);
        }

        public void addVirtualCube(VirtualCube newChild) {
            this.addVirtualCube(this.virtualCubes.size(), newChild);
        }

        public boolean removeVirtualCube(VirtualCube removeChild) {
            int pos = this.virtualCubes.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeVirtualCube(pos);
                return true;
            }
            return false;
        }

        public VirtualCube removeVirtualCube(int pos) {
            VirtualCube removedItem = this.virtualCubes.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(VirtualCube.class) + pos;
                this.fireChildRemoved(VirtualCube.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<VirtualCube> getVirtualCubes() {
            return Collections.unmodifiableList(this.virtualCubes);
        }

        public void addNamedSet(int pos, NamedSet newChild) {
            this.namedSets.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(NamedSet.class) + pos;
            this.fireChildAdded(NamedSet.class, (SPObject)newChild, overallPosition);
        }

        public void addNamedSet(NamedSet newChild) {
            this.addNamedSet(this.namedSets.size(), newChild);
        }

        public boolean removeNamedSet(NamedSet removeChild) {
            int pos = this.namedSets.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeNamedSet(pos);
                return true;
            }
            return false;
        }

        public NamedSet removeNamedSet(int pos) {
            NamedSet removedItem = this.namedSets.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(NamedSet.class) + pos;
                this.fireChildRemoved(NamedSet.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<NamedSet> getNamedSets() {
            return Collections.unmodifiableList(this.namedSets);
        }

        public void addRole(int pos, Role newChild) {
            this.roles.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(Role.class) + pos;
            this.fireChildAdded(Role.class, (SPObject)newChild, overallPosition);
        }

        public void addRole(Role newChild) {
            this.addRole(this.roles.size(), newChild);
        }

        public boolean removeRole(Role removeChild) {
            int pos = this.roles.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeRole(pos);
                return true;
            }
            return false;
        }

        public Role removeRole(int pos) {
            Role removedItem = this.roles.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(Role.class) + pos;
                this.fireChildRemoved(Role.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<Role> getRoles() {
            return Collections.unmodifiableList(this.roles);
        }

        public void addUserDefinedFunction(int pos, UserDefinedFunction newChild) {
            this.userDefinedFunctions.add(pos, newChild);
            newChild.setParent((SPObject)this);
            int overallPosition = this.childPositionOffset(UserDefinedFunction.class) + pos;
            this.fireChildAdded(UserDefinedFunction.class, (SPObject)newChild, overallPosition);
        }

        public void addUserDefinedFunction(UserDefinedFunction newChild) {
            this.addUserDefinedFunction(this.userDefinedFunctions.size(), newChild);
        }

        public boolean removeUserDefinedFunction(UserDefinedFunction removeChild) {
            int pos = this.userDefinedFunctions.indexOf((Object)removeChild);
            if (pos != -1) {
                this.removeUserDefinedFunction(pos);
                return true;
            }
            return false;
        }

        public UserDefinedFunction removeUserDefinedFunction(int pos) {
            UserDefinedFunction removedItem = this.userDefinedFunctions.remove(pos);
            if (removedItem != null) {
                int overallPosition = this.childPositionOffset(UserDefinedFunction.class) + pos;
                this.fireChildRemoved(UserDefinedFunction.class, (SPObject)removedItem, overallPosition);
                removedItem.setParent(null);
            }
            return removedItem;
        }

        @NonProperty
        public List<UserDefinedFunction> getUserDefinedFunctions() {
            return Collections.unmodifiableList(this.userDefinedFunctions);
        }

        @Transient
        @Accessor
        public List<Class<? extends SPObject>> getAllowedChildTypes() {
            return allowedChildTypes;
        }

        public void removeDependency(SPObject dependency) {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @Transient
        @Accessor
        public List<? extends SPObject> getDependencies() {
            throw new IllegalStateException("Dependency management has not been setup for OLAP objects because they reference each other by name.");
        }

        @NonProperty
        public List<SPObject> getChildren() {
            ArrayList<OLAPObject> children = new ArrayList<OLAPObject>();
            children.addAll(this.parameters);
            children.addAll(this.dimensions);
            children.addAll(this.cubes);
            children.addAll(this.virtualCubes);
            children.addAll(this.namedSets);
            children.addAll(this.roles);
            children.addAll(this.userDefinedFunctions);
            return Collections.unmodifiableList(children);
        }

        public boolean allowsChildren() {
            return true;
        }

        @Override
        public int childPositionOffset(Class<? extends SPObject> childClass) {
            int offset = 0;
            if (Parameter.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.parameters.size();
            if (Dimension.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.dimensions.size();
            if (Cube.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.cubes.size();
            if (VirtualCube.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.virtualCubes.size();
            if (NamedSet.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.namedSets.size();
            if (Role.class.isAssignableFrom(childClass)) {
                return offset;
            }
            offset += this.roles.size();
            if (UserDefinedFunction.class.isAssignableFrom(childClass)) {
                return offset;
            }
            return (offset += this.userDefinedFunctions.size()) + super.childPositionOffset(childClass);
        }

        @Override
        public void addChildImpl(SPObject child, int index) {
            if (child instanceof Parameter) {
                int offset = this.childPositionOffset(Parameter.class);
                if (index < 0 || index > this.parameters.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.parameters.size());
                }
                this.addParameter(index, (Parameter)child);
            } else if (child instanceof Dimension) {
                int offset = this.childPositionOffset(Dimension.class);
                if (index < 0 || index > this.dimensions.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.dimensions.size());
                }
                this.addDimension(index, (Dimension)child);
            } else if (child instanceof Cube) {
                int offset = this.childPositionOffset(Cube.class);
                if (index < 0 || index > this.cubes.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.cubes.size());
                }
                this.addCube(index, (Cube)child);
            } else if (child instanceof VirtualCube) {
                int offset = this.childPositionOffset(VirtualCube.class);
                if (index < 0 || index > this.virtualCubes.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.virtualCubes.size());
                }
                this.addVirtualCube(index, (VirtualCube)child);
            } else if (child instanceof NamedSet) {
                int offset = this.childPositionOffset(NamedSet.class);
                if (index < 0 || index > this.namedSets.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.namedSets.size());
                }
                this.addNamedSet(index, (NamedSet)child);
            } else if (child instanceof Role) {
                int offset = this.childPositionOffset(Role.class);
                if (index < 0 || index > this.roles.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.roles.size());
                }
                this.addRole(index, (Role)child);
            } else if (child instanceof UserDefinedFunction) {
                int offset = this.childPositionOffset(UserDefinedFunction.class);
                if (index < 0 || index > this.userDefinedFunctions.size()) {
                    throw new IllegalArgumentException("Index out of bounds for this child type. You gave: " + index + ". min= " + 0 + "; max=" + this.userDefinedFunctions.size());
                }
                this.addUserDefinedFunction(index, (UserDefinedFunction)child);
            } else {
                super.addChildImpl(child, index);
            }
        }

        @Override
        public boolean removeChildImpl(SPObject child) {
            if (child instanceof Parameter) {
                return this.removeParameter((Parameter)child);
            }
            if (child instanceof Dimension) {
                return this.removeDimension((Dimension)child);
            }
            if (child instanceof Cube) {
                return this.removeCube((Cube)child);
            }
            if (child instanceof VirtualCube) {
                return this.removeVirtualCube((VirtualCube)child);
            }
            if (child instanceof NamedSet) {
                return this.removeNamedSet((NamedSet)child);
            }
            if (child instanceof Role) {
                return this.removeRole((Role)child);
            }
            if (child instanceof UserDefinedFunction) {
                return this.removeUserDefinedFunction((UserDefinedFunction)child);
            }
            return super.removeChildImpl(child);
        }

        static {
            ArrayList<Class> childTypes = new ArrayList<Class>(Arrays.asList(Parameter.class, Dimension.class, Cube.class, VirtualCube.class, NamedSet.class, Role.class, UserDefinedFunction.class));
            allowedChildTypes = Collections.unmodifiableList(childTypes);
        }
    }
}

