/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectVersion;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.BrowserUtil;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class WelcomeScreen {
    private final ArchitectSwingSessionContext context;
    private final JLabel imageLabel;
    private JCheckBox showPrefsAgain;
    static final String welcomeHTMLstuff = "<html><head><style>body {margin-left: 100px; margin-right: 100px;}</style></head><body style=\"font:" + new JLabel().getFont() + "\">" + "<br><br>" + "<h1 align=\"center\">SQL Power Architect " + (Object)((Object)ArchitectVersion.APP_FULL_VERSION) + "</h1>" + "<br>" + "<div align=\"center\"><p>" + Messages.getString("WelcomeScreen.forInfo") + "</div>" + "<br>" + "<div align=\"center\"><b>" + Messages.getString("WelcomeScreen.userGuide", "http://www.sqlpower.ca/page/architect-userguide") + "</b></div>" + "<br>" + "<div align=\"center\"><b>" + Messages.getString("WelcomeScreen.premiumSupport", "http://www.sqlpower.ca/page/architect_support") + "</b></div>" + "<br>" + "<div align=\"center\"><b>" + Messages.getString("WelcomeScreen.communityForum", "http://www.sqlpower.ca/page/enter_forum") + "</b></div>" + "<br><br><br>";

    public WelcomeScreen(ArchitectSwingSessionContext context) {
        this.context = context;
        this.imageLabel = new JLabel(SPSUtils.createIcon((String)"architect_welcome_heading", (String)"Large Architect Logo"));
    }

    public void showWelcomeDialog(Component dialogOwner) {
        final JDialog d = SPSUtils.makeOwnedDialog((Component)dialogOwner, (String)Messages.getString("WelcomeScreen.welcomeScreenTitle"));
        d.setLayout(new BorderLayout(0, 12));
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, fill:pref, pref:grow", "pref, pref, pref"));
        CellConstraints cc = new CellConstraints();
        JPanel logoPanel = LogoLayout.generateLogoPanel();
        builder.add((Component)logoPanel, cc.xyw(1, 1, 3));
        d.add((Component)builder.getPanel(), "North");
        logoPanel.getLayout().layoutContainer(logoPanel);
        HTMLEditorKit htmlKit = new HTMLEditorKit();
        JEditorPane htmlComponent = new JEditorPane();
        htmlComponent.setEditorKit(htmlKit);
        htmlComponent.setText(welcomeHTMLstuff);
        htmlComponent.setEditable(false);
        htmlComponent.setBackground(null);
        htmlComponent.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = evt.getURL();
                    try {
                        BrowserUtil.launch((String)url.toString());
                    }
                    catch (IOException e1) {
                        throw new RuntimeException(Messages.getString("WelcomeScreen.unexpectedError"), e1);
                    }
                }
            }
        });
        d.add((Component)htmlComponent, "Center");
        this.showPrefsAgain = new JCheckBox(Messages.getString("WelcomeScreen.showWelcomeInFuture"));
        this.showPrefsAgain.setSelected(true);
        JButton closeButton = new JButton(Messages.getString("WelcomeScreen.closeButton"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WelcomeScreen.this.context.getUserSettings().getSwingSettings().setBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", WelcomeScreen.this.showPrefsAgain.isSelected());
                d.dispose();
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        bottomPanel.add((Component)this.showPrefsAgain, "West");
        bottomPanel.add((Component)closeButton, "East");
        d.add((Component)bottomPanel, "South");
        d.getRootPane().setDefaultButton(closeButton);
        d.pack();
        d.setSize(d.getSize().width - 4, d.getSize().height);
        d.setLocationRelativeTo(dialogOwner);
        d.setVisible(true);
    }

    private static class LogoLayout
    implements LayoutManager {
        public static JPanel generateLogoPanel() {
            JPanel panel = new JPanel(new LogoLayout());
            JLabel bgLabel = new JLabel(new ImageIcon(WelcomeScreen.class.getClassLoader().getResource("icons/architect_header_bkgd.png")));
            JLabel welcomeLabel = new JLabel(new ImageIcon(WelcomeScreen.class.getClassLoader().getResource("icons/architect_header_welcome.png")));
            JLabel architectLabel = new JLabel(new ImageIcon(WelcomeScreen.class.getClassLoader().getResource("icons/architect_header_architect.png")));
            JLabel sqlpowerLabel = new JLabel(new ImageIcon(WelcomeScreen.class.getClassLoader().getResource("icons/architect_header_sqlpower.png")));
            panel.add(welcomeLabel);
            panel.add(architectLabel);
            panel.add(sqlpowerLabel);
            panel.add(bgLabel);
            return panel;
        }

        private LogoLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            JLabel bgLabel = (JLabel)parent.getComponent(3);
            JLabel welcomeLabel = (JLabel)parent.getComponent(0);
            JLabel architectLabel = (JLabel)parent.getComponent(1);
            JLabel sqlpowerLabel = (JLabel)parent.getComponent(2);
            int headerStartX = (parent.getWidth() - 800) / 2;
            bgLabel.setBounds(0, 0, parent.getWidth(), parent.getHeight());
            welcomeLabel.setBounds(headerStartX, 0, welcomeLabel.getPreferredSize().width, welcomeLabel.getPreferredSize().height);
            architectLabel.setBounds(welcomeLabel.getX() + welcomeLabel.getPreferredSize().width, 0, architectLabel.getPreferredSize().width, architectLabel.getPreferredSize().height);
            sqlpowerLabel.setBounds(headerStartX + 800 - sqlpowerLabel.getPreferredSize().width, 0, sqlpowerLabel.getPreferredSize().width, sqlpowerLabel.getPreferredSize().height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JLabel welcomeLabel = (JLabel)parent.getComponent(0);
            JLabel architectLabel = (JLabel)parent.getComponent(1);
            JLabel sqlpowerLabel = (JLabel)parent.getComponent(2);
            return new Dimension(welcomeLabel.getWidth() + architectLabel.getWidth() + sqlpowerLabel.getWidth(), Math.max(Math.max(welcomeLabel.getHeight(), architectLabel.getHeight()), sqlpowerLabel.getHeight()));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }
    }
}

