/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ActivityId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class ActivityCorrelator {
    private static Map<Long, ActivityId> activityIdTlsMap = new ConcurrentHashMap<Long, ActivityId>();

    static void cleanupActivityId() {
        activityIdTlsMap.entrySet().removeIf(e -> null == e.getValue() || null == ((ActivityId)e.getValue()).getThread() || ((ActivityId)e.getValue()).getThread() == Thread.currentThread() || !((ActivityId)e.getValue()).getThread().isAlive());
    }

    static ActivityId getCurrent() {
        Thread thread = Thread.currentThread();
        if (!activityIdTlsMap.containsKey(thread.getId())) {
            activityIdTlsMap.put(thread.getId(), new ActivityId(thread));
        }
        return activityIdTlsMap.get(thread.getId());
    }

    static ActivityId getNext() {
        ActivityId activityId = ActivityCorrelator.getCurrent();
        activityId.increment();
        return activityId;
    }

    static void setCurrentActivityIdSentFlag() {
        ActivityId activityId = ActivityCorrelator.getCurrent();
        activityId.setSentFlag();
    }

    static Map<Long, ActivityId> getActivityIdTlsMap() {
        return activityIdTlsMap;
    }

    private ActivityCorrelator() {
    }
}

