/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.Handlers;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class EagerFormParsingHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;
    private final FormParserFactory formParserFactory;
    public static final HandlerWrapper WRAPPER = new HandlerWrapper(){

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new EagerFormParsingHandler(handler);
        }
    };

    public EagerFormParsingHandler(FormParserFactory formParserFactory) {
        this.formParserFactory = formParserFactory;
    }

    public EagerFormParsingHandler() {
        this.formParserFactory = FormParserFactory.builder().build();
    }

    public EagerFormParsingHandler(HttpHandler next) {
        this();
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        FormDataParser parser = this.formParserFactory.createParser(exchange);
        if (parser == null) {
            this.next.handleRequest(exchange);
            return;
        }
        parser.parse(this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public EagerFormParsingHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "eager-form-parser";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return WRAPPER;
        }
    }
}

