/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.result.CompleteResult;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.QueryPacket;
import org.mariadb.jdbc.message.server.OkPacket;
import org.mariadb.jdbc.util.NativeSql;

public class Statement
implements java.sql.Statement {
    private static final Pattern identifierPattern = Pattern.compile("[0-9a-zA-Z\\$_\\u0080-\\uFFFF]*", 192);
    private static final Pattern escapePattern = Pattern.compile("[\u0000'\"\b\n\r\t\u001a\\\\]");
    private static final Map<String, String> mapper = new HashMap<String, String>();
    private List<String> batchQueries;
    protected final int resultSetType;
    protected final int resultSetConcurrency;
    protected final ReentrantLock lock;
    protected final boolean canUseServerTimeout;
    protected final boolean canUseServerMaxRows;
    protected final Connection con;
    protected int queryTimeout;
    protected long maxRows;
    protected int fetchSize;
    protected int autoGeneratedKeys;
    protected boolean closeOnCompletion;
    protected boolean closed;
    protected boolean escape;
    protected List<Completion> results;
    protected Completion currResult;
    protected InputStream localInfileInputStream;

    public Statement(Connection con, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) {
        this.con = con;
        this.lock = lock;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetType = resultSetType;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.canUseServerTimeout = canUseServerTimeout;
        this.canUseServerMaxRows = canUseServerMaxRows;
        this.fetchSize = defaultFetchSize;
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkNotClosed();
        this.localInfileInputStream = inputStream;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeInternal(sql, 2);
        this.currResult = this.results.remove(0);
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext());
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, 2);
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            if (this.currResult != null && this.currResult instanceof Result) {
                ((Result)this.currResult).closeFromStmtClose(this.lock);
            }
            if (this.results != null && !this.results.isEmpty()) {
                for (Completion completion : this.results) {
                    if (!(completion instanceof Result)) continue;
                    ((Result)completion).closeFromStmtClose(this.lock);
                }
            }
        }
    }

    public void abort() {
        this.lock.lock();
        try {
            if (!this.closed) {
                this.closed = true;
                if (this.currResult != null && this.currResult instanceof Result) {
                    ((Result)this.currResult).abort();
                }
                if (this.results != null) {
                    for (Completion completion : this.results) {
                        if (!(completion instanceof Result)) continue;
                        ((Result)completion).abort();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkNotClosed();
        return (int)this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkNotClosed();
        if (max < 0) {
            throw this.exceptionFactory().create("max rows cannot be negative : asked for " + max, "42000");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkNotClosed();
        this.escape = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkNotClosed();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw this.exceptionFactory().create("Query timeout cannot be negative : asked for " + seconds, "42000");
        }
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkNotClosed();
        boolean locked = this.lock.tryLock();
        if (!locked) {
            this.con.cancelCurrentQuery();
        } else {
            this.lock.unlock();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.con.getWarnings();
    }

    @Override
    public void clearWarnings() {
        this.con.getContext().setWarning(0);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw this.exceptionFactory().notSupported("Cursors are not supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, 2);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof OkPacket) {
            return (int)((OkPacket)this.currResult).getAffectedRows();
        }
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw this.exceptionFactory().create("invalid fetch size");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (sql == null) {
            throw this.exceptionFactory().create("null cannot be set to addBatch(String sql)");
        }
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        }
        this.batchQueries.add(this.escape ? NativeSql.parse(sql, this.con.getContext()) : sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        } else {
            this.batchQueries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchQueries == null || this.batchQueries.isEmpty()) {
            return new int[0];
        }
        this.lock.lock();
        try {
            boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
            if (possibleLoadLocal) {
                possibleLoadLocal = false;
                for (int i = 0; i < this.batchQueries.size(); ++i) {
                    String sql = this.batchQueries.get(i).toUpperCase(Locale.ROOT);
                    if (!sql.contains(" LOCAL ") || !sql.contains("LOAD") || !sql.contains(" INFILE")) continue;
                    possibleLoadLocal = true;
                    break;
                }
            }
            List<Completion> res = possibleLoadLocal ? this.executeInternalBatchStandard() : this.executeInternalBatchPipeline();
            this.results = res;
            int[] updates = new int[res.size()];
            for (int i = 0; i < res.size(); ++i) {
                updates[i] = res.get(i) instanceof OkPacket ? (int)((OkPacket)res.get(i)).getAffectedRows() : -2;
            }
            this.currResult = this.results.remove(0);
            this.batchQueries.clear();
            int[] nArray = updates;
            return nArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkNotClosed();
        return this.con;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof ResultSet) {
            this.lock.lock();
            try {
                Result result = (Result)this.currResult;
                if (current == 1) {
                    result.close();
                } else {
                    result.fetchRemaining();
                }
                if (result.streaming() && (this.con.getContext().getServerStatus() & 8) > 0) {
                    this.con.getClient().readStreamingResults(this.results, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (this.results.size() > 0) {
            this.currResult = this.results.remove(0);
            return this.currResult instanceof Result;
        }
        this.currResult = null;
        return false;
    }

    public void fetchRemaining() throws SQLException {
        if (this.currResult != null && this.currResult instanceof ResultSet) {
            Result result = (Result)this.currResult;
            result.fetchRemaining();
            if (result.streaming() && (this.con.getContext().getServerStatus() & 8) > 0) {
                this.con.getClient().readStreamingResults(this.results, 0, 0L, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion);
            }
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        OkPacket ok;
        this.checkNotClosed();
        if (this.autoGeneratedKeys != 1) {
            throw new SQLException("Cannot return generated keys: query was not set with Statement.RETURN_GENERATED_KEYS");
        }
        if (this.currResult instanceof OkPacket && (ok = (OkPacket)this.currResult).getLastInsertId() != 0L) {
            ArrayList<String[]> insertIds = new ArrayList<String[]>();
            insertIds.add(new String[]{String.valueOf(ok.getLastInsertId())});
            for (Completion result : this.results) {
                if (!(result instanceof OkPacket)) continue;
                insertIds.add(new String[]{String.valueOf(((OkPacket)result).getLastInsertId())});
            }
            String[][] ids = (String[][])insertIds.toArray((T[])new String[0][]);
            return CompleteResult.createResultSet("insert_id", DataType.BIGINT, ids, this.con.getContext(), 544);
        }
        return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext());
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeInternal(sql, autoGeneratedKeys);
        this.currResult = this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return (int)((OkPacket)this.currResult).getAffectedRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInternal(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        this.lock.lock();
        try {
            this.autoGeneratedKeys = autoGeneratedKeys;
            String cmd = this.escapeTimeout(sql);
            this.results = this.con.getClient().execute(new QueryPacket(cmd, this.localInfileInputStream), this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
        }
        finally {
            this.localInfileInputStream = null;
            this.lock.unlock();
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeInternal(sql, autoGeneratedKeys);
        this.currResult = this.results.remove(0);
        return this.currResult instanceof Result;
    }

    protected String escapeTimeout(String sql) throws SQLException {
        String escapedSql;
        String string = escapedSql = this.escape ? NativeSql.parse(sql, this.con.getContext()) : sql;
        if (this.queryTimeout != 0 && this.canUseServerTimeout) {
            if (this.canUseServerMaxRows && this.maxRows > 0L) {
                return "SET STATEMENT max_statement_time=" + this.queryTimeout + ", SQL_SELECT_LIMIT=" + this.maxRows + " FOR " + escapedSql;
            }
            return "SET STATEMENT max_statement_time=" + this.queryTimeout + " FOR " + escapedSql;
        }
        if (this.canUseServerMaxRows && this.maxRows > 0L) {
            return "SET STATEMENT SQL_SELECT_LIMIT=" + this.maxRows + " FOR " + escapedSql;
        }
        return escapedSql;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, 1);
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkNotClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkNotClosed();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw this.exceptionFactory().create("The receiver is not a wrapper and does not implement the interface", "42000");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        if (iface == null) {
            return false;
        }
        return iface.isInstance(this);
    }

    protected void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw this.exceptionFactory().create("Cannot do an operation on a closed statement");
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.executeLargeUpdate(sql, 2);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.executeInternal(sql, autoGeneratedKeys);
        this.currResult = this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.maxRows;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkNotClosed();
        if (max < 0L) {
            throw this.exceptionFactory().create("max rows cannot be negative : asked for " + max, "42000");
        }
        this.maxRows = max;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof OkPacket) {
            return (int)((OkPacket)this.currResult).getAffectedRows();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchQueries == null || this.batchQueries.isEmpty()) {
            return new long[0];
        }
        this.lock.lock();
        try {
            boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
            if (possibleLoadLocal) {
                String sql;
                for (int i = 0; !(i >= this.batchQueries.size() || (sql = this.batchQueries.get(i).toUpperCase(Locale.ROOT)).contains(" LOCAL ") && sql.contains("LOAD") && sql.contains(" INFILE")); ++i) {
                }
                possibleLoadLocal = false;
            }
            List<Completion> res = possibleLoadLocal ? this.executeInternalBatchStandard() : this.executeInternalBatchPipeline();
            this.results = res;
            long[] updates = new long[res.size()];
            for (int i = 0; i < res.size(); ++i) {
                updates[i] = ((OkPacket)res.get(i)).getAffectedRows();
            }
            this.currResult = this.results.remove(0);
            this.batchQueries.clear();
            long[] lArray = updates;
            return lArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Completion> executeInternalBatchPipeline() throws SQLException {
        ClientMessage[] packets = new QueryPacket[this.batchQueries.size()];
        for (int i = 0; i < this.batchQueries.size(); ++i) {
            String sql = this.batchQueries.get(i);
            packets[i] = new QueryPacket(sql);
        }
        return this.con.getClient().executePipeline(packets, this, 0, 0L, 1007, 1003, this.closeOnCompletion, false);
    }

    public List<Completion> executeInternalBatchStandard() throws SQLException {
        ArrayList<Completion> results = new ArrayList<Completion>();
        try {
            for (String batchQuery : this.batchQueries) {
                results.addAll(this.con.getClient().execute(new QueryPacket(batchQuery, this.localInfileInputStream), this, 0, 0L, 1007, 1003, this.closeOnCompletion, false));
            }
            ArrayList<Completion> arrayList = results;
            return arrayList;
        }
        catch (SQLException sqle) {
            int[] updateCounts = new int[this.batchQueries.size()];
            for (int i = 0; i < Math.min(results.size(), updateCounts.length); ++i) {
                Completion completion = (Completion)results.get(i);
                updateCounts[i] = completion instanceof OkPacket ? (int)((OkPacket)completion).getAffectedRows() : 0;
            }
            throw new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), updateCounts, (Throwable)sqle);
        }
        finally {
            this.localInfileInputStream = null;
        }
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        Matcher matcher = escapePattern.matcher(val);
        StringBuffer escapedVal = new StringBuffer("'");
        while (matcher.find()) {
            matcher.appendReplacement(escapedVal, mapper.get(matcher.group()));
        }
        matcher.appendTail(escapedVal);
        escapedVal.append("'");
        return escapedVal.toString();
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        if (this.isSimpleIdentifier(identifier)) {
            return alwaysQuote ? "`" + identifier + "`" : identifier;
        }
        if (identifier.contains("\u0000")) {
            throw this.exceptionFactory().create("Invalid name - containing u0000 character", "42000");
        }
        if (identifier.matches("^`.+`$")) {
            identifier = identifier.substring(1, identifier.length() - 1);
        }
        return "`" + identifier.replace("`", "``") + "`";
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return identifier != null && !identifier.isEmpty() && identifierPattern.matcher(identifier).matches();
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return "N'" + val.replace("'", "''") + "'";
    }

    static {
        mapper.put("\u0000", "\\0");
        mapper.put("'", "\\\\'");
        mapper.put("\"", "\\\\\"");
        mapper.put("\b", "\\\\b");
        mapper.put("\n", "\\\\n");
        mapper.put("\r", "\\\\r");
        mapper.put("\t", "\\\\t");
        mapper.put("\u001a", "\\\\Z");
        mapper.put("\\", "\\\\");
    }
}

