/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.installation;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.services.resources.RealmsResource;

public class KeycloakSamlClientInstallation
implements ClientInstallationProvider {
    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI baseUri) {
        SamlClient samlClient = new SamlClient(client);
        StringBuilder buffer = new StringBuilder();
        buffer.append("<keycloak-saml-adapter>\n");
        KeycloakSamlClientInstallation.baseXml(session, realm, client, baseUri, samlClient, buffer);
        buffer.append("</keycloak-saml-adapter>\n");
        return Response.ok((Object)buffer.toString(), (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public static void baseXml(KeycloakSession session, RealmModel realm, ClientModel client, URI baseUri, SamlClient samlClient, StringBuilder buffer) {
        buffer.append("    <SP entityID=\"").append(client.getBaseUrl() == null ? "SPECIFY YOUR entityID!" : client.getBaseUrl()).append("\"\n");
        buffer.append("        sslPolicy=\"").append(realm.getSslRequired().name()).append("\"\n");
        buffer.append("        logoutPage=\"SPECIFY YOUR LOGOUT PAGE!\">\n");
        if (samlClient.requiresClientSignature() || samlClient.requiresEncryption()) {
            buffer.append("        <Keys>\n");
            if (samlClient.requiresClientSignature()) {
                buffer.append("            <Key signing=\"true\">\n");
                buffer.append("                <PrivateKeyPem>\n");
                if (samlClient.getClientSigningPrivateKey() == null) {
                    buffer.append("                    PRIVATE KEY NOT SET UP OR KNOWN\n");
                } else {
                    buffer.append("                    ").append(samlClient.getClientSigningPrivateKey()).append("\n");
                }
                buffer.append("                </PrivateKeyPem>\n");
                buffer.append("                <CertificatePem>\n");
                if (samlClient.getClientSigningCertificate() == null) {
                    buffer.append("                    YOU MUST CONFIGURE YOUR CLIENT's SIGNING CERTIFICATE\n");
                } else {
                    buffer.append("                    ").append(samlClient.getClientSigningCertificate()).append("\n");
                }
                buffer.append("                </CertificatePem>\n");
                buffer.append("            </Key>\n");
            }
            if (samlClient.requiresEncryption()) {
                buffer.append("            <Key encryption=\"true\">\n");
                buffer.append("                <PrivateKeyPem>\n");
                if (samlClient.getClientEncryptingPrivateKey() == null) {
                    buffer.append("                    PRIVATE KEY NOT SET UP OR KNOWN\n");
                } else {
                    buffer.append("                    ").append(samlClient.getClientEncryptingPrivateKey()).append("\n");
                }
                buffer.append("                </PrivateKeyPem>\n");
                buffer.append("            </Key>\n");
            }
            buffer.append("        </Keys>\n");
        }
        buffer.append("        <IDP entityID=\"idp\"");
        if (samlClient.requiresClientSignature()) {
            buffer.append("\n             signatureAlgorithm=\"").append(samlClient.getSignatureAlgorithm()).append("\"");
            if (samlClient.getCanonicalizationMethod() != null) {
                buffer.append("\n             signatureCanonicalizationMethod=\"").append(samlClient.getCanonicalizationMethod()).append("\"");
            }
        }
        buffer.append(">\n");
        buffer.append("            <SingleSignOnService signRequest=\"").append(Boolean.toString(samlClient.requiresClientSignature())).append("\"\n");
        buffer.append("                                 validateResponseSignature=\"").append(Boolean.toString(samlClient.requiresRealmSignature())).append("\"\n");
        buffer.append("                                 validateAssertionSignature=\"").append(Boolean.toString(samlClient.requiresAssertionSignature())).append("\"\n");
        buffer.append("                                 requestBinding=\"POST\"\n");
        UriBuilder bindingUrlBuilder = UriBuilder.fromUri((URI)baseUri);
        String bindingUrl = RealmsResource.protocolUrl(bindingUrlBuilder).build(new Object[]{realm.getName(), "saml"}).toString();
        buffer.append("                                 bindingUrl=\"").append(bindingUrl).append("\"/>\n");
        buffer.append("            <SingleLogoutService signRequest=\"").append(Boolean.toString(samlClient.requiresClientSignature())).append("\"\n");
        buffer.append("                                 signResponse=\"").append(Boolean.toString(samlClient.requiresClientSignature())).append("\"\n");
        buffer.append("                                 validateRequestSignature=\"").append(Boolean.toString(samlClient.requiresRealmSignature())).append("\"\n");
        buffer.append("                                 validateResponseSignature=\"").append(Boolean.toString(samlClient.requiresRealmSignature())).append("\"\n");
        buffer.append("                                 requestBinding=\"POST\"\n");
        buffer.append("                                 responseBinding=\"POST\"\n");
        buffer.append("                                 postBindingUrl=\"").append(bindingUrl).append("\"\n");
        buffer.append("                                 redirectBindingUrl=\"").append(bindingUrl).append("\"");
        buffer.append("/>\n");
        buffer.append("        </IDP>\n");
        buffer.append("    </SP>\n");
    }

    public String getProtocol() {
        return "saml";
    }

    public String getDisplayType() {
        return "Keycloak SAML Adapter keycloak-saml.xml";
    }

    public String getHelpText() {
        return "Keycloak SAML adapter configuration file you must edit. Put this in WEB-INF directory of your WAR.";
    }

    public String getFilename() {
        return "keycloak-saml.xml";
    }

    public String getMediaType() {
        return "application/xml";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "keycloak-saml";
    }
}

