/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.context.AdminClientUpdateContext;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.context.DynamicClientRegisterContext;
import org.keycloak.services.clientpolicy.context.DynamicClientUpdateContext;

public class ClientUpdaterSourceGroupsCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    private static final Logger logger = Logger.getLogger(ClientUpdaterSourceGroupsCondition.class);

    public ClientUpdaterSourceGroupsCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "client-updater-source-groups";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: {
                if (context instanceof AdminClientRegisterContext) {
                    return this.getVoteForGroupsMatched(((ClientCRUDContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientRegisterContext) {
                    return this.getVoteForGroupsMatched(((ClientCRUDContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
            case UPDATE: {
                if (context instanceof AdminClientUpdateContext) {
                    return this.getVoteForGroupsMatched(((ClientCRUDContext)context).getAuthenticatedUser());
                }
                if (context instanceof DynamicClientUpdateContext) {
                    return this.getVoteForGroupsMatched(((ClientCRUDContext)context).getToken());
                }
                throw new ClientPolicyException("server_error", "unexpected context type.");
            }
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private ClientPolicyVote getVoteForGroupsMatched(UserModel user) {
        if (this.isGroupsMatched(user)) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private ClientPolicyVote getVoteForGroupsMatched(JsonWebToken token) {
        if (token == null) {
            return ClientPolicyVote.NO;
        }
        if (this.isGroupMatched(token.getSubject())) {
            return ClientPolicyVote.YES;
        }
        return ClientPolicyVote.NO;
    }

    private boolean isGroupMatched(String subjectId) {
        if (subjectId == null) {
            return false;
        }
        return this.isGroupsMatched(this.session.users().getUserById(this.session.getContext().getRealm(), subjectId));
    }

    private boolean isGroupsMatched(UserModel user) {
        if (user == null) {
            return false;
        }
        Set<String> expectedGroups = this.instantiateGroupsForMatching();
        if (expectedGroups == null) {
            return false;
        }
        Set<String> groups = user.getGroupsStream().map(GroupModel::getName).collect(Collectors.toSet());
        if (logger.isTraceEnabled()) {
            groups.forEach(i -> logger.tracev("user group = {0}", i));
            expectedGroups.forEach(i -> logger.tracev("expected user group = {0}", i));
        }
        return expectedGroups.removeAll(groups);
    }

    private Set<String> instantiateGroupsForMatching() {
        List<String> groups = ((Configuration)this.configuration).getGroups();
        if (groups == null) {
            return null;
        }
        return new HashSet<String>(groups);
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        protected List<String> groups;

        public List<String> getGroups() {
            return this.groups;
        }

        public void setGroups(List<String> groups) {
            this.groups = groups;
        }
    }
}

