/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.builder.Json;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.util.GlobUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class NativeImageResourceConfigStep {
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void generateResourceConfig(BuildProducer<GeneratedResourceBuildItem> resourceConfig, List<NativeImageResourcePatternsBuildItem> resourcePatterns, List<NativeImageResourceBundleBuildItem> resourceBundles, List<NativeImageResourceBuildItem> resources, List<ServiceProviderBuildItem> serviceProviderBuildItems) {
        Json.JsonObjectBuilder root = Json.object();
        Json.JsonObjectBuilder resourcesJs = Json.object();
        Json.JsonArrayBuilder includes = Json.array();
        Json.JsonArrayBuilder excludes = Json.array();
        for (NativeImageResourceBuildItem nativeImageResourceBuildItem : resources) {
            for (String path : nativeImageResourceBuildItem.getResources()) {
                Json.JsonObjectBuilder pat = Json.object();
                pat.put("pattern", GlobUtil.toRegexPattern((String)path));
                includes.add(pat);
            }
            this.addListToJsonArray(includes, nativeImageResourceBuildItem.getResources());
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            includes.add(Json.object().put("pattern", GlobUtil.toRegexPattern((String)serviceProviderBuildItem.serviceDescriptorFile())));
        }
        for (NativeImageResourcePatternsBuildItem nativeImageResourcePatternsBuildItem : resourcePatterns) {
            this.addListToJsonArray(includes, nativeImageResourcePatternsBuildItem.getIncludePatterns());
            this.addListToJsonArray(excludes, nativeImageResourcePatternsBuildItem.getExcludePatterns());
        }
        resourcesJs.put("includes", includes);
        resourcesJs.put("excludes", excludes);
        root.put("resources", resourcesJs);
        Json.JsonArrayBuilder bundles = Json.array();
        for (NativeImageResourceBundleBuildItem i : resourceBundles) {
            Json.JsonObjectBuilder bundle = Json.object();
            String moduleName = i.getModuleName();
            StringBuilder sb = new StringBuilder();
            if (moduleName != null) {
                sb.append(moduleName).append(":");
            }
            sb.append(i.getBundleName().replace("/", "."));
            bundle.put("name", sb.toString());
            bundles.add(bundle);
        }
        root.put("bundles", bundles);
        try (StringWriter stringWriter = new StringWriter();){
            root.appendTo((Appendable)stringWriter);
            resourceConfig.produce(new GeneratedResourceBuildItem("META-INF/native-image/resource-config.json", stringWriter.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void addListToJsonArray(Json.JsonArrayBuilder array, List<String> patterns) {
        for (String pattern : patterns) {
            Json.JsonObjectBuilder pat = Json.object();
            pat.put("pattern", pattern);
            array.add(pat);
        }
    }
}

