/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.AbstractAnnotationLiteral;
import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class AnnotationLiteralGenerator
extends AbstractGenerator {
    private static final Logger LOGGER = Logger.getLogger(AnnotationLiteralGenerator.class);
    private static final MethodDescriptor FLOAT_TO_INT_BITS = MethodDescriptor.ofMethod(Float.class, (String)"floatToIntBits", Integer.TYPE, (Class[])new Class[]{Float.TYPE});
    private static final MethodDescriptor DOUBLE_TO_LONG_BITS = MethodDescriptor.ofMethod(Double.class, (String)"doubleToLongBits", Long.TYPE, (Class[])new Class[]{Double.TYPE});
    private static final MethodDescriptor BOOLEAN_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{boolean[].class, boolean[].class});
    private static final MethodDescriptor BYTE_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{byte[].class, byte[].class});
    private static final MethodDescriptor SHORT_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{short[].class, short[].class});
    private static final MethodDescriptor INT_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{int[].class, int[].class});
    private static final MethodDescriptor LONG_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{long[].class, long[].class});
    private static final MethodDescriptor FLOAT_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{float[].class, float[].class});
    private static final MethodDescriptor DOUBLE_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{double[].class, double[].class});
    private static final MethodDescriptor CHAR_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{char[].class, char[].class});
    private static final MethodDescriptor OBJECT_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object[].class, Object[].class});
    private static final MethodDescriptor BOOLEAN_HASH_CODE = MethodDescriptor.ofMethod(Boolean.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{Boolean.TYPE});
    private static final MethodDescriptor BOOLEAN_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{boolean[].class});
    private static final MethodDescriptor BYTE_HASH_CODE = MethodDescriptor.ofMethod(Byte.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{Byte.TYPE});
    private static final MethodDescriptor BYTE_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{byte[].class});
    private static final MethodDescriptor SHORT_HASH_CODE = MethodDescriptor.ofMethod(Short.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{Short.TYPE});
    private static final MethodDescriptor SHORT_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{short[].class});
    private static final MethodDescriptor INT_HASH_CODE = MethodDescriptor.ofMethod(Integer.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{Integer.TYPE});
    private static final MethodDescriptor INT_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{int[].class});
    private static final MethodDescriptor LONG_HASH_CODE = MethodDescriptor.ofMethod(Long.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{Long.TYPE});
    private static final MethodDescriptor LONG_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{long[].class});
    private static final MethodDescriptor FLOAT_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{float[].class});
    private static final MethodDescriptor FLOAT_HASH_CODE = MethodDescriptor.ofMethod(Float.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{Float.TYPE});
    private static final MethodDescriptor DOUBLE_HASH_CODE = MethodDescriptor.ofMethod(Double.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{Double.TYPE});
    private static final MethodDescriptor DOUBLE_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{double[].class});
    private static final MethodDescriptor CHAR_HASH_CODE = MethodDescriptor.ofMethod(Character.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{Character.TYPE});
    private static final MethodDescriptor CHAR_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{char[].class});
    private static final MethodDescriptor OBJECT_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, (String)"hashCode", Integer.TYPE, (Class[])new Class[]{Object[].class});
    private static final MethodDescriptor BOOLEAN_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, (String)"toString", String.class, (Class[])new Class[]{boolean[].class});
    private static final MethodDescriptor BYTE_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, (String)"toString", String.class, (Class[])new Class[]{byte[].class});
    private static final MethodDescriptor SHORT_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, (String)"toString", String.class, (Class[])new Class[]{short[].class});
    private static final MethodDescriptor INT_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, (String)"toString", String.class, (Class[])new Class[]{int[].class});
    private static final MethodDescriptor LONG_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, (String)"toString", String.class, (Class[])new Class[]{long[].class});
    private static final MethodDescriptor FLOAT_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, (String)"toString", String.class, (Class[])new Class[]{float[].class});
    private static final MethodDescriptor DOUBLE_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, (String)"toString", String.class, (Class[])new Class[]{double[].class});
    private static final MethodDescriptor CHAR_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, (String)"toString", String.class, (Class[])new Class[]{char[].class});
    private static final MethodDescriptor OBJECT_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, (String)"toString", String.class, (Class[])new Class[]{Object[].class});

    AnnotationLiteralGenerator(boolean generateSources) {
        super(generateSources);
    }

    Collection<ResourceOutput.Resource> generate(ComputingCache<AnnotationLiteralProcessor.CacheKey, AnnotationLiteralProcessor.AnnotationLiteralClassInfo> cache, Set<String> existingClasses) {
        ArrayList<ResourceOutput.Resource> resources = new ArrayList<ResourceOutput.Resource>();
        cache.forEachExistingValue(literal -> {
            ResourceClassOutput classOutput = new ResourceClassOutput(literal.isApplicationClass, this.generateSources);
            this.createAnnotationLiteralClass(classOutput, (AnnotationLiteralProcessor.AnnotationLiteralClassInfo)literal, existingClasses);
            resources.addAll(classOutput.getResources());
        });
        return resources;
    }

    Collection<Future<Collection<ResourceOutput.Resource>>> generate(ComputingCache<AnnotationLiteralProcessor.CacheKey, AnnotationLiteralProcessor.AnnotationLiteralClassInfo> cache, final Set<String> existingClasses, ExecutorService executor) {
        ArrayList<Future<Collection<ResourceOutput.Resource>>> futures = new ArrayList<Future<Collection<ResourceOutput.Resource>>>();
        cache.forEachExistingValue(literal -> futures.add(executor.submit(new Callable<Collection<ResourceOutput.Resource>>(){

            @Override
            public Collection<ResourceOutput.Resource> call() throws Exception {
                ResourceClassOutput classOutput = new ResourceClassOutput(literal.isApplicationClass, AnnotationLiteralGenerator.this.generateSources);
                AnnotationLiteralGenerator.this.createAnnotationLiteralClass(classOutput, literal, existingClasses);
                return classOutput.getResources();
            }
        })));
        return futures;
    }

    private void createAnnotationLiteralClass(ClassOutput classOutput, AnnotationLiteralProcessor.AnnotationLiteralClassInfo literal, Set<String> existingClasses) {
        String generatedName = literal.generatedClassName.replace('.', '/');
        if (existingClasses.contains(generatedName)) {
            return;
        }
        ClassCreator annotationLiteral = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(AbstractAnnotationLiteral.class).interfaces(new String[]{literal.annotationName().toString()}).build();
        MethodCreator constructor = annotationLiteral.getMethodCreator("<init>", (Object)"V", literal.annotationMembers().stream().map(m -> m.returnType().name().toString()).toArray());
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(AbstractAnnotationLiteral.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
        int constructorParameterIndex = 0;
        for (MethodInfo annotationMember : literal.annotationMembers()) {
            String type = annotationMember.returnType().name().toString();
            FieldDescriptor field = FieldDescriptor.of((String)annotationLiteral.getClassName(), (String)annotationMember.name(), (String)type);
            annotationLiteral.getFieldCreator(field).setModifiers(18);
            constructor.writeInstanceField(field, constructor.getThis(), constructor.getMethodParam(constructorParameterIndex));
            MethodCreator value = (MethodCreator)annotationLiteral.getMethodCreator(annotationMember.name(), type, new String[0]).setModifiers(1);
            value.returnValue(value.readInstanceField(field, value.getThis()));
            ++constructorParameterIndex;
        }
        constructor.returnVoid();
        MethodCreator annotationType = (MethodCreator)annotationLiteral.getMethodCreator("annotationType", Class.class, new Class[0]).setModifiers(1);
        annotationType.returnValue(annotationType.loadClass(literal.annotationClass));
        if (literal.annotationMembers().isEmpty()) {
            constructor.setModifiers(2);
            FieldCreator singleton = annotationLiteral.getFieldCreator("INSTANCE", generatedName);
            singleton.setModifiers(25);
            MethodCreator staticInit = annotationLiteral.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            staticInit.setModifiers(8);
            ResultHandle singletonInstance = staticInit.newInstance(constructor.getMethodDescriptor(), new ResultHandle[0]);
            staticInit.writeStaticField(singleton.getFieldDescriptor(), singletonInstance);
            staticInit.returnVoid();
        } else {
            AnnotationLiteralGenerator.generateStaticFieldsWithDefaultValues(annotationLiteral, literal.annotationMembers());
        }
        AnnotationLiteralGenerator.generateEquals(annotationLiteral, literal);
        AnnotationLiteralGenerator.generateHashCode(annotationLiteral, literal);
        AnnotationLiteralGenerator.generateToString(annotationLiteral, literal);
        annotationLiteral.close();
        LOGGER.debugf("Annotation literal class generated: %s", (Object)literal.generatedClassName);
    }

    static String defaultValueStaticFieldName(MethodInfo annotationMember) {
        return annotationMember.name() + "_default_value";
    }

    private static boolean returnsClassOrClassArray(MethodInfo annotationMember) {
        boolean returnsClass = DotNames.CLASS.equals((Object)annotationMember.returnType().name());
        boolean returnsClassArray = annotationMember.returnType().kind() == Type.Kind.ARRAY && DotNames.CLASS.equals((Object)annotationMember.returnType().asArrayType().constituent().name());
        return returnsClass || returnsClassArray;
    }

    private static void generateStaticFieldsWithDefaultValues(ClassCreator classCreator, List<MethodInfo> annotationMembers) {
        ArrayList<MethodInfo> defaultOfClassType = new ArrayList<MethodInfo>();
        for (MethodInfo annotationMember : annotationMembers) {
            if (annotationMember.defaultValue() == null || !AnnotationLiteralGenerator.returnsClassOrClassArray(annotationMember)) continue;
            defaultOfClassType.add(annotationMember);
        }
        if (defaultOfClassType.isEmpty()) {
            return;
        }
        MethodCreator staticConstructor = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
        staticConstructor.setModifiers(8);
        for (MethodInfo annotationMember : defaultOfClassType) {
            String type = annotationMember.returnType().name().toString();
            AnnotationValue defaultValue = annotationMember.defaultValue();
            FieldCreator fieldCreator = classCreator.getFieldCreator(AnnotationLiteralGenerator.defaultValueStaticFieldName(annotationMember), type);
            fieldCreator.setModifiers(25);
            if (defaultValue.kind() == AnnotationValue.Kind.ARRAY) {
                Type[] clazzArray = defaultValue.asClassArray();
                ResultHandle array = staticConstructor.newArray(type, clazzArray.length);
                for (int i = 0; i < clazzArray.length; ++i) {
                    staticConstructor.writeArrayValue(array, staticConstructor.load(i), staticConstructor.loadClass(clazzArray[i].name().toString()));
                }
                staticConstructor.writeStaticField(fieldCreator.getFieldDescriptor(), array);
                continue;
            }
            staticConstructor.writeStaticField(fieldCreator.getFieldDescriptor(), staticConstructor.loadClass(defaultValue.asClass().name().toString()));
        }
        staticConstructor.returnVoid();
    }

    private static void generateEquals(ClassCreator clazz, AnnotationLiteralProcessor.AnnotationLiteralClassInfo literal) {
        MethodCreator equals = clazz.getMethodCreator("equals", Boolean.TYPE, new Class[]{Object.class});
        equals.ifReferencesNotEqual(equals.getThis(), equals.getMethodParam(0)).falseBranch().returnBoolean(true);
        if (literal.annotationMembers().isEmpty()) {
            equals.ifTrue(equals.instanceOf(equals.getMethodParam(0), Annotation.class)).falseBranch().returnBoolean(false);
            ResultHandle thisAnnType = equals.loadClass(literal.annotationClass);
            ResultHandle otherAnnType = equals.invokeInterfaceMethod(MethodDescriptor.ofMethod(Annotation.class, (String)"annotationType", Class.class, (Class[])new Class[0]), equals.getMethodParam(0), new ResultHandle[0]);
            equals.returnValue(Gizmo.equals((BytecodeCreator)equals, (ResultHandle)thisAnnType, (ResultHandle)otherAnnType));
        }
        equals.ifTrue(equals.instanceOf(equals.getMethodParam(0), literal.annotationClass.name().toString())).falseBranch().returnBoolean(false);
        ResultHandle other = equals.checkCast(equals.getMethodParam(0), literal.annotationClass.name().toString());
        block32: for (MethodInfo annotationMember : literal.annotationMembers()) {
            String type = annotationMember.returnType().name().toString();
            FieldDescriptor field = FieldDescriptor.of((String)clazz.getClassName(), (String)annotationMember.name(), (String)type);
            ResultHandle thisValue = equals.readInstanceField(field, equals.getThis());
            ResultHandle thatValue = equals.invokeInterfaceMethod(annotationMember, other, new ResultHandle[0]);
            switch (field.getType()) {
                case "Z": 
                case "B": 
                case "S": 
                case "I": 
                case "C": {
                    equals.ifIntegerEqual(thisValue, thatValue).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "J": {
                    equals.ifZero(equals.compareLong(thisValue, thatValue)).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "F": {
                    equals.ifIntegerEqual(equals.invokeStaticMethod(FLOAT_TO_INT_BITS, new ResultHandle[]{thisValue}), equals.invokeStaticMethod(FLOAT_TO_INT_BITS, new ResultHandle[]{thatValue})).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "D": {
                    equals.ifZero(equals.compareLong(equals.invokeStaticMethod(DOUBLE_TO_LONG_BITS, new ResultHandle[]{thisValue}), equals.invokeStaticMethod(DOUBLE_TO_LONG_BITS, new ResultHandle[]{thatValue}))).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "[Z": {
                    equals.ifTrue(equals.invokeStaticMethod(BOOLEAN_ARRAY_EQUALS, new ResultHandle[]{thisValue, thatValue})).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "[B": {
                    equals.ifTrue(equals.invokeStaticMethod(BYTE_ARRAY_EQUALS, new ResultHandle[]{thisValue, thatValue})).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "[S": {
                    equals.ifTrue(equals.invokeStaticMethod(SHORT_ARRAY_EQUALS, new ResultHandle[]{thisValue, thatValue})).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "[I": {
                    equals.ifTrue(equals.invokeStaticMethod(INT_ARRAY_EQUALS, new ResultHandle[]{thisValue, thatValue})).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "[J": {
                    equals.ifTrue(equals.invokeStaticMethod(LONG_ARRAY_EQUALS, new ResultHandle[]{thisValue, thatValue})).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "[F": {
                    equals.ifTrue(equals.invokeStaticMethod(FLOAT_ARRAY_EQUALS, new ResultHandle[]{thisValue, thatValue})).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "[D": {
                    equals.ifTrue(equals.invokeStaticMethod(DOUBLE_ARRAY_EQUALS, new ResultHandle[]{thisValue, thatValue})).falseBranch().returnBoolean(false);
                    continue block32;
                }
                case "[C": {
                    equals.ifTrue(equals.invokeStaticMethod(CHAR_ARRAY_EQUALS, new ResultHandle[]{thisValue, thatValue})).falseBranch().returnBoolean(false);
                    continue block32;
                }
            }
            if (field.getType().startsWith("L")) {
                equals.ifTrue(equals.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, thisValue, new ResultHandle[]{thatValue})).falseBranch().returnBoolean(false);
                continue;
            }
            if (field.getType().startsWith("[L")) {
                equals.ifTrue(equals.invokeStaticMethod(OBJECT_ARRAY_EQUALS, new ResultHandle[]{thisValue, thatValue})).falseBranch().returnBoolean(false);
                continue;
            }
            throw new IllegalArgumentException("Invalid annotation member: " + field);
        }
        equals.returnBoolean(true);
    }

    private static void generateHashCode(ClassCreator clazz, AnnotationLiteralProcessor.AnnotationLiteralClassInfo literal) {
        MethodCreator hashCode = clazz.getMethodCreator("hashCode", Integer.TYPE, new Class[0]);
        if (literal.annotationMembers().isEmpty()) {
            hashCode.returnInt(0);
        }
        AssignableResultHandle result = hashCode.createVariable(Integer.TYPE);
        hashCode.assign(result, hashCode.load(0));
        for (MethodInfo annotationMember : literal.annotationMembers()) {
            ResultHandle memberValueHash;
            ResultHandle memberName = hashCode.load(annotationMember.name());
            ResultHandle memberNameHash = hashCode.multiply(hashCode.load(127), hashCode.invokeVirtualMethod(MethodDescriptors.OBJECT_HASH_CODE, memberName, new ResultHandle[0]));
            String type = annotationMember.returnType().name().toString();
            FieldDescriptor field = FieldDescriptor.of((String)clazz.getClassName(), (String)annotationMember.name(), (String)type);
            ResultHandle value = hashCode.readInstanceField(field, hashCode.getThis());
            switch (field.getType()) {
                case "Z": {
                    memberValueHash = hashCode.invokeStaticMethod(BOOLEAN_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "B": {
                    memberValueHash = hashCode.invokeStaticMethod(BYTE_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "S": {
                    memberValueHash = hashCode.invokeStaticMethod(SHORT_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "I": {
                    memberValueHash = hashCode.invokeStaticMethod(INT_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "J": {
                    memberValueHash = hashCode.invokeStaticMethod(LONG_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "F": {
                    memberValueHash = hashCode.invokeStaticMethod(FLOAT_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "D": {
                    memberValueHash = hashCode.invokeStaticMethod(DOUBLE_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "C": {
                    memberValueHash = hashCode.invokeStaticMethod(CHAR_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "[Z": {
                    memberValueHash = hashCode.invokeStaticMethod(BOOLEAN_ARRAY_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "[B": {
                    memberValueHash = hashCode.invokeStaticMethod(BYTE_ARRAY_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "[S": {
                    memberValueHash = hashCode.invokeStaticMethod(SHORT_ARRAY_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "[I": {
                    memberValueHash = hashCode.invokeStaticMethod(INT_ARRAY_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "[J": {
                    memberValueHash = hashCode.invokeStaticMethod(LONG_ARRAY_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "[F": {
                    memberValueHash = hashCode.invokeStaticMethod(FLOAT_ARRAY_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "[D": {
                    memberValueHash = hashCode.invokeStaticMethod(DOUBLE_ARRAY_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                case "[C": {
                    memberValueHash = hashCode.invokeStaticMethod(CHAR_ARRAY_HASH_CODE, new ResultHandle[]{value});
                    break;
                }
                default: {
                    if (field.getType().startsWith("L")) {
                        memberValueHash = hashCode.invokeVirtualMethod(MethodDescriptors.OBJECT_HASH_CODE, value, new ResultHandle[0]);
                        break;
                    }
                    if (field.getType().startsWith("[L")) {
                        memberValueHash = hashCode.invokeStaticMethod(OBJECT_ARRAY_HASH_CODE, new ResultHandle[]{value});
                        break;
                    }
                    throw new IllegalArgumentException("Invalid annotation member: " + field);
                }
            }
            ResultHandle xor = hashCode.bitwiseXor(memberNameHash, memberValueHash);
            hashCode.assign(result, hashCode.add((ResultHandle)result, xor));
        }
        hashCode.returnValue((ResultHandle)result);
    }

    private static void generateToString(ClassCreator clazz, AnnotationLiteralProcessor.AnnotationLiteralClassInfo literal) {
        MethodCreator toString = clazz.getMethodCreator("toString", String.class, new Class[0]);
        if (literal.annotationMembers().isEmpty()) {
            toString.returnValue(toString.load("@" + literal.annotationClass.name().toString() + "()"));
        }
        Gizmo.StringBuilderGenerator str = Gizmo.newStringBuilder((BytecodeCreator)toString);
        str.append("@" + literal.annotationClass.name().toString() + "(");
        boolean first = true;
        for (MethodInfo annotationMember : literal.annotationMembers()) {
            if (first) {
                str.append(annotationMember.name() + "=");
            } else {
                str.append(", " + annotationMember.name() + "=");
            }
            String type = annotationMember.returnType().name().toString();
            FieldDescriptor field = FieldDescriptor.of((String)clazz.getClassName(), (String)annotationMember.name(), (String)type);
            ResultHandle value = toString.readInstanceField(field, toString.getThis());
            switch (field.getType()) {
                case "[Z": {
                    str.append(toString.invokeStaticMethod(BOOLEAN_ARRAY_TO_STRING, new ResultHandle[]{value}));
                    break;
                }
                case "[B": {
                    str.append(toString.invokeStaticMethod(BYTE_ARRAY_TO_STRING, new ResultHandle[]{value}));
                    break;
                }
                case "[S": {
                    str.append(toString.invokeStaticMethod(SHORT_ARRAY_TO_STRING, new ResultHandle[]{value}));
                    break;
                }
                case "[I": {
                    str.append(toString.invokeStaticMethod(INT_ARRAY_TO_STRING, new ResultHandle[]{value}));
                    break;
                }
                case "[J": {
                    str.append(toString.invokeStaticMethod(LONG_ARRAY_TO_STRING, new ResultHandle[]{value}));
                    break;
                }
                case "[F": {
                    str.append(toString.invokeStaticMethod(FLOAT_ARRAY_TO_STRING, new ResultHandle[]{value}));
                    break;
                }
                case "[D": {
                    str.append(toString.invokeStaticMethod(DOUBLE_ARRAY_TO_STRING, new ResultHandle[]{value}));
                    break;
                }
                case "[C": {
                    str.append(toString.invokeStaticMethod(CHAR_ARRAY_TO_STRING, new ResultHandle[]{value}));
                    break;
                }
                default: {
                    if (field.getType().startsWith("[L")) {
                        str.append(toString.invokeStaticMethod(OBJECT_ARRAY_TO_STRING, new ResultHandle[]{value}));
                        break;
                    }
                    if (field.getType().startsWith("[[")) {
                        throw new IllegalArgumentException("Invalid annotation member: " + field);
                    }
                    str.append(value);
                }
            }
            first = false;
        }
        str.append(')');
        toString.returnValue(str.callToString());
    }
}

