#!/usr/bin/perl
#
# Copyright (c) 2006 Zmanda Inc.  All Rights Reserved.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Contact information: Zmanda Inc, 505 N Mathlida Ave, Suite 120
# Sunnyvale, CA 94085, USA, or: http://www.zmanda.com
#

# This file contains template for binary log parser plugin that can be 
# used with Zmanda Recovery Manager (ZRM) for MySQL. For more information 
# about the product, please see http://mysqlbackup.zmanda.com/
#
# This plugin can be used to filter the output for "parse-binlogs" action
# of mysql-zrm(1) command. This plugin is passed as parameter 
# "parse-binlogs-plugin" to mysql-zrm tool.
#
# Parameters passed to the plugin
# -------------------------------
# First parameter is the value of "parse-binlogs-plugin-options" parameter
# that was passed to mysql-zrm(1) command.
# Second parameter is one complete binary log entry.
#
# Return values
# -------------
# The plugin should return 0 if the log entry should be displayed 
# and return 1 if the entry should not be displayed.
#
# How to use this plugin
# ----------------------
# 1. Make modifications to the plugin. The default plugin displays all
#    log events.
# 2. Execute mysql-zrm(1) command with "parse-binlogs" as action, 
#    "/usr/share/mysql-zrm/plugins/parse-binlogs.pl" as "parse-binlogs-plugin".
#    

# @fields = split ( / \| /, $ARGV[0] );

# fields[1] binary log filename
# fields[2] log position
# fields[3] timestamp of when the event occurred.
#           example format - 06-09-19 06:20:03
# fields[4] Event type.
#           Common values are "Query", "Stop", "Start", "Rotate", "Xid".
#           "Start", "Stop", "Rotate" refer to start, stop, rotate binary logs
#           "Xid" is transaction id (indicates transaction completion)
#           "Query" is the event corresponding to SQL statement execution


# This plugin will just print all of the inputs and exit with return value 0
foreach( @ARGV ){
	print "$_\n";
}
exit(1);
