/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17113410740376218357ul, 18446744073709551531ul, 18446744073709551522ul)
 * (0ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(18446744073709551449ul, 18446744073709551550ul, 18446744073709551429ul)
 * (3ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17113410740376218360ul, 18446744073709551534ul, 18446744073709551525ul)
 * (3ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(18446744073709551452ul, 18446744073709551553ul, 18446744073709551432ul)
 * (1192ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17113410740376219549ul, 1107ul, 1098ul)
 * (1192ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(1025ul, 1126ul, 1005ul)
 * (1048576ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17113410740377266933ul, 1048491ul, 1048482ul)
 * (1048576ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(1048409ul, 1048510ul, 1048389ul)
 * (4251475ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17113410740380469832ul, 4251390ul, 4251381ul)
 * (4251475ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(4251308ul, 4251409ul, 4251288ul)
 * (29852643761ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17113410770228862118ul, 29852643676ul, 29852643667ul)
 * (29852643761ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(29852643594ul, 29852643695ul, 29852643574ul)
 * (4398046511104ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17113415138422729461ul, 4398046511019ul, 4398046511010ul)
 * (4398046511104ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(4398046510937ul, 4398046511038ul, 4398046510917ul)
 * (3948976685146ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17113414689352903503ul, 3948976685061ul, 3948976685052ul)
 * (3948976685146ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(3948976684979ul, 3948976685080ul, 3948976684959ul)
 * (135763469567146206ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(17249174209943364563ul, 135763469567146121ul, 135763469567146112ul)
 * (135763469567146206ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(135763469567146039ul, 135763469567146140ul, 135763469567146019ul)
 * (11654173250180970009ul - u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(10320839916847636750ul, 11654173250180969924ul, 11654173250180969915ul)
 * (11654173250180970009ul - u64vec3(167ul, 66ul, 187ul)) => u64vec3(11654173250180969842ul, 11654173250180969943ul, 11654173250180969822ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17113410740376218357ul, 18446744073709551531ul, 18446744073709551522ul))) ? 1 : -1] array0;
  float[all(equal((0ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(18446744073709551449ul, 18446744073709551550ul, 18446744073709551429ul))) ? 1 : -1] array1;
  float[all(equal((3ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17113410740376218360ul, 18446744073709551534ul, 18446744073709551525ul))) ? 1 : -1] array2;
  float[all(equal((3ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(18446744073709551452ul, 18446744073709551553ul, 18446744073709551432ul))) ? 1 : -1] array3;
  float[all(equal((1192ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17113410740376219549ul, 1107ul, 1098ul))) ? 1 : -1] array4;
  float[all(equal((1192ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(1025ul, 1126ul, 1005ul))) ? 1 : -1] array5;
  float[all(equal((1048576ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17113410740377266933ul, 1048491ul, 1048482ul))) ? 1 : -1] array6;
  float[all(equal((1048576ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(1048409ul, 1048510ul, 1048389ul))) ? 1 : -1] array7;
  float[all(equal((4251475ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17113410740380469832ul, 4251390ul, 4251381ul))) ? 1 : -1] array8;
  float[all(equal((4251475ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(4251308ul, 4251409ul, 4251288ul))) ? 1 : -1] array9;
  float[all(equal((29852643761ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17113410770228862118ul, 29852643676ul, 29852643667ul))) ? 1 : -1] array10;
  float[all(equal((29852643761ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(29852643594ul, 29852643695ul, 29852643574ul))) ? 1 : -1] array11;
  float[all(equal((4398046511104ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17113415138422729461ul, 4398046511019ul, 4398046511010ul))) ? 1 : -1] array12;
  float[all(equal((4398046511104ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(4398046510937ul, 4398046511038ul, 4398046510917ul))) ? 1 : -1] array13;
  float[all(equal((3948976685146ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17113414689352903503ul, 3948976685061ul, 3948976685052ul))) ? 1 : -1] array14;
  float[all(equal((3948976685146ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(3948976684979ul, 3948976685080ul, 3948976684959ul))) ? 1 : -1] array15;
  float[all(equal((135763469567146206ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(17249174209943364563ul, 135763469567146121ul, 135763469567146112ul))) ? 1 : -1] array16;
  float[all(equal((135763469567146206ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(135763469567146039ul, 135763469567146140ul, 135763469567146019ul))) ? 1 : -1] array17;
  float[all(equal((11654173250180970009ul - u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(10320839916847636750ul, 11654173250180969924ul, 11654173250180969915ul))) ? 1 : -1] array18;
  float[all(equal((11654173250180970009ul - u64vec3(167ul, 66ul, 187ul)), u64vec3(11654173250180969842ul, 11654173250180969943ul, 11654173250180969822ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
