/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.cluster.placement.PlacementException;

public class PlacementModificationException
extends PlacementException {
    private final Map<String, String> rejectedModifications = new HashMap<String, String>();

    public PlacementModificationException() {
    }

    public PlacementModificationException(String message) {
        super(message);
    }

    public PlacementModificationException(String message, Throwable cause) {
        super(message, cause);
    }

    public PlacementModificationException(Throwable cause) {
        super(cause);
    }

    public void addRejectedModification(String modification, String reason) {
        this.rejectedModifications.put(modification, reason);
    }

    public Map<String, String> getRejectedModifications() {
        return this.rejectedModifications;
    }

    @Override
    public String getMessage() {
        if (this.rejectedModifications.isEmpty()) {
            return super.getMessage();
        }
        StringBuilder sb = new StringBuilder(super.getMessage());
        sb.append(": ").append(this.rejectedModifications.size()).append(" rejections:");
        this.rejectedModifications.forEach((modification, reason) -> sb.append("\n").append((String)modification).append("\t").append((String)reason));
        return sb.toString();
    }
}

