/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.TransientSolrCores;
import org.apache.solr.logging.MDCLoggingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCores {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final Object modifyLock = new Object();
    private final Map<String, SolrCore> cores = new LinkedHashMap<String, SolrCore>();
    private final Map<String, CoreDescriptor> residentDescriptors = new LinkedHashMap<String, CoreDescriptor>();
    private final CoreContainer container;
    private final Set<String> currentlyLoadingCores = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> pendingCoreOps = new HashSet<String>();
    private final List<SolrCore> pendingCloses = new ArrayList<SolrCore>();

    public static SolrCores newSolrCores(CoreContainer coreContainer) {
        int transientCacheSize = coreContainer.getConfig().getTransientCacheSize();
        if (transientCacheSize > 0) {
            return new TransientSolrCores(coreContainer, transientCacheSize);
        }
        return new SolrCores(coreContainer);
    }

    SolrCores(CoreContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCoreDescriptor(CoreDescriptor p) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.residentDescriptors.put(p.getName(), p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCoreDescriptor(CoreDescriptor p) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.residentDescriptors.remove(p.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.waitForLoadingCoresToFinish(30000L);
        block6: while (true) {
            ArrayList<SolrCore> coreList = new ArrayList<SolrCore>();
            Object object = this.modifyLock;
            synchronized (object) {
                for (String name : this.getLoadedCoreNames()) {
                    SolrCore core = this.remove(name);
                    if (core == null) continue;
                    coreList.add(core);
                }
                coreList.addAll(this.pendingCloses);
                this.pendingCloses.clear();
            }
            if (coreList.isEmpty()) break;
            ExecutorService coreCloseExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)Integer.MAX_VALUE, (ThreadFactory)new SolrNamedThreadFactory("coreCloseExecutor"));
            try {
                Iterator<String> iterator = coreList.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block6;
                    SolrCore core = (SolrCore)((Object)iterator.next());
                    coreCloseExecutor.execute(() -> {
                        MDCLoggingContext.setCore(core);
                        try {
                            core.close();
                        }
                        catch (Throwable e) {
                            SolrException.log((Logger)log, (String)"Error shutting down core", (Throwable)e);
                            if (e instanceof Error) {
                                throw (Error)e;
                            }
                        }
                        finally {
                            MDCLoggingContext.clear();
                        }
                    });
                }
            }
            finally {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreCloseExecutor);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore putCore(CoreDescriptor cd, SolrCore core) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.addCoreDescriptor(cd);
            return this.cores.put(cd.getName(), core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<SolrCore> getCores() {
        Object object = this.modifyLock;
        synchronized (object) {
            return new ArrayList<SolrCore>(this.cores.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLoadedCoreNames() {
        Object object = this.modifyLock;
        synchronized (object) {
            return new ArrayList<String>(this.cores.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllCoreNames() {
        Object object = this.modifyLock;
        synchronized (object) {
            return new ArrayList<String>(this.residentDescriptors.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLoadedPermanentCores() {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.cores.size();
        }
    }

    public int getNumLoadedTransientCores() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumUnloadedCores() {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.residentDescriptors.size() - this.cores.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumAllCores() {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.residentDescriptors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(String n0, String n1) {
        Object object = this.modifyLock;
        synchronized (object) {
            SolrCore c0 = this.cores.get(n0);
            SolrCore c1 = this.cores.get(n1);
            if (c0 == null && (c0 = this.container.getCore(n0)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n0);
            }
            if (c1 == null && (c1 = this.container.getCore(n1)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n1);
            }
            CoreDescriptor cd1 = c1.getCoreDescriptor();
            this.addCoreDescriptor(new CoreDescriptor(n1, c0.getCoreDescriptor()));
            this.addCoreDescriptor(new CoreDescriptor(n0, cd1));
            this.cores.put(n0, c1);
            this.cores.put(n1, c0);
            c0.setName(n1);
            c1.setName(n0);
            this.container.getMetricManager().swapRegistries(c0.getCoreMetricManager().getRegistryName(), c1.getCoreMetricManager().getRegistryName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore remove(String name) {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.cores.remove(name);
        }
    }

    public SolrCore getCoreFromAnyList(String name, boolean incRefCount) {
        return this.getCoreFromAnyList(name, incRefCount, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCoreFromAnyList(String name, boolean incRefCount, UUID coreId) {
        Object object = this.modifyLock;
        synchronized (object) {
            SolrCore core = this.getLoadedCoreWithoutIncrement(name);
            if (core != null && coreId != null && !coreId.equals(core.uniqueId)) {
                return null;
            }
            if (core != null && incRefCount) {
                core.open();
            }
            return core;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore getLoadedCoreWithoutIncrement(String name) {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.cores.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoadedNotPendingClose(String name) {
        Object object = this.modifyLock;
        synchronized (object) {
            if (!this.isLoaded(name)) {
                return false;
            }
            for (SolrCore core : this.pendingCloses) {
                if (!core.getName().equals(name)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoaded(String name) {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.cores.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPendingCoreOps(String name) {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.pendingCoreOps.contains(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore waitAddPendingCoreOps(String name) {
        Object object = this.modifyLock;
        synchronized (object) {
            boolean pending;
            do {
                if (!(pending = this.pendingCoreOps.contains(name))) {
                    for (SolrCore core : this.pendingCloses) {
                        if (!core.getName().equals(name)) continue;
                        pending = true;
                        break;
                    }
                }
                if (this.container.isShutDown()) {
                    return null;
                }
                if (!pending) continue;
                try {
                    this.modifyLock.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            } while (pending);
            if (!this.container.isShutDown()) {
                if (!this.pendingCoreOps.add(name)) {
                    log.warn("Replaced an entry in pendingCoreOps {}, we should not be doing this", (Object)name);
                }
                return this.getCoreFromAnyList(name, false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromPendingOps(String name) {
        Object object = this.modifyLock;
        synchronized (object) {
            if (!this.pendingCoreOps.remove(name)) {
                log.warn("Tried to remove core {} from pendingCoreOps and it wasn't there. ", (Object)name);
            }
            this.modifyLock.notifyAll();
        }
    }

    public Object getModifyLock() {
        return this.modifyLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCoreToClose() {
        Object object = this.modifyLock;
        synchronized (object) {
            for (SolrCore core : this.pendingCloses) {
                if (this.pendingCoreOps.contains(core.getName())) continue;
                this.pendingCoreOps.add(core.getName());
                this.pendingCloses.remove(core);
                return core;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDescriptor getCoreDescriptor(String coreName) {
        Object object = this.modifyLock;
        synchronized (object) {
            return this.residentDescriptors.get(coreName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CoreDescriptor> getCoreDescriptors() {
        Object object = this.modifyLock;
        synchronized (object) {
            return new ArrayList<CoreDescriptor>(this.residentDescriptors.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCoreAsLoading(CoreDescriptor cd) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.currentlyLoadingCores.add(cd.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCoreAsNotLoading(CoreDescriptor cd) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.currentlyLoadingCores.remove(cd.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoadingCoresToFinish(long timeoutMs) {
        long time = System.nanoTime();
        long timeout = time + TimeUnit.NANOSECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS);
        Object object = this.modifyLock;
        synchronized (object) {
            while (!this.currentlyLoadingCores.isEmpty()) {
                try {
                    this.modifyLock.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (System.nanoTime() < timeout) continue;
                log.warn("Timed out waiting for SolrCores to finish loading.");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoadingCoreToFinish(String core, long timeoutMs) {
        long time = System.nanoTime();
        long timeout = time + TimeUnit.NANOSECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS);
        Object object = this.modifyLock;
        synchronized (object) {
            while (this.isCoreLoading(core)) {
                try {
                    this.modifyLock.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (System.nanoTime() < timeout) continue;
                log.warn("Timed out waiting for SolrCore, {},  to finish loading.", (Object)core);
                break;
            }
        }
    }

    public boolean isCoreLoading(String name) {
        return this.currentlyLoadingCores.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueCoreToClose(SolrCore coreToClose) {
        Object object = this.modifyLock;
        synchronized (object) {
            this.pendingCloses.add(coreToClose);
            this.modifyLock.notifyAll();
        }
    }
}

