/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/collections/{collectionName}/schema/name")
public class SchemaNameAPI
extends JerseyResource {
    private SolrCore solrCore;

    @Inject
    public SchemaNameAPI(SolrCore solrCore) {
        this.solrCore = solrCore;
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public GetSchemaNameResponse getSchemaName() throws Exception {
        GetSchemaNameResponse response = this.instantiateJerseyResponse(GetSchemaNameResponse.class);
        IndexSchema schema = this.solrCore.getLatestSchema();
        if (null == schema.getSchemaName()) {
            throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Schema has no name");
        }
        response.name = schema.getSchemaName();
        return response;
    }

    public static class GetSchemaNameResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="name")
        public String name;
    }
}

