/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.tagger;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.solr.handler.tagger.OffsetCorrector;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;

public class XmlOffsetCorrector
extends OffsetCorrector {
    private static final XMLInputFactory2 XML_INPUT_FACTORY = new WstxInputFactory();

    public XmlOffsetCorrector(String docText) throws XMLStreamException {
        super(docText, false);
        int tagCounter = 0;
        int thisTag = -1;
        XMLStreamReader2 xmlStreamReader = (XMLStreamReader2)XML_INPUT_FACTORY.createXMLStreamReader((Reader)new StringReader(docText));
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            switch (eventType) {
                case 1: {
                    this.tagInfo.ensureCapacity(this.tagInfo.size() + 5);
                    int parentTag = thisTag;
                    LocationInfo info = xmlStreamReader.getLocationInfo();
                    this.tagInfo.add(parentTag);
                    this.tagInfo.add((int)info.getStartingCharOffset(), (int)info.getEndingCharOffset());
                    this.tagInfo.add(-1, -1);
                    thisTag = tagCounter++;
                    this.parentChangeOffsets.add((int)info.getStartingCharOffset());
                    this.parentChangeIds.add(thisTag);
                    break;
                }
                case 2: {
                    LocationInfo info = xmlStreamReader.getLocationInfo();
                    this.tagInfo.set(5 * thisTag + 3, (int)info.getStartingCharOffset());
                    this.tagInfo.set(5 * thisTag + 4, (int)info.getEndingCharOffset());
                    thisTag = this.getParentTag(thisTag);
                    this.parentChangeOffsets.add((int)info.getEndingCharOffset());
                    this.parentChangeIds.add(thisTag);
                    break;
                }
            }
        }
    }

    static {
        XML_INPUT_FACTORY.setXMLResolver(new XMLResolver(){

            @Override
            public InputStream resolveEntity(String publicId, String systemId, String baseURI, String namespace) {
                return ClosedInputStream.CLOSED_INPUT_STREAM;
            }
        });
        XML_INPUT_FACTORY.configureForSpeed();
    }
}

