/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.solr.core.SolrCore;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.glassfish.hk2.api.Factory;

public class InjectionFactories {

    public static class SingletonFactory<T>
    implements Factory<T> {
        private final T singletonVal;

        public SingletonFactory(T singletonVal) {
            this.singletonVal = singletonVal;
        }

        public T provide() {
            return this.singletonVal;
        }

        public void dispose(T instance) {
        }
    }

    public static class ReuseFromContextSolrCoreFactory
    implements Factory<SolrCore> {
        private final ContainerRequestContext containerRequestContext;

        @Inject
        public ReuseFromContextSolrCoreFactory(ContainerRequestContext containerRequestContext) {
            this.containerRequestContext = containerRequestContext;
        }

        public SolrCore provide() {
            return (SolrCore)this.containerRequestContext.getProperty(RequestContextKeys.SOLR_CORE);
        }

        public void dispose(SolrCore instance) {
        }
    }

    public static class SolrQueryResponseFactory
    implements Factory<SolrQueryResponse> {
        private final ContainerRequestContext containerRequestContext;

        @Inject
        public SolrQueryResponseFactory(ContainerRequestContext containerRequestContext) {
            this.containerRequestContext = containerRequestContext;
        }

        public SolrQueryResponse provide() {
            return (SolrQueryResponse)this.containerRequestContext.getProperty(RequestContextKeys.SOLR_QUERY_RESPONSE);
        }

        public void dispose(SolrQueryResponse instance) {
        }
    }

    public static class SolrQueryRequestFactory
    implements Factory<SolrQueryRequest> {
        private final ContainerRequestContext containerRequestContext;

        @Inject
        public SolrQueryRequestFactory(ContainerRequestContext containerRequestContext) {
            this.containerRequestContext = containerRequestContext;
        }

        public SolrQueryRequest provide() {
            return (SolrQueryRequest)this.containerRequestContext.getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
        }

        public void dispose(SolrQueryRequest instance) {
        }
    }
}

