/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.api.Api;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.security.PublicKeyAPI;
import org.apache.solr.security.SolrNodeKeyPair;
import org.apache.solr.util.CryptoKeys;

public class PublicKeyHandler
extends RequestHandlerBase {
    public static final String PATH = "/admin/info/key";
    private final SolrNodeKeyPair nodeKeyPair;

    @VisibleForTesting
    public PublicKeyHandler() {
        this(new SolrNodeKeyPair(null));
    }

    public PublicKeyHandler(SolrNodeKeyPair nodeKeyPair) {
        this.nodeKeyPair = nodeKeyPair;
    }

    public CryptoKeys.RSAKeyPair getKeyPair() {
        return this.nodeKeyPair.getKeyPair();
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, new PublicKeyAPI(this.nodeKeyPair).getPublicKey());
    }

    @Override
    public String getDescription() {
        return "Return the public key of this server";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.ALL;
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public Collection<Api> getApis() {
        return new ArrayList<Api>();
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        return List.of(PublicKeyAPI.class);
    }
}

