/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.LogUpdateProcessorFactory;
import org.apache.solr.update.processor.RunUpdateProcessorFactory;
import org.apache.solr.update.processor.TolerantUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.TestInjection;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedZkUpdateProcessor
extends DistributedUpdateProcessor {
    private final CloudDescriptor cloudDesc;
    private final ZkController zkController;
    private final SolrCmdDistributor cmdDistrib;
    protected List<SolrCmdDistributor.Node> nodes;
    private Set<String> skippedCoreNodeNames;
    private final String collection;
    private boolean readOnlyCollection = false;
    private boolean broadcastDeleteById = false;
    protected ClusterState clusterState;
    private final boolean cloneRequiredOnLeader;
    private final DistributedClusterStateUpdater distributedClusterStateUpdater;
    private DistributedUpdateProcessor.RollupRequestReplicationTracker rollupReplicationTracker = null;
    private DistributedUpdateProcessor.LeaderRequestReplicationTracker leaderReplicationTracker = null;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DistributedZkUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(req, rsp, next);
        CoreContainer cc = req.getCoreContainer();
        this.cloudDesc = req.getCore().getCoreDescriptor().getCloudDescriptor();
        this.zkController = cc.getZkController();
        this.distributedClusterStateUpdater = this.zkController.getDistributedClusterStateUpdater();
        this.cmdDistrib = new SolrCmdDistributor(cc.getUpdateShardHandler());
        this.cloneRequiredOnLeader = this.isCloneRequiredOnLeader(next);
        this.collection = this.cloudDesc.getCollectionName();
        this.clusterState = this.zkController.getClusterState();
        DocCollection coll = this.clusterState.getCollectionOrNull(this.collection);
        if (coll != null) {
            this.readOnlyCollection = coll.isReadOnly();
        }
    }

    private boolean isReadOnly() {
        return this.readOnlyCollection || this.req.getCore().readOnly;
    }

    private boolean isCloneRequiredOnLeader(UpdateRequestProcessor next) {
        boolean shouldClone = false;
        UpdateRequestProcessor nextInChain = next;
        while (nextInChain != null) {
            Class<?> klass = nextInChain.getClass();
            if (klass != LogUpdateProcessorFactory.LogUpdateProcessor.class && klass != RunUpdateProcessorFactory.RunUpdateProcessor.class && klass != TolerantUpdateProcessor.class) {
                shouldClone = true;
                break;
            }
            nextInChain = nextInChain.next;
        }
        return shouldClone;
    }

    @Override
    protected Replica.Type computeReplicaType() {
        return this.req.getCore().getCoreDescriptor().getCloudDescriptor().getReplicaType();
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        this.clusterState = this.zkController.getClusterState();
        assert (TestInjection.injectFailUpdateRequests());
        if (this.isReadOnly()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Collection " + this.collection + " is read-only.");
        }
        this.updateCommand = cmd;
        List<SolrCmdDistributor.Node> nodes = null;
        Replica leaderReplica = null;
        this.zkCheck();
        try {
            leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, this.cloudDesc.getShardId());
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Exception finding leader for shard " + this.cloudDesc.getShardId(), (Throwable)e);
        }
        this.isLeader = leaderReplica.getName().equals(this.cloudDesc.getCoreNodeName());
        nodes = this.getCollectionUrls(this.collection, EnumSet.of(Replica.Type.TLOG, Replica.Type.NRT), true);
        if (nodes == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to distribute commit operation. No replicas available of types " + Replica.Type.TLOG + " or " + Replica.Type.NRT);
        }
        nodes.removeIf(node -> node.getNodeProps().getNodeName().equals(this.zkController.getNodeName()) && node.getNodeProps().getCoreName().equals(this.req.getCore().getName()));
        if (!this.isLeader && this.req.getParams().get("commit_end_point", "").equals("replicas")) {
            if (this.replicaType == Replica.Type.PULL) {
                log.warn("Commit not supported on replicas of type {}", (Object)Replica.Type.PULL);
            } else if (this.replicaType == Replica.Type.NRT) {
                this.doLocalCommit(cmd);
            }
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            boolean issuedDistribCommit = false;
            List<SolrCmdDistributor.Node> useNodes = null;
            if (this.req.getParams().get("commit_end_point") == null) {
                useNodes = nodes;
                params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.TOLEADER.toString()});
                params.set("commit_end_point", new String[]{"leaders"});
                if (useNodes != null) {
                    params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                    this.cmdDistrib.distribCommit(cmd, useNodes, params);
                    issuedDistribCommit = true;
                }
            }
            if (this.isLeader) {
                if (issuedDistribCommit) {
                    params = new ModifiableSolrParams((SolrParams)params);
                }
                params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
                params.set("commit_end_point", new String[]{"replicas"});
                useNodes = this.getReplicaNodesForLeader(this.cloudDesc.getShardId(), leaderReplica);
                if (useNodes != null) {
                    params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                    this.cmdDistrib.distribCommit(cmd, useNodes, params);
                    issuedDistribCommit = true;
                }
                this.doLocalCommit(cmd);
            }
            if (issuedDistribCommit) {
                this.cmdDistrib.blockAndDoRetries();
            }
        }
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        this.clusterState = this.zkController.getClusterState();
        assert (TestInjection.injectFailUpdateRequests());
        if (this.isReadOnly()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Collection " + this.collection + " is read-only.");
        }
        this.setupRequest(cmd);
        this.checkReplicationTracker(cmd);
        super.processAdd(cmd);
    }

    @Override
    protected void doDistribAdd(AddUpdateCommand cmd) throws IOException {
        if (this.isLeader && !this.isSubShardLeader) {
            List<SolrCmdDistributor.Node> nodesByRoutingRules;
            DocCollection coll = this.clusterState.getCollection(this.collection);
            List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), cmd.getIndexedIdStr(), cmd.getSolrInputDocument());
            if (subShardLeaders != null && !subShardLeaders.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
                params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set("distrib.from.parent", new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribAdd(cmd, subShardLeaders, params, true);
            }
            if ((nodesByRoutingRules = this.getNodesByRoutingRules(this.clusterState, coll, cmd.getIndexedIdStr(), cmd.getSolrInputDocument())) != null && !nodesByRoutingRules.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
                params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set("distrib.from.collection", new String[]{this.collection});
                params.set("distrib.from.shard", new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribAdd(cmd, nodesByRoutingRules, params, true);
            }
        }
        if (this.nodes != null) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader || this.isSubShardLeader ? DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString() : DistributedUpdateProcessor.DistribPhase.TOLEADER.toString()});
            params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            if (cmd.isInPlaceUpdate()) {
                params.set("distrib.inplace.prevversion", new String[]{String.valueOf(cmd.prevVersion)});
                this.cmdDistrib.distribAdd(cmd, this.nodes, params, true, this.rollupReplicationTracker, this.leaderReplicationTracker);
            } else {
                this.cmdDistrib.distribAdd(cmd, this.nodes, params, false, this.rollupReplicationTracker, this.leaderReplicationTracker);
            }
        }
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        this.clusterState = this.zkController.getClusterState();
        if (this.isReadOnly()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Collection " + this.collection + " is read-only.");
        }
        super.processDelete(cmd);
    }

    @Override
    protected void doDeleteById(DeleteUpdateCommand cmd) throws IOException {
        this.setupRequest(cmd);
        if (this.broadcastDeleteById && DistributedUpdateProcessor.DistribPhase.NONE == DistributedUpdateProcessor.DistribPhase.parseParam(this.req.getParams().get("update.distrib"))) {
            DocCollection coll = this.clusterState.getCollection(this.collection);
            if (log.isDebugEnabled()) {
                log.debug("The deleteById command for doc {} is missing the required route, broadcasting to leaders of other shards", (Object)cmd.getId());
            }
            this.forwardDelete(coll, cmd);
        }
        this.checkReplicationTracker(cmd);
        super.doDeleteById(cmd);
    }

    @Override
    protected void doDistribDeleteById(DeleteUpdateCommand cmd) throws IOException {
        if (this.isLeader && !this.isSubShardLeader) {
            List<SolrCmdDistributor.Node> nodesByRoutingRules;
            DocCollection coll = this.clusterState.getCollection(this.collection);
            List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), cmd.getId(), null);
            if (subShardLeaders != null && !subShardLeaders.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
                params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set("distrib.from.parent", new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribDelete(cmd, subShardLeaders, params, true, null, null);
            }
            if ((nodesByRoutingRules = this.getNodesByRoutingRules(this.clusterState, coll, cmd.getId(), null)) != null && !nodesByRoutingRules.isEmpty()) {
                ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
                params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set("distrib.from.collection", new String[]{this.collection});
                params.set("distrib.from.shard", new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribDelete(cmd, nodesByRoutingRules, params, true, null, null);
            }
        }
        if (this.nodes != null) {
            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
            params.set("update.distrib", new String[]{this.isLeader || this.isSubShardLeader ? DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString() : DistributedUpdateProcessor.DistribPhase.TOLEADER.toString()});
            params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
            this.cmdDistrib.distribDelete(cmd, this.nodes, params, false, this.rollupReplicationTracker, this.leaderReplicationTracker);
        }
    }

    @Override
    protected void doDeleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        this.zkCheck();
        DistributedUpdateProcessor.DistribPhase phase = DistributedUpdateProcessor.DistribPhase.parseParam(this.req.getParams().get("update.distrib"));
        DocCollection coll = this.clusterState.getCollection(this.collection);
        if (DistributedUpdateProcessor.DistribPhase.NONE == phase) {
            boolean leaderForAnyShard;
            if (this.rollupReplicationTracker == null) {
                this.rollupReplicationTracker = new DistributedUpdateProcessor.RollupRequestReplicationTracker();
            }
            if (!(leaderForAnyShard = this.forwardDelete(coll, cmd))) {
                return;
            }
            phase = DistributedUpdateProcessor.DistribPhase.TOLEADER;
        }
        List<SolrCmdDistributor.Node> replicas = null;
        if (DistributedUpdateProcessor.DistribPhase.TOLEADER == phase) {
            this.isLeader = true;
            replicas = this.setupRequestForDBQ();
        } else if (DistributedUpdateProcessor.DistribPhase.FROMLEADER == phase) {
            this.isLeader = false;
        }
        this.checkReplicationTracker(cmd);
        super.doDeleteByQuery(cmd, replicas, coll);
    }

    private boolean forwardDelete(DocCollection coll, DeleteUpdateCommand cmd) throws IOException {
        boolean leaderForAnyShard = false;
        ModifiableSolrParams outParams = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
        outParams.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.TOLEADER.toString()});
        outParams.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
        SolrParams params = this.req.getParams();
        String route = params.get("_route_");
        Collection slices = coll.getRouter().getSearchSlices(route, params, coll);
        ArrayList<SolrCmdDistributor.Node> leaders = new ArrayList<SolrCmdDistributor.Node>(slices.size());
        for (Slice slice : slices) {
            Replica leader;
            String sliceName = slice.getName();
            try {
                leader = this.zkController.getZkStateReader().getLeaderRetry(this.collection, sliceName);
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Exception finding leader for shard " + sliceName, (Throwable)e);
            }
            ZkCoreNodeProps coreLeaderProps = new ZkCoreNodeProps((ZkNodeProps)leader);
            String leaderCoreNodeName = leader.getName();
            String coreNodeName = this.cloudDesc.getCoreNodeName();
            this.isLeader = coreNodeName.equals(leaderCoreNodeName);
            if (this.isLeader) {
                leaderForAnyShard = true;
                continue;
            }
            leaders.add(new SolrCmdDistributor.ForwardNode(coreLeaderProps, this.zkController.getZkStateReader(), this.collection, sliceName, this.maxRetriesOnForward));
        }
        outParams.remove("commit");
        this.cmdDistrib.distribDelete(cmd, leaders, outParams, false, this.rollupReplicationTracker, null);
        return leaderForAnyShard;
    }

    @Override
    protected void doDistribDeleteByQuery(DeleteUpdateCommand cmd, List<SolrCmdDistributor.Node> replicas, DocCollection coll) throws IOException {
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean leaderLogic = this.isLeader && !isReplayOrPeersync;
        ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
        params.set("_version_", new String[]{Long.toString(cmd.getVersion())});
        params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
        params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
        boolean someReplicas = false;
        boolean subShardLeader = false;
        try {
            subShardLeader = this.amISubShardLeader(coll, null, null, null);
            if (subShardLeader) {
                String myShardId = this.cloudDesc.getShardId();
                Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId);
                List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, myShardId, leaderReplica.getName(), null, Replica.State.DOWN, EnumSet.of(Replica.Type.NRT, Replica.Type.TLOG));
                if (replicaProps != null) {
                    ArrayList<SolrCmdDistributor.Node> myReplicas = new ArrayList<SolrCmdDistributor.Node>(replicaProps.size());
                    for (ZkCoreNodeProps replicaProp : replicaProps) {
                        myReplicas.add(new SolrCmdDistributor.StdNode(replicaProp, this.collection, myShardId));
                    }
                    this.cmdDistrib.distribDelete(cmd, myReplicas, params, false, this.rollupReplicationTracker, this.leaderReplicationTracker);
                    someReplicas = true;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        if (leaderLogic) {
            List<SolrCmdDistributor.Node> nodesByRoutingRules;
            List<SolrCmdDistributor.Node> subShardLeaders = this.getSubShardLeaders(coll, this.cloudDesc.getShardId(), null, null);
            if (subShardLeaders != null) {
                this.cmdDistrib.distribDelete(cmd, subShardLeaders, params, true, this.rollupReplicationTracker, this.leaderReplicationTracker);
            }
            if ((nodesByRoutingRules = this.getNodesByRoutingRules(this.clusterState, coll, null, null)) != null && !nodesByRoutingRules.isEmpty()) {
                params = new ModifiableSolrParams((SolrParams)this.filterParams(this.req.getParams()));
                params.set("update.distrib", new String[]{DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()});
                params.set("distrib.from", new String[]{ZkCoreNodeProps.getCoreUrl((String)this.zkController.getBaseUrl(), (String)this.req.getCore().getName())});
                params.set("distrib.from.collection", new String[]{this.collection});
                params.set("distrib.from.shard", new String[]{this.cloudDesc.getShardId()});
                this.cmdDistrib.distribDelete(cmd, nodesByRoutingRules, params, true, this.rollupReplicationTracker, this.leaderReplicationTracker);
            }
            if (replicas != null) {
                this.cmdDistrib.distribDelete(cmd, replicas, params, false, this.rollupReplicationTracker, this.leaderReplicationTracker);
                someReplicas = true;
            }
        }
        if (someReplicas) {
            this.cmdDistrib.blockAndDoRetries();
        }
    }

    private List<SolrCmdDistributor.Node> setupRequestForDBQ() {
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        String shardId = this.cloudDesc.getShardId();
        try {
            Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId);
            this.isLeader = leaderReplica.getName().equals(this.cloudDesc.getCoreNodeName());
            this.forwardToLeader = false;
            List replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, leaderReplica.getName(), null, Replica.State.DOWN, EnumSet.of(Replica.Type.NRT, Replica.Type.TLOG));
            if (replicaProps != null) {
                nodes = new ArrayList<SolrCmdDistributor.StdNode>(replicaProps.size());
                for (ZkCoreNodeProps props : replicaProps) {
                    nodes.add(new SolrCmdDistributor.StdNode(props, this.collection, shardId));
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        return nodes;
    }

    @Override
    protected String getLeaderUrl(String id) {
        String distribFrom = this.req.getParams().get("distrib.from");
        if (distribFrom != null) {
            return distribFrom;
        }
        return this.getLeaderUrlZk(id);
    }

    private String getLeaderUrlZk(String id) {
        if (this.zkController == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find document with id=" + id + ", but fetching from leader failed since we're not in cloud mode.");
        }
        try {
            return this.zkController.getZkStateReader().getLeaderRetry(this.collection, this.cloudDesc.getShardId()).getCoreUrl();
        }
        catch (InterruptedException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception during fetching from leader.", (Throwable)e);
        }
    }

    @Override
    void setupRequest(UpdateCommand cmd) {
        this.updateCommand = cmd;
        this.zkCheck();
        if (cmd instanceof AddUpdateCommand) {
            AddUpdateCommand acmd = (AddUpdateCommand)cmd;
            this.nodes = this.setupRequest(acmd.getIndexedIdStr(), acmd.getSolrInputDocument());
        } else if (cmd instanceof DeleteUpdateCommand) {
            DeleteUpdateCommand dcmd = (DeleteUpdateCommand)cmd;
            this.nodes = this.setupRequest(dcmd.getId(), null, null != dcmd.getRoute() ? dcmd.getRoute() : this.req.getParams().get("_route_"));
        }
    }

    protected List<SolrCmdDistributor.Node> setupRequest(String id, SolrInputDocument doc) {
        return this.setupRequest(id, doc, null);
    }

    protected List<SolrCmdDistributor.Node> setupRequest(String id, SolrInputDocument doc, String route) {
        DistributedUpdateProcessor.DistribPhase phase;
        assert (TestInjection.injectUpdateRandomPause());
        if ((this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
            this.isLeader = false;
            this.forwardToLeader = false;
            return null;
        }
        this.clusterState = this.zkController.getClusterState();
        DocCollection coll = this.clusterState.getCollection(this.collection);
        Slice slice = coll.getRouter().getTargetSlice(id, doc, route, this.req.getParams(), coll);
        if (slice == null) {
            String shardId = this.cloudDesc.getShardId();
            slice = coll.getSlice(shardId);
            if (slice == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard " + shardId + " in " + coll);
            }
            if (doc == null && coll.getRouter() instanceof CompositeIdRouter && coll.getActiveSlicesMap().size() > 1) {
                this.broadcastDeleteById = true;
            }
        }
        if (DistributedUpdateProcessor.DistribPhase.FROMLEADER == (phase = DistributedUpdateProcessor.DistribPhase.parseParam(this.req.getParams().get("update.distrib"))) && !this.couldIbeSubShardLeader(coll) && !this.cloudDesc.isLeader()) {
            assert (TestInjection.injectFailReplicaRequests());
            this.isLeader = false;
            this.forwardToLeader = false;
            return null;
        }
        String shardId = slice.getName();
        try {
            Replica leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId);
            this.isLeader = leaderReplica.getName().equals(this.cloudDesc.getCoreNodeName());
            if (!this.isLeader) {
                this.isSubShardLeader = this.amISubShardLeader(coll, slice, id, doc);
                if (this.isSubShardLeader) {
                    shardId = this.cloudDesc.getShardId();
                    leaderReplica = this.zkController.getZkStateReader().getLeaderRetry(this.collection, shardId);
                }
            }
            this.doDefensiveChecks(phase);
            String fromCollection = this.updateCommand.getReq().getParams().get("distrib.from.collection");
            if (DistributedUpdateProcessor.DistribPhase.FROMLEADER == phase && !this.isSubShardLeader && fromCollection == null) {
                this.forwardToLeader = false;
                return null;
            }
            if (this.isLeader || this.isSubShardLeader) {
                this.forwardToLeader = false;
                String leaderCoreNodeName = leaderReplica.getName();
                List replicas = this.clusterState.getCollection(this.collection).getSlice(shardId).getReplicas(EnumSet.of(Replica.Type.NRT, Replica.Type.TLOG));
                replicas.removeIf(replica -> replica.getName().equals(leaderCoreNodeName));
                if (replicas.isEmpty()) {
                    return null;
                }
                String[] skipList = this.req.getParams().getParams("test.distrib.skip.servers");
                HashSet<String> skipListSet = null;
                if (skipList != null) {
                    skipListSet = new HashSet<String>(skipList.length);
                    skipListSet.addAll(Arrays.asList(skipList));
                    log.info("test.distrib.skip.servers was found and contains:{}", skipListSet);
                }
                ArrayList<SolrCmdDistributor.Node> nodes = new ArrayList<SolrCmdDistributor.Node>(replicas.size());
                this.skippedCoreNodeNames = new HashSet<String>();
                ZkShardTerms zkShardTerms = this.zkController.getShardTerms(this.collection, shardId);
                for (Replica replica2 : replicas) {
                    String coreNodeName = replica2.getName();
                    if (skipList != null && skipListSet.contains(replica2.getCoreUrl())) {
                        if (!log.isInfoEnabled()) continue;
                        log.info("check url:{} against:{} result:true", (Object)replica2.getCoreUrl(), skipListSet);
                        continue;
                    }
                    if (zkShardTerms.registered(coreNodeName) && zkShardTerms.skipSendingUpdatesTo(coreNodeName)) {
                        if (log.isDebugEnabled()) {
                            log.debug("skip url:{} cause its term is less than leader", (Object)replica2.getCoreUrl());
                        }
                        this.skippedCoreNodeNames.add(replica2.getName());
                        continue;
                    }
                    if (!this.clusterState.getLiveNodes().contains(replica2.getNodeName()) || replica2.getState() == Replica.State.DOWN) {
                        this.skippedCoreNodeNames.add(replica2.getName());
                        continue;
                    }
                    nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)replica2), this.collection, shardId, this.maxRetriesToFollowers));
                }
                return nodes;
            }
            this.forwardToLeader = true;
            return Collections.singletonList(new SolrCmdDistributor.ForwardNode(new ZkCoreNodeProps((ZkNodeProps)leaderReplica), this.zkController.getZkStateReader(), this.collection, shardId, this.maxRetriesOnForward));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    @Override
    protected boolean shouldCloneCmdDoc() {
        boolean willDistrib = this.isLeader && this.nodes != null && this.nodes.size() > 0;
        return willDistrib & this.cloneRequiredOnLeader;
    }

    private void checkReplicationTracker(UpdateCommand cmd) {
        SolrParams rp = cmd.getReq().getParams();
        String distribUpdate = rp.get("update.distrib");
        if ((distribUpdate == null || DistributedUpdateProcessor.DistribPhase.NONE.toString().equals(distribUpdate)) && this.rollupReplicationTracker == null) {
            this.rollupReplicationTracker = new DistributedUpdateProcessor.RollupRequestReplicationTracker();
        }
        if (this.isLeader && this.leaderReplicationTracker == null) {
            this.leaderReplicationTracker = new DistributedUpdateProcessor.LeaderRequestReplicationTracker(this.req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId());
        }
    }

    private List<SolrCmdDistributor.Node> getCollectionUrls(String collection, EnumSet<Replica.Type> types, boolean onlyLeaders) {
        DocCollection docCollection = this.clusterState.getCollectionOrNull(collection);
        if (collection == null || docCollection.getSlicesMap() == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + this.clusterState);
        }
        Map slices = docCollection.getSlicesMap();
        ArrayList<SolrCmdDistributor.Node> urls = new ArrayList<SolrCmdDistributor.Node>(slices.size());
        for (Map.Entry sliceEntry : slices.entrySet()) {
            Slice replicas = (Slice)slices.get(sliceEntry.getKey());
            if (onlyLeaders) {
                Replica replica = docCollection.getLeader(replicas.getName());
                if (replica == null) continue;
                ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)replica);
                urls.add(new SolrCmdDistributor.StdNode(nodeProps, collection, replicas.getName()));
                continue;
            }
            Map shardMap = replicas.getReplicasMap();
            for (Map.Entry entry : shardMap.entrySet()) {
                ZkCoreNodeProps nodeProps;
                if (!types.contains(((Replica)entry.getValue()).getType()) || !this.clusterState.liveNodesContain((nodeProps = new ZkCoreNodeProps((ZkNodeProps)entry.getValue())).getNodeName())) continue;
                urls.add(new SolrCmdDistributor.StdNode(nodeProps, collection, replicas.getName()));
            }
        }
        if (urls.isEmpty()) {
            return null;
        }
        return urls;
    }

    private boolean couldIbeSubShardLeader(DocCollection coll) {
        String myShardId = this.cloudDesc.getShardId();
        Slice mySlice = coll.getSlice(myShardId);
        Slice.State state = mySlice.getState();
        return state == Slice.State.CONSTRUCTION || state == Slice.State.RECOVERY;
    }

    protected boolean amISubShardLeader(DocCollection coll, Slice parentSlice, String id, SolrInputDocument doc) throws InterruptedException {
        Replica myLeader;
        boolean amILeader;
        String myShardId = this.cloudDesc.getShardId();
        Slice mySlice = coll.getSlice(myShardId);
        Slice.State state = mySlice.getState();
        if ((state == Slice.State.CONSTRUCTION || state == Slice.State.RECOVERY) && (amILeader = (myLeader = this.zkController.getZkStateReader().getLeaderRetry(this.collection, myShardId)).getName().equals(this.cloudDesc.getCoreNodeName()))) {
            DocRouter.Range myRange = mySlice.getRange();
            if (myRange == null) {
                myRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (parentSlice != null) {
                boolean isSubset = parentSlice.getRange() != null && myRange.isSubsetOf(parentSlice.getRange());
                return isSubset && coll.getRouter().isTargetSlice(id, doc, this.req.getParams(), myShardId, coll);
            }
            return true;
        }
        return false;
    }

    protected List<SolrCmdDistributor.Node> getReplicaNodesForLeader(String shardId, Replica leaderReplica) {
        String leaderCoreNodeName = leaderReplica.getName();
        List replicas = this.clusterState.getCollection(this.collection).getSlice(shardId).getReplicas(EnumSet.of(Replica.Type.NRT, Replica.Type.TLOG));
        replicas.removeIf(replica -> replica.getName().equals(leaderCoreNodeName));
        if (replicas.isEmpty()) {
            return null;
        }
        String[] skipList = this.req.getParams().getParams("test.distrib.skip.servers");
        HashSet<String> skipListSet = null;
        if (skipList != null) {
            skipListSet = new HashSet<String>(skipList.length);
            skipListSet.addAll(Arrays.asList(skipList));
            log.info("test.distrib.skip.servers was found and contains:{}", skipListSet);
        }
        ArrayList<SolrCmdDistributor.Node> nodes = new ArrayList<SolrCmdDistributor.Node>(replicas.size());
        this.skippedCoreNodeNames = new HashSet<String>();
        ZkShardTerms zkShardTerms = this.zkController.getShardTerms(this.collection, shardId);
        for (Replica replica2 : replicas) {
            String coreNodeName = replica2.getName();
            if (skipList != null && skipListSet.contains(replica2.getCoreUrl())) {
                if (!log.isInfoEnabled()) continue;
                log.info("check url:{} against:{} result:true", (Object)replica2.getCoreUrl(), skipListSet);
                continue;
            }
            if (zkShardTerms.registered(coreNodeName) && zkShardTerms.skipSendingUpdatesTo(coreNodeName)) {
                if (log.isDebugEnabled()) {
                    log.debug("skip url:{} cause its term is less than leader", (Object)replica2.getCoreUrl());
                }
                this.skippedCoreNodeNames.add(replica2.getName());
                continue;
            }
            if (!this.clusterState.getLiveNodes().contains(replica2.getNodeName()) || replica2.getState() == Replica.State.DOWN) {
                this.skippedCoreNodeNames.add(replica2.getName());
                continue;
            }
            nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)replica2), this.collection, shardId));
        }
        return nodes;
    }

    protected List<SolrCmdDistributor.Node> getSubShardLeaders(DocCollection coll, String shardId, String docId, SolrInputDocument doc) {
        Collection allSlices = coll.getSlices();
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        for (Slice aslice : allSlices) {
            Replica sliceLeader;
            boolean isSubset;
            Slice.State state = aslice.getState();
            if (state != Slice.State.CONSTRUCTION && state != Slice.State.RECOVERY) continue;
            DocRouter.Range myRange = coll.getSlice(shardId).getRange();
            if (myRange == null) {
                myRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
            if (!(isSubset = aslice.getRange() != null && aslice.getRange().isSubsetOf(myRange)) || docId != null && !coll.getRouter().isTargetSlice(docId, doc, this.req.getParams(), aslice.getName(), coll) || (sliceLeader = aslice.getLeader()) == null || !this.clusterState.liveNodesContain(sliceLeader.getNodeName())) continue;
            if (nodes == null) {
                nodes = new ArrayList<SolrCmdDistributor.StdNode>();
            }
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)sliceLeader);
            nodes.add(new SolrCmdDistributor.StdNode(nodeProps, coll.getName(), aslice.getName()));
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<SolrCmdDistributor.Node> getNodesByRoutingRules(ClusterState cstate, DocCollection coll, String id, SolrInputDocument doc) {
        RoutingRule rule;
        DocRouter router = coll.getRouter();
        ArrayList<SolrCmdDistributor.StdNode> nodes = null;
        if (!(router instanceof CompositeIdRouter)) return nodes;
        CompositeIdRouter compositeIdRouter = (CompositeIdRouter)router;
        String myShardId = this.cloudDesc.getShardId();
        Slice slice = coll.getSlice(myShardId);
        Map routingRules = slice.getRoutingRules();
        if (routingRules == null) return nodes;
        if (id == null) {
            for (Map.Entry entry : routingRules.entrySet()) {
                String targetCollectionName = ((RoutingRule)entry.getValue()).getTargetCollectionName();
                DocCollection docCollection = cstate.getCollectionOrNull(targetCollectionName);
                if (docCollection == null || docCollection.getActiveSlicesArr().length <= 0) continue;
                Slice[] activeSlices = docCollection.getActiveSlicesArr();
                Slice any = activeSlices[0];
                if (nodes == null) {
                    nodes = new ArrayList<SolrCmdDistributor.StdNode>();
                }
                nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)any.getLeader())));
            }
            return nodes;
        }
        String routeKey = compositeIdRouter.getRouteKeyNoSuffix(id);
        if (routeKey == null || (rule = (RoutingRule)routingRules.get(routeKey + "!")) == null) return nodes;
        if (!rule.isExpired()) {
            List ranges = rule.getRouteRanges();
            if (ranges == null || ranges.isEmpty()) return nodes;
            int hash = compositeIdRouter.sliceHash(id, doc, null, coll);
            for (DocRouter.Range range : ranges) {
                if (!range.includes(hash)) continue;
                DocCollection targetColl = cstate.getCollection(rule.getTargetCollectionName());
                Collection activeSlices = targetColl.getRouter().getSearchSlicesSingle(id, null, targetColl);
                if (activeSlices == null || activeSlices.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No active slices serving " + id + " found for target collection: " + rule.getTargetCollectionName());
                }
                Replica targetLeader = targetColl.getLeader(((Slice)activeSlices.iterator().next()).getName());
                nodes = new ArrayList(1);
                nodes.add(new SolrCmdDistributor.StdNode(new ZkCoreNodeProps((ZkNodeProps)targetLeader)));
                return nodes;
            }
            return nodes;
        }
        ReentrantLock ruleExpiryLock = this.req.getCore().getRuleExpiryLock();
        if (ruleExpiryLock.isLocked()) return nodes;
        try {
            if (!ruleExpiryLock.tryLock(10L, TimeUnit.MILLISECONDS)) return nodes;
            log.info("Going to expire routing rule");
            try {
                Map<String, CallSite> map = Map.of("operation", OverseerAction.REMOVEROUTINGRULE.toLower(), "collection", this.collection, "shard", myShardId, "routeKey", routeKey + "!");
                if (this.distributedClusterStateUpdater.isDistributedStateUpdate()) {
                    ZkNodeProps message = new ZkNodeProps(map);
                    this.distributedClusterStateUpdater.doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.SliceRemoveRoutingRule, message, this.zkController.getOverseer().getSolrCloudManager(), this.zkController.getOverseer().getZkStateReader());
                    return nodes;
                }
                this.zkController.getOverseer().offerStateUpdate(Utils.toJSON(map));
                return nodes;
            }
            catch (KeeperException e) {
                log.warn("Exception while removing routing rule for route key: {}", (Object)routeKey, (Object)e);
                return nodes;
            }
            catch (Exception e) {
                log.error("Exception while removing routing rule for route key: {}", (Object)routeKey, (Object)e);
                return nodes;
            }
            finally {
                ruleExpiryLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return nodes;
    }

    private void doDefensiveChecks(DistributedUpdateProcessor.DistribPhase phase) {
        boolean isReplayOrPeersync;
        boolean bl = isReplayOrPeersync = (this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        if (isReplayOrPeersync) {
            return;
        }
        String from = this.req.getParams().get("distrib.from");
        DocCollection docCollection = this.clusterState.getCollection(this.collection);
        Slice mySlice = docCollection.getSlice(this.cloudDesc.getShardId());
        boolean localIsLeader = this.cloudDesc.isLeader();
        if (DistributedUpdateProcessor.DistribPhase.FROMLEADER == phase && localIsLeader && from != null) {
            String fromShard = this.req.getParams().get("distrib.from.parent");
            if (fromShard != null) {
                if (mySlice.getState() == Slice.State.ACTIVE) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from parent shard leader but we are in active state");
                }
                Slice fromSlice = docCollection.getSlice(fromShard);
                DocRouter.Range parentRange = fromSlice.getRange();
                if (parentRange == null) {
                    parentRange = new DocRouter.Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
                }
                if (mySlice.getRange() != null && !mySlice.getRange().isSubsetOf(parentRange)) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from parent shard leader but parent hash range is not superset of my range");
                }
            } else {
                String fromCollection = this.req.getParams().get("distrib.from.collection");
                if (fromCollection == null) {
                    log.error("Request says it is coming from leader, but we are the leader: {}", (Object)this.req.getParamString());
                    SolrException solrExc = new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request says it is coming from leader, but we are the leader");
                    solrExc.setMetadata("cause", "LeaderChanged");
                    throw solrExc;
                }
            }
        }
        int count = 0;
        while ((this.isLeader && !localIsLeader || this.isSubShardLeader && !localIsLeader) && count < 5) {
            ++count;
            localIsLeader = this.cloudDesc.isLeader();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.isLeader && !localIsLeader || this.isSubShardLeader && !localIsLeader) {
            log.error("ClusterState says we are the leader, but locally we don't think so");
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "ClusterState says we are the leader (" + this.zkController.getBaseUrl() + "/" + this.req.getCore().getName() + "), but locally we don't think so. Request came from " + from);
        }
    }

    @Override
    protected void doClose() {
        if (this.cmdDistrib != null) {
            this.cmdDistrib.close();
        }
    }

    @Override
    public void processMergeIndexes(MergeIndexesCommand cmd) throws IOException {
        this.clusterState = this.zkController.getClusterState();
        if (this.isReadOnly()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Collection " + this.collection + " is read-only.");
        }
        super.processMergeIndexes(cmd);
    }

    @Override
    public void processRollback(RollbackUpdateCommand cmd) throws IOException {
        this.clusterState = this.zkController.getClusterState();
        if (this.isReadOnly()) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Collection " + this.collection + " is read-only.");
        }
        super.processRollback(cmd);
    }

    @Override
    protected void doDistribFinish() {
        boolean shouldUpdateTerms;
        this.clusterState = this.zkController.getClusterState();
        boolean bl = shouldUpdateTerms = this.isLeader && this.isIndexChanged;
        if (shouldUpdateTerms) {
            ZkShardTerms zkShardTerms = this.zkController.getShardTerms(this.cloudDesc.getCollectionName(), this.cloudDesc.getShardId());
            if (this.skippedCoreNodeNames != null) {
                zkShardTerms.ensureTermsIsHigher(this.cloudDesc.getCoreNodeName(), this.skippedCoreNodeNames);
            }
            this.zkController.getShardTerms(this.collection, this.cloudDesc.getShardId()).ensureHighestTermsAreNotZero();
        }
        this.cmdDistrib.finish();
        List<SolrCmdDistributor.SolrError> errors = this.cmdDistrib.getErrors();
        ArrayList<SolrCmdDistributor.SolrError> errorsForClient = new ArrayList<SolrCmdDistributor.SolrError>(errors.size());
        HashSet<String> replicasShouldBeInLowerTerms = new HashSet<String>();
        for (SolrCmdDistributor.SolrError error : errors) {
            String cause;
            if (error.req.node instanceof SolrCmdDistributor.ForwardNode) {
                errorsForClient.add(error);
                continue;
            }
            log.warn("Error sending update to {}", (Object)error.req.node.getBaseUrl(), (Object)error.e);
            DistributedUpdateProcessor.DistribPhase phase = DistributedUpdateProcessor.DistribPhase.parseParam(error.req.uReq.getParams().get("update.distrib"));
            if (phase != DistributedUpdateProcessor.DistribPhase.FROMLEADER || error.req.uReq.getParams().get("commit_end_point") != null) continue;
            String replicaUrl = error.req.node.getUrl();
            String string = cause = error.e instanceof SolrException ? ((SolrException)((Object)error.e)).getMetadata("cause") : null;
            if ("LeaderChanged".equals(cause)) {
                log.error("On {}, replica {} now thinks it is the leader! Failing the request to let the client retry!", new Object[]{this.cloudDesc.getCoreNodeName(), replicaUrl, error.e});
                errorsForClient.add(error);
                continue;
            }
            String collection = null;
            String shardId = null;
            if (!(error.req.node instanceof SolrCmdDistributor.StdNode)) continue;
            SolrCmdDistributor.StdNode stdNode = (SolrCmdDistributor.StdNode)error.req.node;
            collection = stdNode.getCollection();
            shardId = stdNode.getShardId();
            String leaderCoreNodeName = null;
            Exception getLeaderExc = null;
            Replica leaderProps = null;
            try {
                leaderProps = this.zkController.getZkStateReader().getLeader(collection, shardId);
                if (leaderProps != null) {
                    leaderCoreNodeName = leaderProps.getName();
                }
            }
            catch (Exception exc) {
                getLeaderExc = exc;
            }
            if (leaderCoreNodeName == null) {
                log.warn("Failed to determine if {} is still the leader for collection={} shardId={} before putting {} into leader-initiated recovery", new Object[]{this.cloudDesc.getCoreNodeName(), collection, shardId, replicaUrl, getLeaderExc});
            }
            List myReplicas = this.zkController.getZkStateReader().getReplicaProps(collection, this.cloudDesc.getShardId(), this.cloudDesc.getCoreNodeName());
            boolean foundErrorNodeInReplicaList = false;
            if (myReplicas != null) {
                for (ZkCoreNodeProps replicaProp : myReplicas) {
                    if (!((Replica)replicaProp.getNodeProps()).getName().equals(((Replica)stdNode.getNodeProps().getNodeProps()).getName())) continue;
                    foundErrorNodeInReplicaList = true;
                    break;
                }
            }
            if (leaderCoreNodeName != null && this.cloudDesc.getCoreNodeName().equals(leaderCoreNodeName) && foundErrorNodeInReplicaList && !stdNode.getNodeProps().getCoreUrl().equals(leaderProps.getCoreUrl())) {
                try {
                    String coreNodeName = ((Replica)stdNode.getNodeProps().getNodeProps()).getName();
                    Throwable rootCause = SolrException.getRootCause((Throwable)error.e);
                    log.error("Setting up to try to start recovery on replica {} with url {} by increasing leader term", new Object[]{coreNodeName, replicaUrl, rootCause});
                    replicasShouldBeInLowerTerms.add(coreNodeName);
                }
                catch (Exception exc) {
                    Throwable setLirZnodeFailedCause = SolrException.getRootCause((Throwable)exc);
                    log.error("Leader failed to set replica {} state to DOWN due to: {}", new Object[]{error.req.node.getUrl(), setLirZnodeFailedCause, setLirZnodeFailedCause});
                }
                continue;
            }
            if (!foundErrorNodeInReplicaList) {
                log.warn("Core {} belonging to {} {}, does not have error'd node {} as a replica. No request recovery command will be sent!", new Object[]{this.cloudDesc.getCoreNodeName(), collection, this.cloudDesc.getShardId(), stdNode.getNodeProps().getCoreUrl()});
                if (shardId.equals(this.cloudDesc.getShardId())) continue;
                errorsForClient.add(error);
                continue;
            }
            log.warn("Core {} is no longer the leader for {} {}  or we tried to put ourself into LIR, no request recovery command will be sent!", new Object[]{this.cloudDesc.getCoreNodeName(), collection, shardId});
        }
        if (!replicasShouldBeInLowerTerms.isEmpty()) {
            this.zkController.getShardTerms(this.cloudDesc.getCollectionName(), this.cloudDesc.getShardId()).ensureTermsIsHigher(this.cloudDesc.getCoreNodeName(), replicasShouldBeInLowerTerms);
        }
        this.handleReplicationFactor();
        if (0 < errorsForClient.size()) {
            throw new DistributedUpdateProcessor.DistributedUpdatesAsyncException(errorsForClient);
        }
    }

    private void handleReplicationFactor() {
        if (this.leaderReplicationTracker != null || this.rollupReplicationTracker != null) {
            int achievedRf = Integer.MAX_VALUE;
            if (this.leaderReplicationTracker != null) {
                achievedRf = this.leaderReplicationTracker.getAchievedRf();
                if (this.rollupReplicationTracker != null) {
                    this.rollupReplicationTracker.testAndSetAchievedRf(achievedRf);
                }
            }
            if (this.rollupReplicationTracker != null) {
                achievedRf = this.rollupReplicationTracker.getAchievedRf();
            }
            this.rsp.getResponseHeader().add("rf", (Object)achievedRf);
            this.rollupReplicationTracker = null;
            this.leaderReplicationTracker = null;
        }
    }

    private void zkCheck() {
        if (this.req.getCoreContainer().isShutDown()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "CoreContainer is shutting down.");
        }
        if ((this.updateCommand.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0) {
            return;
        }
        if (!this.zkController.getZkClient().getConnectionManager().isLikelyExpired()) {
            return;
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot talk to ZooKeeper - Updates are disabled.");
    }
}

