/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.state.ExponentialCounterFactory;

final class ExponentialBucketStrategy {
    private static final int DEFAULT_STARTING_SCALE = 20;
    private final int startingScale;
    private final int maxBuckets;
    private final ExponentialCounterFactory counterFactory;

    private ExponentialBucketStrategy(int startingScale, int maxBuckets, ExponentialCounterFactory counterFactory) {
        this.startingScale = startingScale;
        this.maxBuckets = maxBuckets;
        this.counterFactory = counterFactory;
    }

    DoubleExponentialHistogramBuckets newBuckets() {
        return new DoubleExponentialHistogramBuckets(this.startingScale, this.maxBuckets, this.counterFactory);
    }

    static ExponentialBucketStrategy newStrategy(int maxBuckets, ExponentialCounterFactory counterFactory) {
        return new ExponentialBucketStrategy(20, maxBuckets, counterFactory);
    }

    static ExponentialBucketStrategy newStrategy(int maxBuckets, ExponentialCounterFactory counterFactory, int startingScale) {
        return new ExponentialBucketStrategy(startingScale, maxBuckets, counterFactory);
    }
}

