/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class FillMissingFunction {
    public static final String name = "fill_missing";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The fill_missing function requires 2 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream baseExpr = params[0];
        AnalyticsValueStream fillExpr = params[1];
        if (baseExpr instanceof DateValue && fillExpr instanceof DateValue) {
            return new DateFillMissingFunction((DateValue)baseExpr, (DateValue)fillExpr);
        }
        if (baseExpr instanceof DateValueStream && fillExpr instanceof DateValueStream) {
            return new DateStreamFillMissingFunction((DateValueStream)baseExpr, (DateValueStream)fillExpr);
        }
        if (baseExpr instanceof BooleanValue && fillExpr instanceof BooleanValue) {
            return new BooleanFillMissingFunction((BooleanValue)baseExpr, (BooleanValue)fillExpr);
        }
        if (baseExpr instanceof BooleanValueStream && fillExpr instanceof BooleanValueStream) {
            return new BooleanStreamFillMissingFunction((BooleanValueStream)baseExpr, (BooleanValueStream)fillExpr);
        }
        if (baseExpr instanceof IntValue && fillExpr instanceof IntValue) {
            return new IntFillMissingFunction((IntValue)baseExpr, (IntValue)fillExpr);
        }
        if (baseExpr instanceof IntValueStream && fillExpr instanceof IntValueStream) {
            return new IntStreamFillMissingFunction((IntValueStream)baseExpr, (IntValueStream)fillExpr);
        }
        if (baseExpr instanceof LongValue && fillExpr instanceof LongValue) {
            return new LongFillMissingFunction((LongValue)baseExpr, (LongValue)fillExpr);
        }
        if (baseExpr instanceof LongValueStream && fillExpr instanceof LongValueStream) {
            return new LongStreamFillMissingFunction((LongValueStream)baseExpr, (LongValueStream)fillExpr);
        }
        if (baseExpr instanceof FloatValue && fillExpr instanceof FloatValue) {
            return new FloatFillMissingFunction((FloatValue)baseExpr, (FloatValue)fillExpr);
        }
        if (baseExpr instanceof FloatValueStream && fillExpr instanceof FloatValueStream) {
            return new FloatStreamFillMissingFunction((FloatValueStream)baseExpr, (FloatValueStream)fillExpr);
        }
        if (baseExpr instanceof DoubleValue && fillExpr instanceof DoubleValue) {
            return new DoubleFillMissingFunction((DoubleValue)baseExpr, (DoubleValue)fillExpr);
        }
        if (baseExpr instanceof DoubleValueStream && fillExpr instanceof DoubleValueStream) {
            return new DoubleStreamFillMissingFunction((DoubleValueStream)baseExpr, (DoubleValueStream)fillExpr);
        }
        if (baseExpr instanceof StringValue && fillExpr instanceof StringValue) {
            return new StringFillMissingFunction((StringValue)baseExpr, (StringValue)fillExpr);
        }
        if (baseExpr instanceof StringValueStream && fillExpr instanceof StringValueStream) {
            return new StringStreamFillMissingFunction((StringValueStream)baseExpr, (StringValueStream)fillExpr);
        }
        if (baseExpr instanceof AnalyticsValue && fillExpr instanceof AnalyticsValue) {
            return new ValueFillMissingFunction((AnalyticsValue)baseExpr, (AnalyticsValue)fillExpr);
        }
        return new StreamFillMissingFunction(baseExpr, fillExpr);
    };

    static class StringFillMissingFunction
    extends StringValue.AbstractStringValue {
        private final StringValue baseExpr;
        private final StringValue fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public StringFillMissingFunction(StringValue baseExpr, StringValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public String getString() {
            String value = this.baseExpr.getString();
            this.exists = true;
            if (!this.baseExpr.exists()) {
                value = this.fillExpr.getString();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringStreamFillMissingFunction
    extends StringValueStream.AbstractStringValueStream
    implements Consumer<String> {
        private final StringValueStream baseExpr;
        private final StringValueStream fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;
        Consumer<String> cons;

        public StringStreamFillMissingFunction(StringValueStream baseExpr, StringValueStream fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            this.exists = false;
            this.cons = cons;
            this.baseExpr.streamStrings(this);
            if (!this.exists) {
                this.fillExpr.streamStrings(cons);
            }
        }

        @Override
        public void accept(String value) {
            this.exists = true;
            this.cons.accept(value);
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateFillMissingFunction
    extends DateValue.AbstractDateValue {
        private final DateValue baseExpr;
        private final DateValue fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public DateFillMissingFunction(DateValue baseExpr, DateValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public long getLong() {
            long value = this.baseExpr.getLong();
            this.exists = true;
            if (!this.baseExpr.exists()) {
                value = this.fillExpr.getLong();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateStreamFillMissingFunction
    extends DateValueStream.AbstractDateValueStream
    implements LongConsumer {
        private final DateValueStream baseExpr;
        private final DateValueStream fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;
        LongConsumer cons;

        public DateStreamFillMissingFunction(DateValueStream baseExpr, DateValueStream fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            this.exists = false;
            this.cons = cons;
            this.baseExpr.streamLongs(this);
            if (!this.exists) {
                this.fillExpr.streamLongs(cons);
            }
        }

        @Override
        public void accept(long value) {
            this.exists = true;
            this.cons.accept(value);
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleFillMissingFunction
    extends DoubleValue.AbstractDoubleValue {
        private final DoubleValue baseExpr;
        private final DoubleValue fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public DoubleFillMissingFunction(DoubleValue baseExpr, DoubleValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public double getDouble() {
            double value = this.baseExpr.getDouble();
            this.exists = true;
            if (!this.baseExpr.exists()) {
                value = this.fillExpr.getDouble();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleStreamFillMissingFunction
    extends DoubleValueStream.AbstractDoubleValueStream
    implements DoubleConsumer {
        private final DoubleValueStream baseExpr;
        private final DoubleValueStream fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;
        DoubleConsumer cons;

        public DoubleStreamFillMissingFunction(DoubleValueStream baseExpr, DoubleValueStream fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            this.exists = false;
            this.cons = cons;
            this.baseExpr.streamDoubles(this);
            if (!this.exists) {
                this.fillExpr.streamDoubles(cons);
            }
        }

        @Override
        public void accept(double value) {
            this.exists = true;
            this.cons.accept(value);
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatFillMissingFunction
    extends FloatValue.AbstractFloatValue {
        private final FloatValue baseExpr;
        private final FloatValue fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public FloatFillMissingFunction(FloatValue baseExpr, FloatValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public float getFloat() {
            float value = this.baseExpr.getFloat();
            this.exists = true;
            if (!this.baseExpr.exists()) {
                value = this.fillExpr.getFloat();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatStreamFillMissingFunction
    extends FloatValueStream.AbstractFloatValueStream
    implements FloatConsumer {
        private final FloatValueStream baseExpr;
        private final FloatValueStream fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;
        FloatConsumer cons;

        public FloatStreamFillMissingFunction(FloatValueStream baseExpr, FloatValueStream fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            this.exists = false;
            this.cons = cons;
            this.baseExpr.streamFloats(this);
            if (!this.exists) {
                this.fillExpr.streamFloats(cons);
            }
        }

        @Override
        public void accept(float value) {
            this.exists = true;
            this.cons.accept(value);
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongFillMissingFunction
    extends LongValue.AbstractLongValue {
        private final LongValue baseExpr;
        private final LongValue fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public LongFillMissingFunction(LongValue baseExpr, LongValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public long getLong() {
            long value = this.baseExpr.getLong();
            this.exists = true;
            if (!this.baseExpr.exists()) {
                value = this.fillExpr.getLong();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongStreamFillMissingFunction
    extends LongValueStream.AbstractLongValueStream
    implements LongConsumer {
        private final LongValueStream baseExpr;
        private final LongValueStream fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;
        LongConsumer cons;

        public LongStreamFillMissingFunction(LongValueStream baseExpr, LongValueStream fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            this.exists = false;
            this.cons = cons;
            this.baseExpr.streamLongs(this);
            if (!this.exists) {
                this.fillExpr.streamLongs(cons);
            }
        }

        @Override
        public void accept(long value) {
            this.exists = true;
            this.cons.accept(value);
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntFillMissingFunction
    extends IntValue.AbstractIntValue {
        private final IntValue baseExpr;
        private final IntValue fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public IntFillMissingFunction(IntValue baseExpr, IntValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public int getInt() {
            int value = this.baseExpr.getInt();
            this.exists = true;
            if (!this.baseExpr.exists()) {
                value = this.fillExpr.getInt();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntStreamFillMissingFunction
    extends IntValueStream.AbstractIntValueStream
    implements IntConsumer {
        private final IntValueStream baseExpr;
        private final IntValueStream fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;
        IntConsumer cons;

        public IntStreamFillMissingFunction(IntValueStream baseExpr, IntValueStream fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public void streamInts(IntConsumer cons) {
            this.exists = false;
            this.cons = cons;
            this.baseExpr.streamInts(this);
            if (!this.exists) {
                this.fillExpr.streamInts(cons);
            }
        }

        @Override
        public void accept(int value) {
            this.exists = true;
            this.cons.accept(value);
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanFillMissingFunction
    extends BooleanValue.AbstractBooleanValue {
        private final BooleanValue baseExpr;
        private final BooleanValue fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public BooleanFillMissingFunction(BooleanValue baseExpr, BooleanValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public boolean getBoolean() {
            boolean value = this.baseExpr.getBoolean();
            this.exists = true;
            if (!this.baseExpr.exists()) {
                value = this.fillExpr.getBoolean();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanStreamFillMissingFunction
    extends BooleanValueStream.AbstractBooleanValueStream
    implements BooleanConsumer {
        private final BooleanValueStream baseExpr;
        private final BooleanValueStream fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;
        BooleanConsumer cons;

        public BooleanStreamFillMissingFunction(BooleanValueStream baseExpr, BooleanValueStream fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            this.exists = false;
            this.cons = cons;
            this.baseExpr.streamBooleans(this);
            if (!this.exists) {
                this.fillExpr.streamBooleans(cons);
            }
        }

        @Override
        public void accept(boolean value) {
            this.exists = true;
            this.cons.accept(value);
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ValueFillMissingFunction
    extends AnalyticsValue.AbstractAnalyticsValue {
        private final AnalyticsValue baseExpr;
        private final AnalyticsValue fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public ValueFillMissingFunction(AnalyticsValue baseExpr, AnalyticsValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public Object getObject() {
            Object value = this.baseExpr.getObject();
            this.exists = true;
            if (!this.baseExpr.exists()) {
                value = this.fillExpr.getObject();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StreamFillMissingFunction
    extends AnalyticsValueStream.AbstractAnalyticsValueStream
    implements Consumer<Object> {
        private final AnalyticsValueStream baseExpr;
        private final AnalyticsValueStream fillExpr;
        public static final String name = "fill_missing";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;
        Consumer<Object> cons;

        public StreamFillMissingFunction(AnalyticsValueStream baseExpr, AnalyticsValueStream fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("fill_missing", baseExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            this.exists = false;
            this.cons = cons;
            this.baseExpr.streamObjects(this);
            if (!this.exists) {
                this.fillExpr.streamObjects(cons);
            }
        }

        @Override
        public void accept(Object value) {
            this.exists = true;
            this.cons.accept(value);
        }

        @Override
        public String getName() {
            return "fill_missing";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }
}

