/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;

public final class Interpolation1D
extends AbstractProvider {
    private static final long serialVersionUID = -2571645687075958970L;
    private static final ParameterDescriptor<double[]> PREIMAGE;
    private static final ParameterDescriptor<double[]> VALUES;
    public static final ParameterDescriptorGroup PARAMETERS;

    public Interpolation1D() {
        super(1, 1, PARAMETERS);
    }

    public Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        Parameters parameters = Parameters.castOrWrap(parameterValueGroup);
        return MathTransforms.interpolate(parameters.getValue(PREIMAGE), parameters.getValue(VALUES));
    }

    static {
        ParameterBuilder parameterBuilder = (ParameterBuilder)new ParameterBuilder().setCodeSpace(Citations.SIS, "SIS");
        PREIMAGE = ((ParameterBuilder)parameterBuilder.addName("preimage")).create(double[].class, null);
        VALUES = ((ParameterBuilder)parameterBuilder.addName("values")).create(double[].class, null);
        PARAMETERS = ((ParameterBuilder)parameterBuilder.addName("Interpolation 1D")).createGroup(new GeneralParameterDescriptor[]{PREIMAGE, VALUES});
    }
}

